/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.datafixers.util.Pair;
import net.minecraft.EnumChatFormat;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.ResourceOrTagLocationArgument;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IRegistry;
import net.minecraft.network.chat.ChatClickable;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.ChatHoverable;
import net.minecraft.network.chat.ChatMessage;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.level.levelgen.feature.StructureFeature;

public class CommandLocate {
    private static final DynamicCommandExceptionType a = new DynamicCommandExceptionType(id -> new ChatMessage("commands.locate.failed", id));
    private static final DynamicCommandExceptionType b = new DynamicCommandExceptionType(id -> new ChatMessage("commands.locate.invalid", id));

    public static void a(CommandDispatcher<CommandListenerWrapper> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("locate").requires(source -> source.c(2))).then(net.minecraft.commands.CommandDispatcher.a("structure", ResourceOrTagLocationArgument.a(IRegistry.aL)).executes(context -> CommandLocate.a((CommandListenerWrapper)context.getSource(), ResourceOrTagLocationArgument.b((CommandContext<CommandListenerWrapper>)context, "structure"))))));
    }

    private static int a(CommandListenerWrapper source, ResourceOrTagLocationArgument.b<StructureFeature<?, ?>> structureFeature) throws CommandSyntaxException {
        IRegistry<StructureFeature<?, ?>> registry = source.e().s().d(IRegistry.aL);
        HolderSet holderSet = (HolderSet)structureFeature.a().map(key -> registry.b((ResourceKey<StructureFeature<?, ?>>)key).map(entry -> HolderSet.a(entry)), registry::c).orElseThrow(() -> b.create((Object)structureFeature.b()));
        BlockPosition blockPos = new BlockPosition(source.d());
        WorldServer serverLevel = source.e();
        Pair<BlockPosition, Holder<StructureFeature<?, ?>>> pair = serverLevel.k().g().a(serverLevel, holderSet, blockPos, 100, false);
        if (pair == null) {
            throw a.create((Object)structureFeature.b());
        }
        return CommandLocate.a(source, structureFeature, blockPos, pair, "commands.locate.success");
    }

    public static int a(CommandListenerWrapper source, ResourceOrTagLocationArgument.b<?> structureFeature, BlockPosition currentPos, Pair<BlockPosition, ? extends Holder<?>> structurePosAndEntry, String successMessage) {
        BlockPosition blockPos = (BlockPosition)structurePosAndEntry.getFirst();
        String string = structureFeature.a().map(key -> key.a().toString(), key2 -> "#" + key2.b() + " (" + ((Holder)structurePosAndEntry.getSecond()).e().map(key -> key.a().toString()).orElse("[unregistered]") + ")");
        int i2 = MathHelper.d(CommandLocate.a(currentPos.u(), currentPos.w(), blockPos.u(), blockPos.w()));
        IChatMutableComponent component = ChatComponentUtils.a(new ChatMessage("chat.coordinates", blockPos.u(), "~", blockPos.w())).a(style -> style.a(EnumChatFormat.k).a(new ChatClickable(ChatClickable.EnumClickAction.d, "/tp @s " + blockPos.u() + " ~ " + blockPos.w())).a(new ChatHoverable(ChatHoverable.EnumHoverAction.a, new ChatMessage("chat.coordinates.tooltip"))));
        source.a(new ChatMessage(successMessage, string, component, i2), false);
        return i2;
    }

    private static float a(int x1, int y1, int x2, int y2) {
        int i2 = x2 - x1;
        int j2 = y2 - y1;
        return MathHelper.c((float)(i2 * i2 + j2 * j2));
    }
}

