/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Collection;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.ArgumentEnchantment;
import net.minecraft.commands.arguments.ArgumentEntity;
import net.minecraft.network.chat.ChatMessage;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentManager;

public class CommandEnchant {
    private static final DynamicCommandExceptionType a = new DynamicCommandExceptionType(entityName -> new ChatMessage("commands.enchant.failed.entity", entityName));
    private static final DynamicCommandExceptionType b = new DynamicCommandExceptionType(entityName -> new ChatMessage("commands.enchant.failed.itemless", entityName));
    private static final DynamicCommandExceptionType c = new DynamicCommandExceptionType(itemName -> new ChatMessage("commands.enchant.failed.incompatible", itemName));
    private static final Dynamic2CommandExceptionType d = new Dynamic2CommandExceptionType((level, maxLevel) -> new ChatMessage("commands.enchant.failed.level", level, maxLevel));
    private static final SimpleCommandExceptionType e = new SimpleCommandExceptionType((Message)new ChatMessage("commands.enchant.failed"));

    public static void a(CommandDispatcher<CommandListenerWrapper> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("enchant").requires(source -> source.c(2))).then(net.minecraft.commands.CommandDispatcher.a("targets", ArgumentEntity.b()).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("enchantment", ArgumentEnchantment.a()).executes(context -> CommandEnchant.a((CommandListenerWrapper)context.getSource(), ArgumentEntity.b((CommandContext<CommandListenerWrapper>)context, "targets"), ArgumentEnchantment.a((CommandContext<CommandListenerWrapper>)context, "enchantment"), 1))).then(net.minecraft.commands.CommandDispatcher.a("level", IntegerArgumentType.integer((int)0)).executes(context -> CommandEnchant.a((CommandListenerWrapper)context.getSource(), ArgumentEntity.b((CommandContext<CommandListenerWrapper>)context, "targets"), ArgumentEnchantment.a((CommandContext<CommandListenerWrapper>)context, "enchantment"), IntegerArgumentType.getInteger((CommandContext)context, (String)"level"))))))));
    }

    private static int a(CommandListenerWrapper source, Collection<? extends Entity> targets, Enchantment enchantment, int level) throws CommandSyntaxException {
        if (level > enchantment.a()) {
            throw d.create((Object)level, (Object)enchantment.a());
        }
        int i2 = 0;
        for (Entity entity : targets) {
            if (entity instanceof EntityLiving) {
                EntityLiving livingEntity = (EntityLiving)entity;
                ItemStack itemStack = livingEntity.es();
                if (!itemStack.b()) {
                    if (enchantment.a(itemStack) && EnchantmentManager.a(EnchantmentManager.a(itemStack).keySet(), enchantment)) {
                        itemStack.a(enchantment, level);
                        ++i2;
                        continue;
                    }
                    if (targets.size() != 1) continue;
                    throw c.create((Object)itemStack.c().m(itemStack).getString());
                }
                if (targets.size() != 1) continue;
                throw b.create((Object)livingEntity.X().getString());
            }
            if (targets.size() != 1) continue;
            throw a.create((Object)entity.X().getString());
        }
        if (i2 == 0) {
            throw e.create();
        }
        if (targets.size() == 1) {
            source.a(new ChatMessage("commands.enchant.success.single", enchantment.d(level), targets.iterator().next().C_()), true);
        } else {
            source.a(new ChatMessage("commands.enchant.success.multiple", enchantment.d(level), targets.size()), true);
        }
        return i2;
    }
}

