/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.collect.ImmutableList;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.ArgumentEntity;
import net.minecraft.commands.arguments.ArgumentMobEffect;
import net.minecraft.network.chat.ChatMessage;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import org.bukkit.event.entity.EntityPotionEffectEvent;

public class CommandEffect {
    private static final SimpleCommandExceptionType a = new SimpleCommandExceptionType((Message)new ChatMessage("commands.effect.give.failed"));
    private static final SimpleCommandExceptionType b = new SimpleCommandExceptionType((Message)new ChatMessage("commands.effect.clear.everything.failed"));
    private static final SimpleCommandExceptionType c = new SimpleCommandExceptionType((Message)new ChatMessage("commands.effect.clear.specific.failed"));

    public static void a(CommandDispatcher<CommandListenerWrapper> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("effect").requires(commandlistenerwrapper -> commandlistenerwrapper.c(2))).then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("clear").executes(commandcontext -> CommandEffect.a((CommandListenerWrapper)commandcontext.getSource(), (Collection<? extends Entity>)ImmutableList.of((Object)((CommandListenerWrapper)commandcontext.getSource()).g())))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("targets", ArgumentEntity.b()).executes(commandcontext -> CommandEffect.a((CommandListenerWrapper)commandcontext.getSource(), ArgumentEntity.b((CommandContext<CommandListenerWrapper>)commandcontext, "targets")))).then(net.minecraft.commands.CommandDispatcher.a("effect", ArgumentMobEffect.a()).executes(commandcontext -> CommandEffect.a((CommandListenerWrapper)commandcontext.getSource(), ArgumentEntity.b((CommandContext<CommandListenerWrapper>)commandcontext, "targets"), ArgumentMobEffect.a((CommandContext<CommandListenerWrapper>)commandcontext, "effect"))))))).then(net.minecraft.commands.CommandDispatcher.a("give").then(net.minecraft.commands.CommandDispatcher.a("targets", ArgumentEntity.b()).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("effect", ArgumentMobEffect.a()).executes(commandcontext -> CommandEffect.a((CommandListenerWrapper)commandcontext.getSource(), ArgumentEntity.b((CommandContext<CommandListenerWrapper>)commandcontext, "targets"), ArgumentMobEffect.a((CommandContext<CommandListenerWrapper>)commandcontext, "effect"), null, 0, true))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("seconds", IntegerArgumentType.integer((int)1, (int)1000000)).executes(commandcontext -> CommandEffect.a((CommandListenerWrapper)commandcontext.getSource(), ArgumentEntity.b((CommandContext<CommandListenerWrapper>)commandcontext, "targets"), ArgumentMobEffect.a((CommandContext<CommandListenerWrapper>)commandcontext, "effect"), IntegerArgumentType.getInteger((CommandContext)commandcontext, (String)"seconds"), 0, true))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("amplifier", IntegerArgumentType.integer((int)0, (int)255)).executes(commandcontext -> CommandEffect.a((CommandListenerWrapper)commandcontext.getSource(), ArgumentEntity.b((CommandContext<CommandListenerWrapper>)commandcontext, "targets"), ArgumentMobEffect.a((CommandContext<CommandListenerWrapper>)commandcontext, "effect"), IntegerArgumentType.getInteger((CommandContext)commandcontext, (String)"seconds"), IntegerArgumentType.getInteger((CommandContext)commandcontext, (String)"amplifier"), true))).then(net.minecraft.commands.CommandDispatcher.a("hideParticles", BoolArgumentType.bool()).executes(commandcontext -> CommandEffect.a((CommandListenerWrapper)commandcontext.getSource(), ArgumentEntity.b((CommandContext<CommandListenerWrapper>)commandcontext, "targets"), ArgumentMobEffect.a((CommandContext<CommandListenerWrapper>)commandcontext, "effect"), IntegerArgumentType.getInteger((CommandContext)commandcontext, (String)"seconds"), IntegerArgumentType.getInteger((CommandContext)commandcontext, (String)"amplifier"), !BoolArgumentType.getBool((CommandContext)commandcontext, (String)"hideParticles")))))))))));
    }

    private static int a(CommandListenerWrapper source, Collection<? extends Entity> targets, MobEffectList effect, @Nullable Integer seconds, int amplifier, boolean showParticles) throws CommandSyntaxException {
        int k2;
        int j2 = 0;
        if (seconds != null) {
            k2 = effect.a() ? seconds : seconds * 20;
        } else if (effect.a()) {
            boolean k22 = true;
        } else {
            k2 = 600;
        }
        for (Entity entity : targets) {
            MobEffect mobeffect;
            if (!(entity instanceof EntityLiving) || !((EntityLiving)entity).addEffect(mobeffect = new MobEffect(effect, k2, amplifier, false, showParticles), source.f(), EntityPotionEffectEvent.Cause.COMMAND)) continue;
            ++j2;
        }
        if (j2 == 0) {
            throw a.create();
        }
        if (targets.size() == 1) {
            source.a(new ChatMessage("commands.effect.give.success.single", effect.d(), targets.iterator().next().C_(), k2 / 20), true);
        } else {
            source.a(new ChatMessage("commands.effect.give.success.multiple", effect.d(), targets.size(), k2 / 20), true);
        }
        return j2;
    }

    private static int a(CommandListenerWrapper source, Collection<? extends Entity> targets) throws CommandSyntaxException {
        int i2 = 0;
        for (Entity entity : targets) {
            if (!(entity instanceof EntityLiving) || !((EntityLiving)entity).removeAllEffects(EntityPotionEffectEvent.Cause.COMMAND)) continue;
            ++i2;
        }
        if (i2 == 0) {
            throw b.create();
        }
        if (targets.size() == 1) {
            source.a(new ChatMessage("commands.effect.clear.everything.success.single", targets.iterator().next().C_()), true);
        } else {
            source.a(new ChatMessage("commands.effect.clear.everything.success.multiple", targets.size()), true);
        }
        return i2;
    }

    private static int a(CommandListenerWrapper source, Collection<? extends Entity> targets, MobEffectList effect) throws CommandSyntaxException {
        int i2 = 0;
        for (Entity entity : targets) {
            if (!(entity instanceof EntityLiving) || !((EntityLiving)entity).removeEffect(effect, EntityPotionEffectEvent.Cause.COMMAND)) continue;
            ++i2;
        }
        if (i2 == 0) {
            throw c.create();
        }
        if (targets.size() == 1) {
            source.a(new ChatMessage("commands.effect.clear.specific.success.single", effect.d(), targets.iterator().next().C_()), true);
        } else {
            source.a(new ChatMessage("commands.effect.clear.specific.success.multiple", effect.d(), targets.size()), true);
        }
        return i2;
    }
}

