/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.mojang.datafixers.util.Pair;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import net.minecraft.commands.CommandDispatcher;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.DataPackResources;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.packs.EnumResourcePackType;
import net.minecraft.server.packs.IResourcePack;
import net.minecraft.server.packs.repository.ResourcePackRepository;
import net.minecraft.server.packs.resources.IReloadableResourceManager;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.level.DataPackConfiguration;
import net.minecraft.world.level.storage.Convertable;
import net.minecraft.world.level.storage.SaveData;

public record WorldStem(IReloadableResourceManager a, DataPackResources b, IRegistryCustom.Dimension c, SaveData d) implements AutoCloseable
{
    private final IReloadableResourceManager a;
    private final DataPackResources b;
    private final IRegistryCustom.Dimension c;
    private final SaveData d;

    public static CompletableFuture<WorldStem> a(b functionLoaderConfig, a dataPackSettingsSupplier, c savePropertiesSupplier, Executor prepareExecutor, Executor applyExecutor) {
        try {
            DataPackConfiguration dataPackConfig = (DataPackConfiguration)dataPackSettingsSupplier.get();
            DataPackConfiguration dataPackConfig2 = MinecraftServer.a(functionLoaderConfig.a(), dataPackConfig, functionLoaderConfig.d());
            List<IResourcePack> list = functionLoaderConfig.a().f();
            ResourceManager closeableResourceManager = new ResourceManager(EnumResourcePackType.b, list);
            Pair<SaveData, IRegistryCustom.Dimension> pair = savePropertiesSupplier.get(closeableResourceManager, dataPackConfig2);
            SaveData worldData = (SaveData)pair.getFirst();
            IRegistryCustom.Dimension frozen = (IRegistryCustom.Dimension)pair.getSecond();
            return ((CompletableFuture)DataPackResources.a(closeableResourceManager, frozen, functionLoaderConfig.b(), functionLoaderConfig.c(), prepareExecutor, applyExecutor).whenComplete((dataPackContents, throwable) -> {
                if (throwable != null) {
                    closeableResourceManager.close();
                }
            })).thenApply(dataPackContents -> new WorldStem(closeableResourceManager, (DataPackResources)dataPackContents, frozen, worldData));
        }
        catch (Exception exception) {
            return CompletableFuture.failedFuture(exception);
        }
    }

    @Override
    @Override
    public void close() {
        this.a.close();
    }

    public void a() {
        this.b.a(this.c);
    }

    @Override
    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{WorldStem.class, "resourceManager;dataPackResources;registryAccess;worldData", "a", "b", "c", "d"}, this);
    }

    @Override
    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{WorldStem.class, "resourceManager;dataPackResources;registryAccess;worldData", "a", "b", "c", "d"}, this);
    }

    @Override
    @Override
    public final boolean equals(Object object) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{WorldStem.class, "resourceManager;dataPackResources;registryAccess;worldData", "a", "b", "c", "d"}, this, object);
    }

    public IReloadableResourceManager b() {
        return this.a;
    }

    public DataPackResources c() {
        return this.b;
    }

    public IRegistryCustom.Dimension d() {
        return this.c;
    }

    public SaveData e() {
        return this.d;
    }

    @FunctionalInterface
    public static interface a
    extends Supplier<DataPackConfiguration> {
        public static a loadFromWorld(Convertable.ConversionSession session) {
            return () -> {
                DataPackConfiguration dataPackConfig = session.d();
                if (dataPackConfig == null) {
                    throw new IllegalStateException("Failed to load data pack config");
                }
                return dataPackConfig;
            };
        }
    }

    public record b(ResourcePackRepository a, CommandDispatcher.ServerType b, int c, boolean d) {
        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "packRepository;commandSelection;functionCompilationLevel;safeMode", "a", "b", "c", "d"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "packRepository;commandSelection;functionCompilationLevel;safeMode", "a", "b", "c", "d"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "packRepository;commandSelection;functionCompilationLevel;safeMode", "a", "b", "c", "d"}, this, object);
        }
    }

    @FunctionalInterface
    public static interface c {
        public Pair<SaveData, IRegistryCustom.Dimension> get(IResourceManager var1, DataPackConfiguration var2);

        public static c loadFromWorld(Convertable.ConversionSession session) {
            return (resourceManager, dataPackSettings) -> {
                IRegistryCustom.e writable = IRegistryCustom.e();
                RegistryOps<NBTBase> dynamicOps = RegistryOps.a(DynamicOpsNBT.a, writable, resourceManager);
                SaveData worldData = session.a(dynamicOps, dataPackSettings, writable.g());
                if (worldData == null) {
                    throw new IllegalStateException("Failed to load world");
                }
                return Pair.of((Object)worldData, (Object)writable.f());
            };
        }
    }
}

