/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import co.aikar.timings.MinecraftTimings;
import co.aikar.timings.Timing;
import co.aikar.timings.TimingsManager;
import com.destroystokyo.paper.PaperConfig;
import com.destroystokyo.paper.event.server.ServerTickEndEvent;
import com.destroystokyo.paper.event.server.ServerTickStartEvent;
import com.destroystokyo.paper.io.PaperFileIOThread;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.chunk.SingleThreadChunkRegionManager;
import io.papermc.paper.console.HexFormattingConverter;
import io.papermc.paper.event.entity.EntityMoveEvent;
import io.papermc.paper.event.server.ServerResourcesReloadedEvent;
import io.papermc.paper.registry.PaperRegistry;
import io.papermc.paper.util.CachedLists;
import io.papermc.paper.util.TraceUtil;
import it.unimi.dsi.fastutil.longs.LongIterator;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.invoke.MethodHandle;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.lang.runtime.ObjectMethods;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.Proxy;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.KeyPair;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import joptsimple.OptionSet;
import net.minecraft.CrashReport;
import net.minecraft.ReportedException;
import net.minecraft.SharedConstants;
import net.minecraft.SystemReport;
import net.minecraft.SystemUtils;
import net.minecraft.commands.CommandDispatcher;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICommandListener;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.data.worldgen.features.MiscOverworldFeatures;
import net.minecraft.gametest.framework.GameTestHarnessTicker;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.ChatComponentText;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.game.PacketPlayOutServerDifficulty;
import net.minecraft.network.protocol.game.PacketPlayOutUpdateTime;
import net.minecraft.network.protocol.status.ServerPing;
import net.minecraft.obfuscate.DontObfuscate;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.AdvancementDataWorld;
import net.minecraft.server.CustomFunctionData;
import net.minecraft.server.DataPackResources;
import net.minecraft.server.MCUtil;
import net.minecraft.server.Main;
import net.minecraft.server.ScoreboardServer;
import net.minecraft.server.TickTask;
import net.minecraft.server.WorldStem;
import net.minecraft.server.bossevents.BossBattleCustomData;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.dedicated.DedicatedServerProperties;
import net.minecraft.server.level.ChunkProviderServer;
import net.minecraft.server.level.DemoPlayerInteractManager;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.PlayerInteractManager;
import net.minecraft.server.level.WorldProviderNormal;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.level.progress.WorldLoadListener;
import net.minecraft.server.level.progress.WorldLoadListenerFactory;
import net.minecraft.server.network.ITextFilter;
import net.minecraft.server.network.ServerConnection;
import net.minecraft.server.packs.EnumResourcePackType;
import net.minecraft.server.packs.IResourcePack;
import net.minecraft.server.packs.repository.ResourcePackLoader;
import net.minecraft.server.packs.repository.ResourcePackRepository;
import net.minecraft.server.packs.resources.IReloadableResourceManager;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.players.OpListEntry;
import net.minecraft.server.players.PlayerList;
import net.minecraft.server.players.UserCache;
import net.minecraft.server.players.WhiteList;
import net.minecraft.util.CircularTimer;
import net.minecraft.util.CryptographyException;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MinecraftEncryption;
import net.minecraft.util.ModCheck;
import net.minecraft.util.NativeModuleLister;
import net.minecraft.util.datafix.DataConverterRegistry;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.GameProfilerTick;
import net.minecraft.util.profiling.MethodProfilerResults;
import net.minecraft.util.profiling.MethodProfilerResultsEmpty;
import net.minecraft.util.profiling.MethodProfilerResultsField;
import net.minecraft.util.profiling.jfr.JvmProfiler;
import net.minecraft.util.profiling.jfr.callback.ProfiledDuration;
import net.minecraft.util.profiling.metrics.profiling.ActiveMetricsRecorder;
import net.minecraft.util.profiling.metrics.profiling.InactiveMetricsRecorder;
import net.minecraft.util.profiling.metrics.profiling.MetricsRecorder;
import net.minecraft.util.profiling.metrics.profiling.ServerMetricsSamplersProvider;
import net.minecraft.util.profiling.metrics.storage.MetricsPersister;
import net.minecraft.util.thread.IAsyncTaskHandlerReentrant;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.entity.ai.village.VillageSiege;
import net.minecraft.world.entity.npc.MobSpawnerCat;
import net.minecraft.world.entity.npc.MobSpawnerTrader;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.alchemy.PotionBrewer;
import net.minecraft.world.item.crafting.CraftingManager;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.DataPackConfiguration;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.ForcedChunk;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.MobSpawner;
import net.minecraft.world.level.WorldSettings;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.WorldChunkManager;
import net.minecraft.world.level.block.entity.TileEntityHopper;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.levelgen.ChunkGeneratorAbstract;
import net.minecraft.world.level.levelgen.GeneratorSettings;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.MobSpawnerPatrol;
import net.minecraft.world.level.levelgen.MobSpawnerPhantom;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureConfigured;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureEmptyConfiguration;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureManager;
import net.minecraft.world.level.storage.Convertable;
import net.minecraft.world.level.storage.IWorldDataServer;
import net.minecraft.world.level.storage.PersistentCommandStorage;
import net.minecraft.world.level.storage.SaveData;
import net.minecraft.world.level.storage.SavedFile;
import net.minecraft.world.level.storage.WorldData;
import net.minecraft.world.level.storage.WorldDataServer;
import net.minecraft.world.level.storage.WorldNBTStorage;
import net.minecraft.world.level.storage.WorldPersistentData;
import net.minecraft.world.level.storage.loot.ItemModifierManager;
import net.minecraft.world.level.storage.loot.LootPredicateManager;
import net.minecraft.world.level.storage.loot.LootTableRegistry;
import net.minecraft.world.phys.Vec2F;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.scores.PersistentScoreboard;
import net.minecraft.world.scores.ScoreboardTeam;
import net.minecrell.terminalconsole.TerminalConsoleAppender;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.command.RemoteConsoleCommandSender;
import org.bukkit.craftbukkit.v1_18_R2.CraftServer;
import org.bukkit.craftbukkit.v1_18_R2.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_18_R2.generator.CraftWorldInfo;
import org.bukkit.craftbukkit.v1_18_R2.generator.CustomWorldChunkManager;
import org.bukkit.craftbukkit.v1_18_R2.scoreboard.CraftScoreboardManager;
import org.bukkit.craftbukkit.v1_18_R2.util.ServerShutdownThread;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockPhysicsEvent;
import org.bukkit.event.inventory.InventoryMoveItemEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.server.ServerLoadEvent;
import org.bukkit.event.world.WorldInitEvent;
import org.bukkit.event.world.WorldLoadEvent;
import org.bukkit.generator.BiomeProvider;
import org.bukkit.generator.WorldInfo;
import org.bukkit.plugin.PluginLoadOrder;
import org.slf4j.Logger;
import org.spigotmc.AsyncCatcher;
import org.spigotmc.SpigotConfig;
import org.spigotmc.WatchdogThread;

public abstract class MinecraftServer
extends IAsyncTaskHandlerReentrant<TickTask>
implements ICommandListener,
AutoCloseable {
    private static MinecraftServer SERVER;
    public static final Logger q;
    public static final String b = "vanilla";
    private static final float r = 0.8f;
    private static final int s = 100;
    public static final int c = 50;
    private static final int t = 2000;
    private static final int u = 15000;
    public static final String d = "level";
    public static final String e = "level://";
    private static final long v = 5000000000L;
    private static final int w = 12;
    public static final String f = "resources.zip";
    public static final File g;
    public static final int h = 11;
    private static final int x = 441;
    private static final int y = 6000;
    private static final int z = 3;
    public static final int i = 29999984;
    public static final WorldSettings j;
    private static final long A = 50L;
    public static final GameProfile k;
    public Convertable.ConversionSession l;
    public final WorldNBTStorage m;
    private final List<Runnable> B = Lists.newArrayList();
    private MetricsRecorder C;
    private GameProfilerFiller D;
    private Consumer<MethodProfilerResults> E;
    private Consumer<Path> F;
    private boolean G;
    @Nullable
    private b H;
    private boolean I;
    private ServerConnection J;
    public final WorldLoadListenerFactory K;
    private final ServerPing L;
    private final Random M;
    public final DataFixer N;
    private String O;
    private int P;
    public final IRegistryCustom.Dimension Q;
    public final Map<ResourceKey<net.minecraft.world.level.World>, WorldServer> R;
    private PlayerList S;
    private volatile boolean T;
    private volatile boolean isRestarting = false;
    private boolean U;
    private int V;
    protected final Proxy n;
    private boolean W;
    private boolean X;
    private boolean Y;
    private boolean Z;
    @Nullable
    private String aa;
    private int ab;
    public final long[] o;
    public final TickTimes tickTimes5s = new TickTimes(100);
    public final TickTimes tickTimes10s = new TickTimes(200);
    public final TickTimes tickTimes60s = new TickTimes(1200);
    @Nullable
    private KeyPair ac;
    @Nullable
    private String ad;
    private boolean ae;
    private String af;
    private String ag;
    private volatile boolean ah;
    private long ai;
    private final MinecraftSessionService aj;
    @Nullable
    private final GameProfileRepository ak;
    @Nullable
    private final UserCache al;
    private long am;
    public final Thread an;
    private long ao;
    private long ap;
    private boolean aq;
    private final ResourcePackRepository ar;
    private final ScoreboardServer as;
    @Nullable
    private PersistentCommandStorage at;
    private final BossBattleCustomData au;
    private final CustomFunctionData av;
    private final CircularTimer aw;
    private boolean ax;
    private float ay;
    public final Executor az;
    @Nullable
    private String aA;
    public a aB;
    private final DefinedStructureManager aC;
    protected SaveData p;
    private volatile boolean aD;
    public final DataPackConfiguration datapackconfiguration;
    public final DynamicOps<NBTBase> registryreadops;
    public CraftServer server;
    public OptionSet options;
    public ConsoleCommandSender console;
    public RemoteConsoleCommandSender remoteConsole;
    public static int currentTick;
    public Queue<Runnable> processQueue = new ConcurrentLinkedQueue<Runnable>();
    public int autosavePeriod;
    public CommandDispatcher vanillaCommandDispatcher;
    public boolean forceTicks;
    public static final int TPS = 20;
    public static final int TICK_TIME = 50000000;
    private static final int SAMPLE_INTERVAL = 20;
    public final double[] recentTps = new double[3];
    public static long currentTickLong;
    public volatile Thread shutdownThread;
    public volatile boolean abnormalExit = false;
    private boolean hasStopped = false;
    public volatile boolean hasFullyShutdown = false;
    private boolean hasLoggedStop = false;
    private final Object stopLock = new Object();
    private static final long SEC_IN_NANO = 1000000000L;
    private static final long MAX_CATCHUP_BUFFER = 60000000000L;
    private long lastTick = 0L;
    private long catchupTime = 0L;
    public final RollingAverage tps1 = new RollingAverage(60);
    public final RollingAverage tps5 = new RollingAverage(300);
    public final RollingAverage tps15 = new RollingAverage(900);
    private static final BigDecimal TPS_BASE;
    boolean isOversleep = false;
    static final long CHUNK_TASK_QUEUE_BACKOFF_MIN_TIME = 25000L;
    static final long MAX_CHUNK_EXEC_TIME = 1000L;
    static final long TASK_EXECUTION_FAILURE_BACKOFF = 5000L;
    private static long lastMidTickExecute;
    private static long lastMidTickExecuteFailure;

    public static <S extends MinecraftServer> S a(Function<Thread, S> serverFactory) {
        AtomicReference<MinecraftServer> atomicreference = new AtomicReference<MinecraftServer>();
        Thread thread = new Thread(() -> ((MinecraftServer)atomicreference.get()).w(), "Server thread");
        thread.setUncaughtExceptionHandler((thread1, throwable) -> q.error("Uncaught exception in server thread", throwable));
        if (Runtime.getRuntime().availableProcessors() > 4) {
            thread.setPriority(8);
        }
        MinecraftServer s0 = (MinecraftServer)serverFactory.apply(thread);
        atomicreference.set(s0);
        thread.setPriority(7);
        thread.start();
        return (S)s0;
    }

    public MinecraftServer(OptionSet options, DataPackConfiguration datapackconfiguration, DynamicOps<NBTBase> registryreadops, Thread thread, Convertable.ConversionSession convertable_conversionsession, ResourcePackRepository resourcepackrepository, WorldStem worldstem, Proxy proxy, DataFixer datafixer, @Nullable MinecraftSessionService minecraftsessionservice, @Nullable GameProfileRepository gameprofilerepository, @Nullable UserCache usercache, WorldLoadListenerFactory worldloadlistenerfactory) {
        super("Server");
        SERVER = this;
        this.C = InactiveMetricsRecorder.a;
        this.D = this.C.e();
        this.E = methodprofilerresults -> this.aP();
        this.F = path -> {};
        this.L = new ServerPing();
        this.M = new Random();
        this.P = -1;
        this.R = Maps.newLinkedHashMap();
        this.T = true;
        this.o = new long[100];
        this.af = "";
        this.ag = "";
        this.ao = SystemUtils.b();
        this.as = new ScoreboardServer(this);
        this.au = new BossBattleCustomData();
        this.aw = new CircularTimer();
        this.Q = worldstem.d();
        this.p = worldstem.e();
        this.n = proxy;
        this.ar = resourcepackrepository;
        this.aB = new a(worldstem.b(), worldstem.c());
        this.aj = minecraftsessionservice;
        this.ak = gameprofilerepository;
        this.al = usercache;
        if (usercache != null) {
            usercache.a(this);
        }
        this.K = worldloadlistenerfactory;
        this.l = convertable_conversionsession;
        this.m = convertable_conversionsession.b();
        this.N = datafixer;
        this.av = new CustomFunctionData(this, this.aB.b.a());
        this.aC = new DefinedStructureManager(worldstem.b(), convertable_conversionsession, datafixer);
        this.an = thread;
        this.az = SystemUtils.f();
        this.options = options;
        this.datapackconfiguration = datapackconfiguration;
        this.registryreadops = registryreadops;
        this.vanillaCommandDispatcher = worldstem.c().c;
        Runtime.getRuntime().addShutdownHook(new ServerShutdownThread(this));
    }

    @Override
    private void a(WorldPersistentData persistentStateManager) {
        ScoreboardServer scoreboardserver = this.aD();
        Objects.requireNonNull(scoreboardserver);
        Function<NBTTagCompound, PersistentScoreboard> function = scoreboardserver::a;
        ScoreboardServer scoreboardserver1 = this.aD();
        Objects.requireNonNull(scoreboardserver1);
        persistentStateManager.a(function, scoreboardserver1::b, "scoreboard");
    }

    protected abstract boolean e() throws IOException;

    protected void loadLevel(String s2) {
        if (!JvmProfiler.e.c()) {
            // empty if block
        }
        boolean flag = false;
        ProfiledDuration profiledduration = JvmProfiler.e.e();
        this.loadWorld0(s2);
        if (profiledduration != null) {
            profiledduration.finish();
        }
        if (flag) {
            try {
                JvmProfiler.e.b();
            }
            catch (Throwable throwable) {
                q.warn("Failed to stop JFR profiling", throwable);
            }
        }
    }

    private void loadWorld0(String s2) {
        Convertable.ConversionSession worldSession = this.l;
        IRegistryCustom.Dimension iregistrycustom_dimension = this.Q;
        WorldDataServer overworldData = (WorldDataServer)worldSession.a(this.registryreadops, this.datapackconfiguration, iregistrycustom_dimension.g());
        if (overworldData == null) {
            GeneratorSettings generatorsettings;
            WorldSettings worldsettings;
            if (this.R()) {
                worldsettings = j;
                generatorsettings = GeneratorSettings.a(iregistrycustom_dimension);
            } else {
                Iterator<WorldServer> dedicatedserverproperties = ((DedicatedServer)this).a();
                worldsettings = new WorldSettings(((DedicatedServerProperties)((Object)dedicatedserverproperties)).p, ((DedicatedServerProperties)((Object)dedicatedserverproperties)).o, ((DedicatedServerProperties)((Object)dedicatedserverproperties)).z, ((DedicatedServerProperties)((Object)dedicatedserverproperties)).n, false, new GameRules(), this.datapackconfiguration);
                generatorsettings = this.options.has("bonusChest") ? ((DedicatedServerProperties)((Object)dedicatedserverproperties)).a(iregistrycustom_dimension).j() : ((DedicatedServerProperties)((Object)dedicatedserverproperties)).a(iregistrycustom_dimension);
            }
            overworldData = new WorldDataServer(worldsettings, generatorsettings, Lifecycle.stable());
        }
        GeneratorSettings overworldSettings = overworldData.A();
        IRegistry<WorldDimension> iregistry = overworldSettings.d();
        for (WorldDimension worldDimension : iregistry) {
            WorldServer world;
            ChunkGenerator chunkgenerator;
            Holder<DimensionManager> holder;
            GeneratorSettings generatorsettings;
            String name;
            ResourceKey<WorldDimension> dimensionKey = iregistry.c(worldDimension).get();
            int dimension = 0;
            if (dimensionKey == WorldDimension.c) {
                if (!this.B()) continue;
                dimension = -1;
            } else if (dimensionKey == WorldDimension.d) {
                if (!this.server.getAllowEnd()) continue;
                dimension = 1;
            } else if (dimensionKey != WorldDimension.b) {
                dimension = -999;
            }
            String worldType = dimension == -999 ? dimensionKey.a().b() + "_" + dimensionKey.a().a() : World.Environment.getEnvironment((int)dimension).toString().toLowerCase();
            String string = name = dimensionKey == WorldDimension.b ? s2 : s2 + "_" + worldType;
            if (dimension != 0) {
                File newWorld = Convertable.getStorageFolder(new File(name).toPath(), dimensionKey).toFile();
                File oldWorld = Convertable.getStorageFolder(new File(s2).toPath(), dimensionKey).toFile();
                File oldLevelDat = new File(new File(s2), "level.dat");
                if (!newWorld.isDirectory() && oldWorld.isDirectory() && oldLevelDat.isFile()) {
                    q.info("---- Migration of old " + worldType + " folder required ----");
                    q.info("Unfortunately due to the way that Minecraft implemented multiworld support in 1.6, Bukkit requires that you move your " + worldType + " folder to a new location in order to operate correctly.");
                    q.info("We will move this folder for you, but it will mean that you need to move it back should you wish to stop using Bukkit in the future.");
                    q.info("Attempting to move " + oldWorld + " to " + newWorld + "...");
                    if (newWorld.exists()) {
                        q.warn("A file or folder already exists at " + newWorld + "!");
                        q.info("---- Migration of old " + worldType + " folder failed ----");
                    } else if (newWorld.getParentFile().mkdirs()) {
                        if (oldWorld.renameTo(newWorld)) {
                            q.info("Success! To restore " + worldType + " in the future, simply move " + newWorld + " to " + oldWorld);
                            try {
                                Files.copy((File)oldLevelDat, (File)new File(new File(name), "level.dat"));
                                FileUtils.copyDirectory((File)new File(new File(s2), "data"), (File)new File(new File(name), "data"));
                            }
                            catch (IOException exception) {
                                q.warn("Unable to migrate world data.");
                            }
                            q.info("---- Migration of old " + worldType + " folder complete ----");
                        } else {
                            q.warn("Could not move folder " + oldWorld + " to " + newWorld + "!");
                            q.info("---- Migration of old " + worldType + " folder failed ----");
                        }
                    } else {
                        q.warn("Could not create path for " + newWorld + "!");
                        q.info("---- Migration of old " + worldType + " folder failed ----");
                    }
                }
                try {
                    worldSession = Convertable.a(this.server.getWorldContainer().toPath()).createAccess(name, dimensionKey);
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
            org.bukkit.generator.ChunkGenerator gen = this.server.getGenerator(name);
            BiomeProvider biomeProvider = this.server.getBiomeProvider(name);
            WorldDataServer worlddata = (WorldDataServer)worldSession.a(this.registryreadops, this.datapackconfiguration, iregistrycustom_dimension.g());
            if (worlddata == null) {
                WorldSettings worldsettings;
                if (this.R()) {
                    worldsettings = j;
                    generatorsettings = GeneratorSettings.a(iregistrycustom_dimension);
                } else {
                    DedicatedServerProperties dedicatedserverproperties = ((DedicatedServer)this).a();
                    worldsettings = new WorldSettings(dedicatedserverproperties.p, dedicatedserverproperties.o, dedicatedserverproperties.z, dedicatedserverproperties.n, false, new GameRules(), this.datapackconfiguration);
                    generatorsettings = this.options.has("bonusChest") ? dedicatedserverproperties.a(iregistrycustom_dimension).j() : dedicatedserverproperties.a(iregistrycustom_dimension);
                }
                worlddata = new WorldDataServer(worldsettings, generatorsettings, Lifecycle.stable());
            }
            worlddata.checkName(name);
            WorldDataServer iworlddataserver = worlddata;
            generatorsettings = worlddata.A();
            boolean flag = generatorsettings.g();
            long i2 = generatorsettings.a();
            long j2 = BiomeManager.a(i2);
            ImmutableList list = ImmutableList.of((Object)new MobSpawnerPhantom(), (Object)new MobSpawnerPatrol(), (Object)new MobSpawnerCat(), (Object)new VillageSiege(), (Object)new MobSpawnerTrader(iworlddataserver));
            WorldDimension worlddimension = dimensionKey == WorldDimension.d || dimensionKey == WorldDimension.c ? generatorsettings.d().a(dimensionKey) : iregistry.a(dimensionKey);
            if (worlddimension == null) {
                holder = this.aU().d(IRegistry.N).c(DimensionManager.m);
                chunkgenerator = GeneratorSettings.a((IRegistryCustom)this.Q, new Random().nextLong());
            } else {
                holder = worlddimension.a();
                chunkgenerator = worlddimension.b();
            }
            CraftWorldInfo worldInfo = new CraftWorldInfo(iworlddataserver, worldSession, World.Environment.getEnvironment((int)dimension), holder.a(), chunkgenerator, this.aU().d(IRegistry.aP));
            if (biomeProvider == null && gen != null) {
                biomeProvider = gen.getDefaultBiomeProvider((WorldInfo)worldInfo);
            }
            if (biomeProvider != null) {
                CustomWorldChunkManager worldChunkManager = new CustomWorldChunkManager(worldInfo, biomeProvider, this.Q.b(IRegistry.aP));
                if (chunkgenerator instanceof ChunkGeneratorAbstract) {
                    ChunkGeneratorAbstract cga = (ChunkGeneratorAbstract)chunkgenerator;
                    chunkgenerator = new ChunkGeneratorAbstract(cga.b, cga.k, (WorldChunkManager)worldChunkManager, chunkgenerator.j, cga.h);
                }
            }
            if (this.options.has("forceUpgrade")) {
                Main.convertWorldButItWorks(dimensionKey, worldSession, DataConverterRegistry.a(), chunkgenerator.c(), this.options.has("eraseCache"));
            }
            ResourceKey<net.minecraft.world.level.World> worldKey = ResourceKey.a(IRegistry.O, dimensionKey.a());
            if (dimensionKey == WorldDimension.b) {
                this.p = worlddata;
                this.p.a(((DedicatedServer)this).a().o);
                worldloadlistener = this.K.create(11);
                world = new WorldServer(this, this.az, worldSession, iworlddataserver, worldKey, holder, worldloadlistener, chunkgenerator, flag, j2, (List<MobSpawner>)list, true, World.Environment.getEnvironment((int)dimension), gen, biomeProvider);
                WorldPersistentData worldpersistentdata = world.t();
                this.a(worldpersistentdata);
                this.server.scoreboardManager = new CraftScoreboardManager(this, world.f());
                this.at = new PersistentCommandStorage(worldpersistentdata);
            } else {
                worldloadlistener = this.K.create(11);
                ImmutableList spawners = PaperConfig.useDimensionTypeForCustomSpawners && this.Q.d(IRegistry.N).c(holder.a()).orElseThrow() == DimensionManager.m ? list : Collections.emptyList();
                world = new WorldServer(this, this.az, worldSession, iworlddataserver, worldKey, holder, worldloadlistener, chunkgenerator, flag, j2, (List<MobSpawner>)spawners, true, World.Environment.getEnvironment((int)dimension), gen, biomeProvider);
            }
            worlddata.a(this.getServerModName(), this.K().a());
            this.R.put(world.aa(), world);
            this.initWorld(world, worlddata, this.p, worlddata.A());
            this.ac().a(world);
            if (worlddata.E() == null) continue;
            this.aJ().a(worlddata.E());
        }
        this.q();
        for (WorldServer worldserver : this.F()) {
            worldserver.paperConfig.removeOldValues();
            this.prepareLevels(worldserver.k().a.C, worldserver);
            worldserver.O.a();
            this.server.getPluginManager().callEvent((Event)new WorldLoadEvent((World)worldserver.getWorld()));
        }
        ScoreboardServer scoreboard = this.aD();
        Collection toRemove = scoreboard.g().stream().filter(team -> team.b().startsWith("collideRule_")).map(ScoreboardTeam::b).collect(Collectors.toList());
        for (String teamName : toRemove) {
            scoreboard.d(scoreboard.f(teamName));
        }
        if (!PaperConfig.enablePlayerCollisions) {
            this.ac().collideRuleTeamName = StringUtils.left((String)("collideRule_" + ThreadLocalRandom.current().nextInt()), (int)16);
            ScoreboardTeam collideTeam = scoreboard.g(this.ac().collideRuleTeamName);
            collideTeam.b(false);
        }
        this.server.enablePlugins(PluginLoadOrder.POSTWORLD);
        this.server.getPluginManager().callEvent((Event)new ServerLoadEvent(ServerLoadEvent.LoadType.STARTUP));
        this.J.acceptConnections();
    }

    protected void q() {
    }

    public void initWorld(WorldServer worldserver, IWorldDataServer iworlddataserver, SaveData saveData, GeneratorSettings generatorsettings) {
        boolean flag = generatorsettings.g();
        if (worldserver.generator != null) {
            worldserver.getWorld().getPopulators().addAll(worldserver.generator.getDefaultPopulators((World)worldserver.getWorld()));
        }
        WorldBorder worldborder = worldserver.p_();
        worldborder.a(iworlddataserver.r());
        this.server.getPluginManager().callEvent((Event)new WorldInitEvent((World)worldserver.getWorld()));
        if (!iworlddataserver.p()) {
            try {
                MinecraftServer.a(worldserver, iworlddataserver, generatorsettings.c(), flag);
                iworlddataserver.c(true);
                if (flag) {
                    this.a(this.p);
                }
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.a(throwable, "Exception initializing level");
                try {
                    worldserver.a(crashreport);
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                throw new ReportedException(crashreport);
            }
            iworlddataserver.c(true);
        }
    }

    private static void a(WorldServer world, IWorldDataServer worldProperties, boolean bonusChest, boolean debugWorld) {
        if (debugWorld) {
            worldProperties.a(BlockPosition.b.b(80), 0.0f);
        } else {
            int i2;
            ChunkGenerator chunkgenerator = world.k().g();
            ChunkCoordIntPair chunkcoordintpair = new ChunkCoordIntPair(chunkgenerator.d().a());
            if (world.generator != null) {
                Random rand = new Random(world.D());
                Location spawn = world.generator.getFixedSpawnLocation((World)world.getWorld(), rand);
                if (spawn != null) {
                    if (spawn.getWorld() != world.getWorld()) {
                        throw new IllegalStateException("Cannot set spawn point for " + worldProperties.g() + " to be in another world (" + spawn.getWorld().getName() + ")");
                    }
                    worldProperties.a(new BlockPosition(spawn.getBlockX(), spawn.getBlockY(), spawn.getBlockZ()), spawn.getYaw());
                    return;
                }
            }
            if ((i2 = chunkgenerator.a(world)) < world.u_()) {
                BlockPosition blockposition = chunkcoordintpair.l();
                i2 = world.a(HeightMap.Type.b, blockposition.u() + 8, blockposition.w() + 8);
            }
            worldProperties.a(chunkcoordintpair.l().b(8, i2, 8), 0.0f);
            int j2 = 0;
            int k2 = 0;
            int l2 = 0;
            int i1 = -1;
            boolean flag2 = true;
            for (int j1 = 0; j1 < MathHelper.h(11); ++j1) {
                BlockPosition blockposition1;
                if (j2 >= -5 && j2 <= 5 && k2 >= -5 && k2 <= 5 && (blockposition1 = WorldProviderNormal.a(world, new ChunkCoordIntPair(chunkcoordintpair.c + j2, chunkcoordintpair.d + k2))) != null) {
                    worldProperties.a(blockposition1, 0.0f);
                    break;
                }
                if (j2 == k2 || j2 < 0 && j2 == -k2 || j2 > 0 && j2 == 1 - k2) {
                    int k1 = l2;
                    l2 = -i1;
                    i1 = k1;
                }
                j2 += l2;
                k2 += i1;
            }
            if (bonusChest) {
                WorldGenFeatureConfigured<WorldGenFeatureEmptyConfiguration, ?> worldgenfeatureconfigured = MiscOverworldFeatures.l.a();
                worldgenfeatureconfigured.a(world, chunkgenerator, world.v, new BlockPosition(worldProperties.a(), worldProperties.b(), worldProperties.c()));
            }
        }
    }

    @Override
    private void a(SaveData properties) {
        properties.a(EnumDifficulty.a);
        properties.d(true);
        IWorldDataServer iworlddataserver = properties.H();
        iworlddataserver.b(false);
        iworlddataserver.a(false);
        iworlddataserver.a(1000000000);
        iworlddataserver.b(6000L);
        iworlddataserver.a(EnumGamemode.d);
    }

    public void prepareLevels(WorldLoadListener worldloadlistener, WorldServer worldserver) {
        WorldServer worldserver1;
        ForcedChunk forcedchunk;
        ChunkProviderServer chunkproviderserver = worldserver.k();
        this.forceTicks = true;
        if (worldserver.getWorld().getKeepSpawnInMemory()) {
            q.info("Preparing start region for dimension {}", (Object)worldserver.aa().a());
            BlockPosition blockposition = worldserver.v();
            worldloadlistener.a(new ChunkCoordIntPair(blockposition));
            chunkproviderserver.a().a(500);
            this.ao = SystemUtils.b();
            short radiusBlocks = worldserver.paperConfig.keepLoadedRange;
            int radiusChunks = radiusBlocks / 16 + ((radiusBlocks & 0xF) != 0 ? 1 : 0);
            int totalChunks = radiusChunks * 2 + 1;
            totalChunks *= totalChunks;
            worldloadlistener.setChunkRadius(radiusBlocks / 16);
            worldserver.addTicketsForSpawn(radiusBlocks, blockposition);
            this.executeModerately();
        }
        if ((forcedchunk = (worldserver1 = worldserver).t().a(ForcedChunk::b, "chunks")) != null) {
            LongIterator longiterator = forcedchunk.a().iterator();
            while (longiterator.hasNext()) {
                long i2 = longiterator.nextLong();
                ChunkCoordIntPair chunkcoordintpair = new ChunkCoordIntPair(i2);
                worldserver1.k().a(chunkcoordintpair, true);
            }
        }
        this.executeModerately();
        if (worldserver.getWorld().getKeepSpawnInMemory()) {
            worldloadlistener.b();
        }
        chunkproviderserver.a().a(worldserver.paperConfig.lightQueueSize);
        worldserver.b(worldserver.M.s() != EnumDifficulty.a && ((DedicatedServer)this).y.a().B, this.W());
        this.forceTicks = false;
    }

    protected void g_() {
        File file = this.l.a(SavedFile.h).toFile();
        if (file.isFile()) {
            String s2 = this.l.a();
            try {
                this.a(e + URLEncoder.encode(s2, StandardCharsets.UTF_8.toString()) + "/resources.zip", "");
            }
            catch (UnsupportedEncodingException unsupportedencodingexception) {
                q.warn("Something went wrong url encoding {}", (Object)s2);
            }
        }
    }

    public EnumGamemode h_() {
        return this.p.m();
    }

    public boolean g() {
        return this.p.n();
    }

    public abstract int h();

    public abstract int i();

    public abstract boolean j();

    public boolean a(boolean suppressLogs, boolean flush, boolean force) {
        boolean flag3 = false;
        for (WorldServer worldserver : this.F()) {
            if (!suppressLogs) {
                q.info("Saving chunks for level '{}'/{}", (Object)worldserver, (Object)worldserver.aa().a());
            }
            worldserver.a((IProgressUpdate)null, flush, worldserver.b && !force);
            flag3 = true;
        }
        if (flush) {
            for (WorldServer worldserver2 : this.F()) {
                q.info("ThreadedAnvilChunkStorage ({}): All chunks are saved", (Object)worldserver2.k().a.l());
            }
            q.info("ThreadedAnvilChunkStorage: All dimensions are saved");
        }
        return flag3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean b(boolean suppressLogs, boolean flush, boolean force) {
        boolean flag3;
        try {
            this.aD = true;
            this.ac().h();
            flag3 = this.a(suppressLogs, flush, force);
        }
        finally {
            this.aD = false;
        }
        return flag3;
    }

    @Override
    public void close() {
        this.t();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean hasStopped() {
        Object object = this.stopLock;
        synchronized (object) {
            return this.hasStopped;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void t() {
        Object object = this.stopLock;
        synchronized (object) {
            if (this.hasStopped) {
                return;
            }
            this.hasStopped = true;
        }
        if (!this.hasLoggedStop && this.isDebugging()) {
            TraceUtil.dumpTraceForThread("Server stopped");
        }
        this.shutdownThread = Thread.currentThread();
        WatchdogThread.doStop();
        if (!this.bk()) {
            q.info("Stopping main thread (Ignore any thread death message you see! - DO NOT REPORT THREAD DEATH TO PAPER)");
            while (this.at().isAlive()) {
                this.at().stop();
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        q.info("Stopping server");
        MinecraftTimings.stopServer();
        if (this.server != null) {
            this.server.disablePlugins();
            this.server.waitForAsyncTasksShutdown();
        }
        if (this.ad() != null) {
            this.ad().b();
        }
        this.aD = true;
        if (this.S != null) {
            q.info("Saving players");
            this.S.h();
            this.S.removeAll(this.isRestarting);
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        q.info("Saving worlds");
        for (WorldServer worldserver : this.F()) {
            if (worldserver == null) continue;
            worldserver.b = false;
        }
        for (WorldServer level : this.F()) {
            level.saveLevelDat();
        }
        while (this.R.values().stream().anyMatch(worldserver1 -> worldserver1.k().a.d())) {
            this.ao = SystemUtils.b() + 1L;
            for (WorldServer worldserver : this.F()) {
                worldserver.k().m();
                worldserver.k().a(() -> true, false);
                while (worldserver.k().d()) {
                }
            }
            this.forceTicks = true;
            while (this.y()) {
            }
        }
        this.a(false, true, false);
        for (WorldServer worldserver : this.F()) {
            if (worldserver == null) continue;
            try {
                worldserver.close();
            }
            catch (IOException ioexception) {
                q.error("Exception closing the level", (Throwable)ioexception);
            }
        }
        this.aD = false;
        this.aB.close();
        try {
            this.l.close();
        }
        catch (IOException ioexception1) {
            q.error("Failed to unlock level {}", (Object)this.l.a(), (Object)ioexception1);
        }
        MCUtil.asyncExecutor.shutdown();
        try {
            MCUtil.asyncExecutor.awaitTermination(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (SpigotConfig.saveUserCacheOnStopOnly) {
            q.info("Saving usercache.json");
            this.ao().save(false);
        }
        q.info("Flushing Chunk IO");
        PaperFileIOThread.Holder.INSTANCE.close(true, true);
        q.info("Closing Thread Pool");
        SystemUtils.h();
        q.info("Closing Server");
        try {
            TerminalConsoleAppender.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.f();
    }

    public String u() {
        return this.O;
    }

    public void a_(String serverIp) {
        this.O = serverIp;
    }

    public boolean v() {
        return this.T;
    }

    @Override
    public void a(boolean flag) {
        this.safeShutdown(flag, false);
    }

    public void safeShutdown(boolean flag, boolean isRestarting) {
        this.isRestarting = isRestarting;
        this.hasLoggedStop = true;
        if (this.isDebugging()) {
            TraceUtil.dumpTraceForThread("Server stopped");
        }
        this.T = false;
        if (flag) {
            try {
                this.an.join();
            }
            catch (InterruptedException interruptedexception) {
                q.error("Error while shutting down", (Throwable)interruptedexception);
            }
        }
    }

    private static double calcTps(double avg, double exp, double tps) {
        return avg * exp + tps * (1.0 - exp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void w() {
        try {
            long serverStartTime = SystemUtils.c();
            if (this.e()) {
                long start;
                this.ao = SystemUtils.b();
                this.L.a(new ChatComponentText(this.aa));
                this.L.a(new ServerPing.ServerData(SharedConstants.b().getName(), SharedConstants.b().getProtocolVersion()));
                this.a(this.L);
                q.info("Running delayed init tasks");
                this.server.getScheduler().mainThreadHeartbeat(this.V);
                String doneTime = String.format(Locale.ROOT, "%.3fs", (double)(SystemUtils.c() - serverStartTime) / 1.0E9);
                q.info("Done ({})! For help, type \"help\"", (Object)doneTime);
                WatchdogThread.tick();
                WatchdogThread.hasStarted = true;
                Arrays.fill(this.recentTps, 20.0);
                long tickSection = start = System.nanoTime();
                this.lastTick = start - 50000000L;
                while (this.T) {
                    long curTime = System.nanoTime();
                    long i2 = curTime / 1000000L - this.ao;
                    if (i2 > 5000L && this.ao - this.ai >= 30000L) {
                        long j2 = i2 / 50L;
                        if (this.server.getWarnOnOverload()) {
                            q.warn("Can't keep up! Is the server overloaded? Running {}ms or {} ticks behind", (Object)i2, (Object)j2);
                        }
                        this.ao += j2 * 50L;
                        this.ai = this.ao;
                    }
                    ++currentTickLong;
                    if (++currentTick % 20 == 0) {
                        long diff = curTime - tickSection;
                        BigDecimal currentTps = TPS_BASE.divide(new BigDecimal(diff), 30, RoundingMode.HALF_UP);
                        this.tps1.add(currentTps, diff);
                        this.tps5.add(currentTps, diff);
                        this.tps15.add(currentTps, diff);
                        this.recentTps[0] = this.tps1.getAverage();
                        this.recentTps[1] = this.tps5.getAverage();
                        this.recentTps[2] = this.tps15.getAverage();
                        tickSection = curTime;
                    }
                    if (this.I) {
                        this.I = false;
                        this.H = new b(SystemUtils.c(), this.V);
                    }
                    this.lastTick = curTime;
                    this.ao += 50L;
                    this.bg();
                    this.D.a("tick");
                    this.a(this::bd);
                    this.D.b("nextTickWait");
                    this.aq = true;
                    this.ap = Math.max(SystemUtils.b() + 50L, this.ao);
                    this.x();
                    this.D.c();
                    this.bh();
                    this.ah = true;
                    JvmProfiler.e.a(this.ay);
                }
                return;
            }
            this.a((CrashReport)null);
            return;
        }
        catch (Throwable throwable) {
            if (throwable instanceof ThreadDeath) {
                q.error("Main thread terminated by WatchDog due to hard crash", throwable);
                return;
            }
            q.error("Encountered an unexpected exception", throwable);
            if (throwable.getCause() != null) {
                q.error("\tCause of unexpected exception was", throwable.getCause());
            }
            CrashReport crashreport = MinecraftServer.a(throwable);
            this.b(crashreport.g());
            File file = new File(this.A(), "crash-reports");
            SimpleDateFormat simpledateformat = new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss");
            Date date = new Date();
            File file1 = new File(file, "crash-" + simpledateformat.format(date) + "-server.txt");
            if (crashreport.a(file1)) {
                q.error("This crash report has been saved to: {}", (Object)file1.getAbsolutePath());
            } else {
                q.error("We were unable to save this crash report to disk.");
            }
            this.a(crashreport);
            return;
        }
        finally {
            try {
                this.U = true;
                this.t();
            }
            catch (Throwable throwable1) {
                q.error("Exception stopping the server", throwable1);
            }
            finally {
                if (this.al != null) {
                    this.al.a();
                }
            }
        }
    }

    private static CrashReport a(Throwable throwable) {
        CrashReport crashreport;
        ReportedException reportedexception = null;
        for (Throwable throwable1 = throwable; throwable1 != null; throwable1 = throwable1.getCause()) {
            ReportedException reportedexception1;
            if (!(throwable1 instanceof ReportedException)) continue;
            reportedexception = reportedexception1 = (ReportedException)throwable1;
        }
        if (reportedexception != null) {
            crashreport = reportedexception.a();
            if (reportedexception != throwable) {
                crashreport.a("Wrapped in").a("Wrapping exception", throwable);
            }
        } else {
            crashreport = new CrashReport("Exception in server tick loop", throwable);
        }
        return crashreport;
    }

    private boolean bd() {
        if (this.forceTicks) {
            return true;
        }
        if (this.isOversleep) {
            return this.canOversleep();
        }
        return this.forceTicks || this.bq() || SystemUtils.b() < (this.aq ? this.ap : this.ao);
    }

    private boolean canOversleep() {
        return this.aq && SystemUtils.b() < this.ap;
    }

    private boolean canSleepForTickNoOversleep() {
        return this.forceTicks || this.bq() || SystemUtils.b() < this.ao;
    }

    private void executeModerately() {
        this.bo();
        LockSupport.parkNanos("executing tasks", 1000L);
    }

    protected void x() {
        this.c(() -> !this.canSleepForTickNoOversleep());
    }

    public TickTask a(Runnable runnable) {
        if (this.hasStopped && Thread.currentThread().equals(this.shutdownThread)) {
            runnable.run();
            runnable = () -> {};
        }
        return new TickTask(this.V, runnable);
    }

    protected boolean a(TickTask ticktask) {
        return ticktask.a() + 3 < this.V || this.bd();
    }

    @Override
    public boolean y() {
        boolean flag;
        this.aq = flag = this.be();
        return flag;
    }

    private boolean be() {
        if (super.y()) {
            this.executeMidTickTasks();
            return true;
        }
        boolean ret = false;
        if (this.bd()) {
            for (WorldServer worldserver : this.F()) {
                if (!worldserver.k().d()) continue;
                ret = true;
            }
        }
        return ret;
    }

    public void b(TickTask ticktask) {
        this.aN().d("runTask");
        super.d(ticktask);
    }

    @Override
    private void a(ServerPing metadata) {
        Optional<File> optional = Optional.of(this.c("server-icon.png")).filter(File::isFile);
        if (!optional.isPresent()) {
            optional = this.l.e().map(Path::toFile).filter(File::isFile);
        }
        optional.ifPresent(file -> {
            try {
                BufferedImage bufferedimage = ImageIO.read(file);
                Validate.validState((bufferedimage.getWidth() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels wide", (Object[])new Object[0]);
                Validate.validState((bufferedimage.getHeight() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels high", (Object[])new Object[0]);
                ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)bufferedimage, "PNG", bytearrayoutputstream);
                byte[] abyte = Base64.getEncoder().encode(bytearrayoutputstream.toByteArray());
                String s2 = new String(abyte, StandardCharsets.UTF_8);
                metadata.a("data:image/png;base64," + s2);
            }
            catch (Exception exception) {
                q.error("Couldn't load server icon", (Throwable)exception);
            }
        });
    }

    public Optional<Path> z() {
        return this.l.e();
    }

    public File A() {
        return new File(".");
    }

    @Override
    protected void a(CrashReport report) {
    }

    public void f() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void a(BooleanSupplier shouldKeepTicking) {
        int playerSaveInterval;
        TimingsManager.FULL_SERVER_TICK.startTiming();
        long i2 = SystemUtils.c();
        this.isOversleep = true;
        MinecraftTimings.serverOversleep.startTiming();
        this.c(() -> !this.canOversleep());
        this.isOversleep = false;
        MinecraftTimings.serverOversleep.stopTiming();
        new ServerTickStartEvent(this.V + 1).callEvent();
        ++this.V;
        this.b(shouldKeepTicking);
        if (i2 - this.am >= 5000000000L) {
            this.am = i2;
            this.L.a(new ServerPing.ServerPingPlayerSample(this.I(), this.H()));
            if (!this.aj()) {
                GameProfile[] agameprofile = new GameProfile[Math.min(this.H(), SpigotConfig.playerSample)];
                int j2 = MathHelper.a(this.M, 0, this.H() - agameprofile.length);
                for (int k2 = 0; k2 < agameprofile.length; ++k2) {
                    EntityPlayer entityplayer = this.S.t().get(j2 + k2);
                    agameprofile[k2] = entityplayer.V() ? entityplayer.fq() : k;
                }
                Collections.shuffle(Arrays.asList(agameprofile));
                this.L.b().a(agameprofile);
            }
        }
        if ((playerSaveInterval = PaperConfig.playerAutoSaveRate) < 0) {
            playerSaveInterval = this.autosavePeriod;
        }
        this.D.a("save");
        boolean fullSave = this.autosavePeriod > 0 && this.V % this.autosavePeriod == 0;
        try {
            this.aD = true;
            if (playerSaveInterval > 0) {
                this.S.saveAll(playerSaveInterval);
            }
            for (WorldServer level : this.F()) {
                if (level.paperConfig.autoSavePeriod <= 0) continue;
                level.saveIncrementally(fullSave);
            }
        }
        finally {
            this.aD = false;
        }
        this.D.c();
        CachedLists.reset();
        try (Timing ignored = MinecraftTimings.processTasksTimer.startTiming();){
            this.bo();
        }
        long endTime = System.nanoTime();
        long remaining = 50000000L - (endTime - this.lastTick) - this.catchupTime;
        new ServerTickEndEvent(this.V, (double)(endTime - this.lastTick) / 1000000.0, remaining).callEvent();
        this.D.a("tallying");
        long l2 = SystemUtils.c() - i2;
        this.o[this.V % 100] = l2;
        long l3 = l2;
        this.ay = this.ay * 0.8f + (float)l3 / 1000000.0f * 0.19999999f;
        long i1 = SystemUtils.c();
        this.tickTimes5s.add(this.V, l3);
        this.tickTimes10s.add(this.V, l3);
        this.tickTimes60s.add(this.V, l3);
        this.aw.a(i1 - i2);
        this.D.c();
        WatchdogThread.tick();
        TimingsManager.FULL_SERVER_TICK.stopTiming();
    }

    public void b(BooleanSupplier shouldKeepTicking) {
        MinecraftTimings.bukkitSchedulerTimer.startTiming();
        this.server.getScheduler().mainThreadHeartbeat(this.V);
        MinecraftTimings.bukkitSchedulerTimer.stopTiming();
        this.D.a("commandFunctions");
        MinecraftTimings.commandFunctionsTimer.startTiming();
        this.ay().c();
        MinecraftTimings.commandFunctionsTimer.stopTiming();
        this.D.b("levels");
        Iterator<WorldServer> iterator = this.F().iterator();
        MinecraftTimings.processQueueTimer.startTiming();
        while (!this.processQueue.isEmpty()) {
            this.processQueue.remove().run();
        }
        MinecraftTimings.processQueueTimer.stopTiming();
        MinecraftTimings.timeUpdateTimer.startTiming();
        for (WorldServer worldServer : this.F()) {
            boolean doDaylight = worldServer.W().b(GameRules.k);
            long dayTime = worldServer.V();
            long worldTime = worldServer.U();
            PacketPlayOutUpdateTime worldPacket = new PacketPlayOutUpdateTime(worldTime, dayTime, doDaylight);
            for (EntityHuman entityHuman : worldServer.y()) {
                if (!(entityHuman instanceof EntityPlayer) || (this.V + entityHuman.ae()) % 20 != 0) continue;
                EntityPlayer entityplayer = (EntityPlayer)entityHuman;
                long playerTime = entityplayer.getPlayerTime();
                PacketPlayOutUpdateTime packet = playerTime == dayTime ? worldPacket : new PacketPlayOutUpdateTime(worldTime, playerTime, doDaylight);
                entityplayer.b.a(packet);
            }
        }
        MinecraftTimings.timeUpdateTimer.stopTiming();
        while (iterator.hasNext()) {
            WorldServer worldserver = iterator.next();
            worldserver.hasPhysicsEvent = BlockPhysicsEvent.getHandlerList().getRegisteredListeners().length > 0;
            worldserver.hasEntityMoveEvent = EntityMoveEvent.getHandlerList().getRegisteredListeners().length > 0;
            TileEntityHopper.skipHopperEvents = worldserver.paperConfig.disableHopperMoveEvents || InventoryMoveItemEvent.getHandlerList().getRegisteredListeners().length == 0;
            this.D.a(() -> worldserver + " " + worldserver.aa().a());
            this.D.a("tick");
            try {
                worldserver.timings.doTick.startTiming();
                worldserver.a(shouldKeepTicking);
                for (SingleThreadChunkRegionManager regionManager : worldserver.k().a.regionManagers) {
                    regionManager.recalculateRegions();
                }
                worldserver.timings.doTick.stopTiming();
            }
            catch (Throwable throwable) {
                CrashReport crashreport;
                try {
                    crashreport = CrashReport.a(throwable, "Exception ticking world");
                }
                catch (Throwable t2) {
                    if (throwable instanceof ThreadDeath) {
                        throw (ThreadDeath)throwable;
                    }
                    throw new RuntimeException("Error generating crash report", t2);
                }
                worldserver.a(crashreport);
                throw new ReportedException(crashreport);
            }
            this.D.c();
            this.D.c();
            worldserver.explosionDensityCache.clear();
        }
        this.D.b("connection");
        MinecraftTimings.connectionTimer.startTiming();
        this.ad().c();
        MinecraftTimings.connectionTimer.stopTiming();
        this.D.b("players");
        MinecraftTimings.playerListTimer.startTiming();
        this.S.d();
        MinecraftTimings.playerListTimer.stopTiming();
        if (SharedConstants.aI) {
            GameTestHarnessTicker.a.b();
        }
        this.D.b("server gui refresh");
        MinecraftTimings.tickablesTimer.startTiming();
        for (int i2 = 0; i2 < this.B.size(); ++i2) {
            this.B.get(i2).run();
        }
        MinecraftTimings.tickablesTimer.stopTiming();
        this.D.c();
    }

    public boolean B() {
        return true;
    }

    public void b(Runnable tickable) {
        this.B.add(tickable);
    }

    protected void b(String serverId) {
        this.aA = serverId;
    }

    public boolean C() {
        return !this.an.isAlive();
    }

    public File c(String path) {
        return new File(this.A(), path);
    }

    public final WorldServer D() {
        return this.R.get(net.minecraft.world.level.World.e);
    }

    @Nullable
    public WorldServer a(ResourceKey<net.minecraft.world.level.World> key) {
        return this.R.get(key);
    }

    public Set<ResourceKey<net.minecraft.world.level.World>> E() {
        return this.R.keySet();
    }

    public Iterable<WorldServer> F() {
        return this.R.values();
    }

    public String G() {
        return SharedConstants.b().getName();
    }

    public int H() {
        return this.S.m();
    }

    public int I() {
        return this.S.n();
    }

    public String[] J() {
        return this.S.e();
    }

    @DontObfuscate
    public String getServerModName() {
        return "Paper";
    }

    public SystemReport b(SystemReport details) {
        details.a("Server Running", () -> Boolean.toString(this.T));
        if (this.S != null) {
            details.a("Player Count", () -> {
                int i2 = this.S.m();
                return i2 + " / " + this.S.n() + "; " + this.S.t();
            });
        }
        details.a("Data Packs", () -> {
            StringBuilder stringbuilder = new StringBuilder();
            for (ResourcePackLoader resourcepackloader : this.ar.e()) {
                if (stringbuilder.length() > 0) {
                    stringbuilder.append(", ");
                }
                stringbuilder.append(resourcepackloader.e());
                if (resourcepackloader.c().a()) continue;
                stringbuilder.append(" (incompatible)");
            }
            return stringbuilder.toString();
        });
        details.a("World Generation", () -> this.p.B().toString());
        if (this.aA != null) {
            details.a("Server Id", () -> this.aA);
        }
        return this.a(details);
    }

    public abstract SystemReport a(SystemReport var1);

    public ModCheck K() {
        return ModCheck.a(b, this::getServerModName, "Server", MinecraftServer.class);
    }

    @Override
    public void a(IChatBaseComponent message, UUID sender) {
        q.info(HexFormattingConverter.SERIALIZER.serialize(PaperAdventure.asAdventure(message)));
    }

    public KeyPair L() {
        return this.ac;
    }

    public int M() {
        return this.P;
    }

    @Override
    public void a(int serverPort) {
        this.P = serverPort;
    }

    public String N() {
        return this.ad;
    }

    @Override
    public void d(String singlePlayerName) {
        this.ad = singlePlayerName;
    }

    public boolean O() {
        return this.ad != null;
    }

    protected void P() {
        q.info("Generating keypair");
        try {
            this.ac = MinecraftEncryption.b();
        }
        catch (CryptographyException cryptographyexception) {
            throw new IllegalStateException("Failed to generate key pair", cryptographyexception);
        }
    }

    public void setDifficulty(WorldServer level, EnumDifficulty difficulty, boolean forceUpdate) {
        WorldDataServer worldData = level.M;
        if (forceUpdate || !worldData.t()) {
            worldData.a(worldData.n() ? EnumDifficulty.d : difficulty);
            level.b(worldData.s() != EnumDifficulty.a && ((DedicatedServer)this).y.a().B, this.W());
        }
    }

    public int b(int initialDistance) {
        return initialDistance;
    }

    private void bf() {
        for (WorldServer worldserver : this.F()) {
            worldserver.b(worldserver.M.s() != EnumDifficulty.a && ((DedicatedServer)this).y.a().B, this.W());
        }
    }

    public void b(boolean locked) {
        this.p.d(locked);
        this.ac().t().forEach(this::c);
    }

    private void c(EntityPlayer player) {
        WorldData worlddata = player.x().n_();
        player.b.a(new PacketPlayOutServerDifficulty(worlddata.s(), worlddata.t()));
    }

    public boolean Q() {
        return this.p.s() != EnumDifficulty.a;
    }

    public boolean R() {
        return this.ae;
    }

    public void c(boolean demo) {
        this.ae = demo;
    }

    public String S() {
        return this.af;
    }

    public String T() {
        return this.ag;
    }

    public void a(String url, String hash) {
        this.af = url;
        this.ag = hash;
    }

    public abstract boolean k();

    public abstract int l();

    public boolean U() {
        return this.W;
    }

    @Override
    public void d(boolean onlineMode) {
        this.W = onlineMode;
    }

    public boolean V() {
        return this.X;
    }

    public void e(boolean preventProxyConnections) {
        this.X = preventProxyConnections;
    }

    public boolean W() {
        return true;
    }

    public boolean X() {
        return true;
    }

    public abstract boolean m();

    public boolean Y() {
        return this.Y;
    }

    public void f(boolean pvpEnabled) {
        this.Y = pvpEnabled;
    }

    public boolean Z() {
        return this.Z;
    }

    public void g(boolean flightEnabled) {
        this.Z = flightEnabled;
    }

    public abstract boolean n();

    public String aa() {
        return this.aa;
    }

    public void e(String motd) {
        this.aa = motd;
    }

    public boolean ab() {
        return this.U;
    }

    public PlayerList ac() {
        return this.S;
    }

    @Override
    public void a(PlayerList playerManager) {
        this.S = playerManager;
    }

    public abstract boolean o();

    @Override
    public void a(EnumGamemode gameMode) {
        this.p.a(gameMode);
    }

    @Nullable
    public ServerConnection ad() {
        return this.J == null ? (this.J = new ServerConnection(this)) : this.J;
    }

    public boolean ae() {
        return this.ah;
    }

    public boolean af() {
        return false;
    }

    public boolean a(@Nullable EnumGamemode gameMode, boolean cheatsAllowed, int port) {
        return false;
    }

    public int ag() {
        return this.V;
    }

    public int ah() {
        return 16;
    }

    public boolean a(WorldServer world, BlockPosition pos, EntityHuman player) {
        return false;
    }

    public boolean ai() {
        return true;
    }

    public boolean aj() {
        return false;
    }

    public Proxy ak() {
        return this.n;
    }

    public int al() {
        return this.ab;
    }

    public void c(int playerIdleTimeout) {
        this.ab = playerIdleTimeout;
    }

    public MinecraftSessionService am() {
        return this.aj;
    }

    public GameProfileRepository an() {
        return this.ak;
    }

    public UserCache ao() {
        return this.al;
    }

    public ServerPing ap() {
        return this.L;
    }

    public void aq() {
        this.am = 0L;
    }

    public int ar() {
        return 29999984;
    }

    @Override
    public boolean as() {
        return super.as() && !this.ab();
    }

    @Override
    public void c(Runnable runnable) {
        if (this.ab()) {
            throw new RejectedExecutionException("Server already shutting down");
        }
        super.c(runnable);
    }

    @Override
    public Thread at() {
        return this.an;
    }

    public int au() {
        return 256;
    }

    public long av() {
        return this.ao;
    }

    public DataFixer aw() {
        return this.N;
    }

    public int a(@Nullable WorldServer world) {
        return world != null ? world.W().c(GameRules.r) : 10;
    }

    public AdvancementDataWorld ax() {
        return this.aB.b.g();
    }

    public CustomFunctionData ay() {
        return this.av;
    }

    @Override
    @Deprecated
    public CompletableFuture<Void> a(Collection<String> dataPacks) {
        return this.reloadResources(dataPacks, ServerResourcesReloadedEvent.Cause.PLUGIN);
    }

    public CompletableFuture<Void> reloadResources(Collection<String> dataPacks, ServerResourcesReloadedEvent.Cause cause) {
        IRegistryCustom.Dimension iregistrycustom_dimension = this.aU();
        CompletionStage completablefuture = ((CompletableFuture)CompletableFuture.supplyAsync(() -> {
            Stream stream = dataPacks.stream();
            ResourcePackRepository resourcepackrepository = this.ar;
            Objects.requireNonNull(this.ar);
            return (ImmutableList)stream.map(resourcepackrepository::a).filter(Objects::nonNull).map(ResourcePackLoader::d).collect(ImmutableList.toImmutableList());
        }, this).thenCompose(immutablelist -> {
            ResourceManager resourcemanager = new ResourceManager(EnumResourcePackType.b, (List<IResourcePack>)immutablelist);
            return ((CompletableFuture)DataPackResources.a(resourcemanager, iregistrycustom_dimension, this.k() ? CommandDispatcher.ServerType.b : CommandDispatcher.ServerType.c, this.i(), this.az, this).whenComplete((datapackresources, throwable) -> {
                if (throwable != null) {
                    resourcemanager.close();
                }
            })).thenApply(datapackresources -> new a(resourcemanager, (DataPackResources)datapackresources));
        })).thenAcceptAsync(minecraftserver_a -> {
            this.aB.close();
            this.aB = minecraftserver_a;
            this.server.syncCommands();
            this.ar.a(dataPacks);
            this.p.a(MinecraftServer.a(this.ar));
            this.aB.b.a(this.aU());
            PaperRegistry.clearCaches();
            PotionBrewer.reload();
            for (WorldServer level : this.R.values()) {
                level.getWorld().structureCache.clear();
            }
            new ServerResourcesReloadedEvent(cause).callEvent();
            if (Thread.currentThread() != this.an) {
                return;
            }
            this.ac().u();
            this.av.a(this.aB.b.a());
            this.aC.a(this.aB.a);
            CraftBlockData.reloadCache();
        }, (Executor)this);
        if (this.bk()) {
            Objects.requireNonNull(completablefuture);
            this.c(((CompletableFuture)completablefuture)::isDone);
        }
        return completablefuture;
    }

    public static DataPackConfiguration a(ResourcePackRepository resourcePackManager, DataPackConfiguration dataPackSettings, boolean safeMode) {
        resourcePackManager.a();
        if (safeMode) {
            resourcePackManager.a(Collections.singleton(b));
            return new DataPackConfiguration((List<String>)ImmutableList.of((Object)b), (List<String>)ImmutableList.of());
        }
        LinkedHashSet set = Sets.newLinkedHashSet();
        for (String s2 : dataPackSettings.a()) {
            if (resourcePackManager.b(s2)) {
                set.add(s2);
                continue;
            }
            q.warn("Missing data pack {}", (Object)s2);
        }
        for (ResourcePackLoader resourcepackloader : resourcePackManager.c()) {
            String s1 = resourcepackloader.e();
            if (dataPackSettings.b().contains(s1) || set.contains(s1)) continue;
            q.info("Found new data pack {}, loading it automatically", (Object)s1);
            set.add(s1);
        }
        if (set.isEmpty()) {
            q.info("No datapacks selected, forcing vanilla");
            set.add(b);
        }
        resourcePackManager.a(set);
        return MinecraftServer.a(resourcePackManager);
    }

    private static DataPackConfiguration a(ResourcePackRepository dataPackManager) {
        Collection<String> collection = dataPackManager.d();
        ImmutableList list = ImmutableList.copyOf(collection);
        List list1 = (List)dataPackManager.b().stream().filter(s2 -> !collection.contains(s2)).collect(ImmutableList.toImmutableList());
        return new DataPackConfiguration((List<String>)list, list1);
    }

    @Override
    public void a(CommandListenerWrapper source) {
        if (this.aK()) {
            PlayerList playerlist = source.j().ac();
            WhiteList whitelist = playerlist.i();
            if (!((DedicatedServer)MinecraftServer.getServer()).a().X.get().booleanValue()) {
                return;
            }
            ArrayList list = Lists.newArrayList(playerlist.t());
            for (EntityPlayer entityplayer : list) {
                if (whitelist.a(entityplayer.fq()) || this.ac().f(entityplayer.fq())) continue;
                entityplayer.b.disconnect(SpigotConfig.whitelistMessage, PlayerKickEvent.Cause.WHITELIST);
            }
        }
    }

    public ResourcePackRepository az() {
        return this.ar;
    }

    public CommandDispatcher aA() {
        return this.aB.b.f();
    }

    public CommandListenerWrapper aB() {
        WorldServer worldserver = this.D();
        return new CommandListenerWrapper(this, worldserver == null ? Vec3D.a : Vec3D.b(worldserver.v()), Vec2F.a, worldserver, 4, "Server", new ChatComponentText("Server"), this, null);
    }

    @Override
    public boolean i_() {
        return true;
    }

    @Override
    public boolean j_() {
        return true;
    }

    @Override
    public abstract boolean G_();

    public CraftingManager aC() {
        return this.aB.b.e();
    }

    public ScoreboardServer aD() {
        return this.as;
    }

    public PersistentCommandStorage aE() {
        if (this.at == null) {
            throw new NullPointerException("Called before server init");
        }
        return this.at;
    }

    public LootTableRegistry aF() {
        return this.aB.b.c();
    }

    public LootPredicateManager aG() {
        return this.aB.b.b();
    }

    public ItemModifierManager aH() {
        return this.aB.b.d();
    }

    public GameRules aI() {
        return this.D().W();
    }

    public BossBattleCustomData aJ() {
        return this.au;
    }

    public boolean aK() {
        return this.ax;
    }

    public void h(boolean enforceWhitelist) {
        this.ax = enforceWhitelist;
    }

    public float aL() {
        return this.ay;
    }

    public int b(GameProfile profile) {
        if (this.ac().f(profile)) {
            OpListEntry oplistentry = (OpListEntry)this.ac().k().b(profile);
            return oplistentry != null ? oplistentry.a() : (this.a(profile) ? 4 : (this.O() ? (this.ac().v() ? 4 : 0) : this.h()));
        }
        return 0;
    }

    public CircularTimer aM() {
        return this.aw;
    }

    public GameProfilerFiller aN() {
        return this.D;
    }

    public abstract boolean a(GameProfile var1);

    @Override
    public void a(Path file) throws IOException {
    }

    private void b(Path path) {
        Path path1 = path.resolve("levels");
        try {
            for (Map.Entry<ResourceKey<net.minecraft.world.level.World>, WorldServer> entry : this.R.entrySet()) {
                MinecraftKey minecraftkey = entry.getKey().a();
                Path path2 = path1.resolve(minecraftkey.b()).resolve(minecraftkey.a());
                java.nio.file.Files.createDirectories(path2, new FileAttribute[0]);
                entry.getValue().a(path2);
            }
            this.d(path.resolve("gamerules.txt"));
            this.e(path.resolve("classpath.txt"));
            this.c(path.resolve("stats.txt"));
            this.f(path.resolve("threads.txt"));
            this.a(path.resolve("server.properties.txt"));
            this.g(path.resolve("modules.txt"));
        }
        catch (IOException ioexception) {
            q.warn("Failed to save debug report", (Throwable)ioexception);
        }
    }

    private void c(Path path) throws IOException {
        try (BufferedWriter bufferedwriter = java.nio.file.Files.newBufferedWriter(path, new OpenOption[0]);){
            bufferedwriter.write(String.format("pending_tasks: %d\n", this.bl()));
            bufferedwriter.write(String.format("average_tick_time: %f\n", Float.valueOf(this.aL())));
            bufferedwriter.write(String.format("tick_times: %s\n", Arrays.toString(this.o)));
            bufferedwriter.write(String.format("queue: %s\n", SystemUtils.f()));
        }
    }

    @Override
    private void d(Path path) throws IOException {
        try (BufferedWriter bufferedwriter = java.nio.file.Files.newBufferedWriter(path, new OpenOption[0]);){
            final ArrayList list = Lists.newArrayList();
            final GameRules gamerules = this.aI();
            GameRules.a(new GameRules.GameRuleVisitor(){

                @Override
                public <T extends GameRules.GameRuleValue<T>> void a(GameRules.GameRuleKey<T> key, GameRules.GameRuleDefinition<T> type) {
                    list.add(String.format("%s=%s\n", key.a(), gamerules.a(key)));
                }
            });
            for (String s2 : list) {
                bufferedwriter.write(s2);
            }
        }
    }

    private void e(Path path) throws IOException {
        try (BufferedWriter bufferedwriter = java.nio.file.Files.newBufferedWriter(path, new OpenOption[0]);){
            String s2 = System.getProperty("java.class.path");
            String s1 = System.getProperty("path.separator");
            for (String s22 : Splitter.on((String)s1).split((CharSequence)s2)) {
                bufferedwriter.write(s22);
                bufferedwriter.write("\n");
            }
        }
    }

    private void f(Path path) throws IOException {
        ThreadMXBean threadmxbean = ManagementFactory.getThreadMXBean();
        ThreadInfo[] athreadinfo = threadmxbean.dumpAllThreads(true, true);
        Arrays.sort(athreadinfo, Comparator.comparing(ThreadInfo::getThreadName));
        try (BufferedWriter bufferedwriter = java.nio.file.Files.newBufferedWriter(path, new OpenOption[0]);){
            ThreadInfo[] athreadinfo1 = athreadinfo;
            int i2 = athreadinfo.length;
            for (int j2 = 0; j2 < i2; ++j2) {
                ThreadInfo threadinfo = athreadinfo1[j2];
                bufferedwriter.write(threadinfo.toString());
                bufferedwriter.write(10);
            }
        }
    }

    private void g(Path path) throws IOException {
        block11: {
            block10: {
                try (BufferedWriter bufferedwriter = java.nio.file.Files.newBufferedWriter(path, new OpenOption[0]);){
                    ArrayList arraylist;
                    try {
                        arraylist = Lists.newArrayList(NativeModuleLister.a());
                    }
                    catch (Throwable throwable) {
                        q.warn("Failed to list native modules", throwable);
                        break block10;
                    }
                    arraylist.sort(Comparator.comparing(nativemodulelister_a -> nativemodulelister_a.a));
                    Iterator iterator = arraylist.iterator();
                    while (true) {
                        if (!iterator.hasNext()) {
                            break block11;
                        }
                        NativeModuleLister.a nativemodulelister_a2 = (NativeModuleLister.a)iterator.next();
                        bufferedwriter.write(nativemodulelister_a2.toString());
                        bufferedwriter.write(10);
                    }
                }
            }
            return;
        }
    }

    @Override
    public boolean bk() {
        return super.bk();
    }

    public boolean isDebugging() {
        return false;
    }

    @Deprecated
    public static MinecraftServer getServer() {
        return SERVER;
    }

    private void bg() {
        if (this.G) {
            this.C = ActiveMetricsRecorder.a(new ServerMetricsSamplersProvider(SystemUtils.a, this.k()), SystemUtils.a, SystemUtils.g(), new MetricsPersister("server"), this.E, path -> {
                this.h(() -> this.b(path.resolve("server")));
                this.F.accept((Path)path);
            });
            this.G = false;
        }
        this.D = GameProfilerTick.a(this.C.e(), GameProfilerTick.a("Server"));
        this.C.b();
        this.D.a();
    }

    private void bh() {
        this.D.b();
        this.C.c();
    }

    public boolean aO() {
        return this.C.d();
    }

    public void a(Consumer<MethodProfilerResults> resultConsumer, Consumer<Path> dumpConsumer) {
        this.E = methodprofilerresults -> {
            this.aP();
            resultConsumer.accept((MethodProfilerResults)methodprofilerresults);
        };
        this.F = dumpConsumer;
        this.G = true;
    }

    public void aP() {
        this.C = InactiveMetricsRecorder.a;
    }

    public void aQ() {
        this.C.a();
    }

    public Path a(SavedFile worldSavePath) {
        return this.l.a(worldSavePath);
    }

    public boolean aR() {
        return true;
    }

    public DefinedStructureManager aS() {
        return this.aC;
    }

    public SaveData aT() {
        return this.p;
    }

    public IRegistryCustom.Dimension aU() {
        return this.Q;
    }

    public ITextFilter a(EntityPlayer player) {
        return ITextFilter.a;
    }

    public boolean aV() {
        return false;
    }

    public PlayerInteractManager b(EntityPlayer player) {
        return this.R() ? new DemoPlayerInteractManager(player) : new PlayerInteractManager(player);
    }

    @Nullable
    public EnumGamemode aW() {
        return null;
    }

    public IResourceManager aX() {
        return this.aB.a;
    }

    @Nullable
    public IChatBaseComponent aY() {
        return null;
    }

    public boolean aZ() {
        return this.aD;
    }

    public boolean ba() {
        return this.I || this.H != null;
    }

    public void bb() {
        this.I = true;
    }

    public MethodProfilerResults bc() {
        if (this.H == null) {
            return MethodProfilerResultsEmpty.a;
        }
        MethodProfilerResults methodprofilerresults = this.H.a(SystemUtils.c(), this.V);
        this.H = null;
        return methodprofilerresults;
    }

    private boolean tickMidTickTasks() {
        boolean executed = false;
        for (WorldServer world : this.F()) {
            long currTime = System.nanoTime();
            if (currTime - world.lastMidTickExecuteFailure <= 5000L) continue;
            if (!world.k().d()) {
                world.lastMidTickExecuteFailure = currTime;
                continue;
            }
            executed = true;
        }
        return executed;
    }

    public final void executeMidTickTasks() {
        AsyncCatcher.catchOp("mid tick chunk task execution");
        long startTime = System.nanoTime();
        if (startTime - lastMidTickExecute <= 25000L || startTime - lastMidTickExecuteFailure <= 5000L) {
            return;
        }
        MinecraftTimings.midTickChunkTasks.startTiming();
        try {
            while (true) {
                long overuse;
                boolean moreTasks = this.tickMidTickTasks();
                long currTime = System.nanoTime();
                long diff = currTime - startTime;
                if (moreTasks && diff < 1000L) continue;
                if (!moreTasks) {
                    lastMidTickExecuteFailure = currTime;
                }
                if ((overuse = diff - 1000L) >= 10000000L) {
                    overuse = 10000000L;
                }
                double overuseCount = (double)overuse / 1000.0;
                long extraSleep = Math.round(overuseCount * 25000.0);
                lastMidTickExecute = currTime + extraSleep;
                return;
            }
        }
        finally {
            MinecraftTimings.midTickChunkTasks.stopTiming();
        }
    }

    static {
        q = LogUtils.getLogger();
        g = new File("usercache.json");
        j = new WorldSettings("Demo World", EnumGamemode.a, false, EnumDifficulty.c, false, new GameRules(), DataPackConfiguration.a);
        k = new GameProfile(SystemUtils.c, "Anonymous Player");
        currentTick = 0;
        currentTickLong = 0L;
        TPS_BASE = new BigDecimal(1.0E9).multiply(new BigDecimal(20));
    }

    public static class TickTimes {
        private final long[] times;

        public TickTimes(int length) {
            this.times = new long[length];
        }

        void add(int index, long time) {
            this.times[index % this.times.length] = time;
        }

        public long[] getTimes() {
            return (long[])this.times.clone();
        }

        public double getAverage() {
            long total = 0L;
            for (long value : this.times) {
                total += value;
            }
            return (double)total / (double)this.times.length * 1.0E-6;
        }
    }

    public static class RollingAverage {
        private final int size;
        private long time;
        private BigDecimal total;
        private int index = 0;
        private final BigDecimal[] samples;
        private final long[] times;

        RollingAverage(int size) {
            this.size = size;
            this.time = (long)size * 1000000000L;
            this.total = RollingAverage.dec(20L).multiply(RollingAverage.dec(1000000000L)).multiply(RollingAverage.dec(size));
            this.samples = new BigDecimal[size];
            this.times = new long[size];
            for (int i2 = 0; i2 < size; ++i2) {
                this.samples[i2] = RollingAverage.dec(20L);
                this.times[i2] = 1000000000L;
            }
        }

        private static BigDecimal dec(long t2) {
            return new BigDecimal(t2);
        }

        public void add(BigDecimal x2, long t2) {
            this.time -= this.times[this.index];
            this.total = this.total.subtract(this.samples[this.index].multiply(RollingAverage.dec(this.times[this.index])));
            this.samples[this.index] = x2;
            this.times[this.index] = t2;
            this.time += t2;
            this.total = this.total.add(x2.multiply(RollingAverage.dec(t2)));
            if (++this.index == this.size) {
                this.index = 0;
            }
        }

        public double getAverage() {
            return this.total.divide(RollingAverage.dec(this.time), 30, RoundingMode.HALF_UP).doubleValue();
        }
    }

    public record a(IReloadableResourceManager a, DataPackResources b) implements AutoCloseable
    {
        @Override
        public void close() {
            this.a.close();
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "resourceManager;managers", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "resourceManager;managers", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "resourceManager;managers", "a", "b"}, this, o2);
        }
    }

    private static class b {
        final long a;
        final int b;

        b(long time, int tick) {
            this.a = time;
            this.b = tick;
        }

        MethodProfilerResults a(final long endTime, final int endTick) {
            return new MethodProfilerResults(){

                @Override
                public List<MethodProfilerResultsField> a(String parentPath) {
                    return Collections.emptyList();
                }

                @Override
                public boolean a(Path path) {
                    return false;
                }

                @Override
                public long a() {
                    return a;
                }

                @Override
                public int b() {
                    return b;
                }

                @Override
                public long c() {
                    return endTime;
                }

                @Override
                public int d() {
                    return endTick;
                }

                @Override
                public String e() {
                    return "";
                }
            };
        }
    }
}

