/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.destroystokyo.paper.profile.PaperAuthenticationService;
import com.google.common.base.Charsets;
import com.google.common.io.Files;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import io.papermc.paper.world.ThreadedWorldUpgrader;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.IOException;
import java.net.Proxy;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BooleanSupplier;
import joptsimple.OptionSet;
import net.minecraft.CrashReport;
import net.minecraft.SharedConstants;
import net.minecraft.SystemUtils;
import net.minecraft.commands.CommandDispatcher;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.obfuscate.DontObfuscate;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.DispenserRegistry;
import net.minecraft.server.EULA;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.WorldStem;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.dedicated.DedicatedServerSettings;
import net.minecraft.server.level.progress.WorldLoadListenerLogger;
import net.minecraft.server.packs.EnumResourcePackType;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.repository.ResourcePackRepository;
import net.minecraft.server.packs.repository.ResourcePackSourceFolder;
import net.minecraft.server.packs.repository.ResourcePackSourceVanilla;
import net.minecraft.server.players.UserCache;
import net.minecraft.util.MathHelper;
import net.minecraft.util.datafix.DataConverterRegistry;
import net.minecraft.util.profiling.jfr.Environment;
import net.minecraft.util.profiling.jfr.JvmProfiler;
import net.minecraft.util.worldupdate.WorldUpgrader;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.level.DataPackConfiguration;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.levelgen.GeneratorSettings;
import net.minecraft.world.level.storage.Convertable;
import net.minecraft.world.level.storage.SavedFile;
import net.minecraft.world.level.storage.WorldInfo;
import org.bukkit.configuration.file.YamlConfiguration;
import org.slf4j.Logger;
import org.spigotmc.SpigotConfig;

public class Main {
    private static final Logger a = LogUtils.getLogger();

    @DontObfuscate
    public static void main(OptionSet optionset) {
        SharedConstants.a();
        try {
            WorldStem worldstem;
            boolean flag;
            File file;
            CrashReport.h();
            if (optionset.has("jfrProfile")) {
                JvmProfiler.e.a(Environment.b);
            }
            DispenserRegistry.a();
            DispenserRegistry.c();
            SystemUtils.l();
            Path path = Paths.get("server.properties", new String[0]);
            DedicatedServerSettings dedicatedserversettings = new DedicatedServerSettings(optionset);
            dedicatedserversettings.b();
            YamlConfiguration bukkitConfiguration = Main.loadConfigFile((File)optionset.valueOf("bukkit-settings"));
            YamlConfiguration spigotConfiguration = Main.loadConfigFile((File)optionset.valueOf("spigot-settings"));
            YamlConfiguration paperConfiguration = Main.loadConfigFile((File)optionset.valueOf("paper-settings"));
            Path path1 = Paths.get("eula.txt", new String[0]);
            EULA eula = new EULA(path1);
            if (optionset.has("initSettings")) {
                a.info("Initialized '{}' and '{}'", (Object)path.toAbsolutePath(), (Object)path1.toAbsolutePath());
                return;
            }
            boolean eulaAgreed = Boolean.getBoolean("com.mojang.eula.agree");
            if (eulaAgreed) {
                System.err.println("You have used the Spigot command line EULA agreement flag.");
                System.err.println("By using this setting you are indicating your agreement to Mojang's EULA (https://account.mojang.com/documents/minecraft_eula).");
                System.err.println("If you do not agree to the above EULA please stop your server and remove this flag immediately.");
            }
            if (!eula.a() && !eulaAgreed) {
                a.info("You need to agree to the EULA in order to run the server. Go to eula.txt for more info.");
                return;
            }
            SpigotConfig.disabledAdvancements = spigotConfiguration.getStringList("advancements.disabled");
            File userCacheFile = new File("usercache.json");
            if (optionset.has("universe")) {
                file = (File)optionset.valueOf("universe");
                userCacheFile = new File(file, "usercache.json");
            } else {
                file = new File(bukkitConfiguration.getString("settings.world-container", "."));
            }
            PaperAuthenticationService yggdrasilauthenticationservice = new PaperAuthenticationService(Proxy.NO_PROXY);
            MinecraftSessionService minecraftsessionservice = yggdrasilauthenticationservice.createMinecraftSessionService();
            GameProfileRepository gameprofilerepository = yggdrasilauthenticationservice.createProfileRepository();
            UserCache usercache = new UserCache(gameprofilerepository, userCacheFile);
            String s2 = Optional.ofNullable((String)optionset.valueOf("world")).orElse(dedicatedserversettings.a().p);
            Convertable convertable = Convertable.a(file.toPath());
            Convertable.ConversionSession convertable_conversionsession = convertable.createAccess(s2, WorldDimension.b);
            WorldInfo worldinfo = convertable_conversionsession.c();
            if (worldinfo != null) {
                if (worldinfo.d()) {
                    a.info("This world must be opened in an older version (like 1.6.4) to be safely converted");
                    return;
                }
                if (!worldinfo.q()) {
                    a.info("This world was created by an incompatible version.");
                    return;
                }
            }
            if (flag = optionset.has("safeMode")) {
                a.warn("Safe mode active, only vanilla datapack will be loaded");
            }
            ResourcePackRepository resourcepackrepository = new ResourcePackRepository(EnumResourcePackType.b, new ResourcePackSourceVanilla(), new ResourcePackSourceFolder(convertable_conversionsession.a(SavedFile.g).toFile(), PackSource.c));
            File bukkitDataPackFolder = new File(convertable_conversionsession.a(SavedFile.g).toFile(), "bukkit");
            if (!bukkitDataPackFolder.exists()) {
                bukkitDataPackFolder.mkdirs();
            }
            File mcMeta = new File(bukkitDataPackFolder, "pack.mcmeta");
            try {
                Files.write((CharSequence)("{\n    \"pack\": {\n        \"description\": \"Data pack for resources provided by Bukkit plugins\",\n        \"pack_format\": " + SharedConstants.b().getPackVersion() + "\n    }\n}\n"), (File)mcMeta, (Charset)Charsets.UTF_8);
            }
            catch (IOException ex) {
                throw new RuntimeException("Could not initialize Bukkit datapack", ex);
            }
            AtomicReference config = new AtomicReference();
            AtomicReference ops = new AtomicReference();
            try {
                WorldStem.b worldstem_b = new WorldStem.b(resourcepackrepository, CommandDispatcher.ServerType.b, dedicatedserversettings.a().G, flag);
                worldstem = WorldStem.a(worldstem_b, () -> {
                    DataPackConfiguration datapackconfiguration = convertable_conversionsession.d();
                    return datapackconfiguration == null ? DataPackConfiguration.a : datapackconfiguration;
                }, (iresourcemanager, datapackconfiguration) -> {
                    IRegistryCustom.e iregistrycustom_e = IRegistryCustom.e();
                    RegistryOps<NBTBase> dynamicops = RegistryOps.a(DynamicOpsNBT.a, iregistrycustom_e, iresourcemanager);
                    config.set(datapackconfiguration);
                    ops.set(dynamicops);
                    return Pair.of(null, (Object)iregistrycustom_e.f());
                }, SystemUtils.f(), Runnable::run).get();
            }
            catch (Exception exception) {
                a.warn("Failed to load datapacks, can't proceed with server load. You can either fix your datapacks or reset to vanilla with --safeMode", (Throwable)exception);
                resourcepackrepository.close();
                return;
            }
            worldstem.a();
            Class.forName(VillagerTrades.class.getName());
            DedicatedServer dedicatedServer = MinecraftServer.a(thread -> {
                int port;
                boolean flag1;
                DedicatedServer dedicatedserver1 = new DedicatedServer(optionset, (DataPackConfiguration)config.get(), (DynamicOps<NBTBase>)((DynamicOps)ops.get()), (Thread)thread, convertable_conversionsession, resourcepackrepository, worldstem, dedicatedserversettings, DataConverterRegistry.a(), minecraftsessionservice, gameprofilerepository, usercache, WorldLoadListenerLogger::new);
                boolean bl = flag1 = !optionset.has("nogui") && !optionset.nonOptionArguments().contains("nogui");
                if (!Boolean.parseBoolean(System.getenv().getOrDefault("PAPER_DISABLE_SERVER_GUI", String.valueOf(false))) && flag1 && !GraphicsEnvironment.isHeadless()) {
                    dedicatedserver1.bg();
                }
                if (optionset.has("port") && (port = ((Integer)optionset.valueOf("port")).intValue()) > 0) {
                    dedicatedserver1.a(port);
                }
                return dedicatedserver1;
            });
        }
        catch (Exception exception1) {
            a.error(LogUtils.FATAL_MARKER, "Failed to start the minecraft server", (Throwable)exception1);
        }
    }

    private static YamlConfiguration loadConfigFile(File configFile) throws Exception {
        YamlConfiguration config = new YamlConfiguration();
        if (configFile.exists()) {
            try {
                config.load(configFile);
            }
            catch (Exception ex) {
                throw new Exception("Failed to load configuration file: " + configFile.getName(), ex);
            }
        }
        return config;
    }

    public static void convertWorldButItWorks(ResourceKey<WorldDimension> dimensionType, Convertable.ConversionSession worldSession, DataFixer dataFixer, Optional<ResourceKey<Codec<? extends ChunkGenerator>>> generatorKey, boolean removeCaches) {
        int threads = Runtime.getRuntime().availableProcessors() * 3 / 8;
        ThreadedWorldUpgrader worldUpgrader = new ThreadedWorldUpgrader(dimensionType, worldSession.a(), worldSession.c.toFile(), threads, dataFixer, generatorKey, removeCaches);
        worldUpgrader.convert();
    }

    public static void a(Convertable.ConversionSession session, DataFixer dataFixer, boolean eraseCache, BooleanSupplier continueCheck, GeneratorSettings generatorOptions) {
        a.info("Forcing world upgrade! {}", (Object)session.a());
        WorldUpgrader worldupgrader = new WorldUpgrader(session, dataFixer, generatorOptions, eraseCache);
        IChatBaseComponent ichatbasecomponent = null;
        while (!worldupgrader.b()) {
            int i2;
            IChatBaseComponent ichatbasecomponent1 = worldupgrader.h();
            if (ichatbasecomponent != ichatbasecomponent1) {
                ichatbasecomponent = ichatbasecomponent1;
                a.info(worldupgrader.h().getString());
            }
            if ((i2 = worldupgrader.e()) > 0) {
                int j2 = worldupgrader.f() + worldupgrader.g();
                a.info("{}% completed ({} / {} chunks)...", new Object[]{MathHelper.d((float)j2 / (float)i2 * 100.0f), j2, i2});
            }
            if (!continueCheck.getAsBoolean()) {
                worldupgrader.a();
                continue;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

