/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.mojang.logging.LogUtils;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import net.minecraft.commands.CommandDispatcher;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.AdvancementDataWorld;
import net.minecraft.server.CustomFunctionManager;
import net.minecraft.server.packs.resources.IReloadListener;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.server.packs.resources.Reloadable;
import net.minecraft.tags.Tag;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagRegistry;
import net.minecraft.util.Unit;
import net.minecraft.world.item.crafting.CraftingManager;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.storage.loot.ItemModifierManager;
import net.minecraft.world.level.storage.loot.LootPredicateManager;
import net.minecraft.world.level.storage.loot.LootTableRegistry;
import org.slf4j.Logger;

public class DataPackResources {
    private static final Logger a = LogUtils.getLogger();
    private static final CompletableFuture<Unit> b = CompletableFuture.completedFuture(Unit.a);
    public CommandDispatcher c;
    private final CraftingManager d = new CraftingManager();
    private final TagRegistry e;
    private final LootPredicateManager f = new LootPredicateManager();
    private final LootTableRegistry g = new LootTableRegistry(this.f);
    private final ItemModifierManager h = new ItemModifierManager(this.f, this.g);
    private final AdvancementDataWorld i = new AdvancementDataWorld(this.f);
    private final CustomFunctionManager j;

    public DataPackResources(IRegistryCustom.Dimension dynamicRegistryManager, CommandDispatcher.ServerType commandEnvironment, int functionPermissionLevel) {
        this.e = new TagRegistry(dynamicRegistryManager);
        this.c = new CommandDispatcher(commandEnvironment);
        this.j = new CustomFunctionManager(functionPermissionLevel, this.c.a());
    }

    public CustomFunctionManager a() {
        return this.j;
    }

    public LootPredicateManager b() {
        return this.f;
    }

    public LootTableRegistry c() {
        return this.g;
    }

    public ItemModifierManager d() {
        return this.h;
    }

    public CraftingManager e() {
        return this.d;
    }

    public CommandDispatcher f() {
        return this.c;
    }

    public AdvancementDataWorld g() {
        return this.i;
    }

    public List<IReloadListener> h() {
        return List.of(this.e, this.f, this.d, this.g, this.h, this.j, this.i);
    }

    public static CompletableFuture<DataPackResources> a(IResourceManager manager, IRegistryCustom.Dimension dynamicRegistryManager, CommandDispatcher.ServerType commandEnvironment, int functionPermissionLevel, Executor prepareExecutor, Executor applyExecutor) {
        DataPackResources reloadableServerResources = new DataPackResources(dynamicRegistryManager, commandEnvironment, functionPermissionLevel);
        return Reloadable.a(manager, reloadableServerResources.h(), prepareExecutor, applyExecutor, b, a.isDebugEnabled()).a().thenApply(object -> reloadableServerResources);
    }

    public void a(IRegistryCustom dynamicRegistryManager) {
        this.e.a().forEach(tags -> DataPackResources.a(dynamicRegistryManager, tags));
        Blocks.a();
    }

    private static <T> void a(IRegistryCustom dynamicRegistryManager, TagRegistry.a<T> tags) {
        ResourceKey resourceKey = tags.a();
        Map map = tags.b().entrySet().stream().collect(Collectors.toUnmodifiableMap(entry -> TagKey.a(resourceKey, (MinecraftKey)entry.getKey()), entry -> ((Tag)entry.getValue()).a()));
        dynamicRegistryManager.d(resourceKey).a(map);
    }
}

