/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.resources;

import com.google.common.collect.Maps;
import com.mojang.serialization.Codec;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.IRegistry;
import net.minecraft.resources.MinecraftKey;

public class ResourceKey<T> {
    private static final Map<String, ResourceKey<?>> a = Collections.synchronizedMap(Maps.newIdentityHashMap());
    private final MinecraftKey b;
    private final MinecraftKey c;

    public static <T> Codec<ResourceKey<T>> a(ResourceKey<? extends IRegistry<T>> registry) {
        return MinecraftKey.a.xmap(id -> ResourceKey.a(registry, id), ResourceKey::a);
    }

    public static <T> ResourceKey<T> a(ResourceKey<? extends IRegistry<T>> registry, MinecraftKey value) {
        return ResourceKey.a(registry.c, value);
    }

    public static <T> ResourceKey<IRegistry<T>> a(MinecraftKey registry) {
        return ResourceKey.a(IRegistry.b, registry);
    }

    private static <T> ResourceKey<T> a(MinecraftKey registry, MinecraftKey value) {
        String string = (registry + ":" + value).intern();
        return a.computeIfAbsent(string, id -> new ResourceKey(registry, value));
    }

    private ResourceKey(MinecraftKey registry, MinecraftKey value) {
        this.b = registry;
        this.c = value;
    }

    @Override
    public String toString() {
        return "ResourceKey[" + this.b + " / " + this.c + "]";
    }

    public boolean b(ResourceKey<? extends IRegistry<?>> registry) {
        return this.b.equals(registry.a());
    }

    public <E> Optional<ResourceKey<E>> c(ResourceKey<? extends IRegistry<E>> registryRef) {
        return this.b(registryRef) ? Optional.of(this) : Optional.empty();
    }

    public MinecraftKey a() {
        return this.c;
    }

    public MinecraftKey b() {
        return this.b;
    }

    public static <T> Function<MinecraftKey, ResourceKey<T>> d(ResourceKey<? extends IRegistry<T>> registry) {
        return id -> ResourceKey.a(registry, id);
    }
}

