/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.resources;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.IRegistryWritable;
import net.minecraft.resources.RegistryResourceAccess;
import net.minecraft.resources.ResourceKey;

public class RegistryLoader {
    private final RegistryResourceAccess a;
    private final Map<ResourceKey<? extends IRegistry<?>>, b<?>> b = new IdentityHashMap();

    RegistryLoader(RegistryResourceAccess entryLoader) {
        this.a = entryLoader;
    }

    public <E> DataResult<? extends IRegistry<E>> a(IRegistryWritable<E> registry, ResourceKey<? extends IRegistry<E>> registryRef, Codec<E> codec, DynamicOps<JsonElement> ops) {
        Collection collection = this.a.a(registryRef);
        DataResult dataResult = DataResult.success(registry, (Lifecycle)Lifecycle.stable());
        for (ResourceKey resourceKey : collection) {
            dataResult = dataResult.flatMap(reg -> this.a((IRegistryWritable)reg, registryRef, codec, resourceKey, ops).map(entry -> reg));
        }
        return dataResult.setPartial(registry);
    }

    <E> DataResult<Holder<E>> a(IRegistryWritable<E> registry, ResourceKey<? extends IRegistry<E>> registryRef, Codec<E> codec, ResourceKey<E> entryKey, DynamicOps<JsonElement> ops) {
        DataResult dataResult2;
        b<E> readCache = this.a(registryRef);
        DataResult dataResult = readCache.a.get(entryKey);
        if (dataResult != null) {
            if (registryRef == IRegistry.P && dataResult.result().isPresent()) {
                registry.a(OptionalInt.empty(), entryKey, ((Holder)dataResult.result().get()).a(), dataResult.lifecycle());
            }
            return dataResult;
        }
        Holder holder = registry.c(entryKey);
        readCache.a.put(entryKey, DataResult.success(holder));
        Optional<DataResult<RegistryResourceAccess.ParsedEntry<E>>> optional = this.a.a(ops, registryRef, entryKey, codec);
        if (optional.isEmpty()) {
            dataResult2 = registry.d(entryKey) ? DataResult.success(holder, (Lifecycle)Lifecycle.stable()) : DataResult.error((String)("Missing referenced custom/removed registry entry for registry " + registryRef + " named " + entryKey.a()));
        } else {
            DataResult<RegistryResourceAccess.ParsedEntry<E>> dataResult4 = optional.get();
            Optional optional2 = dataResult4.result();
            if (optional2.isPresent()) {
                RegistryResourceAccess.ParsedEntry parsedEntry = (RegistryResourceAccess.ParsedEntry)optional2.get();
                registry.a(parsedEntry.b(), entryKey, parsedEntry.a(), dataResult4.lifecycle());
            }
            dataResult2 = dataResult4.map(entry -> holder);
        }
        readCache.a.put(entryKey, dataResult2);
        return dataResult2;
    }

    private <E> b<E> a(ResourceKey<? extends IRegistry<E>> registryRef) {
        return this.b.computeIfAbsent(registryRef, ref -> new b());
    }

    public a a(IRegistryCustom.e dynamicRegistryManager) {
        return new a(dynamicRegistryManager, this);
    }

    static final class b<E> {
        final Map<ResourceKey<E>, DataResult<Holder<E>>> a = Maps.newIdentityHashMap();

        b() {
        }
    }

    public record a(IRegistryCustom.e a, RegistryLoader b) {
        public <E> DataResult<? extends IRegistry<E>> a(ResourceKey<? extends IRegistry<E>> registryRef, Codec<E> codec, DynamicOps<JsonElement> ops) {
            IRegistryWritable writableRegistry = this.a.g(registryRef);
            return this.b.a(writableRegistry, registryRef, codec, ops);
        }

        public <E> DataResult<Holder<E>> a(ResourceKey<? extends IRegistry<E>> registryRef, Codec<E> codec, ResourceKey<E> entryKey, DynamicOps<JsonElement> ops) {
            IRegistryWritable writableRegistry = this.a.g(registryRef);
            return this.b.a(writableRegistry, registryRef, codec, entryKey, ops);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "access;loader", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "access;loader", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "access;loader", "a", "b"}, this, o2);
        }
    }
}

