/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.util.MathHelper;
import net.minecraft.world.phys.Vec3D;

public class PacketPlayOutExplosion
implements Packet<PacketListenerPlayOut> {
    private final double a;
    private final double b;
    private final double c;
    private final float d;
    private final List<BlockPosition> e;
    private final float f;
    private final float g;
    private final float h;

    public PacketPlayOutExplosion(double x2, double y2, double z2, float radius, List<BlockPosition> affectedBlocks, @Nullable Vec3D playerVelocity) {
        this.a = x2;
        this.b = y2;
        this.c = z2;
        this.d = radius;
        this.e = Lists.newArrayList(affectedBlocks);
        if (playerVelocity != null) {
            this.f = (float)playerVelocity.b;
            this.g = (float)playerVelocity.c;
            this.h = (float)playerVelocity.d;
        } else {
            this.f = 0.0f;
            this.g = 0.0f;
            this.h = 0.0f;
        }
    }

    public PacketPlayOutExplosion(PacketDataSerializer buf) {
        this.a = buf.readFloat();
        this.b = buf.readFloat();
        this.c = buf.readFloat();
        this.d = buf.readFloat();
        int i2 = MathHelper.b(this.a);
        int j2 = MathHelper.b(this.b);
        int k2 = MathHelper.b(this.c);
        this.e = buf.a((PacketDataSerializer friendlyByteBuf) -> {
            int l2 = friendlyByteBuf.readByte() + i2;
            int m2 = friendlyByteBuf.readByte() + j2;
            int n2 = friendlyByteBuf.readByte() + k2;
            return new BlockPosition(l2, m2, n2);
        });
        this.f = buf.readFloat();
        this.g = buf.readFloat();
        this.h = buf.readFloat();
    }

    @Override
    @Override
    public void a(PacketDataSerializer buf2) {
        buf2.writeFloat((float)this.a);
        buf2.writeFloat((float)this.b);
        buf2.writeFloat((float)this.c);
        buf2.writeFloat(this.d);
        int i2 = MathHelper.b(this.a);
        int j2 = MathHelper.b(this.b);
        int k2 = MathHelper.b(this.c);
        buf2.a(this.e, (buf, pos) -> {
            int l2 = pos.u() - i2;
            int m2 = pos.v() - j2;
            int n2 = pos.w() - k2;
            buf.writeByte(l2);
            buf.writeByte(m2);
            buf.writeByte(n2);
        });
        buf2.writeFloat(this.f);
        buf2.writeFloat(this.g);
        buf2.writeFloat(this.h);
    }

    @Override
    @Override
    public void a(PacketListenerPlayOut listener) {
        listener.a(this);
    }

    public float b() {
        return this.f;
    }

    public float c() {
        return this.g;
    }

    public float d() {
        return this.h;
    }

    public double e() {
        return this.a;
    }

    public double f() {
        return this.b;
    }

    public double g() {
        return this.c;
    }

    public float h() {
        return this.d;
    }

    public List<BlockPosition> i() {
        return this.e;
    }
}

