/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.tree.ArgumentCommandNode;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.commands.synchronization.ArgumentRegistry;
import net.minecraft.commands.synchronization.CompletionProviders;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;

public class PacketPlayOutCommands
implements Packet<PacketListenerPlayOut> {
    private static final byte a = 3;
    private static final byte b = 4;
    private static final byte c = 8;
    private static final byte d = 16;
    private static final byte e = 0;
    private static final byte f = 1;
    private static final byte g = 2;
    private final RootCommandNode<ICompletionProvider> h;

    public PacketPlayOutCommands(RootCommandNode<ICompletionProvider> commandTree) {
        this.h = commandTree;
    }

    public PacketPlayOutCommands(PacketDataSerializer buf) {
        List<a> list = buf.a(PacketPlayOutCommands::b);
        PacketPlayOutCommands.a(list);
        int i2 = buf.j();
        this.h = (RootCommandNode)list.get((int)i2).e;
    }

    @Override
    @Override
    public void a(PacketDataSerializer buf) {
        Object2IntMap<CommandNode<ICompletionProvider>> object2IntMap = PacketPlayOutCommands.a(this.h);
        List<CommandNode<ICompletionProvider>> list = PacketPlayOutCommands.a(object2IntMap);
        buf.a(list, (friendlyByteBuf, node) -> PacketPlayOutCommands.a(friendlyByteBuf, node, (Map<CommandNode<ICompletionProvider>, Integer>)object2IntMap));
        buf.d(object2IntMap.get(this.h));
    }

    private static void a(List<a> nodeDatas) {
        ArrayList list = Lists.newArrayList(nodeDatas);
        while (!list.isEmpty()) {
            boolean bl = list.removeIf(nodeData -> nodeData.a(nodeDatas));
            if (bl) continue;
            throw new IllegalStateException("Server sent an impossible command tree");
        }
    }

    private static Object2IntMap<CommandNode<ICompletionProvider>> a(RootCommandNode<ICompletionProvider> commandTree) {
        CommandNode commandNode;
        Object2IntOpenHashMap object2IntMap = new Object2IntOpenHashMap();
        ArrayDeque queue = Queues.newArrayDeque();
        queue.add(commandTree);
        while ((commandNode = (CommandNode)queue.poll()) != null) {
            if (object2IntMap.containsKey((Object)commandNode)) continue;
            int i2 = object2IntMap.size();
            object2IntMap.put((Object)commandNode, i2);
            queue.addAll(commandNode.getChildren());
            if (commandNode.getRedirect() == null) continue;
            queue.add(commandNode.getRedirect());
        }
        return object2IntMap;
    }

    private static List<CommandNode<ICompletionProvider>> a(Object2IntMap<CommandNode<ICompletionProvider>> nodes) {
        ObjectArrayList objectArrayList = new ObjectArrayList(nodes.size());
        objectArrayList.size(nodes.size());
        for (Object2IntMap.Entry entry : Object2IntMaps.fastIterable(nodes)) {
            objectArrayList.set(entry.getIntValue(), (Object)((CommandNode)entry.getKey()));
        }
        return objectArrayList;
    }

    private static a b(PacketDataSerializer buf) {
        byte b2 = buf.readByte();
        int[] is = buf.c();
        int i2 = (b2 & 8) != 0 ? buf.j() : 0;
        ArgumentBuilder<ICompletionProvider, ?> argumentBuilder = PacketPlayOutCommands.a(buf, b2);
        return new a(argumentBuilder, b2, i2, is);
    }

    @Nullable
    private static ArgumentBuilder<ICompletionProvider, ?> a(PacketDataSerializer buf, byte b2) {
        int i2 = b2 & 3;
        if (i2 == 2) {
            String string = buf.p();
            ArgumentType<?> argumentType = ArgumentRegistry.a(buf);
            if (argumentType == null) {
                return null;
            }
            RequiredArgumentBuilder requiredArgumentBuilder = RequiredArgumentBuilder.argument((String)string, argumentType);
            if ((b2 & 0x10) != 0) {
                requiredArgumentBuilder.suggests(CompletionProviders.a(buf.q()));
            }
            return requiredArgumentBuilder;
        }
        if (i2 == 1) {
            return LiteralArgumentBuilder.literal((String)buf.p());
        }
        return null;
    }

    private static void a(PacketDataSerializer buf, CommandNode<ICompletionProvider> node, Map<CommandNode<ICompletionProvider>, Integer> nodeToIndex) {
        int b2 = 0;
        if (node.getRedirect() != null) {
            b2 = (byte)(b2 | 8);
        }
        if (node.getCommand() != null) {
            b2 = (byte)(b2 | 4);
        }
        if (node instanceof RootCommandNode) {
            b2 = (byte)(b2 | 0);
        } else if (node instanceof ArgumentCommandNode) {
            b2 = (byte)(b2 | 2);
            if (((ArgumentCommandNode)node).getCustomSuggestions() != null) {
                b2 = (byte)(b2 | 0x10);
            }
        } else if (node instanceof LiteralCommandNode) {
            b2 = (byte)(b2 | 1);
        } else {
            throw new UnsupportedOperationException("Unknown node type " + node);
        }
        buf.writeByte(b2);
        buf.d(node.getChildren().size());
        for (CommandNode<ICompletionProvider> commandNode : node.getChildren()) {
            buf.d(nodeToIndex.get(commandNode));
        }
        if (node.getRedirect() != null) {
            buf.d(nodeToIndex.get(node.getRedirect()));
        }
        if (node instanceof ArgumentCommandNode) {
            ArgumentCommandNode argumentCommandNode = (ArgumentCommandNode)node;
            buf.a(argumentCommandNode.getName());
            ArgumentRegistry.a(buf, argumentCommandNode.getType());
            if (argumentCommandNode.getCustomSuggestions() != null) {
                buf.a(CompletionProviders.a((SuggestionProvider<ICompletionProvider>)argumentCommandNode.getCustomSuggestions()));
            }
        } else if (node instanceof LiteralCommandNode) {
            buf.a(((LiteralCommandNode)node).getLiteral());
        }
    }

    @Override
    @Override
    public void a(PacketListenerPlayOut listener) {
        listener.a(this);
    }

    public RootCommandNode<ICompletionProvider> b() {
        return this.h;
    }

    static class a {
        @Nullable
        private final ArgumentBuilder<ICompletionProvider, ?> a;
        private final byte b;
        private final int c;
        private final int[] d;
        @Nullable
        CommandNode<ICompletionProvider> e;

        a(@Nullable ArgumentBuilder<ICompletionProvider, ?> argumentBuilder, byte flags, int redirectNodeIndex, int[] childNodeIndices) {
            this.a = argumentBuilder;
            this.b = flags;
            this.c = redirectNodeIndex;
            this.d = childNodeIndices;
        }

        public boolean a(List<a> list) {
            if (this.e == null) {
                if (this.a == null) {
                    this.e = new RootCommandNode();
                } else {
                    if ((this.b & 8) != 0) {
                        if (list.get((int)this.c).e == null) {
                            return false;
                        }
                        this.a.redirect(list.get((int)this.c).e);
                    }
                    if ((this.b & 4) != 0) {
                        this.a.executes((Command<ICompletionProvider>)((Command)context -> 0));
                    }
                    this.e = this.a.build();
                }
            }
            for (int i2 : this.d) {
                if (list.get((int)i2).e != null) continue;
                return false;
            }
            for (int j2 : this.d) {
                CommandNode<ICompletionProvider> commandNode = list.get((int)j2).e;
                if (commandNode instanceof RootCommandNode) continue;
                this.e.addChild(commandNode);
            }
            return true;
        }
    }
}

