/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol;

import co.aikar.timings.MinecraftTimings;
import co.aikar.timings.Timing;
import com.destroystokyo.paper.PaperConfig;
import com.mojang.logging.LogUtils;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicLong;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketListener;
import net.minecraft.network.chat.ChatComponentText;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutKickDisconnect;
import net.minecraft.server.CancelledPacketHandleException;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.PlayerConnection;
import net.minecraft.util.thread.IAsyncTaskHandler;
import org.slf4j.Logger;

public class PlayerConnectionUtils {
    private static final Logger a = LogUtils.getLogger();
    public static final ConcurrentLinkedDeque<PacketListener> packetProcessing = new ConcurrentLinkedDeque();
    static final AtomicLong totalMainThreadPacketsProcessed = new AtomicLong();

    public static long getTotalProcessedPackets() {
        return totalMainThreadPacketsProcessed.get();
    }

    public static List<PacketListener> getCurrentPacketProcessors() {
        ArrayList<PacketListener> ret = new ArrayList<PacketListener>(4);
        for (PacketListener listener : packetProcessing) {
            ret.add(listener);
        }
        return ret;
    }

    public static <T extends PacketListener> void a(Packet<T> packet, T listener, WorldServer world) throws CancelledPacketHandleException {
        PlayerConnectionUtils.a(packet, listener, world.n());
    }

    public static <T extends PacketListener> void a(Packet<T> packet, T listener, IAsyncTaskHandler<?> engine) throws CancelledPacketHandleException {
        if (!engine.bk()) {
            engine.c(() -> {
                block16: {
                    packetProcessing.push(listener);
                    try {
                        if (MinecraftServer.getServer().hasStopped() || listener instanceof PlayerConnection && ((PlayerConnection)listener).processedDisconnect) {
                            return;
                        }
                        if (listener.a().h()) {
                            Timing timing = MinecraftTimings.getPacketTiming(packet);
                            try (Timing ignored = timing.startTiming();){
                                packet.a(listener);
                                break block16;
                            }
                            catch (Exception exception) {
                                String playerIP;
                                NetworkManager networkmanager = listener.a();
                                String string = playerIP = PaperConfig.logPlayerIpAddresses ? String.valueOf(networkmanager.c()) : "<ip address withheld>";
                                if (networkmanager.getPlayer() != null) {
                                    a.error("Error whilst processing packet {} for {}[{}]", new Object[]{packet, networkmanager.getPlayer().co(), playerIP, exception});
                                } else {
                                    a.error("Error whilst processing packet {} for connection from {}", new Object[]{packet, playerIP, exception});
                                }
                                ChatComponentText error = new ChatComponentText("Packet processing error");
                                networkmanager.a(new PacketPlayOutKickDisconnect(error), (GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener)future -> networkmanager.a(error)));
                                networkmanager.l();
                            }
                            break block16;
                        }
                        a.debug("Ignoring packet due to disconnection: {}", (Object)packet);
                    }
                    finally {
                        totalMainThreadPacketsProcessed.getAndIncrement();
                        packetProcessing.pop();
                    }
                }
            });
            throw CancelledPacketHandleException.a;
        }
        if (MinecraftServer.getServer().hasStopped() || listener instanceof PlayerConnection && ((PlayerConnection)listener).processedDisconnect) {
            throw CancelledPacketHandleException.a;
        }
    }
}

