/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.DataFixUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.EnumChatFormat;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.network.chat.ChatComponentContextual;
import net.minecraft.network.chat.ChatComponentText;
import net.minecraft.network.chat.ChatHoverable;
import net.minecraft.network.chat.ChatMessage;
import net.minecraft.network.chat.ChatModifier;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.world.entity.Entity;

public class ChatComponentUtils {
    public static final String a = ", ";
    public static final IChatBaseComponent b = new ChatComponentText(", ").a(EnumChatFormat.h);
    public static final IChatBaseComponent c = new ChatComponentText(", ");

    public static IChatMutableComponent a(IChatMutableComponent text, ChatModifier style) {
        if (style.g()) {
            return text;
        }
        ChatModifier style2 = text.c();
        if (style2.g()) {
            return text.a(style);
        }
        if (style2.equals(style)) {
            return text;
        }
        return text.a(style2.a(style));
    }

    public static Optional<IChatMutableComponent> a(@Nullable CommandListenerWrapper source, Optional<IChatBaseComponent> text, @Nullable Entity sender, int depth) throws CommandSyntaxException {
        return text.isPresent() ? Optional.of(ChatComponentUtils.a(source, text.get(), sender, depth)) : Optional.empty();
    }

    public static IChatMutableComponent a(@Nullable CommandListenerWrapper source, IChatBaseComponent text, @Nullable Entity sender, int depth) throws CommandSyntaxException {
        if (depth > 100) {
            return text.e();
        }
        IChatMutableComponent mutableComponent = text instanceof ChatComponentContextual ? ((ChatComponentContextual)((Object)text)).a(source, sender, depth + 1) : text.g();
        for (IChatBaseComponent component : text.b()) {
            mutableComponent.a(ChatComponentUtils.a(source, component, sender, depth + 1));
        }
        return mutableComponent.c(ChatComponentUtils.a(source, text.c(), sender, depth));
    }

    private static ChatModifier a(@Nullable CommandListenerWrapper source, ChatModifier style, @Nullable Entity sender, int depth) throws CommandSyntaxException {
        IChatBaseComponent component;
        ChatHoverable hoverEvent = style.i();
        if (hoverEvent != null && (component = hoverEvent.a(ChatHoverable.EnumHoverAction.a)) != null) {
            ChatHoverable hoverEvent2 = new ChatHoverable(ChatHoverable.EnumHoverAction.a, ChatComponentUtils.a(source, component, sender, depth + 1));
            return style.a(hoverEvent2);
        }
        return style;
    }

    public static IChatBaseComponent a(GameProfile profile) {
        if (profile.getName() != null) {
            return new ChatComponentText(profile.getName());
        }
        if (profile.getId() != null) {
            return new ChatComponentText(profile.getId().toString());
        }
        return new ChatComponentText("(unknown)");
    }

    public static IChatBaseComponent a(Collection<String> strings) {
        return ChatComponentUtils.a(strings, (T string) -> new ChatComponentText((String)string).a(EnumChatFormat.k));
    }

    public static <T extends Comparable<T>> IChatBaseComponent a(Collection<T> elements, Function<T, IChatBaseComponent> transformer) {
        if (elements.isEmpty()) {
            return ChatComponentText.d;
        }
        if (elements.size() == 1) {
            return transformer.apply((Comparable)elements.iterator().next());
        }
        ArrayList list = Lists.newArrayList(elements);
        list.sort(Comparable::compareTo);
        return ChatComponentUtils.b(list, transformer);
    }

    public static <T> IChatBaseComponent b(Collection<? extends T> elements, Function<T, IChatBaseComponent> transformer) {
        return ChatComponentUtils.a(elements, b, transformer);
    }

    public static <T> IChatMutableComponent a(Collection<? extends T> elements, Optional<? extends IChatBaseComponent> separator, Function<T, IChatBaseComponent> transformer) {
        return ChatComponentUtils.a(elements, (IChatBaseComponent)DataFixUtils.orElse(separator, (Object)b), transformer);
    }

    public static IChatBaseComponent a(Collection<? extends IChatBaseComponent> texts, IChatBaseComponent separator) {
        return ChatComponentUtils.a(texts, separator, Function.identity());
    }

    public static <T> IChatMutableComponent a(Collection<? extends T> elements, IChatBaseComponent separator, Function<T, IChatBaseComponent> transformer) {
        if (elements.isEmpty()) {
            return new ChatComponentText("");
        }
        if (elements.size() == 1) {
            return transformer.apply(elements.iterator().next()).e();
        }
        ChatComponentText mutableComponent = new ChatComponentText("");
        boolean bl = true;
        for (T object : elements) {
            if (!bl) {
                mutableComponent.a(separator);
            }
            mutableComponent.a(transformer.apply(object));
            bl = false;
        }
        return mutableComponent;
    }

    public static IChatMutableComponent a(IChatBaseComponent text) {
        return new ChatMessage("chat.square_brackets", text);
    }

    public static IChatBaseComponent a(Message message) {
        if (message instanceof IChatBaseComponent) {
            return (IChatBaseComponent)message;
        }
        return new ChatComponentText(message.getString());
    }
}

