/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.logging.LogUtils;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.selector.ArgumentParserSelector;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.network.chat.ChatBaseComponent;
import net.minecraft.network.chat.ChatComponentContextual;
import net.minecraft.network.chat.ChatComponentText;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.world.entity.Entity;
import org.slf4j.Logger;

public class ChatComponentSelector
extends ChatBaseComponent
implements ChatComponentContextual {
    private static final Logger e = LogUtils.getLogger();
    private final String f;
    @Nullable
    private final EntitySelector g;
    protected final Optional<IChatBaseComponent> d;

    public ChatComponentSelector(String pattern, Optional<IChatBaseComponent> separator) {
        this.f = pattern;
        this.d = separator;
        EntitySelector entitySelector = null;
        try {
            ArgumentParserSelector entitySelectorParser = new ArgumentParserSelector(new StringReader(pattern));
            entitySelector = entitySelectorParser.t();
        }
        catch (CommandSyntaxException commandSyntaxException) {
            e.warn("Invalid selector component: {}: {}", (Object)pattern, (Object)commandSyntaxException.getMessage());
        }
        this.g = entitySelector;
    }

    public String h() {
        return this.f;
    }

    @Nullable
    public EntitySelector i() {
        return this.g;
    }

    public Optional<IChatBaseComponent> j() {
        return this.d;
    }

    @Override
    @Override
    public IChatMutableComponent a(@Nullable CommandListenerWrapper source, @Nullable Entity sender, int depth) throws CommandSyntaxException {
        if (source == null || this.g == null) {
            return new ChatComponentText("");
        }
        Optional<IChatMutableComponent> optional = ChatComponentUtils.a(source, this.d, sender, depth);
        return ChatComponentUtils.a(this.g.b(source), optional, Entity::C_);
    }

    @Override
    @Override
    public String a() {
        return this.f;
    }

    @Override
    public ChatComponentSelector k() {
        return new ChatComponentSelector(this.f, this.d);
    }

    @Override
    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof ChatComponentSelector) {
            ChatComponentSelector selectorComponent = (ChatComponentSelector)object;
            return this.f.equals(selectorComponent.f) && super.equals(object);
        }
        return false;
    }

    @Override
    @Override
    public String toString() {
        return "SelectorComponent{pattern='" + this.f + "', siblings=" + this.a + ", style=" + this.c() + "}";
    }

    @Override
    public /* synthetic */ ChatBaseComponent d() {
        return this.k();
    }

    @Override
    public /* synthetic */ IChatMutableComponent g() {
        return this.k();
    }
}

