/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network;

import com.mojang.logging.LogUtils;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import io.papermc.paper.adventure.PaperAdventure;
import java.io.IOException;
import java.util.Locale;
import net.minecraft.network.EnumProtocol;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.SkipEncodeException;
import net.minecraft.network.protocol.EnumProtocolDirection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.util.profiling.jfr.JvmProfiler;
import org.slf4j.Logger;

public class PacketEncoder
extends MessageToByteEncoder<Packet<?>> {
    private static final Logger a = LogUtils.getLogger();
    private final EnumProtocolDirection b;
    private static int MAX_PACKET_SIZE = 0x200000;

    public PacketEncoder(EnumProtocolDirection side) {
        this.b = side;
    }

    protected void a(ChannelHandlerContext channelHandlerContext, Packet<?> packet, ByteBuf byteBuf) throws Exception {
        EnumProtocol connectionProtocol = (EnumProtocol)((Object)channelHandlerContext.channel().attr(NetworkManager.e).get());
        if (connectionProtocol == null) {
            throw new RuntimeException("ConnectionProtocol unknown: " + packet);
        }
        Integer integer = connectionProtocol.a(this.b, packet);
        if (a.isDebugEnabled()) {
            a.debug(NetworkManager.d, "OUT: [{}:{}] {}", new Object[]{channelHandlerContext.channel().attr(NetworkManager.e).get(), integer, packet.getClass().getName()});
        }
        if (integer == null) {
            throw new IOException("Can't serialize unregistered packet");
        }
        PacketDataSerializer friendlyByteBuf = new PacketDataSerializer(byteBuf);
        friendlyByteBuf.d(integer);
        friendlyByteBuf.adventure$locale = (Locale)channelHandlerContext.channel().attr(PaperAdventure.LOCALE_ATTRIBUTE).get();
        try {
            int i2 = friendlyByteBuf.writerIndex();
            packet.a(friendlyByteBuf);
            int j2 = friendlyByteBuf.writerIndex() - i2;
            if (j2 > 0x800000) {
                throw new IllegalArgumentException("Packet too big (is " + j2 + ", should be less than 8388608): " + packet);
            }
            int k2 = ((EnumProtocol)((Object)channelHandlerContext.channel().attr(NetworkManager.e).get())).a();
            JvmProfiler.e.b(k2, integer, channelHandlerContext.channel().remoteAddress(), j2);
        }
        catch (Throwable var10) {
            a.error("Packet encoding of packet ID {} threw (skippable? {})", new Object[]{integer, packet.a(), var10});
            if (packet.a()) {
                throw new SkipEncodeException(var10);
            }
            throw var10;
        }
        int packetLength = friendlyByteBuf.readableBytes();
        if (packetLength > MAX_PACKET_SIZE) {
            throw new PacketTooLargeException(packet, packetLength);
        }
    }

    public static class PacketTooLargeException
    extends RuntimeException {
        private final Packet<?> packet;

        PacketTooLargeException(Packet<?> packet, int packetLength) {
            super("PacketTooLarge - " + packet.getClass().getSimpleName() + " is " + packetLength + ". Max is " + MAX_PACKET_SIZE);
            this.packet = packet;
        }

        public Packet<?> getPacket() {
            return this.packet;
        }
    }
}

