/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network;

import com.destroystokyo.paper.PaperConfig;
import com.destroystokyo.paper.event.player.PlayerConnectionCloseEvent;
import com.google.common.collect.Queues;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.logging.LogUtils;
import com.velocitypowered.natives.compression.VelocityCompressor;
import com.velocitypowered.natives.compression.VelocityCompressorFactory;
import com.velocitypowered.natives.encryption.VelocityCipher;
import com.velocitypowered.natives.encryption.VelocityCipherFactory;
import com.velocitypowered.natives.util.Natives;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.DefaultEventLoopGroup;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.local.LocalChannel;
import io.netty.channel.local.LocalServerChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.EncoderException;
import io.netty.handler.timeout.ReadTimeoutHandler;
import io.netty.handler.timeout.TimeoutException;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.AbstractEventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.papermc.paper.util.IntervalledCounter;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import javax.crypto.SecretKey;
import net.minecraft.SystemUtils;
import net.minecraft.ThreadNamedUncaughtExceptionHandler;
import net.minecraft.network.EnumProtocol;
import net.minecraft.network.PacketCompressor;
import net.minecraft.network.PacketDecoder;
import net.minecraft.network.PacketDecompressor;
import net.minecraft.network.PacketDecrypter;
import net.minecraft.network.PacketEncoder;
import net.minecraft.network.PacketEncrypter;
import net.minecraft.network.PacketListener;
import net.minecraft.network.PacketPrepender;
import net.minecraft.network.PacketSplitter;
import net.minecraft.network.SkipEncodeException;
import net.minecraft.network.chat.ChatMessage;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.EnumProtocolDirection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PlayerConnectionUtils;
import net.minecraft.network.protocol.game.ClientboundClearTitlesPacket;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetSubtitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTitlesAnimationPacket;
import net.minecraft.network.protocol.game.PacketPlayOutBoss;
import net.minecraft.network.protocol.game.PacketPlayOutChat;
import net.minecraft.network.protocol.game.PacketPlayOutKeepAlive;
import net.minecraft.network.protocol.game.PacketPlayOutKickDisconnect;
import net.minecraft.network.protocol.game.PacketPlayOutTabComplete;
import net.minecraft.network.protocol.login.PacketLoginOutDisconnect;
import net.minecraft.network.protocol.login.PacketLoginOutListener;
import net.minecraft.server.CancelledPacketHandleException;
import net.minecraft.server.MCUtil;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.network.LoginListener;
import net.minecraft.server.network.PlayerConnection;
import net.minecraft.util.CryptographyException;
import net.minecraft.util.LazyInitVar;
import net.minecraft.util.MathHelper;
import org.apache.commons.lang3.Validate;
import org.bukkit.craftbukkit.v1_18_R2.util.CraftChatMessage;
import org.bukkit.event.player.PlayerQuitEvent;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class NetworkManager
extends SimpleChannelInboundHandler<Packet<?>> {
    private static final float i = 0.75f;
    private static final Logger j = LogUtils.getLogger();
    public static final Marker a = MarkerFactory.getMarker((String)"NETWORK");
    public static final Marker b = SystemUtils.a(MarkerFactory.getMarker((String)"NETWORK_PACKETS"), (T marker) -> marker.add(a));
    public static final Marker c = SystemUtils.a(MarkerFactory.getMarker((String)"PACKET_RECEIVED"), (T marker) -> marker.add(b));
    public static final Marker d = SystemUtils.a(MarkerFactory.getMarker((String)"PACKET_SENT"), (T marker) -> marker.add(b));
    public static final AttributeKey<EnumProtocol> e = AttributeKey.valueOf((String)"protocol");
    public static final LazyInitVar<NioEventLoopGroup> f = new LazyInitVar<NioEventLoopGroup>(() -> new NioEventLoopGroup(0, new ThreadFactoryBuilder().setNameFormat("Netty Client IO #%d").setDaemon(true).setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new ThreadNamedUncaughtExceptionHandler(j)).build()));
    public static final LazyInitVar<EpollEventLoopGroup> g = new LazyInitVar<EpollEventLoopGroup>(() -> new EpollEventLoopGroup(0, new ThreadFactoryBuilder().setNameFormat("Netty Epoll Client IO #%d").setDaemon(true).setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new ThreadNamedUncaughtExceptionHandler(j)).build()));
    public static final LazyInitVar<DefaultEventLoopGroup> h = new LazyInitVar<DefaultEventLoopGroup>(() -> new DefaultEventLoopGroup(0, new ThreadFactoryBuilder().setNameFormat("Netty Local Client IO #%d").setDaemon(true).setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new ThreadNamedUncaughtExceptionHandler(j)).build()));
    private final EnumProtocolDirection k;
    private final Queue<QueuedPacket> l = Queues.newConcurrentLinkedQueue();
    public Channel m;
    public SocketAddress n;
    public UUID spoofedUUID;
    public Property[] spoofedProfile;
    public boolean preparing = true;
    private PacketListener o;
    private IChatBaseComponent p;
    private boolean q;
    private boolean r;
    private int s;
    private int t;
    private float u;
    private float v;
    private int w;
    private boolean x;
    public int protocolVersion;
    public InetSocketAddress virtualHost;
    private static boolean enableExplicitFlush = Boolean.getBoolean("paper.explicit-flush");
    public boolean isPending = true;
    public boolean queueImmunity = false;
    public EnumProtocol protocol;
    private final Queue<Runnable> pendingTasks = new ConcurrentLinkedQueue<Runnable>();
    volatile boolean canFlush = true;
    private final AtomicInteger packetWrites = new AtomicInteger();
    private int flushPacketsStart;
    private final Object flushLock = new Object();
    protected final Object PACKET_LIMIT_LOCK = new Object();
    protected final IntervalledCounter allPacketCounts;
    protected final Map<Class<? extends Packet<?>>, IntervalledCounter> packetSpecificLimits;
    private boolean stopReadingPackets;
    private static final int MAX_PER_TICK = PaperConfig.maxJoinsPerTick;
    private static int joinAttemptsThisTick;
    private static int currTick;

    public void execute(Runnable run) {
        boolean queue;
        if (this.m == null || !this.m.isRegistered()) {
            run.run();
            return;
        }
        boolean bl = queue = !this.l.isEmpty();
        if (!queue) {
            this.m.eventLoop().execute(run);
        } else {
            this.pendingTasks.add(run);
            if (this.l.isEmpty()) {
                Runnable r2;
                while ((r2 = this.pendingTasks.poll()) != null) {
                    this.m.eventLoop().execute(r2);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disableAutomaticFlush() {
        Object object = this.flushLock;
        synchronized (object) {
            this.flushPacketsStart = this.packetWrites.get();
            this.canFlush = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableAutomaticFlush() {
        Object object = this.flushLock;
        synchronized (object) {
            this.canFlush = true;
            if (this.packetWrites.get() != this.flushPacketsStart) {
                this.flush();
            }
        }
    }

    private final void flush() {
        if (this.m.eventLoop().inEventLoop()) {
            this.m.flush();
        } else {
            this.m.eventLoop().execute(() -> this.m.flush());
        }
    }

    private void killForPacketSpam() {
        this.b(new PacketPlayOutKickDisconnect(CraftChatMessage.fromString(PaperConfig.kickMessage, true)[0]), (GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener)future -> this.a(CraftChatMessage.fromString(PaperConfig.kickMessage, true)[0])));
        this.l();
        this.stopReadingPackets = true;
    }

    public NetworkManager(EnumProtocolDirection side) {
        this.allPacketCounts = PaperConfig.allPacketsLimit != null ? new IntervalledCounter((long)(PaperConfig.allPacketsLimit.packetLimitInterval * 1.0E9)) : null;
        this.packetSpecificLimits = new HashMap();
        this.k = side;
    }

    public void channelActive(ChannelHandlerContext channelhandlercontext) throws Exception {
        super.channelActive(channelhandlercontext);
        this.m = channelhandlercontext.channel();
        this.n = this.m.remoteAddress();
        this.preparing = false;
        try {
            this.a(EnumProtocol.a);
        }
        catch (Throwable throwable) {
            j.error(LogUtils.FATAL_MARKER, "Failed to change protocol to handshake", throwable);
        }
    }

    public void a(EnumProtocol state) {
        this.protocol = state;
        this.m.attr(e).set((Object)state);
        this.m.config().setAutoRead(true);
        j.debug("Enabled auto read");
    }

    public void channelInactive(ChannelHandlerContext channelhandlercontext) {
        this.a(new ChatMessage("disconnect.endOfStream"));
    }

    public void exceptionCaught(ChannelHandlerContext channelhandlercontext, Throwable throwable) {
        if (throwable instanceof EncoderException && throwable.getCause() instanceof PacketEncoder.PacketTooLargeException) {
            if (((PacketEncoder.PacketTooLargeException)throwable.getCause()).getPacket().packetTooLarge(this)) {
                return;
            }
            throwable = throwable.getCause();
        }
        if (throwable instanceof SkipEncodeException) {
            j.debug("Skipping packet due to errors", throwable.getCause());
        } else {
            boolean flag = !this.x;
            this.x = true;
            if (this.m.isOpen()) {
                EntityPlayer player = this.getPlayer();
                if (throwable instanceof TimeoutException) {
                    j.debug("Timeout", throwable);
                    if (player != null) {
                        player.quitReason = PlayerQuitEvent.QuitReason.TIMED_OUT;
                    }
                    this.a(new ChatMessage("disconnect.timeout"));
                } else {
                    ChatMessage chatmessage = new ChatMessage("disconnect.genericReason", "Internal Exception: " + throwable);
                    if (player != null) {
                        player.quitReason = PlayerQuitEvent.QuitReason.ERRONEOUS_STATE;
                    }
                    if (flag) {
                        j.debug("Failed to sent packet", throwable);
                        EnumProtocol enumprotocol = this.p();
                        Packet<PacketLoginOutListener> packet = enumprotocol == EnumProtocol.d ? new PacketLoginOutDisconnect(chatmessage) : new PacketPlayOutKickDisconnect(chatmessage);
                        this.a(packet, (GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener)future -> this.a(chatmessage)));
                        this.l();
                    } else {
                        j.debug("Double fault", throwable);
                        this.a(chatmessage);
                    }
                }
            }
        }
        if (MinecraftServer.getServer().isDebugging()) {
            throwable.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void a(ChannelHandlerContext channelhandlercontext, Packet<?> packet) {
        if (this.m.isOpen()) {
            if (this.stopReadingPackets) {
                return;
            }
            if (this.allPacketCounts != null || PaperConfig.packetSpecificLimits.containsKey(packet.getClass())) {
                long time = System.nanoTime();
                Object object = this.PACKET_LIMIT_LOCK;
                synchronized (object) {
                    if (this.allPacketCounts != null) {
                        this.allPacketCounts.updateAndAdd(1, time);
                        if (this.allPacketCounts.getRate() >= PaperConfig.allPacketsLimit.maxPacketRate) {
                            this.killForPacketSpam();
                            return;
                        }
                    }
                    for (Class<?> check = packet.getClass(); check != Object.class; check = check.getSuperclass()) {
                        PaperConfig.PacketLimit packetSpecificLimit = PaperConfig.packetSpecificLimits.get(check);
                        if (packetSpecificLimit == null) continue;
                        IntervalledCounter counter = this.packetSpecificLimits.computeIfAbsent(check, clazz -> new IntervalledCounter((long)(packetSpecificLimit.packetLimitInterval * 1.0E9)));
                        counter.updateAndAdd(1, time);
                        if (!(counter.getRate() >= packetSpecificLimit.maxPacketRate)) continue;
                        switch (packetSpecificLimit.violateAction) {
                            case DROP: {
                                return;
                            }
                            case KICK: {
                                this.killForPacketSpam();
                                return;
                            }
                        }
                    }
                }
            }
            try {
                NetworkManager.a(packet, this.o);
            }
            catch (CancelledPacketHandleException time) {
            }
            catch (RejectedExecutionException rejectedexecutionexception) {
                this.a(new ChatMessage("multiplayer.disconnect.server_shutdown"));
            }
            catch (ClassCastException classcastexception) {
                j.error("Received {} that couldn't be processed", packet.getClass(), (Object)classcastexception);
                this.a(new ChatMessage("multiplayer.disconnect.invalid_packet"));
            }
            ++this.s;
        }
    }

    private static <T extends PacketListener> void a(Packet<T> packet, PacketListener listener) {
        packet.a(listener);
    }

    public void a(PacketListener listener) {
        Validate.notNull((Object)listener, (String)"packetListener", (Object[])new Object[0]);
        this.o = listener;
    }

    public EntityPlayer getPlayer() {
        if (this.o instanceof PlayerConnection) {
            return ((PlayerConnection)this.o).b;
        }
        return null;
    }

    public void a(Packet<?> packet) {
        this.a(packet, (GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener)null));
    }

    public void a(Packet<?> packet, @Nullable GenericFutureListener<? extends Future<? super Void>> callback) {
        boolean hasExtraPackets;
        boolean connected = this.h();
        if (!connected && !this.preparing) {
            return;
        }
        packet.onPacketDispatch(this.getPlayer());
        if (connected && (InnerUtil.canSendImmediate(this, packet) || MCUtil.isMainThread() && packet.isReady() && this.l.isEmpty() && (packet.getExtraPackets() == null || packet.getExtraPackets().isEmpty()))) {
            this.writePacket(packet, callback, null);
            return;
        }
        List<Packet> extraPackets = InnerUtil.buildExtraPackets(packet);
        boolean bl = hasExtraPackets = extraPackets != null && !extraPackets.isEmpty();
        if (!hasExtraPackets) {
            this.l.add(new QueuedPacket(packet, callback));
        } else {
            ArrayList<QueuedPacket> packets = new ArrayList<QueuedPacket>(1 + extraPackets.size());
            packets.add(new QueuedPacket(packet, null));
            int i2 = 0;
            int len = extraPackets.size();
            while (i2 < len) {
                Packet extra = extraPackets.get(i2);
                boolean end = ++i2 == len;
                packets.add(new QueuedPacket(extra, (GenericFutureListener<? extends Future<? super Void>>)(end ? callback : null)));
            }
            this.l.addAll(packets);
        }
        this.flushQueue();
    }

    private void b(Packet<?> packet, @Nullable GenericFutureListener<? extends Future<? super Void>> callback) {
        this.writePacket(packet, callback, Boolean.TRUE);
    }

    private void writePacket(Packet<?> packet, @Nullable GenericFutureListener<? extends Future<? super Void>> callback, Boolean flushConditional) {
        this.packetWrites.getAndIncrement();
        boolean effectiveFlush = flushConditional == null ? this.canFlush : flushConditional;
        boolean flush = effectiveFlush || packet instanceof PacketPlayOutKeepAlive || packet instanceof PacketPlayOutKickDisconnect;
        EnumProtocol enumprotocol = EnumProtocol.a(packet);
        EnumProtocol enumprotocol1 = this.p();
        ++this.t;
        if (enumprotocol1 != enumprotocol) {
            j.debug("Disabled auto read");
            this.m.config().setAutoRead(false);
        }
        if (this.m.eventLoop().inEventLoop()) {
            this.doSendPacket(packet, callback, enumprotocol, enumprotocol1, flush);
        } else if (!flush) {
            AbstractEventExecutor.LazyRunnable run = () -> this.doSendPacket(packet, callback, enumprotocol, enumprotocol1, flush);
            this.m.eventLoop().execute((Runnable)run);
        } else {
            this.m.eventLoop().execute(() -> this.doSendPacket(packet, callback, enumprotocol, enumprotocol1, flush));
        }
    }

    private void a(Packet<?> packet, @Nullable GenericFutureListener<? extends Future<? super Void>> callback, EnumProtocol packetState, EnumProtocol currentState) {
        this.doSendPacket(packet, callback, packetState, currentState, true);
    }

    private void doSendPacket(Packet<?> packet, @Nullable GenericFutureListener<? extends Future<? super Void>> callback, EnumProtocol packetState, EnumProtocol currentState, boolean flush) {
        if (packetState != currentState) {
            this.a(packetState);
        }
        EntityPlayer player = this.getPlayer();
        if (!this.h()) {
            packet.onPacketDispatchFinish(player, null);
            return;
        }
        try {
            ChannelFuture channelfuture;
            ChannelFuture channelFuture2 = channelfuture = flush ? this.m.writeAndFlush(packet) : this.m.write(packet);
            if (callback != null) {
                channelfuture.addListener(callback);
            }
            if (packet.hasFinishListener()) {
                channelfuture.addListener((GenericFutureListener)((ChannelFutureListener)channelFuture -> packet.onPacketDispatchFinish(player, (ChannelFuture)channelFuture)));
            }
            channelfuture.addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
        }
        catch (Exception e2) {
            j.error("NetworkException: " + player, (Throwable)e2);
            this.a(new ChatMessage("disconnect.genericReason", "Internal Exception: " + e2.getMessage()));
            packet.onPacketDispatchFinish(player, null);
        }
    }

    private EnumProtocol p() {
        return (EnumProtocol)((Object)this.m.attr(e).get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean flushQueue() {
        if (!this.h()) {
            return true;
        }
        if (MCUtil.isMainThread()) {
            return this.processQueue();
        }
        if (this.isPending) {
            Queue<QueuedPacket> queue = this.l;
            synchronized (queue) {
                return this.processQueue();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processQueue() {
        try {
            if (this.l.isEmpty()) {
                boolean bl = true;
                return bl;
            }
            boolean needsFlush = this.canFlush;
            boolean hasWrotePacket = false;
            Iterator iterator = this.l.iterator();
            while (iterator.hasNext()) {
                QueuedPacket queued = (QueuedPacket)iterator.next();
                Packet<?> packet = queued.a;
                if (!packet.isReady()) {
                    if (hasWrotePacket && (needsFlush || this.canFlush)) {
                        this.flush();
                    }
                    boolean bl = false;
                    return bl;
                }
                iterator.remove();
                this.writePacket(packet, queued.b, !iterator.hasNext() && (needsFlush || this.canFlush) ? Boolean.TRUE : Boolean.FALSE);
                hasWrotePacket = true;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            Runnable r2;
            while ((r2 = this.pendingTasks.poll()) != null) {
                this.m.eventLoop().execute(r2);
            }
        }
    }

    public void a() {
        this.flushQueue();
        if (currTick != MinecraftServer.currentTick) {
            currTick = MinecraftServer.currentTick;
            joinAttemptsThisTick = 0;
        }
        if (this.o instanceof LoginListener && (((LoginListener)this.o).h != LoginListener.EnumProtocolState.e || joinAttemptsThisTick++ < MAX_PER_TICK)) {
            ((LoginListener)this.o).c();
        }
        if (this.o instanceof PlayerConnection) {
            PlayerConnectionUtils.packetProcessing.push(this.o);
            try {
                ((PlayerConnection)this.o).c();
            }
            finally {
                PlayerConnectionUtils.packetProcessing.pop();
            }
        }
        if (!this.h() && !this.r) {
            this.m();
        }
        if (this.m != null && enableExplicitFlush) {
            this.m.eventLoop().execute(() -> this.m.flush());
        }
        if (this.w++ % 20 == 0) {
            this.b();
        }
    }

    protected void b() {
        this.v = MathHelper.i(0.75f, this.t, this.v);
        this.u = MathHelper.i(0.75f, this.s, this.u);
        this.t = 0;
        this.s = 0;
    }

    public SocketAddress c() {
        return this.n;
    }

    public void clearPacketQueue() {
        EntityPlayer player = this.getPlayer();
        this.l.forEach(queuedPacket -> {
            Packet<?> packet = queuedPacket.a;
            if (packet.hasFinishListener()) {
                packet.onPacketDispatchFinish(player, null);
            }
        });
        this.l.clear();
    }

    public void a(IChatBaseComponent disconnectReason) {
        this.preparing = false;
        this.clearPacketQueue();
        if (this.m.isOpen()) {
            this.m.close();
            this.p = disconnectReason;
        }
    }

    public boolean d() {
        return this.m instanceof LocalChannel || this.m instanceof LocalServerChannel;
    }

    public EnumProtocolDirection e() {
        return this.k;
    }

    public EnumProtocolDirection f() {
        return this.k.a();
    }

    public static NetworkManager a(InetSocketAddress address, boolean useEpoll) {
        LazyInitVar<NioEventLoopGroup> lazyinitvar;
        Class<NioSocketChannel> oclass;
        final NetworkManager networkmanager = new NetworkManager(EnumProtocolDirection.b);
        if (Epoll.isAvailable() && useEpoll) {
            oclass = EpollSocketChannel.class;
            lazyinitvar = g;
        } else {
            oclass = NioSocketChannel.class;
            lazyinitvar = f;
        }
        ((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)lazyinitvar.a())).handler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel channel) {
                try {
                    channel.config().setOption(ChannelOption.TCP_NODELAY, (Object)true);
                }
                catch (ChannelException channelException) {
                    // empty catch block
                }
                channel.pipeline().addLast("timeout", (ChannelHandler)new ReadTimeoutHandler(30)).addLast("splitter", (ChannelHandler)new PacketSplitter()).addLast("decoder", (ChannelHandler)new PacketDecoder(EnumProtocolDirection.b)).addLast("prepender", (ChannelHandler)new PacketPrepender()).addLast("encoder", (ChannelHandler)new PacketEncoder(EnumProtocolDirection.a)).addLast("packet_handler", (ChannelHandler)networkmanager);
            }
        })).channel(oclass)).connect(address.getAddress(), address.getPort()).syncUninterruptibly();
        return networkmanager;
    }

    public static NetworkManager a(SocketAddress address) {
        final NetworkManager networkmanager = new NetworkManager(EnumProtocolDirection.b);
        ((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)h.a())).handler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel channel) {
                channel.pipeline().addLast("packet_handler", (ChannelHandler)networkmanager);
            }
        })).channel(LocalChannel.class)).connect(address).syncUninterruptibly();
        return networkmanager;
    }

    public void setupEncryption(SecretKey key) throws CryptographyException {
        if (!this.q) {
            try {
                VelocityCipher decryption = ((VelocityCipherFactory)Natives.cipher.get()).forDecryption(key);
                VelocityCipher encryption = ((VelocityCipherFactory)Natives.cipher.get()).forEncryption(key);
                this.q = true;
                this.m.pipeline().addBefore("splitter", "decrypt", (ChannelHandler)new PacketDecrypter(decryption));
                this.m.pipeline().addBefore("prepender", "encrypt", (ChannelHandler)new PacketEncrypter(encryption));
            }
            catch (GeneralSecurityException e2) {
                throw new CryptographyException(e2);
            }
        }
    }

    public boolean g() {
        return this.q;
    }

    public boolean h() {
        return this.m != null && this.m.isOpen();
    }

    public boolean i() {
        return this.m == null;
    }

    public PacketListener j() {
        return this.o;
    }

    @Nullable
    public IChatBaseComponent k() {
        return this.p;
    }

    public void l() {
        this.m.config().setAutoRead(false);
    }

    public void a(int compressionThreshold, boolean rejectsBadPackets) {
        if (compressionThreshold >= 0) {
            VelocityCompressor compressor = ((VelocityCompressorFactory)Natives.compress.get()).create(-1);
            if (this.m.pipeline().get("decompress") instanceof PacketDecompressor) {
                ((PacketDecompressor)this.m.pipeline().get("decompress")).a(compressionThreshold, rejectsBadPackets);
            } else {
                this.m.pipeline().addBefore("decoder", "decompress", (ChannelHandler)new PacketDecompressor(compressor, compressionThreshold, rejectsBadPackets));
            }
            if (this.m.pipeline().get("compress") instanceof PacketCompressor) {
                ((PacketCompressor)this.m.pipeline().get("compress")).a(compressionThreshold);
            } else {
                this.m.pipeline().addBefore("encoder", "compress", (ChannelHandler)new PacketCompressor(compressor, compressionThreshold));
            }
        } else {
            if (this.m.pipeline().get("decompress") instanceof PacketDecompressor) {
                this.m.pipeline().remove("decompress");
            }
            if (this.m.pipeline().get("compress") instanceof PacketCompressor) {
                this.m.pipeline().remove("compress");
            }
        }
    }

    public void m() {
        if (this.m != null && !this.m.isOpen() && !this.r) {
            this.r = true;
            if (this.k() != null) {
                this.j().a(this.k());
            } else if (this.j() != null) {
                this.j().a(new ChatMessage("multiplayer.disconnect.generic"));
            }
            this.clearPacketQueue();
            PacketListener packetListener = this.j();
            if (packetListener instanceof PlayerConnection) {
                PlayerConnection playerConnection = (PlayerConnection)packetListener;
                new PlayerConnectionCloseEvent(playerConnection.b.cm(), playerConnection.b.co(), ((InetSocketAddress)this.n).getAddress(), false).callEvent();
            } else if (packetListener instanceof LoginListener) {
                LoginListener loginListener = (LoginListener)packetListener;
                switch (loginListener.h) {
                    case e: 
                    case f: 
                    case g: {
                        GameProfile profile = loginListener.j;
                        new PlayerConnectionCloseEvent(profile.getId(), profile.getName(), ((InetSocketAddress)this.n).getAddress(), false).callEvent();
                    }
                }
            }
        }
    }

    public float n() {
        return this.u;
    }

    public float o() {
        return this.v;
    }

    public SocketAddress getRawAddress() {
        if (this.m.remoteAddress() == null) {
            return new InetSocketAddress(InetAddress.getLoopbackAddress(), 0);
        }
        return this.m.remoteAddress();
    }

    private static class InnerUtil {
        private InnerUtil() {
        }

        private static List<Packet> buildExtraPackets(Packet packet) {
            List<Packet> extra = packet.getExtraPackets();
            if (extra == null || extra.isEmpty()) {
                return null;
            }
            ArrayList<Packet> ret = new ArrayList<Packet>(1 + extra.size());
            InnerUtil.buildExtraPackets0(extra, ret);
            return ret;
        }

        private static void buildExtraPackets0(List<Packet> extraPackets, List<Packet> into) {
            for (Packet extra : extraPackets) {
                into.add(extra);
                List<Packet> extraExtra = extra.getExtraPackets();
                if (extraExtra == null || extraExtra.isEmpty()) continue;
                InnerUtil.buildExtraPackets0(extraExtra, into);
            }
        }

        private static boolean canSendImmediate(NetworkManager networkManager, Packet<?> packet) {
            return networkManager.isPending || networkManager.protocol != EnumProtocol.b || packet instanceof PacketPlayOutKeepAlive || packet instanceof PacketPlayOutChat || packet instanceof PacketPlayOutTabComplete || packet instanceof ClientboundSetTitleTextPacket || packet instanceof ClientboundSetSubtitleTextPacket || packet instanceof ClientboundSetActionBarTextPacket || packet instanceof ClientboundSetTitlesAnimationPacket || packet instanceof ClientboundClearTitlesPacket || packet instanceof PacketPlayOutBoss;
        }
    }

    private static class QueuedPacket {
        final Packet<?> a;
        @Nullable
        final GenericFutureListener<? extends Future<? super Void>> b;

        public QueuedPacket(Packet<?> packet, @Nullable GenericFutureListener<? extends Future<? super Void>> callback) {
            this.a = packet;
            this.b = callback;
        }
    }
}

