/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.bytes.ByteCollection;
import it.unimi.dsi.fastutil.bytes.ByteOpenHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.regex.Pattern;
import net.minecraft.EnumChatFormat;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagEnd;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagLongArray;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.nbt.TagVisitor;
import net.minecraft.network.chat.ChatComponentText;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import org.slf4j.Logger;

public class TextComponentTagVisitor
implements TagVisitor {
    private static final Logger a = LogUtils.getLogger();
    private static final int b = 8;
    private static final ByteCollection c = new ByteOpenHashSet(Arrays.asList((byte)1, (byte)2, (byte)3, (byte)4, (byte)5, (byte)6));
    private static final EnumChatFormat d = EnumChatFormat.l;
    private static final EnumChatFormat e = EnumChatFormat.k;
    private static final EnumChatFormat f = EnumChatFormat.g;
    private static final EnumChatFormat g = EnumChatFormat.m;
    private static final Pattern h = Pattern.compile("[A-Za-z0-9._+-]+");
    private static final String i = String.valueOf(':');
    private static final String j = String.valueOf(',');
    private static final String k = "[";
    private static final String l = "]";
    private static final String m = ";";
    private static final String n = " ";
    private static final String o = "{";
    private static final String p = "}";
    private static final String q = "\n";
    private final String r;
    private final int s;
    private IChatBaseComponent t = ChatComponentText.d;

    public TextComponentTagVisitor(String prefix, int indentationLevel) {
        this.r = prefix;
        this.s = indentationLevel;
    }

    public IChatBaseComponent a(NBTBase element) {
        element.a(this);
        return this.t;
    }

    @Override
    @Override
    public void a(NBTTagString element) {
        String string = NBTTagString.b(element.e_());
        String string2 = string.substring(0, 1);
        IChatMutableComponent component = new ChatComponentText(string.substring(1, string.length() - 1)).a(e);
        this.t = new ChatComponentText(string2).a(component).c(string2);
    }

    @Override
    @Override
    public void a(NBTTagByte element) {
        IChatMutableComponent component = new ChatComponentText("b").a(g);
        this.t = new ChatComponentText(String.valueOf(element.k())).a(component).a(f);
    }

    @Override
    @Override
    public void a(NBTTagShort element) {
        IChatMutableComponent component = new ChatComponentText("s").a(g);
        this.t = new ChatComponentText(String.valueOf(element.k())).a(component).a(f);
    }

    @Override
    @Override
    public void a(NBTTagInt element) {
        this.t = new ChatComponentText(String.valueOf(element.k())).a(f);
    }

    @Override
    @Override
    public void a(NBTTagLong element) {
        IChatMutableComponent component = new ChatComponentText("L").a(g);
        this.t = new ChatComponentText(String.valueOf(element.k())).a(component).a(f);
    }

    @Override
    @Override
    public void a(NBTTagFloat element) {
        IChatMutableComponent component = new ChatComponentText("f").a(g);
        this.t = new ChatComponentText(String.valueOf(element.j())).a(component).a(f);
    }

    @Override
    @Override
    public void a(NBTTagDouble element) {
        IChatMutableComponent component = new ChatComponentText("d").a(g);
        this.t = new ChatComponentText(String.valueOf(element.i())).a(component).a(f);
    }

    @Override
    @Override
    public void a(NBTTagByteArray element) {
        IChatMutableComponent component = new ChatComponentText("B").a(g);
        IChatMutableComponent mutableComponent = new ChatComponentText(k).a(component).c(m);
        byte[] bs = element.d();
        for (int i2 = 0; i2 < bs.length; ++i2) {
            IChatMutableComponent mutableComponent2 = new ChatComponentText(String.valueOf(bs[i2])).a(f);
            mutableComponent.c(n).a(mutableComponent2).a(component);
            if (i2 == bs.length - 1) continue;
            mutableComponent.c(j);
        }
        mutableComponent.c(l);
        this.t = mutableComponent;
    }

    @Override
    @Override
    public void a(NBTTagIntArray element) {
        IChatMutableComponent component = new ChatComponentText("I").a(g);
        IChatMutableComponent mutableComponent = new ChatComponentText(k).a(component).c(m);
        int[] is = element.f();
        for (int i2 = 0; i2 < is.length; ++i2) {
            mutableComponent.c(n).a(new ChatComponentText(String.valueOf(is[i2])).a(f));
            if (i2 == is.length - 1) continue;
            mutableComponent.c(j);
        }
        mutableComponent.c(l);
        this.t = mutableComponent;
    }

    @Override
    @Override
    public void a(NBTTagLongArray element) {
        IChatMutableComponent component = new ChatComponentText("L").a(g);
        IChatMutableComponent mutableComponent = new ChatComponentText(k).a(component).c(m);
        long[] ls = element.f();
        for (int i2 = 0; i2 < ls.length; ++i2) {
            IChatMutableComponent component2 = new ChatComponentText(String.valueOf(ls[i2])).a(f);
            mutableComponent.c(n).a(component2).a(component);
            if (i2 == ls.length - 1) continue;
            mutableComponent.c(j);
        }
        mutableComponent.c(l);
        this.t = mutableComponent;
    }

    @Override
    @Override
    public void a(NBTTagList element) {
        if (element.isEmpty()) {
            this.t = new ChatComponentText("[]");
            return;
        }
        if (c.contains(element.e()) && element.size() <= 8) {
            String string = j + n;
            ChatComponentText mutableComponent = new ChatComponentText(k);
            for (int i2 = 0; i2 < element.size(); ++i2) {
                if (i2 != 0) {
                    mutableComponent.c(string);
                }
                mutableComponent.a(new TextComponentTagVisitor(this.r, this.s).a(element.k(i2)));
            }
            mutableComponent.c(l);
            this.t = mutableComponent;
            return;
        }
        ChatComponentText mutableComponent2 = new ChatComponentText(k);
        if (!this.r.isEmpty()) {
            mutableComponent2.c(q);
        }
        for (int j2 = 0; j2 < element.size(); ++j2) {
            ChatComponentText mutableComponent3 = new ChatComponentText(Strings.repeat((String)this.r, (int)(this.s + 1)));
            mutableComponent3.a(new TextComponentTagVisitor(this.r, this.s + 1).a(element.k(j2)));
            if (j2 != element.size() - 1) {
                mutableComponent3.c(j).c(this.r.isEmpty() ? n : q);
            }
            mutableComponent2.a(mutableComponent3);
        }
        if (!this.r.isEmpty()) {
            mutableComponent2.c(q).c(Strings.repeat((String)this.r, (int)this.s));
        }
        mutableComponent2.c(l);
        this.t = mutableComponent2;
    }

    @Override
    @Override
    public void a(NBTTagCompound compound) {
        if (compound.f()) {
            this.t = new ChatComponentText("{}");
            return;
        }
        ChatComponentText mutableComponent = new ChatComponentText(o);
        Collection<String> collection = compound.d();
        if (a.isDebugEnabled()) {
            ArrayList list = Lists.newArrayList(compound.d());
            Collections.sort(list);
            collection = list;
        }
        if (!this.r.isEmpty()) {
            mutableComponent.c(q);
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            IChatMutableComponent mutableComponent2 = new ChatComponentText(Strings.repeat((String)this.r, (int)(this.s + 1))).a(TextComponentTagVisitor.a(string)).c(i).c(n).a(new TextComponentTagVisitor(this.r, this.s + 1).a(compound.c(string)));
            if (iterator.hasNext()) {
                mutableComponent2.c(j).c(this.r.isEmpty() ? n : q);
            }
            mutableComponent.a(mutableComponent2);
        }
        if (!this.r.isEmpty()) {
            mutableComponent.c(q).c(Strings.repeat((String)this.r, (int)this.s));
        }
        mutableComponent.c(p);
        this.t = mutableComponent;
    }

    protected static IChatBaseComponent a(String name) {
        if (h.matcher(name).matches()) {
            return new ChatComponentText(name).a(d);
        }
        String string = NBTTagString.b(name);
        String string2 = string.substring(0, 1);
        IChatMutableComponent component = new ChatComponentText(string.substring(1, string.length() - 1)).a(d);
        return new ChatComponentText(string2).a(component).c(string2);
    }

    @Override
    @Override
    public void a(NBTTagEnd element) {
        this.t = ChatComponentText.d;
    }
}

