/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import io.netty.buffer.ByteBufInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTReadLimiter;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagEnd;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.nbt.NBTTagType;
import net.minecraft.nbt.NBTTagTypes;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.util.FastBufferedInputStream;
import org.spigotmc.LimitStream;

public class NBTCompressedStreamTools {
    public static NBTTagCompound a(File file) throws IOException {
        NBTTagCompound nbttagcompound;
        try (FileInputStream fileinputstream = new FileInputStream(file);){
            nbttagcompound = NBTCompressedStreamTools.a(fileinputstream);
        }
        return nbttagcompound;
    }

    private static DataInputStream b(InputStream stream) throws IOException {
        return new DataInputStream(new FastBufferedInputStream(new GZIPInputStream(stream)));
    }

    public static NBTTagCompound a(InputStream stream) throws IOException {
        NBTTagCompound nbttagcompound;
        try (DataInputStream datainputstream = NBTCompressedStreamTools.b(stream);){
            nbttagcompound = NBTCompressedStreamTools.a((DataInput)datainputstream, NBTReadLimiter.a);
        }
        return nbttagcompound;
    }

    public static void a(File file, StreamTagVisitor scanner) throws IOException {
        try (FileInputStream fileinputstream = new FileInputStream(file);){
            NBTCompressedStreamTools.a(fileinputstream, scanner);
        }
    }

    public static void a(InputStream stream, StreamTagVisitor scanner) throws IOException {
        try (DataInputStream datainputstream = NBTCompressedStreamTools.b(stream);){
            NBTCompressedStreamTools.a((DataInput)datainputstream, scanner);
        }
    }

    public static void a(NBTTagCompound compound, File file) throws IOException {
        try (FileOutputStream fileoutputstream = new FileOutputStream(file);){
            NBTCompressedStreamTools.a(compound, fileoutputstream);
        }
    }

    public static void a(NBTTagCompound compound, OutputStream stream) throws IOException {
        try (DataOutputStream dataoutputstream = new DataOutputStream(new BufferedOutputStream(new GZIPOutputStream(stream)));){
            NBTCompressedStreamTools.a(compound, (DataOutput)dataoutputstream);
        }
    }

    public static void b(NBTTagCompound compound, File file) throws IOException {
        try (FileOutputStream fileoutputstream = new FileOutputStream(file);
             DataOutputStream dataoutputstream = new DataOutputStream(fileoutputstream);){
            NBTCompressedStreamTools.a(compound, (DataOutput)dataoutputstream);
        }
    }

    @Nullable
    public static NBTTagCompound b(File file) throws IOException {
        NBTTagCompound nbttagcompound;
        if (!file.exists()) {
            return null;
        }
        try (FileInputStream fileinputstream = new FileInputStream(file);
             DataInputStream datainputstream = new DataInputStream(fileinputstream);){
            nbttagcompound = NBTCompressedStreamTools.a((DataInput)datainputstream, NBTReadLimiter.a);
        }
        return nbttagcompound;
    }

    public static NBTTagCompound a(DataInput input) throws IOException {
        return NBTCompressedStreamTools.a(input, NBTReadLimiter.a);
    }

    public static NBTTagCompound a(DataInput input, NBTReadLimiter tracker) throws IOException {
        NBTBase nbtbase;
        if (input instanceof ByteBufInputStream) {
            input = new DataInputStream(new LimitStream((InputStream)((Object)input), tracker));
        }
        if ((nbtbase = NBTCompressedStreamTools.a(input, 0, tracker)) instanceof NBTTagCompound) {
            return (NBTTagCompound)nbtbase;
        }
        throw new IOException("Root tag must be a named compound tag");
    }

    public static void a(NBTTagCompound compound, DataOutput output) throws IOException {
        NBTCompressedStreamTools.a((NBTBase)compound, output);
    }

    public static void a(DataInput input, StreamTagVisitor scanner) throws IOException {
        NBTTagType<?> nbttagtype = NBTTagTypes.a(input.readByte());
        if (nbttagtype == NBTTagEnd.a) {
            if (scanner.b(NBTTagEnd.a) == StreamTagVisitor.b.a) {
                scanner.a();
            }
        } else {
            switch (scanner.b(nbttagtype)) {
                default: {
                    break;
                }
                case b: {
                    NBTTagString.a(input);
                    nbttagtype.a(input);
                    break;
                }
                case a: {
                    NBTTagString.a(input);
                    nbttagtype.a(input, scanner);
                }
            }
        }
    }

    public static void a(NBTBase element, DataOutput output) throws IOException {
        output.writeByte(element.a());
        if (element.a() != 0) {
            output.writeUTF("");
            element.a(output);
        }
    }

    private static NBTBase a(DataInput input, int depth, NBTReadLimiter tracker) throws IOException {
        byte b0 = input.readByte();
        if (b0 == 0) {
            return NBTTagEnd.b;
        }
        NBTTagString.a(input);
        try {
            return NBTTagTypes.a(b0).b(input, depth, tracker);
        }
        catch (IOException ioexception) {
            CrashReport crashreport = CrashReport.a(ioexception, "Loading NBT data");
            CrashReportSystemDetails crashreportsystemdetails = crashreport.a("NBT Tag");
            crashreportsystemdetails.a("Tag type", b0);
            throw new ReportedException(crashreport);
        }
    }
}

