/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.gametest.framework;

import com.google.common.base.MoreObjects;
import java.util.Arrays;
import net.minecraft.EnumChatFormat;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.gametest.framework.ExhaustedAttemptsException;
import net.minecraft.gametest.framework.GameTestHarnessAssertionPosition;
import net.minecraft.gametest.framework.GameTestHarnessInfo;
import net.minecraft.gametest.framework.GameTestHarnessListener;
import net.minecraft.gametest.framework.GameTestHarnessTestFunction;
import net.minecraft.gametest.framework.GameTestHarnessTicker;
import net.minecraft.gametest.framework.GlobalTestReporter;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.chat.ChatComponentText;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockLectern;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructure;
import org.apache.commons.lang3.exception.ExceptionUtils;

class ReportGameListener
implements GameTestHarnessListener {
    private final GameTestHarnessInfo c;
    private final GameTestHarnessTicker d;
    private final BlockPosition e;
    int a;
    int b;

    public ReportGameListener(GameTestHarnessInfo test, GameTestHarnessTicker testManager, BlockPosition pos) {
        this.c = test;
        this.d = testManager;
        this.e = pos;
        this.a = 0;
        this.b = 0;
    }

    @Override
    @Override
    public void a(GameTestHarnessInfo test) {
        ReportGameListener.a(this.c, Blocks.do);
        ++this.a;
    }

    @Override
    @Override
    public void b(GameTestHarnessInfo test) {
        ++this.b;
        if (!test.x()) {
            ReportGameListener.a(test, test.c() + " passed!");
            return;
        }
        if (this.b >= test.z()) {
            ReportGameListener.a(test, test + " passed " + this.b + " times of " + this.a + " attempts.");
        } else {
            ReportGameListener.a(this.c.g(), EnumChatFormat.k, "Flaky test " + this.c + " succeeded, attempt: " + this.a + " successes: " + this.b);
            this.a();
        }
    }

    @Override
    @Override
    public void c(GameTestHarnessInfo test) {
        if (!test.x()) {
            ReportGameListener.a(test, test.n());
            return;
        }
        GameTestHarnessTestFunction testFunction = this.c.v();
        String string = "Flaky test " + this.c + " failed, attempt: " + this.a + "/" + testFunction.i();
        if (testFunction.j() > 1) {
            string = string + ", successes: " + this.b + " (" + testFunction.j() + " required)";
        }
        ReportGameListener.a(this.c.g(), EnumChatFormat.o, string);
        if (test.y() - this.a + this.b >= test.z()) {
            this.a();
        } else {
            ReportGameListener.a(test, new ExhaustedAttemptsException(this.a, this.b, test));
        }
    }

    public static void a(GameTestHarnessInfo test, String output) {
        ReportGameListener.a(test, Blocks.dl);
        ReportGameListener.b(test, output);
    }

    private static void b(GameTestHarnessInfo test, String output) {
        ReportGameListener.a(test.g(), EnumChatFormat.k, output);
        GlobalTestReporter.b(test);
    }

    protected static void a(GameTestHarnessInfo test, Throwable output) {
        ReportGameListener.a(test, test.r() ? Blocks.du : Blocks.dh);
        ReportGameListener.c(test, SystemUtils.d(output));
        ReportGameListener.b(test, output);
    }

    protected static void b(GameTestHarnessInfo test, Throwable output) {
        String string = output.getMessage() + (String)(output.getCause() == null ? "" : " cause: " + SystemUtils.d(output.getCause()));
        String string2 = (test.r() ? "" : "(optional) ") + test.c() + " failed! " + string;
        ReportGameListener.a(test.g(), test.r() ? EnumChatFormat.m : EnumChatFormat.o, string2);
        Throwable throwable = (Throwable)MoreObjects.firstNonNull((Object)ExceptionUtils.getRootCause((Throwable)output), (Object)output);
        if (throwable instanceof GameTestHarnessAssertionPosition) {
            GameTestHarnessAssertionPosition gameTestAssertPosException = (GameTestHarnessAssertionPosition)throwable;
            ReportGameListener.a(test.g(), gameTestAssertPosException.c(), gameTestAssertPosException.a());
        }
        GlobalTestReporter.a(test);
    }

    private void a() {
        this.c.o();
        GameTestHarnessInfo gameTestInfo = new GameTestHarnessInfo(this.c.v(), this.c.u(), this.c.g());
        gameTestInfo.a();
        this.d.a(gameTestInfo);
        gameTestInfo.a(this);
        gameTestInfo.a(this.e, 2);
    }

    protected static void a(GameTestHarnessInfo test, Block block) {
        WorldServer serverLevel = test.g();
        BlockPosition blockPos = test.d();
        BlockPosition blockPos2 = new BlockPosition(-1, -1, -1);
        BlockPosition blockPos3 = DefinedStructure.a(blockPos.a(blockPos2), EnumBlockMirror.a, test.u(), blockPos);
        serverLevel.b(blockPos3, Blocks.eF.n().a(test.u()));
        BlockPosition blockPos4 = blockPos3.b(0, 1, 0);
        serverLevel.b(blockPos4, block.n());
        for (int i2 = -1; i2 <= 1; ++i2) {
            for (int j2 = -1; j2 <= 1; ++j2) {
                BlockPosition blockPos5 = blockPos3.b(i2, -1, j2);
                serverLevel.b(blockPos5, Blocks.bL.n());
            }
        }
    }

    private static void c(GameTestHarnessInfo test, String output) {
        WorldServer serverLevel = test.g();
        BlockPosition blockPos = test.d();
        BlockPosition blockPos2 = new BlockPosition(-1, 1, -1);
        BlockPosition blockPos3 = DefinedStructure.a(blockPos.a(blockPos2), EnumBlockMirror.a, test.u(), blockPos);
        serverLevel.b(blockPos3, Blocks.mm.n().a(test.u()));
        IBlockData blockState = serverLevel.a_(blockPos3);
        ItemStack itemStack = ReportGameListener.a(test.c(), test.r(), output);
        BlockLectern.a(null, serverLevel, blockPos3, blockState, itemStack);
    }

    private static ItemStack a(String text, boolean required, String output) {
        ItemStack itemStack = new ItemStack(Items.rg);
        NBTTagList listTag = new NBTTagList();
        StringBuffer stringBuffer = new StringBuffer();
        Arrays.stream(text.split("\\.")).forEach(line -> stringBuffer.append((String)line).append('\n'));
        if (!required) {
            stringBuffer.append("(optional)\n");
        }
        stringBuffer.append("-------------------\n");
        listTag.add(NBTTagString.a(stringBuffer + output));
        itemStack.a("pages", listTag);
        return itemStack;
    }

    protected static void a(WorldServer world, EnumChatFormat formatting, String message) {
        world.a((? super EntityPlayer player) -> true).forEach(player -> player.a((IChatBaseComponent)new ChatComponentText(message).a(formatting), SystemUtils.c));
    }

    private static void a(WorldServer world, BlockPosition pos, String message) {
        PacketDebug.a(world, pos, message, -2130771968, Integer.MAX_VALUE);
    }
}

