/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.gametest.framework;

import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Lifecycle;
import java.net.Proxy;
import java.util.Collection;
import java.util.List;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.SystemReport;
import net.minecraft.SystemUtils;
import net.minecraft.commands.CommandDispatcher;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.gametest.framework.GameTestHarnessBatch;
import net.minecraft.gametest.framework.GameTestHarnessCollector;
import net.minecraft.gametest.framework.GameTestHarnessInfo;
import net.minecraft.gametest.framework.GameTestHarnessRunner;
import net.minecraft.gametest.framework.GameTestHarnessTicker;
import net.minecraft.gametest.framework.GlobalTestReporter;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.WorldStem;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.level.progress.WorldLoadListenerLogger;
import net.minecraft.server.packs.repository.ResourcePackRepository;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.server.players.PlayerList;
import net.minecraft.util.datafix.DataConverterRegistry;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.level.DataPackConfiguration;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.WorldSettings;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.level.levelgen.ChunkProviderFlat;
import net.minecraft.world.level.levelgen.GeneratorSettings;
import net.minecraft.world.level.levelgen.flat.GeneratorSettingsFlat;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.storage.Convertable;
import net.minecraft.world.level.storage.WorldDataServer;
import org.slf4j.Logger;

public class GameTestServer
extends MinecraftServer {
    private static final Logger q = LogUtils.getLogger();
    private static final int r = 20;
    private final List<GameTestHarnessBatch> s;
    private final BlockPosition t;
    private static final GameRules u = SystemUtils.a(new GameRules(), (T gameRules) -> {
        gameRules.a(GameRules.e).a(false, (MinecraftServer)null);
        gameRules.a(GameRules.u).a(false, (MinecraftServer)null);
    });
    private static final WorldSettings v = new WorldSettings("Test Level", EnumGamemode.b, false, EnumDifficulty.c, true, u, DataPackConfiguration.a);
    @Nullable
    private GameTestHarnessCollector w;

    public static GameTestServer a(Thread thread, Convertable.ConversionSession session, ResourcePackRepository resourcePackManager, Collection<GameTestHarnessBatch> batches, BlockPosition pos) {
        if (batches.isEmpty()) {
            throw new IllegalArgumentException("No test batches were given!");
        }
        WorldStem.b initConfig = new WorldStem.b(resourcePackManager, CommandDispatcher.ServerType.b, 4, false);
        try {
            WorldStem worldStem = WorldStem.a(initConfig, () -> DataPackConfiguration.a, (IResourceManager resourceManager, DataPackConfiguration dataPackSettings) -> {
                IRegistryCustom.Dimension frozen = IRegistryCustom.d.get();
                IRegistry<BiomeBase> registry = frozen.d(IRegistry.aP);
                IRegistry<StructureSet> registry2 = frozen.d(IRegistry.aM);
                IRegistry<DimensionManager> registry3 = frozen.d(IRegistry.N);
                WorldDataServer worldData = new WorldDataServer(v, new GeneratorSettings(0L, false, false, GeneratorSettings.a(registry3, DimensionManager.a(frozen, 0L), (ChunkGenerator)new ChunkProviderFlat(registry2, GeneratorSettingsFlat.a(registry, registry2)))), Lifecycle.stable());
                return Pair.of((Object)worldData, (Object)frozen);
            }, SystemUtils.f(), Runnable::run).get();
            worldStem.a();
            return new GameTestServer(thread, session, resourcePackManager, worldStem, batches, pos);
        }
        catch (Exception exception) {
            q.warn("Failed to load vanilla datapack, bit oops", (Throwable)exception);
            System.exit(-1);
            throw new IllegalStateException();
        }
    }

    private GameTestServer(Thread serverThread, Convertable.ConversionSession session, ResourcePackRepository dataPackManager, WorldStem saveLoader, Collection<GameTestHarnessBatch> batches, BlockPosition pos) {
        super(serverThread, session, dataPackManager, saveLoader, Proxy.NO_PROXY, DataConverterRegistry.a(), null, null, null, WorldLoadListenerLogger::new);
        this.s = Lists.newArrayList(batches);
        this.t = pos;
    }

    @Override
    @Override
    public boolean e() {
        this.a(new PlayerList(this, this.aU(), this.m, 1){});
        this.loadLevel();
        WorldServer serverLevel = this.D();
        serverLevel.a(this.t, 0.0f);
        int i2 = 20000000;
        serverLevel.a(20000000, 20000000, false, false);
        return true;
    }

    @Override
    @Override
    public void a(BooleanSupplier shouldKeepTicking) {
        super.a(shouldKeepTicking);
        WorldServer serverLevel = this.D();
        if (!this.bd()) {
            this.b(serverLevel);
        }
        if (serverLevel.U() % 20L == 0L) {
            q.info(this.w.j());
        }
        if (this.w.i()) {
            this.a(false);
            q.info(this.w.j());
            GlobalTestReporter.a();
            q.info("========= {} GAME TESTS COMPLETE ======================", (Object)this.w.h());
            if (this.w.d()) {
                q.info("{} required tests failed :(", (Object)this.w.a());
                this.w.f().forEach(test -> q.info("   - {}", (Object)test.c()));
            } else {
                q.info("All {} required tests passed :)", (Object)this.w.h());
            }
            if (this.w.e()) {
                q.info("{} optional tests failed", (Object)this.w.b());
                this.w.g().forEach(test -> q.info("   - {}", (Object)test.c()));
            }
            q.info("====================================================");
        }
    }

    @Override
    @Override
    public SystemReport a(SystemReport details) {
        details.a("Type", "Game test server");
        return details;
    }

    @Override
    @Override
    public void f() {
        super.f();
        System.exit(this.w.a());
    }

    @Override
    @Override
    public void a(CrashReport report) {
        System.exit(1);
    }

    private void b(WorldServer world) {
        Collection<GameTestHarnessInfo> collection = GameTestHarnessRunner.a(this.s, new BlockPosition(0, -60, 0), EnumBlockRotation.a, world, GameTestHarnessTicker.a, 8);
        this.w = new GameTestHarnessCollector(collection);
        q.info("{} tests are now running!", (Object)this.w.h());
    }

    private boolean bd() {
        return this.w != null;
    }

    @Override
    @Override
    public boolean g() {
        return false;
    }

    @Override
    @Override
    public int h() {
        return 0;
    }

    @Override
    @Override
    public int i() {
        return 4;
    }

    @Override
    @Override
    public boolean j() {
        return false;
    }

    @Override
    @Override
    public boolean k() {
        return false;
    }

    @Override
    @Override
    public int l() {
        return 0;
    }

    @Override
    @Override
    public boolean m() {
        return false;
    }

    @Override
    @Override
    public boolean n() {
        return true;
    }

    @Override
    @Override
    public boolean o() {
        return false;
    }

    @Override
    @Override
    public boolean G_() {
        return false;
    }

    @Override
    @Override
    public boolean a(GameProfile profile) {
        return false;
    }
}

