/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.gametest.framework;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.EnumChatFormat;
import net.minecraft.SystemUtils;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.blocks.ArgumentTileLocation;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.data.structures.DebugReportNBT;
import net.minecraft.gametest.framework.GameTestHarnessCollector;
import net.minecraft.gametest.framework.GameTestHarnessInfo;
import net.minecraft.gametest.framework.GameTestHarnessListener;
import net.minecraft.gametest.framework.GameTestHarnessRegistry;
import net.minecraft.gametest.framework.GameTestHarnessRunner;
import net.minecraft.gametest.framework.GameTestHarnessStructures;
import net.minecraft.gametest.framework.GameTestHarnessTestClassArgument;
import net.minecraft.gametest.framework.GameTestHarnessTestFunction;
import net.minecraft.gametest.framework.GameTestHarnessTestFunctionArgument;
import net.minecraft.gametest.framework.GameTestHarnessTicker;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTCompressedStreamTools;
import net.minecraft.network.chat.ChatClickable;
import net.minecraft.network.chat.ChatComponentText;
import net.minecraft.network.chat.ChatHoverable;
import net.minecraft.network.chat.ChatModifier;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.entity.TileEntityStructure;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import org.apache.commons.io.IOUtils;

public class GameTestHarnessTestCommand {
    private static final int a = 200;
    private static final int b = 1024;
    private static final int c = 15;
    private static final int d = 200;
    private static final int e = 3;
    private static final int f = 10000;
    private static final int g = 5;
    private static final int h = 5;
    private static final int i = 5;

    public static void a(CommandDispatcher<CommandListenerWrapper> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("test").then(net.minecraft.commands.CommandDispatcher.a("runthis").executes(context -> GameTestHarnessTestCommand.a((CommandListenerWrapper)context.getSource())))).then(net.minecraft.commands.CommandDispatcher.a("runthese").executes(context -> GameTestHarnessTestCommand.b((CommandListenerWrapper)context.getSource())))).then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("runfailed").executes(context -> GameTestHarnessTestCommand.a((CommandListenerWrapper)context.getSource(), false, 0, 8))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("onlyRequiredTests", BoolArgumentType.bool()).executes(context -> GameTestHarnessTestCommand.a((CommandListenerWrapper)context.getSource(), BoolArgumentType.getBool((CommandContext)context, (String)"onlyRequiredTests"), 0, 8))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("rotationSteps", IntegerArgumentType.integer()).executes(context -> GameTestHarnessTestCommand.a((CommandListenerWrapper)context.getSource(), BoolArgumentType.getBool((CommandContext)context, (String)"onlyRequiredTests"), IntegerArgumentType.getInteger((CommandContext)context, (String)"rotationSteps"), 8))).then(net.minecraft.commands.CommandDispatcher.a("testsPerRow", IntegerArgumentType.integer()).executes(context -> GameTestHarnessTestCommand.a((CommandListenerWrapper)context.getSource(), BoolArgumentType.getBool((CommandContext)context, (String)"onlyRequiredTests"), IntegerArgumentType.getInteger((CommandContext)context, (String)"rotationSteps"), IntegerArgumentType.getInteger((CommandContext)context, (String)"testsPerRow")))))))).then(net.minecraft.commands.CommandDispatcher.a("run").then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("testName", GameTestHarnessTestFunctionArgument.a()).executes(context -> GameTestHarnessTestCommand.a((CommandListenerWrapper)context.getSource(), GameTestHarnessTestFunctionArgument.a((CommandContext<CommandListenerWrapper>)context, "testName"), 0))).then(net.minecraft.commands.CommandDispatcher.a("rotationSteps", IntegerArgumentType.integer()).executes(context -> GameTestHarnessTestCommand.a((CommandListenerWrapper)context.getSource(), GameTestHarnessTestFunctionArgument.a((CommandContext<CommandListenerWrapper>)context, "testName"), IntegerArgumentType.getInteger((CommandContext)context, (String)"rotationSteps"))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("runall").executes(context -> GameTestHarnessTestCommand.a((CommandListenerWrapper)context.getSource(), 0, 8))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("testClassName", GameTestHarnessTestClassArgument.a()).executes(context -> GameTestHarnessTestCommand.a((CommandListenerWrapper)context.getSource(), GameTestHarnessTestClassArgument.a((CommandContext<CommandListenerWrapper>)context, "testClassName"), 0, 8))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("rotationSteps", IntegerArgumentType.integer()).executes(context -> GameTestHarnessTestCommand.a((CommandListenerWrapper)context.getSource(), GameTestHarnessTestClassArgument.a((CommandContext<CommandListenerWrapper>)context, "testClassName"), IntegerArgumentType.getInteger((CommandContext)context, (String)"rotationSteps"), 8))).then(net.minecraft.commands.CommandDispatcher.a("testsPerRow", IntegerArgumentType.integer()).executes(context -> GameTestHarnessTestCommand.a((CommandListenerWrapper)context.getSource(), GameTestHarnessTestClassArgument.a((CommandContext<CommandListenerWrapper>)context, "testClassName"), IntegerArgumentType.getInteger((CommandContext)context, (String)"rotationSteps"), IntegerArgumentType.getInteger((CommandContext)context, (String)"testsPerRow"))))))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("rotationSteps", IntegerArgumentType.integer()).executes(context -> GameTestHarnessTestCommand.a((CommandListenerWrapper)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"rotationSteps"), 8))).then(net.minecraft.commands.CommandDispatcher.a("testsPerRow", IntegerArgumentType.integer()).executes(context -> GameTestHarnessTestCommand.a((CommandListenerWrapper)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"rotationSteps"), IntegerArgumentType.getInteger((CommandContext)context, (String)"testsPerRow"))))))).then(net.minecraft.commands.CommandDispatcher.a("export").then(net.minecraft.commands.CommandDispatcher.a("testName", StringArgumentType.word()).executes(context -> GameTestHarnessTestCommand.c((CommandListenerWrapper)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"testName")))))).then(net.minecraft.commands.CommandDispatcher.a("exportthis").executes(context -> GameTestHarnessTestCommand.c((CommandListenerWrapper)context.getSource())))).then(net.minecraft.commands.CommandDispatcher.a("import").then(net.minecraft.commands.CommandDispatcher.a("testName", StringArgumentType.word()).executes(context -> GameTestHarnessTestCommand.d((CommandListenerWrapper)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"testName")))))).then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("pos").executes(context -> GameTestHarnessTestCommand.a((CommandListenerWrapper)context.getSource(), "pos"))).then(net.minecraft.commands.CommandDispatcher.a("var", StringArgumentType.word()).executes(context -> GameTestHarnessTestCommand.a((CommandListenerWrapper)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"var")))))).then(net.minecraft.commands.CommandDispatcher.a("create").then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("testName", StringArgumentType.word()).executes(context -> GameTestHarnessTestCommand.a((CommandListenerWrapper)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"testName"), 5, 5, 5))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("width", IntegerArgumentType.integer()).executes(context -> GameTestHarnessTestCommand.a((CommandListenerWrapper)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"testName"), IntegerArgumentType.getInteger((CommandContext)context, (String)"width"), IntegerArgumentType.getInteger((CommandContext)context, (String)"width"), IntegerArgumentType.getInteger((CommandContext)context, (String)"width")))).then(net.minecraft.commands.CommandDispatcher.a("height", IntegerArgumentType.integer()).then(net.minecraft.commands.CommandDispatcher.a("depth", IntegerArgumentType.integer()).executes(context -> GameTestHarnessTestCommand.a((CommandListenerWrapper)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"testName"), IntegerArgumentType.getInteger((CommandContext)context, (String)"width"), IntegerArgumentType.getInteger((CommandContext)context, (String)"height"), IntegerArgumentType.getInteger((CommandContext)context, (String)"depth"))))))))).then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("clearall").executes(context -> GameTestHarnessTestCommand.a((CommandListenerWrapper)context.getSource(), 200))).then(net.minecraft.commands.CommandDispatcher.a("radius", IntegerArgumentType.integer()).executes(context -> GameTestHarnessTestCommand.a((CommandListenerWrapper)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"radius")))))));
    }

    private static int a(CommandListenerWrapper source, String structure, int x2, int y2, int z2) {
        if (x2 > 48 || y2 > 48 || z2 > 48) {
            throw new IllegalArgumentException("The structure must be less than 48 blocks big in each axis");
        }
        WorldServer serverLevel = source.e();
        BlockPosition blockPos = new BlockPosition(source.d());
        BlockPosition blockPos2 = new BlockPosition(blockPos.u(), source.e().a(HeightMap.Type.b, blockPos).v(), blockPos.w() + 3);
        GameTestHarnessStructures.a(structure.toLowerCase(), blockPos2, new BaseBlockPosition(x2, y2, z2), EnumBlockRotation.a, serverLevel);
        for (int i2 = 0; i2 < x2; ++i2) {
            for (int j2 = 0; j2 < z2; ++j2) {
                BlockPosition blockPos3 = new BlockPosition(blockPos2.u() + i2, blockPos2.v() + 1, blockPos2.w() + j2);
                Block block = Blocks.h;
                ArgumentTileLocation blockInput = new ArgumentTileLocation(block.n(), Collections.emptySet(), null);
                blockInput.a(serverLevel, blockPos3, 2);
            }
        }
        GameTestHarnessStructures.a(blockPos2, new BlockPosition(1, 0, -1), EnumBlockRotation.a, serverLevel);
        return 0;
    }

    private static int a(CommandListenerWrapper source, String variableName) throws CommandSyntaxException {
        WorldServer serverLevel;
        MovingObjectPositionBlock blockHitResult = (MovingObjectPositionBlock)source.h().a(10.0, 1.0f, false);
        BlockPosition blockPos = blockHitResult.a();
        Optional<BlockPosition> optional = GameTestHarnessStructures.a(blockPos, 15, serverLevel = source.e());
        if (!optional.isPresent()) {
            optional = GameTestHarnessStructures.a(blockPos, 200, serverLevel);
        }
        if (!optional.isPresent()) {
            source.a(new ChatComponentText("Can't find a structure block that contains the targeted pos " + blockPos));
            return 0;
        }
        TileEntityStructure structureBlockEntity = (TileEntityStructure)serverLevel.c_(optional.get());
        BlockPosition blockPos2 = blockPos.b(optional.get());
        String string = blockPos2.u() + ", " + blockPos2.v() + ", " + blockPos2.w();
        String string2 = structureBlockEntity.f();
        IChatMutableComponent component = new ChatComponentText(string).a(ChatModifier.a.a(true).a(EnumChatFormat.k).a(new ChatHoverable(ChatHoverable.EnumHoverAction.a, new ChatComponentText("Click to copy to clipboard"))).a(new ChatClickable(ChatClickable.EnumClickAction.f, "final BlockPos " + variableName + " = new BlockPos(" + string + ");")));
        source.a(new ChatComponentText("Position relative to " + string2 + ": ").a(component), false);
        PacketDebug.a(serverLevel, new BlockPosition(blockPos), string, -2147418368, 10000);
        return 1;
    }

    private static int a(CommandListenerWrapper source) {
        WorldServer serverLevel;
        BlockPosition blockPos = new BlockPosition(source.d());
        BlockPosition blockPos2 = GameTestHarnessStructures.b(blockPos, 15, serverLevel = source.e());
        if (blockPos2 == null) {
            GameTestHarnessTestCommand.a(serverLevel, "Couldn't find any structure block within 15 radius", EnumChatFormat.m);
            return 0;
        }
        GameTestHarnessRunner.a(serverLevel);
        GameTestHarnessTestCommand.a(serverLevel, blockPos2, null);
        return 1;
    }

    private static int b(CommandListenerWrapper source) {
        WorldServer serverLevel;
        BlockPosition blockPos = new BlockPosition(source.d());
        Collection<BlockPosition> collection = GameTestHarnessStructures.c(blockPos, 200, serverLevel = source.e());
        if (collection.isEmpty()) {
            GameTestHarnessTestCommand.a(serverLevel, "Couldn't find any structure blocks within 200 block radius", EnumChatFormat.m);
            return 1;
        }
        GameTestHarnessRunner.a(serverLevel);
        GameTestHarnessTestCommand.b(source, "Running " + collection.size() + " tests...");
        GameTestHarnessCollector multipleTestTracker = new GameTestHarnessCollector();
        collection.forEach(pos -> GameTestHarnessTestCommand.a(serverLevel, pos, multipleTestTracker));
        return 1;
    }

    private static void a(WorldServer world, BlockPosition pos, @Nullable GameTestHarnessCollector tests) {
        TileEntityStructure structureBlockEntity = (TileEntityStructure)world.c_(pos);
        String string = structureBlockEntity.f();
        GameTestHarnessTestFunction testFunction = GameTestHarnessRegistry.f(string);
        GameTestHarnessInfo gameTestInfo = new GameTestHarnessInfo(testFunction, structureBlockEntity.w(), world);
        if (tests != null) {
            tests.a(gameTestInfo);
            gameTestInfo.a(new a(world, tests));
        }
        GameTestHarnessTestCommand.a(testFunction, world);
        AxisAlignedBB aABB = GameTestHarnessStructures.a(structureBlockEntity);
        BlockPosition blockPos = new BlockPosition(aABB.a, aABB.b, aABB.c);
        GameTestHarnessRunner.a(gameTestInfo, blockPos, GameTestHarnessTicker.a);
    }

    static void a(WorldServer world, GameTestHarnessCollector tests) {
        if (tests.i()) {
            GameTestHarnessTestCommand.a(world, "GameTest done! " + tests.h() + " tests were run", EnumChatFormat.p);
            if (tests.d()) {
                GameTestHarnessTestCommand.a(world, tests.a() + " required tests failed :(", EnumChatFormat.m);
            } else {
                GameTestHarnessTestCommand.a(world, "All required tests passed :)", EnumChatFormat.k);
            }
            if (tests.e()) {
                GameTestHarnessTestCommand.a(world, tests.b() + " optional tests failed", EnumChatFormat.h);
            }
        }
    }

    private static int a(CommandListenerWrapper source, int radius) {
        WorldServer serverLevel = source.e();
        GameTestHarnessRunner.a(serverLevel);
        BlockPosition blockPos = new BlockPosition(source.d().b, (double)source.e().a(HeightMap.Type.b, new BlockPosition(source.d())).v(), source.d().d);
        GameTestHarnessRunner.a(serverLevel, blockPos, GameTestHarnessTicker.a, MathHelper.a(radius, 0, 1024));
        return 1;
    }

    private static int a(CommandListenerWrapper source, GameTestHarnessTestFunction testFunction, int rotationSteps) {
        WorldServer serverLevel = source.e();
        BlockPosition blockPos = new BlockPosition(source.d());
        int i2 = source.e().a(HeightMap.Type.b, blockPos).v();
        BlockPosition blockPos2 = new BlockPosition(blockPos.u(), i2, blockPos.w() + 3);
        GameTestHarnessRunner.a(serverLevel);
        GameTestHarnessTestCommand.a(testFunction, serverLevel);
        EnumBlockRotation rotation = GameTestHarnessStructures.a(rotationSteps);
        GameTestHarnessInfo gameTestInfo = new GameTestHarnessInfo(testFunction, rotation, serverLevel);
        GameTestHarnessRunner.a(gameTestInfo, blockPos2, GameTestHarnessTicker.a);
        return 1;
    }

    private static void a(GameTestHarnessTestFunction testFunction, WorldServer world) {
        Consumer<WorldServer> consumer = GameTestHarnessRegistry.c(testFunction.e());
        if (consumer != null) {
            consumer.accept(world);
        }
    }

    private static int a(CommandListenerWrapper source, int rotationSteps, int sizeZ) {
        GameTestHarnessRunner.a(source.e());
        Collection<GameTestHarnessTestFunction> collection = GameTestHarnessRegistry.a();
        GameTestHarnessTestCommand.b(source, "Running all " + collection.size() + " tests...");
        GameTestHarnessRegistry.d();
        GameTestHarnessTestCommand.a(source, collection, rotationSteps, sizeZ);
        return 1;
    }

    private static int a(CommandListenerWrapper source, String testClass, int rotationSteps, int sizeZ) {
        Collection<GameTestHarnessTestFunction> collection = GameTestHarnessRegistry.a(testClass);
        GameTestHarnessRunner.a(source.e());
        GameTestHarnessTestCommand.b(source, "Running " + collection.size() + " tests from " + testClass + "...");
        GameTestHarnessRegistry.d();
        GameTestHarnessTestCommand.a(source, collection, rotationSteps, sizeZ);
        return 1;
    }

    private static int a(CommandListenerWrapper source, boolean requiredOnly, int rotationSteps, int sizeZ) {
        Collection<GameTestHarnessTestFunction> collection2;
        if (requiredOnly) {
            Collection collection = GameTestHarnessRegistry.c().stream().filter(GameTestHarnessTestFunction::d).collect(Collectors.toList());
        } else {
            collection2 = GameTestHarnessRegistry.c();
        }
        if (collection2.isEmpty()) {
            GameTestHarnessTestCommand.b(source, "No failed tests to rerun");
            return 0;
        }
        GameTestHarnessRunner.a(source.e());
        GameTestHarnessTestCommand.b(source, "Rerunning " + collection2.size() + " failed tests (" + (requiredOnly ? "only required tests" : "including optional tests") + ")");
        GameTestHarnessTestCommand.a(source, collection2, rotationSteps, sizeZ);
        return 1;
    }

    private static void a(CommandListenerWrapper source, Collection<GameTestHarnessTestFunction> testFunctions, int rotationSteps, int i2) {
        BlockPosition blockPos = new BlockPosition(source.d());
        BlockPosition blockPos2 = new BlockPosition(blockPos.u(), source.e().a(HeightMap.Type.b, blockPos).v(), blockPos.w() + 3);
        WorldServer serverLevel = source.e();
        EnumBlockRotation rotation = GameTestHarnessStructures.a(rotationSteps);
        Collection<GameTestHarnessInfo> collection = GameTestHarnessRunner.b(testFunctions, blockPos2, rotation, serverLevel, GameTestHarnessTicker.a, i2);
        GameTestHarnessCollector multipleTestTracker = new GameTestHarnessCollector(collection);
        multipleTestTracker.a(new a(serverLevel, multipleTestTracker));
        multipleTestTracker.a(test -> GameTestHarnessRegistry.a(test.v()));
    }

    private static void b(CommandListenerWrapper source, String message) {
        source.a(new ChatComponentText(message), false);
    }

    private static int c(CommandListenerWrapper source) {
        WorldServer serverLevel;
        BlockPosition blockPos = new BlockPosition(source.d());
        BlockPosition blockPos2 = GameTestHarnessStructures.b(blockPos, 15, serverLevel = source.e());
        if (blockPos2 == null) {
            GameTestHarnessTestCommand.a(serverLevel, "Couldn't find any structure block within 15 radius", EnumChatFormat.m);
            return 0;
        }
        TileEntityStructure structureBlockEntity = (TileEntityStructure)serverLevel.c_(blockPos2);
        String string = structureBlockEntity.f();
        return GameTestHarnessTestCommand.c(source, string);
    }

    private static int c(CommandListenerWrapper source, String structure) {
        Path path = Paths.get(GameTestHarnessStructures.b, new String[0]);
        MinecraftKey resourceLocation = new MinecraftKey("minecraft", structure);
        Path path2 = source.e().p().a(resourceLocation, ".nbt");
        Path path3 = DebugReportNBT.a(path2, structure, path);
        if (path3 == null) {
            GameTestHarnessTestCommand.b(source, "Failed to export " + path2);
            return 1;
        }
        try {
            Files.createDirectories(path3.getParent(), new FileAttribute[0]);
        }
        catch (IOException iOException) {
            GameTestHarnessTestCommand.b(source, "Could not create folder " + path3.getParent());
            iOException.printStackTrace();
            return 1;
        }
        GameTestHarnessTestCommand.b(source, "Exported " + structure + " to " + path3.toAbsolutePath());
        return 0;
    }

    private static int d(CommandListenerWrapper source, String structure) {
        Path path = Paths.get(GameTestHarnessStructures.b, structure + ".snbt");
        MinecraftKey resourceLocation = new MinecraftKey("minecraft", structure);
        Path path2 = source.e().p().a(resourceLocation, ".nbt");
        try {
            BufferedReader bufferedReader = Files.newBufferedReader(path);
            String string = IOUtils.toString((Reader)bufferedReader);
            Files.createDirectories(path2.getParent(), new FileAttribute[0]);
            try (OutputStream outputStream = Files.newOutputStream(path2, new OpenOption[0]);){
                NBTCompressedStreamTools.a(GameProfileSerializer.a(string), outputStream);
            }
            GameTestHarnessTestCommand.b(source, "Imported to " + path2.toAbsolutePath());
            return 0;
        }
        catch (CommandSyntaxException | IOException exception) {
            System.err.println("Failed to load structure " + structure);
            exception.printStackTrace();
            return 1;
        }
    }

    private static void a(WorldServer world, String message, EnumChatFormat formatting) {
        world.a(player -> true).forEach(player -> player.a((IChatBaseComponent)new ChatComponentText(formatting + message), SystemUtils.c));
    }

    static class a
    implements GameTestHarnessListener {
        private final WorldServer a;
        private final GameTestHarnessCollector b;

        public a(WorldServer world, GameTestHarnessCollector tests) {
            this.a = world;
            this.b = tests;
        }

        @Override
        @Override
        public void a(GameTestHarnessInfo test) {
        }

        @Override
        @Override
        public void b(GameTestHarnessInfo test) {
            GameTestHarnessTestCommand.a(this.a, this.b);
        }

        @Override
        @Override
        public void c(GameTestHarnessInfo test) {
            GameTestHarnessTestCommand.a(this.a, this.b);
        }
    }
}

