/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.gametest.framework;

import com.google.common.collect.Lists;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.commands.arguments.blocks.ArgumentTileLocation;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IRegistry;
import net.minecraft.data.structures.DebugReportNBT;
import net.minecraft.data.structures.StructureUpdater;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.DispenserRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.entity.TileEntityCommand;
import net.minecraft.world.level.block.entity.TileEntityStructure;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockPropertyStructureMode;
import net.minecraft.world.level.levelgen.flat.GeneratorSettingsFlat;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureManager;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;

public class GameTestHarnessStructures {
    private static final Logger c = LogUtils.getLogger();
    public static final String a = "gameteststructures";
    public static String b = "gameteststructures";
    private static final int d = 4;

    public static EnumBlockRotation a(int steps) {
        switch (steps) {
            case 0: {
                return EnumBlockRotation.a;
            }
            case 1: {
                return EnumBlockRotation.b;
            }
            case 2: {
                return EnumBlockRotation.c;
            }
            case 3: {
                return EnumBlockRotation.d;
            }
        }
        throw new IllegalArgumentException("rotationSteps must be a value from 0-3. Got value " + steps);
    }

    public static int a(EnumBlockRotation rotation) {
        switch (rotation) {
            case a: {
                return 0;
            }
            case b: {
                return 1;
            }
            case c: {
                return 2;
            }
            case d: {
                return 3;
            }
        }
        throw new IllegalArgumentException("Unknown rotation value, don't know how many steps it represents: " + rotation);
    }

    public static void a(String[] args) throws IOException {
        DispenserRegistry.a();
        Files.walk(Paths.get(b, new String[0]), new FileVisitOption[0]).filter(path -> path.toString().endsWith(".snbt")).forEach(path -> {
            try {
                String string = new String(Files.readAllBytes(path), StandardCharsets.UTF_8);
                NBTTagCompound compoundTag = GameProfileSerializer.a(string);
                NBTTagCompound compoundTag2 = StructureUpdater.a(path.toString(), compoundTag);
                DebugReportNBT.a(path, GameProfileSerializer.d(compoundTag2));
            }
            catch (CommandSyntaxException | IOException exception) {
                c.error("Something went wrong upgrading: {}", path, (Object)exception);
            }
        });
    }

    public static AxisAlignedBB a(TileEntityStructure structureBlockEntity) {
        BlockPosition blockPos = structureBlockEntity.p();
        BlockPosition blockPos2 = blockPos.a(structureBlockEntity.j().c(-1, -1, -1));
        BlockPosition blockPos3 = DefinedStructure.a(blockPos2, EnumBlockMirror.a, structureBlockEntity.w(), blockPos);
        return new AxisAlignedBB(blockPos, blockPos3);
    }

    public static StructureBoundingBox b(TileEntityStructure structureBlockEntity) {
        BlockPosition blockPos = structureBlockEntity.p();
        BlockPosition blockPos2 = blockPos.a(structureBlockEntity.j().c(-1, -1, -1));
        BlockPosition blockPos3 = DefinedStructure.a(blockPos2, EnumBlockMirror.a, structureBlockEntity.w(), blockPos);
        return StructureBoundingBox.a(blockPos, blockPos3);
    }

    public static void a(BlockPosition pos, BlockPosition relativePos, EnumBlockRotation rotation, WorldServer world) {
        BlockPosition blockPos = DefinedStructure.a(pos.a(relativePos), EnumBlockMirror.a, rotation, pos);
        world.b(blockPos, Blocks.eE.n());
        TileEntityCommand commandBlockEntity = (TileEntityCommand)world.c_(blockPos);
        commandBlockEntity.c().a("test runthis");
        BlockPosition blockPos2 = DefinedStructure.a(blockPos.b(0, 0, -1), EnumBlockMirror.a, rotation, blockPos);
        world.b(blockPos2, Blocks.cJ.n().a(rotation));
    }

    public static void a(String structure, BlockPosition pos, BaseBlockPosition relativePos, EnumBlockRotation rotation, WorldServer world) {
        StructureBoundingBox boundingBox = GameTestHarnessStructures.a(pos, relativePos, rotation);
        GameTestHarnessStructures.a(boundingBox, pos.v(), world);
        world.b(pos, Blocks.nm.n());
        TileEntityStructure structureBlockEntity = (TileEntityStructure)world.c_(pos);
        structureBlockEntity.a(false);
        structureBlockEntity.a(new MinecraftKey(structure));
        structureBlockEntity.a(relativePos);
        structureBlockEntity.a(BlockPropertyStructureMode.a);
        structureBlockEntity.e(true);
    }

    /*
     * WARNING - void declaration
     */
    public static TileEntityStructure a(String structureName, BlockPosition pos, EnumBlockRotation rotation, int i2, WorldServer world, boolean bl) {
        void blockPos5;
        BaseBlockPosition vec3i = GameTestHarnessStructures.a(structureName, world).a();
        StructureBoundingBox boundingBox = GameTestHarnessStructures.a(pos, vec3i, rotation);
        if (rotation == EnumBlockRotation.a) {
            BlockPosition blockPos = pos;
        } else if (rotation == EnumBlockRotation.b) {
            BlockPosition blockPos2 = pos.b(vec3i.w() - 1, 0, 0);
        } else if (rotation == EnumBlockRotation.c) {
            BlockPosition blockPos3 = pos.b(vec3i.u() - 1, 0, vec3i.w() - 1);
        } else if (rotation == EnumBlockRotation.d) {
            BlockPosition blockPos4 = pos.b(0, 0, vec3i.u() - 1);
        } else {
            throw new IllegalArgumentException("Invalid rotation: " + rotation);
        }
        GameTestHarnessStructures.a(pos, world);
        GameTestHarnessStructures.a(boundingBox, pos.v(), world);
        TileEntityStructure structureBlockEntity = GameTestHarnessStructures.a(structureName, (BlockPosition)blockPos5, rotation, world, bl);
        world.l().a(boundingBox);
        world.a(boundingBox);
        return structureBlockEntity;
    }

    private static void a(BlockPosition pos, WorldServer world) {
        ChunkCoordIntPair chunkPos = new ChunkCoordIntPair(pos);
        for (int i2 = -1; i2 < 4; ++i2) {
            for (int j2 = -1; j2 < 4; ++j2) {
                int k2 = chunkPos.c + i2;
                int l2 = chunkPos.d + j2;
                world.a(k2, l2, true);
            }
        }
    }

    public static void a(StructureBoundingBox area, int altitude, WorldServer world) {
        StructureBoundingBox boundingBox = new StructureBoundingBox(area.g() - 2, area.h() - 3, area.i() - 3, area.j() + 3, area.k() + 20, area.l() + 3);
        BlockPosition.a(boundingBox).forEach(pos -> GameTestHarnessStructures.a(altitude, pos, world));
        world.l().a(boundingBox);
        world.a(boundingBox);
        AxisAlignedBB aABB = new AxisAlignedBB(boundingBox.g(), boundingBox.h(), boundingBox.i(), boundingBox.j(), boundingBox.k(), boundingBox.l());
        List<Entity> list = world.a(Entity.class, aABB, entity -> !(entity instanceof EntityHuman));
        list.forEach(Entity::ah);
    }

    public static StructureBoundingBox a(BlockPosition pos, BaseBlockPosition relativePos, EnumBlockRotation rotation) {
        BlockPosition blockPos = pos.a(relativePos).b(-1, -1, -1);
        BlockPosition blockPos2 = DefinedStructure.a(blockPos, EnumBlockMirror.a, rotation, pos);
        StructureBoundingBox boundingBox = StructureBoundingBox.a(pos, blockPos2);
        int i2 = Math.min(boundingBox.g(), boundingBox.j());
        int j2 = Math.min(boundingBox.i(), boundingBox.l());
        return boundingBox.a(pos.u() - i2, 0, pos.w() - j2);
    }

    public static Optional<BlockPosition> a(BlockPosition pos, int radius, WorldServer world) {
        return GameTestHarnessStructures.c(pos, radius, world).stream().filter(structureBlockPos -> GameTestHarnessStructures.a(structureBlockPos, pos, world)).findFirst();
    }

    @Nullable
    public static BlockPosition b(BlockPosition pos2, int radius, WorldServer world) {
        Comparator<BlockPosition> comparator = Comparator.comparingInt(pos -> pos.k(pos2));
        Collection<BlockPosition> collection = GameTestHarnessStructures.c(pos2, radius, world);
        Optional<BlockPosition> optional = collection.stream().min(comparator);
        return optional.orElse(null);
    }

    public static Collection<BlockPosition> c(BlockPosition pos, int radius, WorldServer world) {
        ArrayList collection = Lists.newArrayList();
        AxisAlignedBB aABB = new AxisAlignedBB(pos);
        aABB = aABB.g(radius);
        for (int i2 = (int)aABB.a; i2 <= (int)aABB.d; ++i2) {
            for (int j2 = (int)aABB.b; j2 <= (int)aABB.e; ++j2) {
                for (int k2 = (int)aABB.c; k2 <= (int)aABB.f; ++k2) {
                    BlockPosition blockPos = new BlockPosition(i2, j2, k2);
                    IBlockData blockState = world.a_(blockPos);
                    if (!blockState.a(Blocks.nm)) continue;
                    collection.add(blockPos);
                }
            }
        }
        return collection;
    }

    private static DefinedStructure a(String structureId, WorldServer world) {
        DefinedStructureManager structureManager = world.p();
        Optional<DefinedStructure> optional = structureManager.b(new MinecraftKey(structureId));
        if (optional.isPresent()) {
            return optional.get();
        }
        String string = structureId + ".snbt";
        Path path = Paths.get(b, string);
        NBTTagCompound compoundTag = GameTestHarnessStructures.a(path);
        if (compoundTag == null) {
            throw new RuntimeException("Could not find structure file " + path + ", and the structure is not available in the world structures either.");
        }
        return structureManager.a(compoundTag);
    }

    private static TileEntityStructure a(String name, BlockPosition pos, EnumBlockRotation rotation, WorldServer world, boolean bl) {
        world.b(pos, Blocks.nm.n());
        TileEntityStructure structureBlockEntity = (TileEntityStructure)world.c_(pos);
        structureBlockEntity.a(BlockPropertyStructureMode.b);
        structureBlockEntity.a(rotation);
        structureBlockEntity.a(false);
        structureBlockEntity.a(new MinecraftKey(name));
        structureBlockEntity.a(world, bl);
        if (structureBlockEntity.j() != BaseBlockPosition.g) {
            return structureBlockEntity;
        }
        DefinedStructure structureTemplate = GameTestHarnessStructures.a(name, world);
        structureBlockEntity.a(world, bl, structureTemplate);
        if (structureBlockEntity.j() == BaseBlockPosition.g) {
            throw new RuntimeException("Failed to load structure " + name);
        }
        return structureBlockEntity;
    }

    @Nullable
    private static NBTTagCompound a(Path path) {
        try {
            BufferedReader bufferedReader = Files.newBufferedReader(path);
            String string = IOUtils.toString((Reader)bufferedReader);
            return GameProfileSerializer.a(string);
        }
        catch (IOException iOException) {
            return null;
        }
        catch (CommandSyntaxException commandSyntaxException) {
            throw new RuntimeException("Error while trying to load structure " + path, commandSyntaxException);
        }
    }

    private static void a(int altitude, BlockPosition pos, WorldServer world) {
        IBlockData blockState = null;
        GeneratorSettingsFlat flatLevelGeneratorSettings = GeneratorSettingsFlat.a(world.s().d(IRegistry.aP), world.s().d(IRegistry.aM));
        List<IBlockData> list = flatLevelGeneratorSettings.g();
        int i2 = pos.v() - world.u_();
        if (pos.v() < altitude && i2 > 0 && i2 <= list.size()) {
            blockState = list.get(i2 - 1);
        }
        if (blockState == null) {
            blockState = Blocks.a.n();
        }
        ArgumentTileLocation blockInput = new ArgumentTileLocation(blockState, Collections.emptySet(), null);
        blockInput.a(world, pos, 2);
        world.a(pos, blockState.b());
    }

    private static boolean a(BlockPosition structureBlockPos, BlockPosition pos, WorldServer world) {
        TileEntityStructure structureBlockEntity = (TileEntityStructure)world.c_(structureBlockPos);
        AxisAlignedBB aABB = GameTestHarnessStructures.a(structureBlockEntity).g(1.0);
        return aABB.d(Vec3D.a(pos));
    }
}

