/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.worldgen;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.MathHelper;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.Noises;
import net.minecraft.world.level.levelgen.PositionalRandomFactory;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.levelgen.VerticalAnchor;

public class SurfaceRuleData {
    private static final SurfaceRules.o a = SurfaceRuleData.a(Blocks.a);
    private static final SurfaceRules.o b = SurfaceRuleData.a(Blocks.z);
    private static final SurfaceRules.o c = SurfaceRuleData.a(Blocks.fS);
    private static final SurfaceRules.o d = SurfaceRuleData.a(Blocks.fT);
    private static final SurfaceRules.o e = SurfaceRuleData.a(Blocks.hf);
    private static final SurfaceRules.o f = SurfaceRuleData.a(Blocks.D);
    private static final SurfaceRules.o g = SurfaceRuleData.a(Blocks.hU);
    private static final SurfaceRules.o h = SurfaceRuleData.a(Blocks.b);
    private static final SurfaceRules.o i = SurfaceRuleData.a(Blocks.pN);
    private static final SurfaceRules.o j = SurfaceRuleData.a(Blocks.j);
    private static final SurfaceRules.o k = SurfaceRuleData.a(Blocks.l);
    private static final SurfaceRules.o l = SurfaceRuleData.a(Blocks.k);
    private static final SurfaceRules.o m = SurfaceRuleData.a(Blocks.ec);
    private static final SurfaceRules.o n = SurfaceRuleData.a(Blocks.i);
    private static final SurfaceRules.o o = SurfaceRuleData.a(Blocks.oM);
    private static final SurfaceRules.o p = SurfaceRuleData.a(Blocks.E);
    private static final SurfaceRules.o q = SurfaceRuleData.a(Blocks.C);
    private static final SurfaceRules.o r = SurfaceRuleData.a(Blocks.az);
    private static final SurfaceRules.o s = SurfaceRuleData.a(Blocks.hh);
    private static final SurfaceRules.o t = SurfaceRuleData.a(Blocks.cM);
    private static final SurfaceRules.o u = SurfaceRuleData.a(Blocks.oO);
    private static final SurfaceRules.o v = SurfaceRuleData.a(Blocks.cL);
    private static final SurfaceRules.o w = SurfaceRuleData.a(Blocks.A);
    private static final SurfaceRules.o x = SurfaceRuleData.a(Blocks.B);
    private static final SurfaceRules.o y = SurfaceRuleData.a(Blocks.cT);
    private static final SurfaceRules.o z = SurfaceRuleData.a(Blocks.cU);
    private static final SurfaceRules.o A = SurfaceRuleData.a(Blocks.cV);
    private static final SurfaceRules.o B = SurfaceRuleData.a(Blocks.cW);
    private static final SurfaceRules.o C = SurfaceRuleData.a(Blocks.nD);
    private static final SurfaceRules.o D = SurfaceRuleData.a(Blocks.mB);
    private static final SurfaceRules.o E = SurfaceRuleData.a(Blocks.mz);
    private static final SurfaceRules.o F = SurfaceRuleData.a(Blocks.iY);
    private static final SurfaceRules.o G = SurfaceRuleData.a(Blocks.mI);
    private static final SurfaceRules.o H = SurfaceRuleData.a(Blocks.eq);

    private static SurfaceRules.o a(Block block) {
        return SurfaceRules.a(block.n());
    }

    public static SurfaceRules.o a() {
        return SurfaceRuleData.a(true, false, true);
    }

    public static SurfaceRules.o a(boolean surface, boolean bedrockRoof, boolean bedrockFloor) {
        SurfaceRules.f conditionSource = SurfaceRules.a(VerticalAnchor.a(97), 2);
        SurfaceRules.f conditionSource2 = SurfaceRules.a(VerticalAnchor.a(256), 0);
        SurfaceRules.f conditionSource3 = SurfaceRules.b(VerticalAnchor.a(63), -1);
        SurfaceRules.f conditionSource4 = SurfaceRules.b(VerticalAnchor.a(74), 1);
        SurfaceRules.f conditionSource5 = SurfaceRules.a(VerticalAnchor.a(62), 0);
        SurfaceRules.f conditionSource6 = SurfaceRules.a(VerticalAnchor.a(63), 0);
        SurfaceRules.f conditionSource7 = SurfaceRules.a(-1, 0);
        SurfaceRules.f conditionSource8 = SurfaceRules.a(0, 0);
        SurfaceRules.f conditionSource9 = SurfaceRules.b(-6, -1);
        SurfaceRules.f conditionSource10 = SurfaceRules.b();
        SurfaceRules.f conditionSource11 = SurfaceRules.a(Biomes.U, Biomes.V);
        SurfaceRules.f conditionSource12 = SurfaceRules.a();
        SurfaceRules.o ruleSource = SurfaceRules.a(SurfaceRules.a(conditionSource8, n), j);
        SurfaceRules.o ruleSource2 = SurfaceRules.a(SurfaceRules.a(SurfaceRules.e, r), q);
        SurfaceRules.o ruleSource3 = SurfaceRules.a(SurfaceRules.a(SurfaceRules.e, h), p);
        SurfaceRules.f conditionSource13 = SurfaceRules.a(Biomes.N, Biomes.K, Biomes.L);
        SurfaceRules.f conditionSource14 = SurfaceRules.a(Biomes.f);
        SurfaceRules.o ruleSource4 = SurfaceRules.a(SurfaceRules.a(SurfaceRules.a(Biomes.H), SurfaceRules.a(SurfaceRules.a(SurfaceRules.a(Noises.X, -0.0125, 0.0125), o), h)), SurfaceRules.a(SurfaceRules.a(Biomes.M), SurfaceRules.a(SurfaceRules.a(SurfaceRules.a(Noises.Y, -0.05, 0.05), ruleSource3), h)), SurfaceRules.a(SurfaceRules.a(Biomes.s), SurfaceRules.a(SurfaceRuleData.a(1.0), h)), SurfaceRules.a(conditionSource13, ruleSource2), SurfaceRules.a(conditionSource14, ruleSource2), SurfaceRules.a(SurfaceRules.a(Biomes.X), h));
        SurfaceRules.o ruleSource5 = SurfaceRules.a(SurfaceRules.a(Noises.Z, 0.45, 0.58), SurfaceRules.a(conditionSource8, u));
        SurfaceRules.o ruleSource6 = SurfaceRules.a(SurfaceRules.a(Noises.Z, 0.35, 0.6), SurfaceRules.a(conditionSource8, u));
        SurfaceRules.o ruleSource7 = SurfaceRules.a(SurfaceRules.a(SurfaceRules.a(Biomes.F), SurfaceRules.a(SurfaceRules.a(conditionSource12, s), SurfaceRules.a(SurfaceRules.a(Noises.aa, -0.5, 0.2), s), SurfaceRules.a(SurfaceRules.a(Noises.ab, -0.0625, 0.025), v), SurfaceRules.a(conditionSource8, t))), SurfaceRules.a(SurfaceRules.a(Biomes.E), SurfaceRules.a(SurfaceRules.a(conditionSource12, h), ruleSource5, SurfaceRules.a(conditionSource8, t))), SurfaceRules.a(SurfaceRules.a(Biomes.G), h), SurfaceRules.a(SurfaceRules.a(Biomes.D), SurfaceRules.a(ruleSource5, j)), ruleSource4, SurfaceRules.a(SurfaceRules.a(Biomes.v), SurfaceRules.a(SurfaceRuleData.a(1.75), h)), SurfaceRules.a(SurfaceRules.a(Biomes.t), SurfaceRules.a(SurfaceRules.a(SurfaceRuleData.a(2.0), ruleSource3), SurfaceRules.a(SurfaceRuleData.a(1.0), h), SurfaceRules.a(SurfaceRuleData.a(-1.0), j), ruleSource3)), j);
        SurfaceRules.o ruleSource8 = SurfaceRules.a(SurfaceRules.a(SurfaceRules.a(Biomes.F), SurfaceRules.a(SurfaceRules.a(conditionSource12, s), SurfaceRules.a(SurfaceRules.a(Noises.aa, 0.0, 0.2), s), SurfaceRules.a(SurfaceRules.a(Noises.ab, 0.0, 0.025), v), SurfaceRules.a(conditionSource8, t))), SurfaceRules.a(SurfaceRules.a(Biomes.E), SurfaceRules.a(SurfaceRules.a(conditionSource12, h), ruleSource6, SurfaceRules.a(conditionSource8, t))), SurfaceRules.a(SurfaceRules.a(Biomes.G), SurfaceRules.a(SurfaceRules.a(conditionSource12, h), SurfaceRules.a(conditionSource8, t))), SurfaceRules.a(SurfaceRules.a(Biomes.D), SurfaceRules.a(ruleSource6, SurfaceRules.a(conditionSource8, t))), ruleSource4, SurfaceRules.a(SurfaceRules.a(Biomes.v), SurfaceRules.a(SurfaceRules.a(SurfaceRuleData.a(1.75), h), SurfaceRules.a(SurfaceRuleData.a(-0.5), l))), SurfaceRules.a(SurfaceRules.a(Biomes.t), SurfaceRules.a(SurfaceRules.a(SurfaceRuleData.a(2.0), ruleSource3), SurfaceRules.a(SurfaceRuleData.a(1.0), h), SurfaceRules.a(SurfaceRuleData.a(-1.0), ruleSource), ruleSource3)), SurfaceRules.a(SurfaceRules.a(Biomes.m, Biomes.n), SurfaceRules.a(SurfaceRules.a(SurfaceRuleData.a(1.75), l), SurfaceRules.a(SurfaceRuleData.a(-0.95), k))), SurfaceRules.a(SurfaceRules.a(Biomes.e), SurfaceRules.a(conditionSource8, t)), SurfaceRules.a(SurfaceRules.a(Biomes.W), m), ruleSource);
        SurfaceRules.f conditionSource15 = SurfaceRules.a(Noises.N, -0.909, -0.5454);
        SurfaceRules.f conditionSource16 = SurfaceRules.a(Noises.N, -0.1818, 0.1818);
        SurfaceRules.f conditionSource17 = SurfaceRules.a(Noises.N, 0.5454, 0.909);
        SurfaceRules.o ruleSource9 = SurfaceRules.a(SurfaceRules.a(SurfaceRules.a, SurfaceRules.a(SurfaceRules.a(SurfaceRules.a(Biomes.B), SurfaceRules.a(conditionSource, SurfaceRules.a(SurfaceRules.a(conditionSource15, l), SurfaceRules.a(conditionSource16, l), SurfaceRules.a(conditionSource17, l), ruleSource))), SurfaceRules.a(SurfaceRules.a(Biomes.g), SurfaceRules.a(conditionSource5, SurfaceRules.a(SurfaceRules.a(conditionSource6), SurfaceRules.a(SurfaceRules.a(Noises.W, 0.0), w)))))), SurfaceRules.a(SurfaceRules.a(Biomes.z, Biomes.A, Biomes.B), SurfaceRules.a(SurfaceRules.a(SurfaceRules.a, SurfaceRules.a(SurfaceRules.a(conditionSource2, d), SurfaceRules.a(conditionSource4, SurfaceRules.a(SurfaceRules.a(conditionSource15, e), SurfaceRules.a(conditionSource16, e), SurfaceRules.a(conditionSource17, e), SurfaceRules.e())), SurfaceRules.a(conditionSource7, SurfaceRules.a(SurfaceRules.a(SurfaceRules.e, g), f)), SurfaceRules.a(SurfaceRules.a(conditionSource10), d), SurfaceRules.a(conditionSource9, c), ruleSource3)), SurfaceRules.a(conditionSource3, SurfaceRules.a(SurfaceRules.a(conditionSource6, SurfaceRules.a(SurfaceRules.a(conditionSource4), d)), SurfaceRules.e())), SurfaceRules.a(SurfaceRules.b, SurfaceRules.a(conditionSource9, c)))), SurfaceRules.a(SurfaceRules.a, SurfaceRules.a(conditionSource7, SurfaceRules.a(SurfaceRules.a(conditionSource11, SurfaceRules.a(conditionSource10, SurfaceRules.a(SurfaceRules.a(conditionSource8, a), SurfaceRules.a(SurfaceRules.d(), v), w))), ruleSource8))), SurfaceRules.a(conditionSource9, SurfaceRules.a(SurfaceRules.a(SurfaceRules.a, SurfaceRules.a(conditionSource11, SurfaceRules.a(conditionSource10, w))), SurfaceRules.a(SurfaceRules.b, ruleSource7), SurfaceRules.a(conditionSource13, SurfaceRules.a(SurfaceRules.c, r)), SurfaceRules.a(conditionSource14, SurfaceRules.a(SurfaceRules.d, r)))), SurfaceRules.a(SurfaceRules.a, SurfaceRules.a(SurfaceRules.a(SurfaceRules.a(Biomes.F, Biomes.G), h), SurfaceRules.a(SurfaceRules.a(Biomes.N, Biomes.O, Biomes.P), ruleSource2), ruleSource3)));
        ImmutableList.Builder builder = ImmutableList.builder();
        if (bedrockRoof) {
            builder.add((Object)SurfaceRules.a(SurfaceRules.a(new PaperBedrockConditionSource("bedrock_roof", VerticalAnchor.c(5), VerticalAnchor.b(), true)), b));
        }
        if (bedrockFloor) {
            builder.add((Object)SurfaceRules.a(new PaperBedrockConditionSource("bedrock_floor", VerticalAnchor.a(), VerticalAnchor.b(5), false), b));
        }
        SurfaceRules.o ruleSource10 = SurfaceRules.a(SurfaceRules.c(), ruleSource9);
        builder.add((Object)(surface ? ruleSource10 : ruleSource9));
        builder.add((Object)SurfaceRules.a(SurfaceRules.a("deepslate", VerticalAnchor.a(0), VerticalAnchor.a(8)), i));
        return SurfaceRules.a((SurfaceRules.o[])builder.build().toArray(SurfaceRules.o[]::new));
    }

    public static SurfaceRules.o b() {
        SurfaceRules.f conditionSource = SurfaceRules.a(VerticalAnchor.a(31), 0);
        SurfaceRules.f conditionSource2 = SurfaceRules.a(VerticalAnchor.a(32), 0);
        SurfaceRules.f conditionSource3 = SurfaceRules.b(VerticalAnchor.a(30), 0);
        SurfaceRules.f conditionSource4 = SurfaceRules.a(SurfaceRules.b(VerticalAnchor.a(35), 0));
        SurfaceRules.f conditionSource5 = SurfaceRules.a(VerticalAnchor.c(5), 0);
        SurfaceRules.f conditionSource6 = SurfaceRules.b();
        SurfaceRules.f conditionSource7 = SurfaceRules.a(Noises.ac, -0.012);
        SurfaceRules.f conditionSource8 = SurfaceRules.a(Noises.ad, -0.012);
        SurfaceRules.f conditionSource9 = SurfaceRules.a(Noises.ae, -0.012);
        SurfaceRules.f conditionSource10 = SurfaceRules.a(Noises.af, 0.54);
        SurfaceRules.f conditionSource11 = SurfaceRules.a(Noises.ag, 1.17);
        SurfaceRules.f conditionSource12 = SurfaceRules.a(Noises.ah, 0.0);
        SurfaceRules.o ruleSource = SurfaceRules.a(conditionSource9, SurfaceRules.a(conditionSource3, SurfaceRules.a(conditionSource4, p)));
        return SurfaceRules.a(SurfaceRules.a(new PaperBedrockConditionSource("bedrock_floor", VerticalAnchor.a(), VerticalAnchor.b(5), false), b), SurfaceRules.a(SurfaceRules.a(new PaperBedrockConditionSource("bedrock_roof", VerticalAnchor.c(5), VerticalAnchor.b(), true)), b), SurfaceRules.a(conditionSource5, y), SurfaceRules.a(SurfaceRules.a(Biomes.ad), SurfaceRules.a(SurfaceRules.a(SurfaceRules.f, B), SurfaceRules.a(SurfaceRules.b, SurfaceRules.a(ruleSource, SurfaceRules.a(conditionSource12, B), C)))), SurfaceRules.a(SurfaceRules.a(Biomes.ac), SurfaceRules.a(SurfaceRules.a(SurfaceRules.f, SurfaceRules.a(SurfaceRules.a(conditionSource12, z), A)), SurfaceRules.a(SurfaceRules.b, SurfaceRules.a(ruleSource, SurfaceRules.a(conditionSource12, z), A)))), SurfaceRules.a(SurfaceRules.a, SurfaceRules.a(SurfaceRules.a(SurfaceRules.a(conditionSource2), SurfaceRules.a(conditionSource6, x)), SurfaceRules.a(SurfaceRules.a(Biomes.aa), SurfaceRules.a(SurfaceRules.a(conditionSource10), SurfaceRules.a(conditionSource, SurfaceRules.a(SurfaceRules.a(conditionSource11, D), E)))), SurfaceRules.a(SurfaceRules.a(Biomes.ab), SurfaceRules.a(SurfaceRules.a(conditionSource10), SurfaceRules.a(conditionSource, SurfaceRules.a(SurfaceRules.a(conditionSource11, F), G)))))), SurfaceRules.a(SurfaceRules.a(Biomes.Z), SurfaceRules.a(SurfaceRules.a(SurfaceRules.b, SurfaceRules.a(conditionSource7, SurfaceRules.a(SurfaceRules.a(SurfaceRules.a(conditionSource6), SurfaceRules.a(conditionSource3, SurfaceRules.a(conditionSource4, z))), y))), SurfaceRules.a(SurfaceRules.a, SurfaceRules.a(conditionSource, SurfaceRules.a(conditionSource4, SurfaceRules.a(conditionSource8, SurfaceRules.a(SurfaceRules.a(conditionSource2, p), SurfaceRules.a(SurfaceRules.a(conditionSource6), p)))))))), y);
    }

    public static SurfaceRules.o c() {
        return H;
    }

    private static SurfaceRules.f a(double min) {
        return SurfaceRules.a(Noises.N, min / 8.25, Double.MAX_VALUE);
    }

    public record PaperBedrockConditionSource(MinecraftKey randomName, VerticalAnchor trueAtAndBelow, VerticalAnchor falseAtAndAbove, boolean isRoof) implements SurfaceRules.f
    {
        public static final Codec<PaperBedrockConditionSource> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)MinecraftKey.a.fieldOf("random_name").forGetter(PaperBedrockConditionSource::randomName), (App)VerticalAnchor.a.fieldOf("true_at_and_below").forGetter(PaperBedrockConditionSource::trueAtAndBelow), (App)VerticalAnchor.a.fieldOf("false_at_and_above").forGetter(PaperBedrockConditionSource::falseAtAndAbove), (App)Codec.BOOL.fieldOf("roof").forGetter(PaperBedrockConditionSource::isRoof)).apply((Applicative)instance, PaperBedrockConditionSource::new));

        public PaperBedrockConditionSource(String randomName, VerticalAnchor trueAtAndBelow, VerticalAnchor falseAtAndAbove, boolean invert) {
            this(new MinecraftKey(randomName), trueAtAndBelow, falseAtAndAbove, invert);
        }

        @Override
        public Codec<? extends SurfaceRules.f> a() {
            return CODEC;
        }

        @Override
        public SurfaceRules.e apply(SurfaceRules.g context) {
            boolean hasFlatBedrock = context.m.getWorld().paperConfig.generateFlatBedrock;
            int trueAtY = this.trueAtAndBelow().a(context.m);
            int falseAtY = this.falseAtAndAbove().a(context.m);
            int y2 = this.isRoof ? Math.max(falseAtY, trueAtY) - 1 : Math.min(falseAtY, trueAtY);
            final int i2 = hasFlatBedrock ? y2 : trueAtY;
            final int j2 = hasFlatBedrock ? y2 : falseAtY;
            final PositionalRandomFactory positionalRandomFactory = context.e.a(this.randomName());
            class VerticalGradientCondition
            extends SurfaceRules.k {
                VerticalGradientCondition(SurfaceRules.g context) {
                    super(context);
                }

                @Override
                protected boolean a() {
                    int y2 = this.c.A;
                    if (y2 <= i2) {
                        return true;
                    }
                    if (y2 >= j2) {
                        return false;
                    }
                    double d2 = MathHelper.b((double)y2, (double)i2, (double)j2, 1.0, 0.0);
                    RandomSource randomSource = positionalRandomFactory.a(this.c.q, i2, this.c.r);
                    return (double)randomSource.nextFloat() < d2;
                }
            }
            return new VerticalGradientCondition(context);
        }
    }
}

