/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.tags;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.IRegistry;
import net.minecraft.data.DebugReportGenerator;
import net.minecraft.data.DebugReportProvider;
import net.minecraft.data.HashCache;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.Tag;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagRegistry;
import org.slf4j.Logger;

public abstract class TagsProvider<T>
implements DebugReportProvider {
    private static final Logger d = LogUtils.getLogger();
    private static final Gson e = new GsonBuilder().setPrettyPrinting().create();
    protected final DebugReportGenerator b;
    protected final IRegistry<T> c;
    private final Map<MinecraftKey, Tag.a> f = Maps.newLinkedHashMap();

    protected TagsProvider(DebugReportGenerator root, IRegistry<T> registry) {
        this.b = root;
        this.c = registry;
    }

    protected abstract void b();

    @Override
    @Override
    public void a(HashCache cache) {
        this.f.clear();
        this.b();
        this.f.forEach((id, builder) -> {
            List<Tag.b> list = builder.b().filter(tag -> !tag.a().a(this.c::c, this.f::containsKey)).toList();
            if (!list.isEmpty()) {
                throw new IllegalArgumentException(String.format("Couldn't define tag %s as it is missing following references: %s", id, list.stream().map(Objects::toString).collect(Collectors.joining(","))));
            }
            JsonObject jsonObject = builder.c();
            Path path = this.a((MinecraftKey)id);
            try {
                String string = e.toJson((JsonElement)jsonObject);
                String string2 = a.hashUnencodedChars((CharSequence)string).toString();
                if (!Objects.equals(cache.a(path), string2) || !Files.exists(path, new LinkOption[0])) {
                    Files.createDirectories(path.getParent(), new FileAttribute[0]);
                    try (BufferedWriter bufferedWriter = Files.newBufferedWriter(path, new OpenOption[0]);){
                        bufferedWriter.write(string);
                    }
                }
                cache.a(path, string2);
            }
            catch (IOException iOException) {
                d.error("Couldn't save tags to {}", (Object)path, (Object)iOException);
            }
        });
    }

    private Path a(MinecraftKey id) {
        ResourceKey<IRegistry<T>> resourceKey = this.c.m();
        return this.b.b().resolve("data/" + id.b() + "/" + TagRegistry.a(resourceKey) + "/" + id.a() + ".json");
    }

    protected a<T> a(TagKey<T> tag) {
        Tag.a builder = this.b(tag);
        return new a<T>(builder, this.c, "vanilla");
    }

    protected Tag.a b(TagKey<T> tag) {
        return this.f.computeIfAbsent(tag.b(), id -> new Tag.a());
    }

    protected static class a<T> {
        private final Tag.a a;
        private final IRegistry<T> b;
        private final String c;

        a(Tag.a builder, IRegistry<T> registry, String source) {
            this.a = builder;
            this.b = registry;
            this.c = source;
        }

        public a<T> a(T element) {
            this.a.a(this.b.b(element), this.c);
            return this;
        }

        @SafeVarargs
        public final a<T> a(ResourceKey<T> ... keys) {
            for (ResourceKey<T> resourceKey : keys) {
                this.a.a(resourceKey.a(), this.c);
            }
            return this;
        }

        public a<T> a(MinecraftKey id) {
            this.a.b(id, this.c);
            return this;
        }

        public a<T> a(TagKey<T> identifiedTag) {
            this.a.c(identifiedTag.b(), this.c);
            return this;
        }

        public a<T> b(MinecraftKey id) {
            this.a.d(id, this.c);
            return this;
        }

        @SafeVarargs
        public final a<T> a(T ... elements) {
            Stream.of(elements).map(this.b::b).forEach(id -> this.a.a((MinecraftKey)id, this.c));
            return this;
        }
    }
}

