/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.structures;

import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.data.DebugReportGenerator;
import net.minecraft.data.DebugReportProvider;
import net.minecraft.data.HashCache;
import net.minecraft.data.structures.DebugReportNBT;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTCompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;

public class SnbtToNbt
implements DebugReportProvider {
    @Nullable
    private static final Path b = null;
    private static final Logger c = LogUtils.getLogger();
    private final DebugReportGenerator d;
    private final List<a> e = Lists.newArrayList();

    public SnbtToNbt(DebugReportGenerator generator) {
        this.d = generator;
    }

    public SnbtToNbt a(a tweaker) {
        this.e.add(tweaker);
        return this;
    }

    private NBTTagCompound a(String key, NBTTagCompound compound) {
        NBTTagCompound compoundTag = compound;
        for (a filter : this.e) {
            compoundTag = filter.apply(key, compoundTag);
        }
        return compoundTag;
    }

    @Override
    @Override
    public void a(HashCache cache) throws IOException {
        Path path3 = this.d.b();
        ArrayList list = Lists.newArrayList();
        for (Path path22 : this.d.a()) {
            Files.walk(path22, new FileVisitOption[0]).filter(path -> path.toString().endsWith(".snbt")).forEach(path2 -> list.add(CompletableFuture.supplyAsync(() -> this.a((Path)path2, this.a(path22, (Path)path2)), SystemUtils.f())));
        }
        boolean bl = false;
        for (CompletableFuture completableFuture : list) {
            try {
                this.a(cache, (c)completableFuture.get(), path3);
            }
            catch (Exception exception) {
                c.error("Failed to process structure", (Throwable)exception);
                bl = true;
            }
        }
        if (bl) {
            throw new IllegalStateException("Failed to convert all structures, aborting");
        }
    }

    @Override
    @Override
    public String a() {
        return "SNBT -> NBT";
    }

    private String a(Path root, Path file) {
        String string = root.relativize(file).toString().replaceAll("\\\\", "/");
        return string.substring(0, string.length() - ".snbt".length());
    }

    private c a(Path path, String name) {
        c c2;
        block10: {
            BufferedReader bufferedReader = Files.newBufferedReader(path);
            try {
                String string4;
                String string = IOUtils.toString((Reader)bufferedReader);
                NBTTagCompound compoundTag = this.a(name, GameProfileSerializer.a(string));
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                NBTCompressedStreamTools.a(compoundTag, byteArrayOutputStream);
                byte[] bs = byteArrayOutputStream.toByteArray();
                String string2 = a.hashBytes(bs).toString();
                if (b != null) {
                    String string3 = GameProfileSerializer.d(compoundTag);
                } else {
                    string4 = null;
                }
                c2 = new c(name, bs, string4, string2);
                if (bufferedReader == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (bufferedReader != null) {
                        try {
                            bufferedReader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable throwable3) {
                    throw new b(path, throwable3);
                }
            }
            bufferedReader.close();
        }
        return c2;
    }

    private void a(HashCache cache, c data, Path root) {
        if (data.c != null) {
            Path path = b.resolve(data.a + ".snbt");
            try {
                DebugReportNBT.a(path, data.c);
            }
            catch (IOException iOException) {
                c.error("Couldn't write structure SNBT {} at {}", new Object[]{data.a, path, iOException});
            }
        }
        Path path2 = root.resolve(data.a + ".nbt");
        try {
            if (!Objects.equals(cache.a(path2), data.d) || !Files.exists(path2, new LinkOption[0])) {
                Files.createDirectories(path2.getParent(), new FileAttribute[0]);
                try (OutputStream outputStream = Files.newOutputStream(path2, new OpenOption[0]);){
                    outputStream.write(data.b);
                }
            }
            cache.a(path2, data.d);
        }
        catch (IOException iOException2) {
            c.error("Couldn't write structure {} at {}", new Object[]{data.a, path2, iOException2});
        }
    }

    @FunctionalInterface
    public static interface a {
        public NBTTagCompound apply(String var1, NBTTagCompound var2);
    }

    static class c {
        final String a;
        final byte[] b;
        @Nullable
        final String c;
        final String d;

        public c(String name, byte[] bytes, @Nullable String snbtContent, String sha1) {
            this.a = name;
            this.b = bytes;
            this.c = snbtContent;
            this.d = sha1;
        }
    }

    static class b
    extends RuntimeException {
        public b(Path path, Throwable cause) {
            super(path.toAbsolutePath().toString(), cause);
        }
    }
}

