/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.recipes;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionInstance;
import net.minecraft.advancements.critereon.CriterionTriggerRecipeUnlocked;
import net.minecraft.core.IRegistry;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.IMaterial;

public class ShapedRecipeBuilder
implements RecipeBuilder {
    private final Item a;
    private final int b;
    private final List<String> c = Lists.newArrayList();
    private final Map<Character, RecipeItemStack> d = Maps.newLinkedHashMap();
    private final Advancement.SerializedAdvancement e = Advancement.SerializedAdvancement.a();
    @Nullable
    private String f;

    public ShapedRecipeBuilder(IMaterial output, int outputCount) {
        this.a = output.l();
        this.b = outputCount;
    }

    public static ShapedRecipeBuilder b(IMaterial output) {
        return ShapedRecipeBuilder.a(output, 1);
    }

    public static ShapedRecipeBuilder a(IMaterial output, int outputCount) {
        return new ShapedRecipeBuilder(output, outputCount);
    }

    public ShapedRecipeBuilder a(Character c2, TagKey<Item> tag) {
        return this.a(c2, RecipeItemStack.a(tag));
    }

    public ShapedRecipeBuilder a(Character c2, IMaterial itemProvider) {
        return this.a(c2, RecipeItemStack.a(itemProvider));
    }

    public ShapedRecipeBuilder a(Character c2, RecipeItemStack ingredient) {
        if (this.d.containsKey(c2)) {
            throw new IllegalArgumentException("Symbol '" + c2 + "' is already defined!");
        }
        if (c2.charValue() == ' ') {
            throw new IllegalArgumentException("Symbol ' ' (whitespace) is reserved and cannot be defined");
        }
        this.d.put(c2, ingredient);
        return this;
    }

    public ShapedRecipeBuilder b(String patternStr) {
        if (!this.c.isEmpty() && patternStr.length() != this.c.get(0).length()) {
            throw new IllegalArgumentException("Pattern must be the same width on every line!");
        }
        this.c.add(patternStr);
        return this;
    }

    @Override
    public ShapedRecipeBuilder b(String string, CriterionInstance criterionTriggerInstance) {
        this.e.a(string, criterionTriggerInstance);
        return this;
    }

    @Override
    public ShapedRecipeBuilder c(@Nullable String string) {
        this.f = string;
        return this;
    }

    @Override
    @Override
    public Item a() {
        return this.a;
    }

    @Override
    @Override
    public void a(Consumer<FinishedRecipe> exporter, MinecraftKey recipeId) {
        this.a(recipeId);
        this.e.a(new MinecraftKey("recipes/root")).a("has_the_recipe", CriterionTriggerRecipeUnlocked.a(recipeId)).a(AdvancementRewards.a.c(recipeId)).a(AdvancementRequirements.b);
        exporter.accept(new a(recipeId, this.a, this.b, this.f == null ? "" : this.f, this.c, this.d, this.e, new MinecraftKey(recipeId.b(), "recipes/" + this.a.u().b() + "/" + recipeId.a())));
    }

    private void a(MinecraftKey recipeId) {
        if (this.c.isEmpty()) {
            throw new IllegalStateException("No pattern is defined for shaped recipe " + recipeId + "!");
        }
        HashSet set = Sets.newHashSet(this.d.keySet());
        set.remove(Character.valueOf(' '));
        for (String string : this.c) {
            for (int i2 = 0; i2 < string.length(); ++i2) {
                char c2 = string.charAt(i2);
                if (!this.d.containsKey(Character.valueOf(c2)) && c2 != ' ') {
                    throw new IllegalStateException("Pattern in recipe " + recipeId + " uses undefined symbol '" + c2 + "'");
                }
                set.remove(Character.valueOf(c2));
            }
        }
        if (!set.isEmpty()) {
            throw new IllegalStateException("Ingredients are defined but not used in pattern for recipe " + recipeId);
        }
        if (this.c.size() == 1 && this.c.get(0).length() == 1) {
            throw new IllegalStateException("Shaped recipe " + recipeId + " only takes in a single item - should it be a shapeless recipe instead?");
        }
        if (this.e.c().isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + recipeId);
        }
    }

    @Override
    public /* synthetic */ RecipeBuilder a(@Nullable String group) {
        return this.c(group);
    }

    @Override
    public /* synthetic */ RecipeBuilder a(String name, CriterionInstance conditions) {
        return this.b(name, conditions);
    }

    static class a
    implements FinishedRecipe {
        private final MinecraftKey a;
        private final Item b;
        private final int c;
        private final String d;
        private final List<String> e;
        private final Map<Character, RecipeItemStack> f;
        private final Advancement.SerializedAdvancement g;
        private final MinecraftKey h;

        public a(MinecraftKey recipeId, Item output, int resultCount, String group, List<String> pattern, Map<Character, RecipeItemStack> inputs, Advancement.SerializedAdvancement advancementBuilder, MinecraftKey advancementId) {
            this.a = recipeId;
            this.b = output;
            this.c = resultCount;
            this.d = group;
            this.e = pattern;
            this.f = inputs;
            this.g = advancementBuilder;
            this.h = advancementId;
        }

        @Override
        @Override
        public void a(JsonObject json) {
            if (!this.d.isEmpty()) {
                json.addProperty("group", this.d);
            }
            JsonArray jsonArray = new JsonArray();
            for (String string : this.e) {
                jsonArray.add(string);
            }
            json.add("pattern", (JsonElement)jsonArray);
            JsonObject jsonObject = new JsonObject();
            for (Map.Entry<Character, RecipeItemStack> entry : this.f.entrySet()) {
                jsonObject.add(String.valueOf(entry.getKey()), entry.getValue().c());
            }
            json.add("key", (JsonElement)jsonObject);
            JsonObject jsonObject2 = new JsonObject();
            jsonObject2.addProperty("item", IRegistry.X.b(this.b).toString());
            if (this.c > 1) {
                jsonObject2.addProperty("count", (Number)this.c);
            }
            json.add("result", (JsonElement)jsonObject2);
        }

        @Override
        @Override
        public RecipeSerializer<?> c() {
            return RecipeSerializer.a;
        }

        @Override
        @Override
        public MinecraftKey b() {
            return this.a;
        }

        @Override
        @Nullable
        @Override
        public JsonObject d() {
            return this.g.b();
        }

        @Override
        @Nullable
        @Override
        public MinecraftKey e() {
            return this.h;
        }
    }
}

