/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.models.model;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.data.models.model.ModelLocationUtils;
import net.minecraft.data.models.model.TextureMapping;
import net.minecraft.data.models.model.TextureSlot;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.level.block.Block;

public class ModelTemplate {
    private final Optional<MinecraftKey> a;
    private final Set<TextureSlot> b;
    private final Optional<String> c;

    public ModelTemplate(Optional<MinecraftKey> parent, Optional<String> variant, TextureSlot ... requiredTextureKeys) {
        this.a = parent;
        this.c = variant;
        this.b = ImmutableSet.copyOf((Object[])requiredTextureKeys);
    }

    public MinecraftKey a(Block block, TextureMapping textures, BiConsumer<MinecraftKey, Supplier<JsonElement>> modelCollector) {
        return this.a(ModelLocationUtils.a(block, this.c.orElse("")), textures, modelCollector);
    }

    public MinecraftKey a(Block block, String suffix, TextureMapping textures, BiConsumer<MinecraftKey, Supplier<JsonElement>> modelCollector) {
        return this.a(ModelLocationUtils.a(block, suffix + this.c.orElse("")), textures, modelCollector);
    }

    public MinecraftKey b(Block block, String suffix, TextureMapping textures, BiConsumer<MinecraftKey, Supplier<JsonElement>> modelCollector) {
        return this.a(ModelLocationUtils.a(block, suffix), textures, modelCollector);
    }

    public MinecraftKey a(MinecraftKey id, TextureMapping textures, BiConsumer<MinecraftKey, Supplier<JsonElement>> modelCollector) {
        Map<TextureSlot, MinecraftKey> map = this.a(textures);
        modelCollector.accept(id, () -> {
            JsonObject jsonObject = new JsonObject();
            this.a.ifPresent(parentId -> jsonObject.addProperty("parent", parentId.toString()));
            if (!map.isEmpty()) {
                JsonObject jsonObject2 = new JsonObject();
                map.forEach((textureKey, textureId) -> jsonObject2.addProperty(textureKey.a(), textureId.toString()));
                jsonObject.add("textures", (JsonElement)jsonObject2);
            }
            return jsonObject;
        });
        return id;
    }

    private Map<TextureSlot, MinecraftKey> a(TextureMapping textures) {
        return (Map)Streams.concat((Stream[])new Stream[]{this.b.stream(), textures.a()}).collect(ImmutableMap.toImmutableMap(Function.identity(), textures::a));
    }
}

