/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.models;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.logging.LogUtils;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.core.IRegistry;
import net.minecraft.data.DebugReportGenerator;
import net.minecraft.data.DebugReportProvider;
import net.minecraft.data.HashCache;
import net.minecraft.data.models.BlockModelGenerators;
import net.minecraft.data.models.ItemModelGenerators;
import net.minecraft.data.models.blockstates.BlockStateGenerator;
import net.minecraft.data.models.model.DelegatedModel;
import net.minecraft.data.models.model.ModelLocationUtils;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import org.slf4j.Logger;

public class ModelProvider
implements DebugReportProvider {
    private static final Logger b = LogUtils.getLogger();
    private static final Gson c = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private final DebugReportGenerator d;

    public ModelProvider(DebugReportGenerator generator) {
        this.d = generator;
    }

    @Override
    @Override
    public void a(HashCache cache) {
        Path path = this.d.b();
        HashMap map = Maps.newHashMap();
        Consumer<BlockStateGenerator> consumer = blockStateGenerator -> {
            Block block = blockStateGenerator.a();
            BlockStateGenerator blockStateGenerator2 = map.put(block, blockStateGenerator);
            if (blockStateGenerator2 != null) {
                throw new IllegalStateException("Duplicate blockstate definition for " + block);
            }
        };
        HashMap map2 = Maps.newHashMap();
        HashSet set = Sets.newHashSet();
        BiConsumer<MinecraftKey, Supplier<JsonElement>> biConsumer = (resourceLocation, supplier) -> {
            Supplier supplier2 = map2.put(resourceLocation, supplier);
            if (supplier2 != null) {
                throw new IllegalStateException("Duplicate model definition for " + resourceLocation);
            }
        };
        Consumer<Item> consumer2 = set::add;
        new BlockModelGenerators(consumer, biConsumer, consumer2).a();
        new ItemModelGenerators(biConsumer).a();
        List list = IRegistry.U.q().filter(block -> !map.containsKey(block)).collect(Collectors.toList());
        if (!list.isEmpty()) {
            throw new IllegalStateException("Missing blockstate definitions for: " + list);
        }
        IRegistry.U.forEach(block -> {
            Item item = Item.k.get(block);
            if (item != null) {
                if (set.contains(item)) {
                    return;
                }
                MinecraftKey resourceLocation = ModelLocationUtils.a(item);
                if (!map2.containsKey(resourceLocation)) {
                    map2.put(resourceLocation, new DelegatedModel(ModelLocationUtils.a(block)));
                }
            }
        });
        this.a(cache, path, map, ModelProvider::a);
        this.a(cache, path, map2, ModelProvider::a);
    }

    private <T> void a(HashCache cache, Path root, Map<T, ? extends Supplier<JsonElement>> jsons, BiFunction<Path, T, Path> locator) {
        jsons.forEach((object, supplier) -> {
            Path path2 = (Path)locator.apply(root, object);
            try {
                DebugReportProvider.a(c, cache, (JsonElement)supplier.get(), path2);
            }
            catch (Exception exception) {
                b.error("Couldn't save {}", (Object)path2, (Object)exception);
            }
        });
    }

    private static Path a(Path root, Block block) {
        MinecraftKey resourceLocation = IRegistry.U.b(block);
        return root.resolve("assets/" + resourceLocation.b() + "/blockstates/" + resourceLocation.a() + ".json");
    }

    private static Path a(Path root, MinecraftKey id) {
        return root.resolve("assets/" + id.b() + "/models/" + id.a() + ".json");
    }

    @Override
    @Override
    public String a() {
        return "Block State Definitions";
    }
}

