/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.loot;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.data.DebugReportGenerator;
import net.minecraft.data.DebugReportProvider;
import net.minecraft.data.HashCache;
import net.minecraft.data.loot.BlockLoot;
import net.minecraft.data.loot.ChestLoot;
import net.minecraft.data.loot.EntityLoot;
import net.minecraft.data.loot.FishingLoot;
import net.minecraft.data.loot.GiftLoot;
import net.minecraft.data.loot.PiglinBarterLoot;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.level.storage.loot.LootCollector;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTableRegistry;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import org.slf4j.Logger;

public class LootTableProvider
implements DebugReportProvider {
    private static final Logger b = LogUtils.getLogger();
    private static final Gson c = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private final DebugReportGenerator d;
    private final List<Pair<Supplier<Consumer<BiConsumer<MinecraftKey, LootTable.a>>>, LootContextParameterSet>> e = ImmutableList.of((Object)Pair.of(FishingLoot::new, (Object)LootContextParameterSets.e), (Object)Pair.of(ChestLoot::new, (Object)LootContextParameterSets.b), (Object)Pair.of(EntityLoot::new, (Object)LootContextParameterSets.f), (Object)Pair.of(BlockLoot::new, (Object)LootContextParameterSets.l), (Object)Pair.of(PiglinBarterLoot::new, (Object)LootContextParameterSets.h), (Object)Pair.of(GiftLoot::new, (Object)LootContextParameterSets.g));

    public LootTableProvider(DebugReportGenerator root) {
        this.d = root;
    }

    @Override
    @Override
    public void a(HashCache cache) {
        Path path = this.d.b();
        HashMap map = Maps.newHashMap();
        this.e.forEach(generator -> ((Consumer)((Supplier)generator.getFirst()).get()).accept((id, builder) -> {
            if (map.put(id, builder.a((LootContextParameterSet)generator.getSecond()).b()) != null) {
                throw new IllegalStateException("Duplicate loot table " + id);
            }
        }));
        LootCollector validationContext = new LootCollector(LootContextParameterSets.k, id -> null, map::get);
        Sets.SetView set = Sets.difference(LootTables.a(), map.keySet());
        for (MinecraftKey resourceLocation : set) {
            validationContext.a("Missing built-in table: " + resourceLocation);
        }
        map.forEach((id, table) -> LootTableRegistry.a(validationContext, id, table));
        Multimap<String, String> multimap = validationContext.a();
        if (!multimap.isEmpty()) {
            multimap.forEach((name, message) -> b.warn("Found validation problem in {}: {}", name, message));
            throw new IllegalStateException("Failed to validate loot tables, see logs");
        }
        map.forEach((id, table) -> {
            Path path2 = LootTableProvider.a(path, id);
            try {
                DebugReportProvider.a(c, cache, LootTableRegistry.a(table), path2);
            }
            catch (IOException iOException) {
                b.error("Couldn't save loot table {}", (Object)path2, (Object)iOException);
            }
        });
    }

    private static Path a(Path rootOutput, MinecraftKey lootTableId) {
        return rootOutput.resolve("data/" + lootTableId.b() + "/loot_tables/" + lootTableId.a() + ".json");
    }

    @Override
    @Override
    public String a() {
        return "LootTables";
    }
}

