/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data;

import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Lifecycle;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.IRegistryWritable;
import net.minecraft.core.RegistryMaterials;
import net.minecraft.data.worldgen.NoiseData;
import net.minecraft.data.worldgen.ProcessorLists;
import net.minecraft.data.worldgen.StructureFeatures;
import net.minecraft.data.worldgen.StructureSets;
import net.minecraft.data.worldgen.WorldGenCarvers;
import net.minecraft.data.worldgen.WorldGenFeaturePieces;
import net.minecraft.data.worldgen.biome.BiomeRegistry;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.GeneratorSettingBase;
import net.minecraft.world.level.levelgen.NoiseRouterData;
import net.minecraft.world.level.levelgen.carver.WorldGenCarverWrapper;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureConfigured;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePoolTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.ProcessorList;
import net.minecraft.world.level.levelgen.synth.NoiseGeneratorNormal;
import org.slf4j.Logger;

public class RegistryGeneration {
    private static final Logger n = LogUtils.getLogger();
    private static final Map<MinecraftKey, Supplier<? extends Holder<?>>> o = Maps.newLinkedHashMap();
    private static final IRegistryWritable<IRegistryWritable<?>> p = new RegistryMaterials(ResourceKey.a(new MinecraftKey("root")), Lifecycle.experimental(), null);
    public static final IRegistry<? extends IRegistry<?>> a = p;
    public static final IRegistry<WorldGenCarverWrapper<?>> b = RegistryGeneration.a(IRegistry.aI, () -> WorldGenCarvers.a);
    public static final IRegistry<WorldGenFeatureConfigured<?, ?>> c = RegistryGeneration.a(IRegistry.aJ, FeatureUtils::a);
    public static final IRegistry<PlacedFeature> d = RegistryGeneration.a(IRegistry.aK, PlacementUtils::a);
    public static final IRegistry<StructureFeature<?, ?>> e = RegistryGeneration.a(IRegistry.aL, StructureFeatures::a);
    public static final IRegistry<StructureSet> f = RegistryGeneration.a(IRegistry.aM, StructureSets::a);
    public static final IRegistry<ProcessorList> g = RegistryGeneration.a(IRegistry.aN, () -> ProcessorLists.b);
    public static final IRegistry<WorldGenFeatureDefinedStructurePoolTemplate> h = RegistryGeneration.a(IRegistry.aO, WorldGenFeaturePieces::a);
    public static final IRegistry<BiomeBase> i = RegistryGeneration.a(IRegistry.aP, BiomeRegistry::a);
    public static final IRegistry<NoiseGeneratorNormal.a> j = RegistryGeneration.a(IRegistry.aQ, NoiseData::a);
    public static final IRegistry<DensityFunction> k = RegistryGeneration.a(IRegistry.aR, NoiseRouterData::a);
    public static final IRegistry<GeneratorSettingBase> l = RegistryGeneration.a(IRegistry.aH, GeneratorSettingBase::e);
    public static final IRegistryCustom m;

    private static <T> IRegistry<T> a(ResourceKey<? extends IRegistry<T>> registryRef, Supplier<? extends Holder<? extends T>> defaultValueSupplier) {
        return RegistryGeneration.a(registryRef, Lifecycle.stable(), defaultValueSupplier);
    }

    private static <T> IRegistry<T> a(ResourceKey<? extends IRegistry<T>> registryRef, Lifecycle lifecycle, Supplier<? extends Holder<? extends T>> defaultValueSupplier) {
        return RegistryGeneration.a(registryRef, new RegistryMaterials(registryRef, lifecycle, null), defaultValueSupplier, lifecycle);
    }

    private static <T, R extends IRegistryWritable<T>> R a(ResourceKey<? extends IRegistry<T>> registryRef, R registry, Supplier<? extends Holder<? extends T>> defaultValueSupplier, Lifecycle lifecycle) {
        MinecraftKey resourceLocation = registryRef.a();
        o.put(resourceLocation, defaultValueSupplier);
        p.a(registryRef, registry, lifecycle);
        return registry;
    }

    public static <V extends T, T> Holder<V> a(IRegistry<T> registry, String id, V value) {
        Holder<T> holder = RegistryGeneration.a(registry, new MinecraftKey(id), value);
        return holder;
    }

    public static <T> Holder<T> b(IRegistry<T> registry, String id, T object) {
        return RegistryGeneration.a(registry, new MinecraftKey(id), object);
    }

    public static <T> Holder<T> a(IRegistry<T> registry, MinecraftKey id, T object) {
        return RegistryGeneration.a(registry, ResourceKey.a(registry.m(), id), object);
    }

    public static <T> Holder<T> a(IRegistry<T> registry, ResourceKey<T> key, T object) {
        return ((IRegistryWritable)registry).a(key, object, Lifecycle.stable());
    }

    public static void a() {
    }

    static {
        o.forEach((id, supplier) -> {
            if (!((Holder)supplier.get()).b()) {
                n.error("Unable to bootstrap registry '{}'", id);
            }
        });
        IRegistry.a(p);
        m = IRegistryCustom.a(a);
    }
}

