/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.minecraft.data.DebugReportProvider;
import net.minecraft.data.HashCache;
import net.minecraft.server.DispenserRegistry;
import org.slf4j.Logger;

public class DebugReportGenerator {
    private static final Logger a = LogUtils.getLogger();
    private final Collection<Path> b;
    private final Path c;
    private final List<DebugReportProvider> d = Lists.newArrayList();

    public DebugReportGenerator(Path output, Collection<Path> inputs) {
        this.c = output;
        this.b = inputs;
    }

    public Collection<Path> a() {
        return this.b;
    }

    public Path b() {
        return this.c;
    }

    public void c() throws IOException {
        HashCache hashCache = new HashCache(this.c, "cache");
        hashCache.c(this.b().resolve("version.json"));
        Stopwatch stopwatch = Stopwatch.createStarted();
        Stopwatch stopwatch2 = Stopwatch.createUnstarted();
        for (DebugReportProvider dataProvider : this.d) {
            a.info("Starting provider: {}", (Object)dataProvider.a());
            stopwatch2.start();
            dataProvider.a(hashCache);
            stopwatch2.stop();
            a.info("{} finished after {} ms", (Object)dataProvider.a(), (Object)stopwatch2.elapsed(TimeUnit.MILLISECONDS));
            stopwatch2.reset();
        }
        a.info("All providers took: {} ms", (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
        hashCache.a();
    }

    public void a(DebugReportProvider provider) {
        this.d.add(provider);
    }

    static {
        DispenserRegistry.a();
    }
}

