/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Lifecycle;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryWritable;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;

public class RegistryMaterials<T>
extends IRegistryWritable<T> {
    private static final Logger bC = LogUtils.getLogger();
    private final ObjectList<Holder.c<T>> bD = new ObjectArrayList(256);
    private final Reference2IntOpenHashMap<T> bE = new Reference2IntOpenHashMap(2048);
    private final Map<MinecraftKey, Holder.c<T>> bF = new HashMap<MinecraftKey, Holder.c<T>>(2048);
    private final Map<ResourceKey<T>, Holder.c<T>> bG = new HashMap<ResourceKey<T>, Holder.c<T>>(2048);
    private final Map<T, Holder.c<T>> bH = new IdentityHashMap<T, Holder.c<T>>(2048);
    private final Map<T, Lifecycle> bI = new IdentityHashMap<T, Lifecycle>(2048);
    private Lifecycle bJ;
    private volatile Map<TagKey<T>, HolderSet.Named<T>> bK = new IdentityHashMap<TagKey<T>, HolderSet.Named<T>>();
    private boolean bL;
    @Nullable
    private final Function<T, Holder.c<T>> bM;
    @Nullable
    private Map<T, Holder.c<T>> bN;
    @Nullable
    private List<Holder.c<T>> bO;
    private int bP;

    public RegistryMaterials(ResourceKey<? extends IRegistry<T>> key, Lifecycle lifecycle, @Nullable Function<T, Holder.c<T>> valueToEntryFunction) {
        super(key, lifecycle);
        this.bJ = lifecycle;
        this.bM = valueToEntryFunction;
        if (valueToEntryFunction != null) {
            this.bN = new IdentityHashMap<T, Holder.c<T>>();
        }
        this.bE.defaultReturnValue(-1);
    }

    private List<Holder.c<T>> a() {
        if (this.bO == null) {
            this.bO = this.bD.stream().filter(Objects::nonNull).toList();
        }
        return this.bO;
    }

    private void h(ResourceKey<T> key) {
        if (this.bL) {
            throw new IllegalStateException("Registry is already frozen (trying to add key " + key + ")");
        }
    }

    @Override
    public Holder<T> a(int rawId, ResourceKey<T> key, T value, Lifecycle lifecycle) {
        return this.a(rawId, key, value, lifecycle, true);
    }

    private Holder<T> a(int rawId, ResourceKey<T> key, T value, Lifecycle lifecycle, boolean checkDuplicateKeys) {
        Holder.c reference;
        this.h(key);
        Validate.notNull(key);
        Validate.notNull(value);
        this.bD.size(Math.max(this.bD.size(), rawId + 1));
        this.bE.put(value, rawId);
        this.bO = null;
        if (checkDuplicateKeys && this.bG.containsKey(key)) {
            SystemUtils.a("Adding duplicate key '" + key + "' to registry");
        }
        if (this.bH.containsKey(value)) {
            SystemUtils.a("Adding duplicate value '" + value + "' to registry");
        }
        this.bI.put(value, lifecycle);
        this.bJ = this.bJ.add(lifecycle);
        if (this.bP <= rawId) {
            this.bP = rawId + 1;
        }
        if (this.bM != null) {
            reference = this.bM.apply(value);
            Holder.c reference2 = this.bG.put(key, reference);
            if (reference2 != null && reference2 != reference) {
                throw new IllegalStateException("Invalid holder present for key " + key);
            }
        } else {
            reference = this.bG.computeIfAbsent(key, keyx -> Holder.c.a(this, keyx));
        }
        this.bF.put(key.a(), reference);
        this.bH.put(value, reference);
        reference.a(key, value);
        this.bD.set(rawId, (Object)reference);
        return reference;
    }

    @Override
    public Holder<T> a(ResourceKey<T> key, T entry, Lifecycle lifecycle) {
        return this.a(this.bP, key, entry, lifecycle);
    }

    @Override
    public Holder<T> a(OptionalInt rawId, ResourceKey<T> key, T newEntry, Lifecycle lifecycle) {
        int i2;
        Object object;
        this.h(key);
        Validate.notNull(key);
        Validate.notNull(newEntry);
        Holder holder = this.bG.get(key);
        Object v0 = object = holder != null && holder.b() ? holder.a() : null;
        if (object == null) {
            i2 = rawId.orElse(this.bP);
        } else {
            i2 = this.bE.getInt(object);
            if (rawId.isPresent() && rawId.getAsInt() != i2) {
                throw new IllegalStateException("ID mismatch");
            }
            this.bI.remove(object);
            this.bE.removeInt(object);
            this.bH.remove(object);
        }
        return this.a(i2, key, newEntry, lifecycle, false);
    }

    @Override
    @Nullable
    public MinecraftKey b(T value) {
        Holder.c<T> reference = this.bH.get(value);
        return reference != null ? reference.g().a() : null;
    }

    @Override
    public Optional<ResourceKey<T>> c(T entry) {
        return Optional.ofNullable(this.bH.get(entry)).map(Holder.c::g);
    }

    @Override
    public int a(@Nullable T value) {
        return this.bE.getInt(value);
    }

    @Override
    @Nullable
    public T a(@Nullable ResourceKey<T> key) {
        return RegistryMaterials.a(this.bG.get(key));
    }

    @Override
    @Nullable
    public T a(int index) {
        return index >= 0 && index < this.bD.size() ? (T)RegistryMaterials.a((Holder.c)this.bD.get(index)) : null;
    }

    @Override
    public Optional<Holder<T>> c(int rawId) {
        return rawId >= 0 && rawId < this.bD.size() ? Optional.ofNullable((Holder)this.bD.get(rawId)) : Optional.empty();
    }

    @Override
    public Optional<Holder<T>> b(ResourceKey<T> key) {
        return Optional.ofNullable((Holder)this.bG.get(key));
    }

    @Override
    public Holder<T> c(ResourceKey<T> key) {
        return this.bG.computeIfAbsent(key, keyx -> {
            if (this.bM != null) {
                throw new IllegalStateException("This registry can't create new holders without value");
            }
            this.h((ResourceKey<T>)keyx);
            return Holder.c.a(this, keyx);
        });
    }

    @Override
    public int b() {
        return this.bG.size();
    }

    @Override
    public Lifecycle d(T entry) {
        return this.bI.get(entry);
    }

    @Override
    public Lifecycle c() {
        return this.bJ;
    }

    @Override
    public Iterator<T> iterator() {
        return Iterators.transform(this.a().iterator(), Holder::a);
    }

    @Override
    @Nullable
    public T a(@Nullable MinecraftKey id) {
        Holder.c<T> reference = this.bF.get(id);
        return RegistryMaterials.a(reference);
    }

    @Nullable
    private static <T> T a(@Nullable Holder.c<T> entry) {
        return entry != null ? (T)entry.a() : null;
    }

    @Override
    public Set<MinecraftKey> d() {
        return Collections.unmodifiableSet(this.bF.keySet());
    }

    @Override
    public Set<Map.Entry<ResourceKey<T>, T>> e() {
        return Collections.unmodifiableSet(Maps.transformValues(this.bG, Holder::a).entrySet());
    }

    @Override
    public Stream<Holder.c<T>> f() {
        return this.a().stream();
    }

    @Override
    public boolean a(TagKey<T> tag) {
        return this.bK.containsKey(tag);
    }

    @Override
    public Stream<Pair<TagKey<T>, HolderSet.Named<T>>> g() {
        return this.bK.entrySet().stream().map(entry -> Pair.of((Object)((TagKey)entry.getKey()), (Object)((HolderSet.Named)entry.getValue())));
    }

    @Override
    public HolderSet.Named<T> b(TagKey<T> tag) {
        HolderSet.Named<T> named = this.bK.get(tag);
        if (named == null) {
            named = this.e(tag);
            IdentityHashMap<TagKey<T>, HolderSet.Named<T>> map = new IdentityHashMap<TagKey<T>, HolderSet.Named<T>>(this.bK);
            map.put(tag, named);
            this.bK = map;
        }
        return named;
    }

    @Override
    private HolderSet.Named<T> e(TagKey<T> tag) {
        return new HolderSet.Named<T>(this, tag);
    }

    @Override
    public Stream<TagKey<T>> h() {
        return this.bK.keySet().stream();
    }

    @Override
    public boolean i() {
        return this.bG.isEmpty();
    }

    @Override
    public Optional<Holder<T>> a(Random random) {
        return SystemUtils.b(this.a(), random).map(Holder::a);
    }

    @Override
    public boolean c(MinecraftKey id) {
        return this.bF.containsKey(id);
    }

    @Override
    public boolean d(ResourceKey<T> key) {
        return this.bG.containsKey(key);
    }

    @Override
    public IRegistry<T> j() {
        this.bL = true;
        List<MinecraftKey> list = this.bG.entrySet().stream().filter(entry -> !((Holder.c)entry.getValue()).b()).map(entry -> ((ResourceKey)entry.getKey()).a()).sorted().toList();
        if (!list.isEmpty()) {
            throw new IllegalStateException("Unbound values in registry " + this.m() + ": " + list);
        }
        if (this.bN != null) {
            List<Holder.c> list2 = this.bN.values().stream().filter(entry -> !entry.b()).toList();
            if (!list2.isEmpty()) {
                throw new IllegalStateException("Some intrusive holders were not added to registry: " + list2);
            }
            this.bN = null;
        }
        return this;
    }

    @Override
    public Holder.c<T> e(T value) {
        if (this.bM == null) {
            throw new IllegalStateException("This registry can't create intrusive holders");
        }
        if (!this.bL && this.bN != null) {
            return this.bN.computeIfAbsent(value, key -> Holder.c.a(this, key));
        }
        throw new IllegalStateException("Registry is already frozen");
    }

    @Override
    public Optional<HolderSet.Named<T>> c(TagKey<T> tag) {
        return Optional.ofNullable(this.bK.get(tag));
    }

    @Override
    public void a(Map<TagKey<T>, List<Holder<T>>> tagEntries) {
        IdentityHashMap<Holder.c, List> map = new IdentityHashMap<Holder.c, List>();
        this.bG.values().forEach(entry -> map.put((Holder.c)entry, new ArrayList()));
        tagEntries.forEach((? super K tag, ? super V entries) -> {
            for (Holder holder : entries) {
                if (!holder.a(this)) {
                    throw new IllegalStateException("Can't create named set " + tag + " containing value " + holder + " from outside registry " + this);
                }
                if (!(holder instanceof Holder.c)) {
                    throw new IllegalStateException("Found direct holder " + holder + " value in tag " + tag);
                }
                Holder.c reference = (Holder.c)holder;
                ((List)map.get(reference)).add(tag);
            }
        });
        Sets.SetView set = Sets.difference(this.bK.keySet(), tagEntries.keySet());
        if (!set.isEmpty()) {
            bC.warn("Not all defined tags for registry {} are present in data pack: {}", this.m(), (Object)set.stream().map(tag -> tag.b().toString()).sorted().collect(Collectors.joining(", ")));
        }
        IdentityHashMap<TagKey<T>, HolderSet.Named<T>> map2 = new IdentityHashMap<TagKey<T>, HolderSet.Named<T>>(this.bK);
        tagEntries.forEach((? super K tag, ? super V entries) -> map2.computeIfAbsent((TagKey<T>)tag, this::e).b(entries));
        map.forEach(Holder.c::a);
        this.bK = map2;
    }

    @Override
    public void k() {
        this.bK.values().forEach(entryList -> entryList.b(List.of()));
        this.bG.values().forEach(entry -> entry.a(Set.of()));
    }
}

