/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Map;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryWritable;
import net.minecraft.core.RegistryMaterials;
import net.minecraft.resources.HolderSetCodec;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.resources.RegistryFixedCodec;
import net.minecraft.resources.RegistryLoader;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;

public class RegistryCodecs {
    private static <T> MapCodec<a<T>> a(ResourceKey<? extends IRegistry<T>> registryRef, MapCodec<T> elementCodec) {
        return RecordCodecBuilder.mapCodec(instance -> instance.group((App)MinecraftKey.a.xmap(ResourceKey.d(registryRef), ResourceKey::a).fieldOf("name").forGetter(a::a), (App)Codec.INT.fieldOf("id").forGetter(a::b), (App)elementCodec.forGetter(a::c)).apply((Applicative)instance, a::new));
    }

    public static <T> Codec<IRegistry<T>> a(ResourceKey<? extends IRegistry<T>> registryRef, Lifecycle lifecycle, Codec<T> elementCodec) {
        return RegistryCodecs.a(registryRef, elementCodec.fieldOf("element")).codec().listOf().xmap(entries -> {
            RegistryMaterials writableRegistry = new RegistryMaterials(registryRef, lifecycle, null);
            for (a registryEntry : entries) {
                ((IRegistryWritable)writableRegistry).a(registryEntry.b(), registryEntry.a(), registryEntry.c(), lifecycle);
            }
            return writableRegistry;
        }, registry -> {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (Object object : registry) {
                builder.add(new a(registry.c(object).get(), registry.a(object), object));
            }
            return builder.build();
        });
    }

    public static <E> Codec<IRegistry<E>> b(ResourceKey<? extends IRegistry<E>> registryRef, Lifecycle lifecycle, Codec<E> elementCodec) {
        Codec<Map<ResourceKey<E>, E>> codec = RegistryCodecs.b(registryRef, elementCodec);
        Encoder encoder = codec.comap(registry -> ImmutableMap.copyOf(registry.e()));
        return Codec.of((Encoder)encoder, RegistryCodecs.a(registryRef, elementCodec, codec, lifecycle), (String)("DataPackRegistryCodec for " + registryRef));
    }

    private static <E> Decoder<IRegistry<E>> a(final ResourceKey<? extends IRegistry<E>> registryRef, final Codec<E> codec, Decoder<Map<ResourceKey<E>, E>> entryMapDecoder, Lifecycle lifecycle) {
        final Decoder decoder = entryMapDecoder.map(map -> {
            RegistryMaterials writableRegistry = new RegistryMaterials(registryRef, lifecycle, null);
            map.forEach((key, value) -> writableRegistry.a(key, value, lifecycle));
            return writableRegistry;
        });
        return new Decoder<IRegistry<E>>(){

            public <T> DataResult<Pair<IRegistry<E>, T>> decode(DynamicOps<T> dynamicOps, T object) {
                DataResult dataResult = decoder.decode(dynamicOps, object);
                if (dynamicOps instanceof RegistryOps) {
                    RegistryOps registryOps = (RegistryOps)dynamicOps;
                    return registryOps.a().map(loaderAccess -> this.a(dataResult, registryOps, loaderAccess.b())).orElseGet(() -> DataResult.error((String)"Can't load registry with this ops"));
                }
                return dataResult.map(pair -> pair.mapFirst(registry -> registry));
            }

            private <T> DataResult<Pair<IRegistry<E>, T>> a(DataResult<Pair<IRegistryWritable<E>, T>> result, RegistryOps<?> ops, RegistryLoader loader) {
                return result.flatMap(pair -> loader.a((IRegistryWritable)pair.getFirst(), registryRef, codec, ops.b()).map(registry -> Pair.of((Object)registry, (Object)pair.getSecond())));
            }
        };
    }

    private static <T> Codec<Map<ResourceKey<T>, T>> b(ResourceKey<? extends IRegistry<T>> registryRef, Codec<T> elementCodec) {
        return Codec.unboundedMap((Codec)MinecraftKey.a.xmap(ResourceKey.d(registryRef), ResourceKey::a), elementCodec);
    }

    public static <E> Codec<HolderSet<E>> a(ResourceKey<? extends IRegistry<E>> registryRef, Codec<E> elementCodec) {
        return RegistryCodecs.a(registryRef, elementCodec, false);
    }

    public static <E> Codec<HolderSet<E>> a(ResourceKey<? extends IRegistry<E>> registryRef, Codec<E> elementCodec, boolean alwaysSerializeAsList) {
        return HolderSetCodec.a(registryRef, RegistryFileCodec.a(registryRef, elementCodec), alwaysSerializeAsList);
    }

    public static <E> Codec<HolderSet<E>> a(ResourceKey<? extends IRegistry<E>> registryRef) {
        return RegistryCodecs.a(registryRef, false);
    }

    public static <E> Codec<HolderSet<E>> a(ResourceKey<? extends IRegistry<E>> registryRef, boolean alwaysSerializeAsList) {
        return HolderSetCodec.a(registryRef, RegistryFixedCodec.a(registryRef), alwaysSerializeAsList);
    }

    record a<T>(ResourceKey<T> a, int b, T c) {
        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "key;id;value", "a", "b", "c"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "key;id;value", "a", "b", "c"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "key;id;value", "a", "b", "c"}, this, object);
        }
    }
}

