/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.codecs.UnboundedMapCodec;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryWritable;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.RegistryMaterials;
import net.minecraft.data.RegistryGeneration;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.RegistryLoader;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.RegistryResourceAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.GeneratorSettingBase;
import net.minecraft.world.level.levelgen.carver.WorldGenCarverWrapper;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureConfigured;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePoolTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureStructureProcessorType;
import net.minecraft.world.level.levelgen.synth.NoiseGeneratorNormal;
import org.slf4j.Logger;

public interface IRegistryCustom {
    public static final Logger a = LogUtils.getLogger();
    public static final Map<ResourceKey<? extends IRegistry<?>>, RegistryData<?>> b = (Map)SystemUtils.a(() -> {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        IRegistryCustom.a(builder, IRegistry.N, DimensionManager.k, DimensionManager.k);
        IRegistryCustom.a(builder, IRegistry.aP, BiomeBase.a, BiomeBase.b);
        IRegistryCustom.a(builder, IRegistry.aI, WorldGenCarverWrapper.a);
        IRegistryCustom.a(builder, IRegistry.aJ, WorldGenFeatureConfigured.a);
        IRegistryCustom.a(builder, IRegistry.aK, PlacedFeature.a);
        IRegistryCustom.a(builder, IRegistry.aL, StructureFeature.a);
        IRegistryCustom.a(builder, IRegistry.aM, StructureSet.a);
        IRegistryCustom.a(builder, IRegistry.aN, DefinedStructureStructureProcessorType.m);
        IRegistryCustom.a(builder, IRegistry.aO, WorldGenFeatureDefinedStructurePoolTemplate.a);
        IRegistryCustom.a(builder, IRegistry.aH, GeneratorSettingBase.a);
        IRegistryCustom.a(builder, IRegistry.aQ, NoiseGeneratorNormal.a.a);
        IRegistryCustom.a(builder, IRegistry.aR, DensityFunction.b);
        return builder.build();
    });
    public static final Codec<IRegistryCustom> c = IRegistryCustom.i();
    public static final Supplier<Dimension> d = Suppliers.memoize(() -> IRegistryCustom.e().f());

    public <E> Optional<IRegistry<E>> a(ResourceKey<? extends IRegistry<? extends E>> var1);

    default public <E> IRegistry<E> b(ResourceKey<? extends IRegistry<? extends E>> key) {
        return this.a(key).orElseThrow(() -> new IllegalStateException("Missing registry: " + key));
    }

    default public <E> Optional<? extends IRegistry<E>> c(ResourceKey<? extends IRegistry<? extends E>> key) {
        Optional<IRegistry<E>> optional = this.a(key);
        if (optional.isPresent()) {
            return optional;
        }
        return IRegistry.d.b(key.a());
    }

    default public <E> IRegistry<E> d(ResourceKey<? extends IRegistry<? extends E>> key) {
        return this.c(key).orElseThrow(() -> new IllegalStateException("Missing registry: " + key));
    }

    private static <E> void a(ImmutableMap.Builder<ResourceKey<? extends IRegistry<?>>, RegistryData<?>> infosBuilder, ResourceKey<? extends IRegistry<E>> registryRef, Codec<E> entryCodec) {
        infosBuilder.put(registryRef, new RegistryData<E>(registryRef, entryCodec, null));
    }

    private static <E> void a(ImmutableMap.Builder<ResourceKey<? extends IRegistry<?>>, RegistryData<?>> infosBuilder, ResourceKey<? extends IRegistry<E>> registryRef, Codec<E> entryCodec, Codec<E> networkEntryCodec) {
        infosBuilder.put(registryRef, new RegistryData<E>(registryRef, entryCodec, networkEntryCodec));
    }

    public static Iterable<RegistryData<?>> a() {
        return b.values();
    }

    public Stream<d<?>> b();

    private static Stream<d<Object>> h() {
        return IRegistry.d.f().map(d::a);
    }

    default public Stream<d<?>> c() {
        return Stream.concat(this.b(), IRegistryCustom.h());
    }

    default public Stream<d<?>> d() {
        return Stream.concat(this.j(), IRegistryCustom.h());
    }

    private static <E> Codec<IRegistryCustom> i() {
        Codec codec = MinecraftKey.a.xmap(ResourceKey::a, ResourceKey::a);
        Codec codec2 = codec.partialDispatch("type", registry -> DataResult.success(registry.m()), registryRef -> IRegistryCustom.f(registryRef).map(codec -> RegistryCodecs.a(registryRef, Lifecycle.experimental(), codec)));
        UnboundedMapCodec unboundedMapCodec = Codec.unboundedMap((Codec)codec, (Codec)codec2);
        return IRegistryCustom.a(unboundedMapCodec);
    }

    private static <K extends ResourceKey<? extends IRegistry<?>>, V extends IRegistry<?>> Codec<IRegistryCustom> a(UnboundedMapCodec<K, V> originalCodec) {
        return originalCodec.xmap(b::new, dynamicRegistryManager -> (Map)dynamicRegistryManager.j().collect(ImmutableMap.toImmutableMap(entry -> entry.a(), entry -> entry.b())));
    }

    private Stream<d<?>> j() {
        return this.b().filter(entry -> b.get(entry.a).a());
    }

    private static <E> DataResult<? extends Codec<E>> f(ResourceKey<? extends IRegistry<E>> registryKey) {
        return Optional.ofNullable(b.get(registryKey)).map(info -> info.d()).map(DataResult::success).orElseGet(() -> DataResult.error((String)("Unknown or not serializable registry: " + registryKey)));
    }

    private static Map<ResourceKey<? extends IRegistry<?>>, ? extends IRegistryWritable<?>> k() {
        return b.keySet().stream().collect(Collectors.toMap(Function.identity(), IRegistryCustom::e));
    }

    private static e l() {
        return new f(IRegistryCustom.k());
    }

    public static Dimension a(final IRegistry<? extends IRegistry<?>> registries) {
        return new Dimension(){

            @Override
            public <T> Optional<IRegistry<T>> a(ResourceKey<? extends IRegistry<? extends T>> key) {
                IRegistry registry = registries;
                return registry.e(key);
            }

            @Override
            @Override
            public Stream<d<?>> b() {
                return registries.e().stream().map(d::a);
            }
        };
    }

    public static e e() {
        e writable = IRegistryCustom.l();
        RegistryResourceAccess.InMemoryStorage inMemoryStorage = new RegistryResourceAccess.InMemoryStorage();
        for (Map.Entry<ResourceKey<IRegistry<?>>, RegistryData<?>> entry : b.entrySet()) {
            if (entry.getKey().equals(IRegistry.N)) continue;
            IRegistryCustom.a(inMemoryStorage, entry.getValue());
        }
        RegistryOps.a(JsonOps.INSTANCE, writable, inMemoryStorage);
        return DimensionManager.a(writable);
    }

    private static <E> void a(RegistryResourceAccess.InMemoryStorage entryLoader, RegistryData<E> info) {
        ResourceKey<IRegistry<E>> resourceKey = info.b();
        IRegistry<E> registry = RegistryGeneration.m.d(resourceKey);
        for (Map.Entry<ResourceKey<E>, E> entry : registry.e()) {
            ResourceKey<E> resourceKey2 = entry.getKey();
            E object = entry.getValue();
            entryLoader.a(RegistryGeneration.m, resourceKey2, info.c(), registry.a(object), object, registry.d(object));
        }
    }

    public static void a(e dynamicRegistryManager, DynamicOps<JsonElement> ops, RegistryLoader registryLoader) {
        RegistryLoader.a bound = registryLoader.a(dynamicRegistryManager);
        for (RegistryData<?> registryData : b.values()) {
            IRegistryCustom.a(ops, bound, registryData);
        }
    }

    private static <E> void a(DynamicOps<JsonElement> ops, RegistryLoader.a loaderAccess, RegistryData<E> info) {
        DataResult<IRegistry<E>> dataResult = loaderAccess.a(info.b(), info.c(), ops);
        dataResult.error().ifPresent(partialResult -> {
            throw new JsonParseException("Error loading registry data: " + partialResult.message());
        });
    }

    public static IRegistryCustom a(Dynamic<?> dynamic) {
        return new b(b.keySet().stream().collect(Collectors.toMap(Function.identity(), registryRef -> IRegistryCustom.a(registryRef, dynamic))));
    }

    public static <E> IRegistry<E> a(ResourceKey<? extends IRegistry<? extends E>> registryRef, Dynamic<?> dynamic) {
        return (IRegistry)RegistryOps.b(registryRef).codec().parse(dynamic).resultOrPartial(SystemUtils.a(registryRef + " registry: ", arg_0 -> ((Logger)a).error(arg_0))).orElseThrow(() -> new IllegalStateException("Failed to get " + registryRef + " registry"));
    }

    public static <E> IRegistryWritable<?> e(ResourceKey<? extends IRegistry<?>> registryRef) {
        return new RegistryMaterials(registryRef, Lifecycle.stable(), null);
    }

    default public Dimension f() {
        return new b(this.b().map(d::c));
    }

    default public Lifecycle g() {
        return this.b().map(entry -> entry.b.c()).reduce(Lifecycle.stable(), Lifecycle::add);
    }

    public record RegistryData<E>(ResourceKey<? extends IRegistry<E>> a, Codec<E> b, @Nullable Codec<E> c) {
        private final ResourceKey<? extends IRegistry<E>> a;
        private final Codec<E> b;
        @Nullable
        private final Codec<E> c;

        public boolean a() {
            return this.c != null;
        }

        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{RegistryData.class, "key;codec;networkCodec", "a", "b", "c"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{RegistryData.class, "key;codec;networkCodec", "a", "b", "c"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{RegistryData.class, "key;codec;networkCodec", "a", "b", "c"}, this, object);
        }

        public ResourceKey<? extends IRegistry<E>> b() {
            return this.a;
        }

        public Codec<E> c() {
            return this.b;
        }

        @Nullable
        public Codec<E> d() {
            return this.c;
        }
    }

    public static final class f
    implements e {
        private final Map<? extends ResourceKey<? extends IRegistry<?>>, ? extends IRegistryWritable<?>> e;

        f(Map<? extends ResourceKey<? extends IRegistry<?>>, ? extends IRegistryWritable<?>> mutableRegistries) {
            this.e = mutableRegistries;
        }

        @Override
        @Override
        public <E> Optional<IRegistry<E>> a(ResourceKey<? extends IRegistry<? extends E>> key) {
            return Optional.ofNullable(this.e.get(key)).map(registry -> registry);
        }

        @Override
        @Override
        public <E> Optional<IRegistryWritable<E>> f(ResourceKey<? extends IRegistry<? extends E>> key) {
            return Optional.ofNullable(this.e.get(key)).map(registry -> registry);
        }

        @Override
        @Override
        public Stream<d<?>> b() {
            return this.e.entrySet().stream().map(d::a);
        }
    }

    public static interface e
    extends IRegistryCustom {
        public <E> Optional<IRegistryWritable<E>> f(ResourceKey<? extends IRegistry<? extends E>> var1);

        default public <E> IRegistryWritable<E> g(ResourceKey<? extends IRegistry<? extends E>> key) {
            return this.f(key).orElseThrow(() -> new IllegalStateException("Missing registry: " + key));
        }
    }

    public static final class b
    implements Dimension {
        private final Map<? extends ResourceKey<? extends IRegistry<?>>, ? extends IRegistry<?>> e;

        public b(Map<? extends ResourceKey<? extends IRegistry<?>>, ? extends IRegistry<?>> registries) {
            this.e = Map.copyOf(registries);
        }

        b(Stream<d<?>> stream) {
            this.e = (Map)stream.collect(ImmutableMap.toImmutableMap(d::a, d::b));
        }

        @Override
        @Override
        public <E> Optional<IRegistry<E>> a(ResourceKey<? extends IRegistry<? extends E>> key) {
            return Optional.ofNullable(this.e.get(key)).map(registry -> registry);
        }

        @Override
        @Override
        public Stream<d<?>> b() {
            return this.e.entrySet().stream().map(d::a);
        }
    }

    public record d<T>(ResourceKey<? extends IRegistry<T>> a, IRegistry<T> b) {
        private static <T, R extends IRegistry<? extends T>> d<T> a(Map.Entry<? extends ResourceKey<? extends IRegistry<?>>, R> entry) {
            return net.minecraft.core.IRegistryCustom$d.a(entry.getKey(), (IRegistry)entry.getValue());
        }

        private static <T> d<T> a(Holder.c<? extends IRegistry<? extends T>> entry) {
            return net.minecraft.core.IRegistryCustom$d.a(entry.g(), entry.a());
        }

        private static <T> d<T> a(ResourceKey<? extends IRegistry<?>> key, IRegistry<?> value) {
            return new d(key, value);
        }

        private d<T> c() {
            return new d<T>(this.a, this.b.j());
        }

        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{d.class, "key;value", "a", "b"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{d.class, "key;value", "a", "b"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{d.class, "key;value", "a", "b"}, this, object);
        }
    }

    public static interface Dimension
    extends IRegistryCustom {
        @Override
        @Override
        default public Dimension f() {
            return this;
        }
    }
}

