/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import com.google.common.collect.Maps;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Keyable;
import com.mojang.serialization.Lifecycle;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IRegistryWritable;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryBlocks;
import net.minecraft.core.RegistryMaterials;
import net.minecraft.core.particles.Particle;
import net.minecraft.core.particles.Particles;
import net.minecraft.data.RegistryGeneration;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.DispenserRegistry;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.stats.StatisticWrapper;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.valueproviders.FloatProviderType;
import net.minecraft.util.valueproviders.IntProviderType;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceType;
import net.minecraft.world.entity.decoration.Paintings;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.entity.schedule.Schedule;
import net.minecraft.world.inventory.Containers;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionRegistry;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.Recipes;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.World;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.WorldChunkManager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.PositionSourceType;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;
import net.minecraft.world.level.levelgen.GeneratorSettingBase;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicateType;
import net.minecraft.world.level.levelgen.carver.WorldGenCarverAbstract;
import net.minecraft.world.level.levelgen.carver.WorldGenCarverWrapper;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.StructureGenerator;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureConfigured;
import net.minecraft.world.level.levelgen.feature.WorldGenerator;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSizeType;
import net.minecraft.world.level.levelgen.feature.foliageplacers.WorldGenFoilagePlacers;
import net.minecraft.world.level.levelgen.feature.stateproviders.WorldGenFeatureStateProviders;
import net.minecraft.world.level.levelgen.feature.treedecorators.WorldGenFeatureTrees;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacers;
import net.minecraft.world.level.levelgen.heightproviders.HeightProviderType;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.pieces.WorldGenFeatureStructurePieceType;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacementType;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePoolTemplate;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePools;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureRuleTestType;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureStructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.PosRuleTestType;
import net.minecraft.world.level.levelgen.structure.templatesystem.ProcessorList;
import net.minecraft.world.level.levelgen.synth.NoiseGeneratorNormal;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.storage.loot.entries.LootEntries;
import net.minecraft.world.level.storage.loot.entries.LootEntryType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditions;
import net.minecraft.world.level.storage.loot.providers.nbt.LootNbtProviderType;
import net.minecraft.world.level.storage.loot.providers.nbt.NbtProviders;
import net.minecraft.world.level.storage.loot.providers.number.LootNumberProviderType;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;
import net.minecraft.world.level.storage.loot.providers.score.LootScoreProviderType;
import net.minecraft.world.level.storage.loot.providers.score.ScoreboardNameProviders;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;

public abstract class IRegistry<T>
implements Keyable,
Registry<T> {
    private static final Logger bC = LogUtils.getLogger();
    private static final Map<MinecraftKey, Supplier<?>> bD = Maps.newLinkedHashMap();
    public static final MinecraftKey b = new MinecraftKey("root");
    protected static final IRegistryWritable<IRegistryWritable<?>> c = new RegistryMaterials(IRegistry.a("root"), Lifecycle.experimental(), null);
    public static final IRegistry<? extends IRegistry<?>> d = c;
    public static final ResourceKey<IRegistry<SoundEffect>> e = IRegistry.a("sound_event");
    public static final ResourceKey<IRegistry<FluidType>> f = IRegistry.a("fluid");
    public static final ResourceKey<IRegistry<MobEffectList>> g = IRegistry.a("mob_effect");
    public static final ResourceKey<IRegistry<Block>> h = IRegistry.a("block");
    public static final ResourceKey<IRegistry<Enchantment>> i = IRegistry.a("enchantment");
    public static final ResourceKey<IRegistry<EntityTypes<?>>> j = IRegistry.a("entity_type");
    public static final ResourceKey<IRegistry<Item>> k = IRegistry.a("item");
    public static final ResourceKey<IRegistry<PotionRegistry>> l = IRegistry.a("potion");
    public static final ResourceKey<IRegistry<Particle<?>>> m = IRegistry.a("particle_type");
    public static final ResourceKey<IRegistry<TileEntityTypes<?>>> n = IRegistry.a("block_entity_type");
    public static final ResourceKey<IRegistry<Paintings>> o = IRegistry.a("motive");
    public static final ResourceKey<IRegistry<MinecraftKey>> p = IRegistry.a("custom_stat");
    public static final ResourceKey<IRegistry<ChunkStatus>> q = IRegistry.a("chunk_status");
    public static final ResourceKey<IRegistry<DefinedStructureRuleTestType<?>>> r = IRegistry.a("rule_test");
    public static final ResourceKey<IRegistry<PosRuleTestType<?>>> s = IRegistry.a("pos_rule_test");
    public static final ResourceKey<IRegistry<Containers<?>>> t = IRegistry.a("menu");
    public static final ResourceKey<IRegistry<Recipes<?>>> u = IRegistry.a("recipe_type");
    public static final ResourceKey<IRegistry<RecipeSerializer<?>>> v = IRegistry.a("recipe_serializer");
    public static final ResourceKey<IRegistry<AttributeBase>> w = IRegistry.a("attribute");
    public static final ResourceKey<IRegistry<GameEvent>> x = IRegistry.a("game_event");
    public static final ResourceKey<IRegistry<PositionSourceType<?>>> y = IRegistry.a("position_source_type");
    public static final ResourceKey<IRegistry<StatisticWrapper<?>>> z = IRegistry.a("stat_type");
    public static final ResourceKey<IRegistry<VillagerType>> A = IRegistry.a("villager_type");
    public static final ResourceKey<IRegistry<VillagerProfession>> B = IRegistry.a("villager_profession");
    public static final ResourceKey<IRegistry<VillagePlaceType>> C = IRegistry.a("point_of_interest_type");
    public static final ResourceKey<IRegistry<MemoryModuleType<?>>> D = IRegistry.a("memory_module_type");
    public static final ResourceKey<IRegistry<SensorType<?>>> E = IRegistry.a("sensor_type");
    public static final ResourceKey<IRegistry<Schedule>> F = IRegistry.a("schedule");
    public static final ResourceKey<IRegistry<Activity>> G = IRegistry.a("activity");
    public static final ResourceKey<IRegistry<LootEntryType>> H = IRegistry.a("loot_pool_entry_type");
    public static final ResourceKey<IRegistry<LootItemFunctionType>> I = IRegistry.a("loot_function_type");
    public static final ResourceKey<IRegistry<LootItemConditionType>> J = IRegistry.a("loot_condition_type");
    public static final ResourceKey<IRegistry<LootNumberProviderType>> K = IRegistry.a("loot_number_provider_type");
    public static final ResourceKey<IRegistry<LootNbtProviderType>> L = IRegistry.a("loot_nbt_provider_type");
    public static final ResourceKey<IRegistry<LootScoreProviderType>> M = IRegistry.a("loot_score_provider_type");
    public static final ResourceKey<IRegistry<DimensionManager>> N = IRegistry.a("dimension_type");
    public static final ResourceKey<IRegistry<World>> O = IRegistry.a("dimension");
    public static final ResourceKey<IRegistry<WorldDimension>> P = IRegistry.a("dimension");
    public static final RegistryBlocks<GameEvent> Q = IRegistry.a(x, "step", GameEvent::c, (IRegistry<T> registry) -> GameEvent.Q);
    public static final IRegistry<SoundEffect> R = IRegistry.a(e, (IRegistry<T> registry) -> SoundEffects.jv);
    public static final RegistryBlocks<FluidType> S = IRegistry.a(f, "empty", FluidType::l, (IRegistry<T> registry) -> FluidTypes.a);
    public static final IRegistry<MobEffectList> T = IRegistry.a(g, (IRegistry<T> registry) -> MobEffects.z);
    public static final RegistryBlocks<Block> U = IRegistry.a(h, "air", Block::q, (IRegistry<T> registry) -> Blocks.a);
    public static final IRegistry<Enchantment> V = IRegistry.a(i, (IRegistry<T> registry) -> Enchantments.w);
    public static final RegistryBlocks<EntityTypes<?>> W = IRegistry.a(j, "pig", EntityTypes::q, (IRegistry<T> registry) -> EntityTypes.an);
    public static final RegistryBlocks<Item> X = IRegistry.a(k, "air", Item::k, (IRegistry<T> registry) -> Items.a);
    public static final RegistryBlocks<PotionRegistry> Y = IRegistry.a(l, "empty", (IRegistry<T> registry) -> Potions.a);
    public static final IRegistry<Particle<?>> Z = IRegistry.a(m, (IRegistry<T> registry) -> Particles.c);
    public static final IRegistry<TileEntityTypes<?>> aa = IRegistry.a(n, (IRegistry<T> registry) -> TileEntityTypes.a);
    public static final RegistryBlocks<Paintings> ab = IRegistry.a(o, "kebab", (IRegistry<T> registry) -> Paintings.a);
    public static final IRegistry<MinecraftKey> ac = IRegistry.a(p, (IRegistry<T> registry) -> StatisticList.E);
    public static final RegistryBlocks<ChunkStatus> ad = IRegistry.a(q, "empty", (IRegistry<T> registry) -> ChunkStatus.c);
    public static final IRegistry<DefinedStructureRuleTestType<?>> ae = IRegistry.a(r, (IRegistry<T> registry) -> DefinedStructureRuleTestType.a);
    public static final IRegistry<PosRuleTestType<?>> af = IRegistry.a(s, (IRegistry<T> registry) -> PosRuleTestType.a);
    public static final IRegistry<Containers<?>> ag = IRegistry.a(t, (IRegistry<T> registry) -> Containers.h);
    public static final IRegistry<Recipes<?>> ah = IRegistry.a(u, (IRegistry<T> registry) -> Recipes.a);
    public static final IRegistry<RecipeSerializer<?>> ai = IRegistry.a(v, (IRegistry<T> registry) -> RecipeSerializer.b);
    public static final IRegistry<AttributeBase> aj = IRegistry.a(w, (IRegistry<T> registry) -> GenericAttributes.k);
    public static final IRegistry<PositionSourceType<?>> ak = IRegistry.a(y, (IRegistry<T> registry) -> PositionSourceType.a);
    public static final IRegistry<StatisticWrapper<?>> al = IRegistry.a(z, (IRegistry<T> registry) -> StatisticList.c);
    public static final RegistryBlocks<VillagerType> am = IRegistry.a(A, "plains", (IRegistry<T> registry) -> VillagerType.c);
    public static final RegistryBlocks<VillagerProfession> an = IRegistry.a(B, "none", (IRegistry<T> registry) -> VillagerProfession.a);
    public static final RegistryBlocks<VillagePlaceType> ao = IRegistry.a(C, "unemployed", (IRegistry<T> registry) -> VillagePlaceType.c);
    public static final RegistryBlocks<MemoryModuleType<?>> ap = IRegistry.a(D, "dummy", (IRegistry<T> registry) -> MemoryModuleType.a);
    public static final RegistryBlocks<SensorType<?>> aq = IRegistry.a(E, "dummy", (IRegistry<T> registry) -> SensorType.a);
    public static final IRegistry<Schedule> ar = IRegistry.a(F, (IRegistry<T> registry) -> Schedule.c);
    public static final IRegistry<Activity> as = IRegistry.a(G, (IRegistry<T> registry) -> Activity.b);
    public static final IRegistry<LootEntryType> at = IRegistry.a(H, (IRegistry<T> registry) -> LootEntries.a);
    public static final IRegistry<LootItemFunctionType> au = IRegistry.a(I, (IRegistry<T> registry) -> LootItemFunctions.b);
    public static final IRegistry<LootItemConditionType> av = IRegistry.a(J, (IRegistry<T> registry) -> LootItemConditions.a);
    public static final IRegistry<LootNumberProviderType> aw = IRegistry.a(K, (IRegistry<T> registry) -> NumberProviders.a);
    public static final IRegistry<LootNbtProviderType> ax = IRegistry.a(L, (IRegistry<T> registry) -> NbtProviders.b);
    public static final IRegistry<LootScoreProviderType> ay = IRegistry.a(M, (IRegistry<T> registry) -> ScoreboardNameProviders.b);
    public static final ResourceKey<IRegistry<FloatProviderType<?>>> az = IRegistry.a("float_provider_type");
    public static final IRegistry<FloatProviderType<?>> aA = IRegistry.a(az, (IRegistry<T> registry) -> FloatProviderType.a);
    public static final ResourceKey<IRegistry<IntProviderType<?>>> aB = IRegistry.a("int_provider_type");
    public static final IRegistry<IntProviderType<?>> aC = IRegistry.a(aB, (IRegistry<T> tegistry) -> IntProviderType.a);
    public static final ResourceKey<IRegistry<HeightProviderType<?>>> aD = IRegistry.a("height_provider_type");
    public static final IRegistry<HeightProviderType<?>> aE = IRegistry.a(aD, (IRegistry<T> registry) -> HeightProviderType.a);
    public static final ResourceKey<IRegistry<BlockPredicateType<?>>> aF = IRegistry.a("block_predicate_type");
    public static final IRegistry<BlockPredicateType<?>> aG = IRegistry.a(aF, (IRegistry<T> registry) -> BlockPredicateType.k);
    public static final ResourceKey<IRegistry<GeneratorSettingBase>> aH = IRegistry.a("worldgen/noise_settings");
    public static final ResourceKey<IRegistry<WorldGenCarverWrapper<?>>> aI = IRegistry.a("worldgen/configured_carver");
    public static final ResourceKey<IRegistry<WorldGenFeatureConfigured<?, ?>>> aJ = IRegistry.a("worldgen/configured_feature");
    public static final ResourceKey<IRegistry<PlacedFeature>> aK = IRegistry.a("worldgen/placed_feature");
    public static final ResourceKey<IRegistry<StructureFeature<?, ?>>> aL = IRegistry.a("worldgen/configured_structure_feature");
    public static final ResourceKey<IRegistry<StructureSet>> aM = IRegistry.a("worldgen/structure_set");
    public static final ResourceKey<IRegistry<ProcessorList>> aN = IRegistry.a("worldgen/processor_list");
    public static final ResourceKey<IRegistry<WorldGenFeatureDefinedStructurePoolTemplate>> aO = IRegistry.a("worldgen/template_pool");
    public static final ResourceKey<IRegistry<BiomeBase>> aP = IRegistry.a("worldgen/biome");
    public static final ResourceKey<IRegistry<NoiseGeneratorNormal.a>> aQ = IRegistry.a("worldgen/noise");
    public static final ResourceKey<IRegistry<DensityFunction>> aR = IRegistry.a("worldgen/density_function");
    public static final ResourceKey<IRegistry<WorldGenCarverAbstract<?>>> aS = IRegistry.a("worldgen/carver");
    public static final IRegistry<WorldGenCarverAbstract<?>> aT = IRegistry.a(aS, (IRegistry<T> registry) -> WorldGenCarverAbstract.a);
    public static final ResourceKey<IRegistry<WorldGenerator<?>>> aU = IRegistry.a("worldgen/feature");
    public static final IRegistry<WorldGenerator<?>> aV = IRegistry.a(aU, (IRegistry<T> registry) -> WorldGenerator.K);
    public static final ResourceKey<IRegistry<StructureGenerator<?>>> aW = IRegistry.a("worldgen/structure_feature");
    public static final IRegistry<StructureGenerator<?>> aX = IRegistry.a(aW, (IRegistry<T> registry) -> StructureGenerator.c);
    public static final ResourceKey<IRegistry<StructurePlacementType<?>>> aY = IRegistry.a("worldgen/structure_placement");
    public static final IRegistry<StructurePlacementType<?>> aZ = IRegistry.a(aY, (IRegistry<T> registry) -> StructurePlacementType.a);
    public static final ResourceKey<IRegistry<WorldGenFeatureStructurePieceType>> ba = IRegistry.a("worldgen/structure_piece");
    public static final IRegistry<WorldGenFeatureStructurePieceType> bb = IRegistry.a(ba, (IRegistry<T> registry) -> WorldGenFeatureStructurePieceType.c);
    public static final ResourceKey<IRegistry<PlacementModifierType<?>>> bc = IRegistry.a("worldgen/placement_modifier_type");
    public static final IRegistry<PlacementModifierType<?>> bd = IRegistry.a(bc, (IRegistry<T> registry) -> PlacementModifierType.f);
    public static final ResourceKey<IRegistry<WorldGenFeatureStateProviders<?>>> be = IRegistry.a("worldgen/block_state_provider_type");
    public static final ResourceKey<IRegistry<WorldGenFoilagePlacers<?>>> bf = IRegistry.a("worldgen/foliage_placer_type");
    public static final ResourceKey<IRegistry<TrunkPlacers<?>>> bg = IRegistry.a("worldgen/trunk_placer_type");
    public static final ResourceKey<IRegistry<WorldGenFeatureTrees<?>>> bh = IRegistry.a("worldgen/tree_decorator_type");
    public static final ResourceKey<IRegistry<FeatureSizeType<?>>> bi = IRegistry.a("worldgen/feature_size_type");
    public static final ResourceKey<IRegistry<Codec<? extends WorldChunkManager>>> bj = IRegistry.a("worldgen/biome_source");
    public static final ResourceKey<IRegistry<Codec<? extends ChunkGenerator>>> bk = IRegistry.a("worldgen/chunk_generator");
    public static final ResourceKey<IRegistry<Codec<? extends SurfaceRules.f>>> bl = IRegistry.a("worldgen/material_condition");
    public static final ResourceKey<IRegistry<Codec<? extends SurfaceRules.o>>> bm = IRegistry.a("worldgen/material_rule");
    public static final ResourceKey<IRegistry<Codec<? extends DensityFunction>>> bn = IRegistry.a("worldgen/density_function_type");
    public static final ResourceKey<IRegistry<DefinedStructureStructureProcessorType<?>>> bo = IRegistry.a("worldgen/structure_processor");
    public static final ResourceKey<IRegistry<WorldGenFeatureDefinedStructurePools<?>>> bp = IRegistry.a("worldgen/structure_pool_element");
    public static final IRegistry<WorldGenFeatureStateProviders<?>> bq = IRegistry.a(be, (IRegistry<T> registry) -> WorldGenFeatureStateProviders.a);
    public static final IRegistry<WorldGenFoilagePlacers<?>> br = IRegistry.a(bf, (IRegistry<T> registry) -> WorldGenFoilagePlacers.a);
    public static final IRegistry<TrunkPlacers<?>> bs = IRegistry.a(bg, (IRegistry<T> registry) -> TrunkPlacers.a);
    public static final IRegistry<WorldGenFeatureTrees<?>> bt = IRegistry.a(bh, (IRegistry<T> registry) -> WorldGenFeatureTrees.b);
    public static final IRegistry<FeatureSizeType<?>> bu = IRegistry.a(bi, (IRegistry<T> registry) -> FeatureSizeType.a);
    public static final IRegistry<Codec<? extends WorldChunkManager>> bv = IRegistry.a(bj, Lifecycle.stable(), (IRegistry<T> registry) -> WorldChunkManager.a);
    public static final IRegistry<Codec<? extends ChunkGenerator>> bw = IRegistry.a(bk, Lifecycle.stable(), (IRegistry<T> registry) -> ChunkGenerator.a);
    public static final IRegistry<Codec<? extends SurfaceRules.f>> bx = IRegistry.a(bl, SurfaceRules.f::a);
    public static final IRegistry<Codec<? extends SurfaceRules.o>> by = IRegistry.a(bm, SurfaceRules.o::a);
    public static final IRegistry<Codec<? extends DensityFunction>> bz = IRegistry.a(bn, DensityFunctions::a);
    public static final IRegistry<DefinedStructureStructureProcessorType<?>> bA = IRegistry.a(bo, (IRegistry<T> registry) -> DefinedStructureStructureProcessorType.a);
    public static final IRegistry<WorldGenFeatureDefinedStructurePools<?>> bB = IRegistry.a(bp, (IRegistry<T> registry) -> WorldGenFeatureDefinedStructurePools.d);
    private final ResourceKey<? extends IRegistry<T>> bE;
    private final Lifecycle bF;

    private static <T> ResourceKey<IRegistry<T>> a(String registryId) {
        return ResourceKey.a(new MinecraftKey(registryId));
    }

    public static <T extends IRegistry<?>> void a(IRegistry<T> registries) {
        registries.forEach(registry -> {
            if (registry.d().isEmpty()) {
                SystemUtils.a("Registry '" + registries.b(registry) + "' was empty after loading");
            }
            if (registry instanceof RegistryBlocks) {
                MinecraftKey resourceLocation = ((RegistryBlocks)registry).a();
                Validate.notNull(registry.a(resourceLocation), (String)("Missing default of DefaultedMappedRegistry: " + resourceLocation), (Object[])new Object[0]);
            }
        });
    }

    private static <T> IRegistry<T> a(ResourceKey<? extends IRegistry<T>> key, a<T> defaultEntryGetter) {
        return IRegistry.a(key, Lifecycle.experimental(), defaultEntryGetter);
    }

    private static <T> RegistryBlocks<T> a(ResourceKey<? extends IRegistry<T>> key, String defaultId, a<T> defaultEntryGetter) {
        return IRegistry.a(key, defaultId, Lifecycle.experimental(), defaultEntryGetter);
    }

    private static <T> RegistryBlocks<T> a(ResourceKey<? extends IRegistry<T>> key, String defaultId, Function<T, Holder.c<T>> valueToEntryFunction, a<T> defaultEntryGetter) {
        return IRegistry.a(key, defaultId, Lifecycle.experimental(), valueToEntryFunction, defaultEntryGetter);
    }

    private static <T> IRegistry<T> a(ResourceKey<? extends IRegistry<T>> key, Lifecycle lifecycle, a<T> defaultEntryGetter) {
        return IRegistry.a(key, new RegistryMaterials(key, lifecycle, null), defaultEntryGetter, lifecycle);
    }

    private static <T> IRegistry<T> a(ResourceKey<? extends IRegistry<T>> key, Lifecycle lifecycle, Function<T, Holder.c<T>> valueToEntryFunction, a<T> defaultEntryGetter) {
        return IRegistry.a(key, new RegistryMaterials<T>(key, lifecycle, valueToEntryFunction), defaultEntryGetter, lifecycle);
    }

    private static <T> RegistryBlocks<T> a(ResourceKey<? extends IRegistry<T>> key, String defaultId, Lifecycle lifecycle, a<T> defaultEntryGetter) {
        return IRegistry.a(key, new RegistryBlocks(defaultId, key, lifecycle, null), defaultEntryGetter, lifecycle);
    }

    private static <T> RegistryBlocks<T> a(ResourceKey<? extends IRegistry<T>> key, String defaultId, Lifecycle lifecycle, Function<T, Holder.c<T>> valueToEntryFunction, a<T> defaultEntryGetter) {
        return IRegistry.a(key, new RegistryBlocks<T>(defaultId, key, lifecycle, valueToEntryFunction), defaultEntryGetter, lifecycle);
    }

    private static <T, R extends IRegistryWritable<T>> R a(ResourceKey<? extends IRegistry<T>> key, R registry, a<T> defaultEntryGetter, Lifecycle lifecycle) {
        MinecraftKey resourceLocation = key.a();
        bD.put(resourceLocation, () -> defaultEntryGetter.run(registry));
        c.a(key, registry, lifecycle);
        return registry;
    }

    protected IRegistry(ResourceKey<? extends IRegistry<T>> key, Lifecycle lifecycle) {
        DispenserRegistry.a(() -> "registry " + key);
        this.bE = key;
        this.bF = lifecycle;
    }

    public static void l() {
        for (IRegistry iRegistry : d) {
            iRegistry.j();
        }
    }

    public ResourceKey<? extends IRegistry<T>> m() {
        return this.bE;
    }

    public Lifecycle n() {
        return this.bF;
    }

    @Override
    public String toString() {
        return "Registry[" + this.bE + " (" + this.bF + ")]";
    }

    public Codec<T> o() {
        Codec codec = MinecraftKey.a.flatXmap(id -> Optional.ofNullable(this.a((MinecraftKey)id)).map(DataResult::success).orElseGet(() -> DataResult.error((String)("Unknown registry key in " + this.bE + ": " + id))), value -> this.c(value).map(ResourceKey::a).map(DataResult::success).orElseGet(() -> DataResult.error((String)("Unknown registry element in " + this.bE + ":" + value))));
        Codec<Object> codec2 = ExtraCodecs.a((E value) -> this.c(value).isPresent() ? this.a(value) : -1, this::a, -1);
        return ExtraCodecs.a(ExtraCodecs.b(codec, codec2), this::d, (E value) -> this.bF);
    }

    public Codec<Holder<T>> p() {
        Codec codec = MinecraftKey.a.flatXmap(id -> this.b(ResourceKey.a(this.bE, id)).map(DataResult::success).orElseGet(() -> DataResult.error((String)("Unknown registry key in " + this.bE + ": " + id))), entry -> entry.e().map(ResourceKey::a).map(DataResult::success).orElseGet(() -> DataResult.error((String)("Unknown registry element in " + this.bE + ":" + entry))));
        return ExtraCodecs.a(codec, (E entry) -> this.d(entry.a()), (E entry) -> this.bF);
    }

    public <U> Stream<U> keys(DynamicOps<U> dynamicOps) {
        return this.d().stream().map(id -> dynamicOps.createString(id.toString()));
    }

    @Nullable
    public abstract MinecraftKey b(T var1);

    public abstract Optional<ResourceKey<T>> c(T var1);

    @Override
    @Override
    public abstract int a(@Nullable T var1);

    @Nullable
    public abstract T a(@Nullable ResourceKey<T> var1);

    @Nullable
    public abstract T a(@Nullable MinecraftKey var1);

    public abstract Lifecycle d(T var1);

    public abstract Lifecycle c();

    public Optional<T> b(@Nullable MinecraftKey id) {
        return Optional.ofNullable(this.a(id));
    }

    public Optional<T> e(@Nullable ResourceKey<T> key) {
        return Optional.ofNullable(this.a(key));
    }

    public T f(ResourceKey<T> key) {
        T object = this.a(key);
        if (object == null) {
            throw new IllegalStateException("Missing key in " + this.bE + ": " + key);
        }
        return object;
    }

    public abstract Set<MinecraftKey> d();

    public abstract Set<Map.Entry<ResourceKey<T>, T>> e();

    public abstract Optional<Holder<T>> a(Random var1);

    public Stream<T> q() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    public abstract boolean c(MinecraftKey var1);

    public abstract boolean d(ResourceKey<T> var1);

    public static <T> T a(IRegistry<? super T> registry, String id, T entry) {
        return IRegistry.a(registry, new MinecraftKey(id), entry);
    }

    public static <V, T extends V> T a(IRegistry<V> registry, MinecraftKey id, T entry) {
        return IRegistry.a(registry, ResourceKey.a(registry.bE, id), entry);
    }

    public static <V, T extends V> T a(IRegistry<V> registry, ResourceKey<V> key, T entry) {
        ((IRegistryWritable)registry).a(key, entry, Lifecycle.stable());
        return entry;
    }

    public static <V, T extends V> T a(IRegistry<V> registry, int rawId, String id, T entry) {
        ((IRegistryWritable)registry).a(rawId, ResourceKey.a(registry.bE, new MinecraftKey(id)), entry, Lifecycle.stable());
        return entry;
    }

    public abstract IRegistry<T> j();

    public abstract Holder<T> c(ResourceKey<T> var1);

    public abstract Holder.c<T> e(T var1);

    public abstract Optional<Holder<T>> c(int var1);

    public abstract Optional<Holder<T>> b(ResourceKey<T> var1);

    public Holder<T> g(ResourceKey<T> key) {
        return this.b(key).orElseThrow(() -> new IllegalStateException("Missing key in " + this.bE + ": " + key));
    }

    public abstract Stream<Holder.c<T>> f();

    public abstract Optional<HolderSet.Named<T>> c(TagKey<T> var1);

    public Iterable<Holder<T>> d(TagKey<T> tag) {
        return (Iterable)DataFixUtils.orElse(this.c(tag), List.of());
    }

    public abstract HolderSet.Named<T> b(TagKey<T> var1);

    public abstract Stream<Pair<TagKey<T>, HolderSet.Named<T>>> g();

    public abstract Stream<TagKey<T>> h();

    public abstract boolean a(TagKey<T> var1);

    public abstract void k();

    public abstract void a(Map<TagKey<T>, List<Holder<T>>> var1);

    public Registry<Holder<T>> r() {
        return new Registry<Holder<T>>(){

            @Override
            @Override
            public int a(Holder<T> value) {
                return IRegistry.this.a(value.a());
            }

            @Nullable
            @Override
            public Holder<T> c(int i2) {
                return IRegistry.this.c(i2).orElse(null);
            }

            @Override
            @Override
            public int b() {
                return IRegistry.this.b();
            }

            @Override
            @Override
            public Iterator<Holder<T>> iterator() {
                return IRegistry.this.f().map(entry -> entry).iterator();
            }

            @Override
            @Nullable
            public /* synthetic */ Object a(int index) {
                return this.c(index);
            }
        };
    }

    static {
        RegistryGeneration.a();
        bD.forEach((? super K id, ? super V defaultEntry) -> {
            if (defaultEntry.get() == null) {
                bC.error("Unable to bootstrap registry '{}'", id);
            }
        });
        IRegistry.a(c);
    }

    @FunctionalInterface
    static interface a<T> {
        public T run(IRegistry<T> var1);
    }
}

