/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments;

import com.google.gson.JsonObject;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.datafixers.util.Either;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.commands.synchronization.ArgumentSerializer;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.chat.ChatMessage;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.levelgen.feature.StructureFeature;

public class ResourceOrTagLocationArgument<T>
implements ArgumentType<b<T>> {
    private static final Collection<String> a = Arrays.asList("foo", "foo:bar", "012", "#skeletons", "#minecraft:skeletons");
    private static final DynamicCommandExceptionType b = new DynamicCommandExceptionType(id -> new ChatMessage("commands.locatebiome.invalid", id));
    private static final DynamicCommandExceptionType c = new DynamicCommandExceptionType(id -> new ChatMessage("commands.locate.invalid", id));
    final ResourceKey<? extends IRegistry<T>> d;

    public ResourceOrTagLocationArgument(ResourceKey<? extends IRegistry<T>> registryRef) {
        this.d = registryRef;
    }

    public static <T> ResourceOrTagLocationArgument<T> a(ResourceKey<? extends IRegistry<T>> registryRef) {
        return new ResourceOrTagLocationArgument<T>(registryRef);
    }

    private static <T> b<T> a(CommandContext<CommandListenerWrapper> context, String name, ResourceKey<IRegistry<T>> registryRef, DynamicCommandExceptionType invalidException) throws CommandSyntaxException {
        b result = (b)context.getArgument(name, b.class);
        Optional<b<T>> optional = result.a(registryRef);
        return optional.orElseThrow(() -> invalidException.create((Object)result));
    }

    public static b<BiomeBase> a(CommandContext<CommandListenerWrapper> context, String name) throws CommandSyntaxException {
        return ResourceOrTagLocationArgument.a(context, name, IRegistry.aP, b);
    }

    public static b<StructureFeature<?, ?>> b(CommandContext<CommandListenerWrapper> context, String name) throws CommandSyntaxException {
        return ResourceOrTagLocationArgument.a(context, name, IRegistry.aL, c);
    }

    public b<T> a(StringReader stringReader) throws CommandSyntaxException {
        if (stringReader.canRead() && stringReader.peek() == '#') {
            int i2 = stringReader.getCursor();
            try {
                stringReader.skip();
                MinecraftKey resourceLocation = MinecraftKey.a(stringReader);
                return new d(TagKey.a(this.d, resourceLocation));
            }
            catch (CommandSyntaxException commandSyntaxException) {
                stringReader.setCursor(i2);
                throw commandSyntaxException;
            }
        }
        MinecraftKey resourceLocation2 = MinecraftKey.a(stringReader);
        return new a(ResourceKey.a(this.d, resourceLocation2));
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> commandContext, SuggestionsBuilder suggestionsBuilder) {
        Object object = commandContext.getSource();
        if (object instanceof ICompletionProvider) {
            ICompletionProvider sharedSuggestionProvider = (ICompletionProvider)object;
            return sharedSuggestionProvider.a(this.d, ICompletionProvider.a.c, suggestionsBuilder, commandContext);
        }
        return suggestionsBuilder.buildFuture();
    }

    public Collection<String> getExamples() {
        return a;
    }

    public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
        return this.a(stringReader);
    }

    public static interface b<T>
    extends Predicate<Holder<T>> {
        public Either<ResourceKey<T>, TagKey<T>> a();

        public <E> Optional<b<E>> a(ResourceKey<? extends IRegistry<E>> var1);

        public String b();
    }

    record d<T>(TagKey<T> a) implements b<T>
    {
        private final TagKey<T> a;

        @Override
        @Override
        public Either<ResourceKey<T>, TagKey<T>> a() {
            return Either.right(this.a);
        }

        @Override
        @Override
        public <E> Optional<b<E>> a(ResourceKey<? extends IRegistry<E>> registryRef) {
            return this.a.d(registryRef).map(d::new);
        }

        @Override
        public boolean a(Holder<T> holder) {
            return holder.a(this.a);
        }

        @Override
        @Override
        public String b() {
            return "#" + this.a.b();
        }

        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{d.class, "key", "a"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{d.class, "key", "a"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{d.class, "key", "a"}, this, object);
        }

        public TagKey<T> c() {
            return this.a;
        }

        @Override
        public /* synthetic */ boolean test(Object object) {
            return this.a((Holder)object);
        }
    }

    record a<T>(ResourceKey<T> a) implements b<T>
    {
        private final ResourceKey<T> a;

        @Override
        @Override
        public Either<ResourceKey<T>, TagKey<T>> a() {
            return Either.left(this.a);
        }

        @Override
        @Override
        public <E> Optional<b<E>> a(ResourceKey<? extends IRegistry<E>> registryRef) {
            return this.a.c(registryRef).map(a::new);
        }

        @Override
        public boolean a(Holder<T> holder) {
            return holder.a(this.a);
        }

        @Override
        @Override
        public String b() {
            return this.a.a().toString();
        }

        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "key", "a"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "key", "a"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "key", "a"}, this, object);
        }

        public ResourceKey<T> c() {
            return this.a;
        }

        @Override
        public /* synthetic */ boolean test(Object object) {
            return this.a((Holder)object);
        }
    }

    public static class c
    implements ArgumentSerializer<ResourceOrTagLocationArgument<?>> {
        @Override
        @Override
        public void a(ResourceOrTagLocationArgument<?> type, PacketDataSerializer buf) {
            buf.a(type.d.a());
        }

        @Override
        public ResourceOrTagLocationArgument<?> a(PacketDataSerializer friendlyByteBuf) {
            MinecraftKey resourceLocation = friendlyByteBuf.q();
            return new ResourceOrTagLocationArgument(ResourceKey.a(resourceLocation));
        }

        @Override
        @Override
        public void a(ResourceOrTagLocationArgument<?> type, JsonObject json) {
            json.addProperty("registry", type.d.a().toString());
        }

        @Override
        public /* synthetic */ ArgumentType b(PacketDataSerializer buf) {
            return this.a(buf);
        }
    }
}

