/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments;

import com.google.gson.JsonObject;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.commands.synchronization.ArgumentSerializer;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.chat.ChatMessage;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureConfigured;

public class ResourceKeyArgument<T>
implements ArgumentType<ResourceKey<T>> {
    private static final Collection<String> a = Arrays.asList("foo", "foo:bar", "012");
    private static final DynamicCommandExceptionType b = new DynamicCommandExceptionType(id -> new ChatMessage("attribute.unknown", id));
    private static final DynamicCommandExceptionType c = new DynamicCommandExceptionType(id -> new ChatMessage("commands.placefeature.invalid", id));
    final ResourceKey<? extends IRegistry<T>> d;

    public ResourceKeyArgument(ResourceKey<? extends IRegistry<T>> registryRef) {
        this.d = registryRef;
    }

    public static <T> ResourceKeyArgument<T> a(ResourceKey<? extends IRegistry<T>> registryRef) {
        return new ResourceKeyArgument<T>(registryRef);
    }

    private static <T> ResourceKey<T> a(CommandContext<CommandListenerWrapper> context, String name, ResourceKey<IRegistry<T>> registryRef, DynamicCommandExceptionType invalidException) throws CommandSyntaxException {
        ResourceKey resourceKey = (ResourceKey)context.getArgument(name, ResourceKey.class);
        Optional<ResourceKey<T>> optional = resourceKey.c(registryRef);
        return optional.orElseThrow(() -> invalidException.create((Object)resourceKey));
    }

    private static <T> IRegistry<T> a(CommandContext<CommandListenerWrapper> context, ResourceKey<? extends IRegistry<T>> registryRef) {
        return ((CommandListenerWrapper)context.getSource()).j().aU().d(registryRef);
    }

    public static AttributeBase a(CommandContext<CommandListenerWrapper> context, String name) throws CommandSyntaxException {
        ResourceKey resourceKey = ResourceKeyArgument.a(context, name, IRegistry.w, b);
        return ResourceKeyArgument.a(context, IRegistry.w).e(resourceKey).orElseThrow(() -> b.create((Object)resourceKey.a()));
    }

    public static Holder<WorldGenFeatureConfigured<?, ?>> b(CommandContext<CommandListenerWrapper> context, String name) throws CommandSyntaxException {
        ResourceKey resourceKey = ResourceKeyArgument.a(context, name, IRegistry.aJ, c);
        return ResourceKeyArgument.a(context, IRegistry.aJ).b(resourceKey).orElseThrow(() -> c.create((Object)resourceKey.a()));
    }

    public ResourceKey<T> a(StringReader stringReader) throws CommandSyntaxException {
        MinecraftKey resourceLocation = MinecraftKey.a(stringReader);
        return ResourceKey.a(this.d, resourceLocation);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> commandContext, SuggestionsBuilder suggestionsBuilder) {
        Object object = commandContext.getSource();
        if (object instanceof ICompletionProvider) {
            ICompletionProvider sharedSuggestionProvider = (ICompletionProvider)object;
            return sharedSuggestionProvider.a(this.d, ICompletionProvider.a.b, suggestionsBuilder, commandContext);
        }
        return suggestionsBuilder.buildFuture();
    }

    public Collection<String> getExamples() {
        return a;
    }

    public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
        return this.a(stringReader);
    }

    public static class a
    implements ArgumentSerializer<ResourceKeyArgument<?>> {
        @Override
        @Override
        public void a(ResourceKeyArgument<?> type, PacketDataSerializer buf) {
            buf.a(type.d.a());
        }

        @Override
        public ResourceKeyArgument<?> a(PacketDataSerializer friendlyByteBuf) {
            MinecraftKey resourceLocation = friendlyByteBuf.q();
            return new ResourceKeyArgument(ResourceKey.a(resourceLocation));
        }

        @Override
        @Override
        public void a(ResourceKeyArgument<?> type, JsonObject json) {
            json.addProperty("registry", type.d.a().toString());
        }

        @Override
        public /* synthetic */ ArgumentType b(PacketDataSerializer buf) {
            return this.a(buf);
        }
    }
}

