/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments;

import com.google.common.collect.Iterables;
import com.google.gson.JsonObject;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.commands.arguments.selector.ArgumentParserSelector;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.commands.synchronization.ArgumentSerializer;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.chat.ChatMessage;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.entity.Entity;

public class ArgumentEntity
implements ArgumentType<EntitySelector> {
    private static final Collection<String> g = Arrays.asList("Player", "0123", "@e", "@e[type=foo]", "dd12be42-52a9-4a91-a8a1-11c01849e498");
    public static final SimpleCommandExceptionType a = new SimpleCommandExceptionType((Message)new ChatMessage("argument.entity.toomany"));
    public static final SimpleCommandExceptionType b = new SimpleCommandExceptionType((Message)new ChatMessage("argument.player.toomany"));
    public static final SimpleCommandExceptionType c = new SimpleCommandExceptionType((Message)new ChatMessage("argument.player.entities"));
    public static final SimpleCommandExceptionType d = new SimpleCommandExceptionType((Message)new ChatMessage("argument.entity.notfound.entity"));
    public static final SimpleCommandExceptionType e = new SimpleCommandExceptionType((Message)new ChatMessage("argument.entity.notfound.player"));
    public static final SimpleCommandExceptionType f = new SimpleCommandExceptionType((Message)new ChatMessage("argument.entity.selector.not_allowed"));
    private static final byte h = 1;
    private static final byte i = 2;
    final boolean j;
    final boolean k;

    protected ArgumentEntity(boolean singleTarget, boolean playersOnly) {
        this.j = singleTarget;
        this.k = playersOnly;
    }

    public static ArgumentEntity a() {
        return new ArgumentEntity(true, false);
    }

    public static Entity a(CommandContext<CommandListenerWrapper> context, String name) throws CommandSyntaxException {
        return ((EntitySelector)context.getArgument(name, EntitySelector.class)).a((CommandListenerWrapper)context.getSource());
    }

    public static ArgumentEntity b() {
        return new ArgumentEntity(false, false);
    }

    public static Collection<? extends Entity> b(CommandContext<CommandListenerWrapper> context, String name) throws CommandSyntaxException {
        Collection<? extends Entity> collection = ArgumentEntity.c(context, name);
        if (collection.isEmpty()) {
            throw d.create();
        }
        return collection;
    }

    public static Collection<? extends Entity> c(CommandContext<CommandListenerWrapper> context, String name) throws CommandSyntaxException {
        return ((EntitySelector)context.getArgument(name, EntitySelector.class)).b((CommandListenerWrapper)context.getSource());
    }

    public static Collection<EntityPlayer> d(CommandContext<CommandListenerWrapper> context, String name) throws CommandSyntaxException {
        return ((EntitySelector)context.getArgument(name, EntitySelector.class)).d((CommandListenerWrapper)context.getSource());
    }

    public static ArgumentEntity c() {
        return new ArgumentEntity(true, true);
    }

    public static EntityPlayer e(CommandContext<CommandListenerWrapper> context, String name) throws CommandSyntaxException {
        return ((EntitySelector)context.getArgument(name, EntitySelector.class)).c((CommandListenerWrapper)context.getSource());
    }

    public static ArgumentEntity d() {
        return new ArgumentEntity(false, true);
    }

    public static Collection<EntityPlayer> f(CommandContext<CommandListenerWrapper> context, String name) throws CommandSyntaxException {
        List<EntityPlayer> list = ((EntitySelector)context.getArgument(name, EntitySelector.class)).d((CommandListenerWrapper)context.getSource());
        if (list.isEmpty()) {
            throw e.create();
        }
        return list;
    }

    public EntitySelector a(StringReader stringreader) throws CommandSyntaxException {
        return this.parse(stringreader, false);
    }

    public EntitySelector parse(StringReader stringreader, boolean overridePermissions) throws CommandSyntaxException {
        boolean flag = false;
        ArgumentParserSelector argumentparserselector = new ArgumentParserSelector(stringreader);
        EntitySelector entityselector = argumentparserselector.parse(overridePermissions);
        if (entityselector.a() > 1 && this.j) {
            if (this.k) {
                stringreader.setCursor(0);
                throw b.createWithContext((ImmutableStringReader)stringreader);
            }
            stringreader.setCursor(0);
            throw a.createWithContext((ImmutableStringReader)stringreader);
        }
        if (entityselector.b() && this.k && !entityselector.c()) {
            stringreader.setCursor(0);
            throw c.createWithContext((ImmutableStringReader)stringreader);
        }
        return entityselector;
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> commandcontext, SuggestionsBuilder suggestionsbuilder) {
        if (commandcontext.getSource() instanceof ICompletionProvider) {
            StringReader stringreader = new StringReader(suggestionsbuilder.getInput());
            stringreader.setCursor(suggestionsbuilder.getStart());
            ICompletionProvider icompletionprovider = (ICompletionProvider)commandcontext.getSource();
            ArgumentParserSelector argumentparserselector = new ArgumentParserSelector(stringreader, icompletionprovider.c(2), true);
            try {
                argumentparserselector.t();
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
            return argumentparserselector.a(suggestionsbuilder, suggestionsbuilder1 -> {
                Collection<String> collection = icompletionprovider.l();
                Collection<String> iterable = this.k ? collection : Iterables.concat(collection, icompletionprovider.r());
                ICompletionProvider.b(iterable, suggestionsbuilder1);
            });
        }
        return Suggestions.empty();
    }

    public Collection<String> getExamples() {
        return g;
    }

    public static class a
    implements ArgumentSerializer<ArgumentEntity> {
        @Override
        public void a(ArgumentEntity type, PacketDataSerializer buf) {
            byte b0 = 0;
            if (type.j) {
                b0 = (byte)(b0 | 1);
            }
            if (type.k) {
                b0 = (byte)(b0 | 2);
            }
            buf.writeByte(b0);
        }

        public ArgumentEntity a(PacketDataSerializer buf) {
            byte b0 = buf.readByte();
            return new ArgumentEntity((b0 & 1) != 0, (b0 & 2) != 0);
        }

        @Override
        public void a(ArgumentEntity type, JsonObject json) {
            json.addProperty("amount", type.j ? "single" : "multiple");
            json.addProperty("type", type.k ? "players" : "entities");
        }
    }
}

