/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands;

import com.destroystokyo.paper.PaperConfig;
import com.destroystokyo.paper.event.brigadier.AsyncPlayerSendCommandsEvent;
import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import com.mojang.brigadier.AmbiguityConsumer;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.ResultConsumer;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import com.mojang.logging.LogUtils;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.EnumChatFormat;
import net.minecraft.SharedConstants;
import net.minecraft.SystemUtils;
import net.minecraft.commands.CommandException;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICommandListener;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.commands.arguments.ArgumentEntity;
import net.minecraft.commands.synchronization.ArgumentRegistry;
import net.minecraft.commands.synchronization.CompletionProviders;
import net.minecraft.gametest.framework.GameTestHarnessTestCommand;
import net.minecraft.network.chat.ChatClickable;
import net.minecraft.network.chat.ChatComponentText;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.ChatHoverable;
import net.minecraft.network.chat.ChatMessage;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.protocol.game.PacketPlayOutCommands;
import net.minecraft.server.MCUtil;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.commands.CommandAdvancement;
import net.minecraft.server.commands.CommandAttribute;
import net.minecraft.server.commands.CommandBan;
import net.minecraft.server.commands.CommandBanIp;
import net.minecraft.server.commands.CommandBanList;
import net.minecraft.server.commands.CommandBossBar;
import net.minecraft.server.commands.CommandClear;
import net.minecraft.server.commands.CommandClone;
import net.minecraft.server.commands.CommandDatapack;
import net.minecraft.server.commands.CommandDebug;
import net.minecraft.server.commands.CommandDeop;
import net.minecraft.server.commands.CommandDifficulty;
import net.minecraft.server.commands.CommandEffect;
import net.minecraft.server.commands.CommandEnchant;
import net.minecraft.server.commands.CommandExecute;
import net.minecraft.server.commands.CommandFill;
import net.minecraft.server.commands.CommandForceload;
import net.minecraft.server.commands.CommandFunction;
import net.minecraft.server.commands.CommandGamemode;
import net.minecraft.server.commands.CommandGamemodeDefault;
import net.minecraft.server.commands.CommandGamerule;
import net.minecraft.server.commands.CommandGive;
import net.minecraft.server.commands.CommandHelp;
import net.minecraft.server.commands.CommandIdleTimeout;
import net.minecraft.server.commands.CommandKick;
import net.minecraft.server.commands.CommandKill;
import net.minecraft.server.commands.CommandList;
import net.minecraft.server.commands.CommandLocate;
import net.minecraft.server.commands.CommandLocateBiome;
import net.minecraft.server.commands.CommandLoot;
import net.minecraft.server.commands.CommandMe;
import net.minecraft.server.commands.CommandOp;
import net.minecraft.server.commands.CommandPardon;
import net.minecraft.server.commands.CommandPardonIP;
import net.minecraft.server.commands.CommandParticle;
import net.minecraft.server.commands.CommandPlaySound;
import net.minecraft.server.commands.CommandPublish;
import net.minecraft.server.commands.CommandRecipe;
import net.minecraft.server.commands.CommandReload;
import net.minecraft.server.commands.CommandSaveAll;
import net.minecraft.server.commands.CommandSaveOff;
import net.minecraft.server.commands.CommandSaveOn;
import net.minecraft.server.commands.CommandSay;
import net.minecraft.server.commands.CommandSchedule;
import net.minecraft.server.commands.CommandScoreboard;
import net.minecraft.server.commands.CommandSeed;
import net.minecraft.server.commands.CommandSetBlock;
import net.minecraft.server.commands.CommandSetWorldSpawn;
import net.minecraft.server.commands.CommandSpawnpoint;
import net.minecraft.server.commands.CommandSpectate;
import net.minecraft.server.commands.CommandSpreadPlayers;
import net.minecraft.server.commands.CommandStop;
import net.minecraft.server.commands.CommandStopSound;
import net.minecraft.server.commands.CommandSummon;
import net.minecraft.server.commands.CommandTag;
import net.minecraft.server.commands.CommandTeam;
import net.minecraft.server.commands.CommandTeamMsg;
import net.minecraft.server.commands.CommandTeleport;
import net.minecraft.server.commands.CommandTell;
import net.minecraft.server.commands.CommandTellRaw;
import net.minecraft.server.commands.CommandTime;
import net.minecraft.server.commands.CommandTitle;
import net.minecraft.server.commands.CommandTrigger;
import net.minecraft.server.commands.CommandWeather;
import net.minecraft.server.commands.CommandWhitelist;
import net.minecraft.server.commands.CommandWorldBorder;
import net.minecraft.server.commands.CommandXp;
import net.minecraft.server.commands.ItemCommands;
import net.minecraft.server.commands.JfrCommand;
import net.minecraft.server.commands.PerfCommand;
import net.minecraft.server.commands.PlaceFeatureCommand;
import net.minecraft.server.commands.data.CommandData;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.util.profiling.jfr.JvmProfiler;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_18_R2.command.VanillaCommandWrapper;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerCommandSendEvent;
import org.bukkit.event.server.ServerCommandEvent;
import org.slf4j.Logger;
import org.spigotmc.SpigotConfig;

public class CommandDispatcher {
    private static final Logger f = LogUtils.getLogger();
    public static final int a = 0;
    public static final int b = 1;
    public static final int c = 2;
    public static final int d = 3;
    public static final int e = 4;
    private final com.mojang.brigadier.CommandDispatcher<CommandListenerWrapper> g = new com.mojang.brigadier.CommandDispatcher();

    public CommandDispatcher(ServerType environment) {
        this();
        CommandAdvancement.a(this.g);
        CommandAttribute.a(this.g);
        CommandExecute.a(this.g);
        CommandBossBar.a(this.g);
        CommandClear.a(this.g);
        CommandClone.a(this.g);
        CommandData.a(this.g);
        CommandDatapack.a(this.g);
        CommandDebug.a(this.g);
        CommandGamemodeDefault.a(this.g);
        CommandDifficulty.a(this.g);
        CommandEffect.a(this.g);
        CommandMe.a(this.g);
        CommandEnchant.a(this.g);
        CommandXp.a(this.g);
        CommandFill.a(this.g);
        CommandForceload.a(this.g);
        CommandFunction.a(this.g);
        CommandGamemode.a(this.g);
        CommandGamerule.a(this.g);
        CommandGive.a(this.g);
        CommandHelp.a(this.g);
        ItemCommands.a(this.g);
        CommandKick.a(this.g);
        CommandKill.a(this.g);
        CommandList.a(this.g);
        CommandLocate.a(this.g);
        CommandLocateBiome.a(this.g);
        CommandLoot.a(this.g);
        CommandTell.a(this.g);
        CommandParticle.a(this.g);
        PlaceFeatureCommand.a(this.g);
        CommandPlaySound.a(this.g);
        CommandReload.a(this.g);
        CommandRecipe.a(this.g);
        CommandSay.a(this.g);
        CommandSchedule.a(this.g);
        CommandScoreboard.a(this.g);
        CommandSeed.a(this.g, environment != ServerType.c);
        CommandSetBlock.a(this.g);
        CommandSpawnpoint.a(this.g);
        CommandSetWorldSpawn.a(this.g);
        CommandSpectate.a(this.g);
        CommandSpreadPlayers.a(this.g);
        CommandStopSound.a(this.g);
        CommandSummon.a(this.g);
        CommandTag.a(this.g);
        CommandTeam.a(this.g);
        CommandTeamMsg.a(this.g);
        CommandTeleport.a(this.g);
        CommandTellRaw.a(this.g);
        CommandTime.a(this.g);
        CommandTitle.a(this.g);
        CommandTrigger.a(this.g);
        CommandWeather.a(this.g);
        CommandWorldBorder.a(this.g);
        if (JvmProfiler.e.d()) {
            JfrCommand.a(this.g);
        }
        if (SharedConstants.aI) {
            GameTestHarnessTestCommand.a(this.g);
        }
        if (environment.e) {
            CommandBanIp.a(this.g);
            CommandBanList.a(this.g);
            CommandBan.a(this.g);
            CommandDeop.a(this.g);
            CommandOp.a(this.g);
            CommandPardon.a(this.g);
            CommandPardonIP.a(this.g);
            PerfCommand.a(this.g);
            CommandSaveAll.a(this.g);
            CommandSaveOff.a(this.g);
            CommandSaveOn.a(this.g);
            CommandIdleTimeout.a(this.g);
            CommandStop.a(this.g);
            CommandWhitelist.a(this.g);
        }
        if (environment.d) {
            CommandPublish.a(this.g);
        }
        for (CommandNode node : this.g.getRoot().getChildren()) {
            if (node.getRequirement() != ArgumentBuilder.defaultRequirement()) continue;
            node.requirement = stack -> stack.c == ICommandListener.a || stack.getBukkitSender().hasPermission(VanillaCommandWrapper.getPermission(node));
        }
        this.g.findAmbiguities((AmbiguityConsumer<CommandListenerWrapper>)((AmbiguityConsumer)(commandnode, commandnode1, commandnode2, collection) -> {}));
    }

    public CommandDispatcher() {
        this.g.setConsumer((ResultConsumer<CommandListenerWrapper>)((ResultConsumer)(commandcontext, flag, i2) -> ((CommandListenerWrapper)commandcontext.getSource()).a((CommandContext<CommandListenerWrapper>)commandcontext, flag, i2)));
    }

    public int dispatchServerCommand(CommandListenerWrapper sender, String command) {
        Joiner joiner = Joiner.on((String)" ");
        if (command.startsWith("/")) {
            command = command.substring(1);
        }
        ServerCommandEvent event = new ServerCommandEvent(sender.getBukkitSender(), command);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return 0;
        }
        command = event.getCommand();
        Object[] args = command.split(" ");
        if (args.length == 0) {
            return 0;
        }
        String cmd = args[0];
        if (cmd.startsWith("minecraft:")) {
            cmd = cmd.substring("minecraft:".length());
        }
        if (cmd.startsWith("bukkit:")) {
            cmd = cmd.substring("bukkit:".length());
        }
        if (cmd.equalsIgnoreCase("stop") || cmd.equalsIgnoreCase("kick") || cmd.equalsIgnoreCase("op") || cmd.equalsIgnoreCase("deop") || cmd.equalsIgnoreCase("ban") || cmd.equalsIgnoreCase("ban-ip") || cmd.equalsIgnoreCase("pardon") || cmd.equalsIgnoreCase("pardon-ip") || cmd.equalsIgnoreCase("reload")) {
            return 0;
        }
        if (sender.e().getCraftServer().getCommandBlockOverride(args[0])) {
            args[0] = "minecraft:" + (String)args[0];
        }
        String newCommand = joiner.join(args);
        return this.performCommand(sender, newCommand, newCommand, false);
    }

    public int a(CommandListenerWrapper commandSource, String command) {
        return this.performCommand(commandSource, command, command, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int performCommand(CommandListenerWrapper commandlistenerwrapper, String s2, String label, boolean stripSlash) {
        int b0;
        StringReader stringreader = new StringReader(s2);
        if (stripSlash && stringreader.canRead() && stringreader.peek() == '/') {
            stringreader.skip();
        }
        commandlistenerwrapper.j().aN().a(s2);
        try {
            int i2;
            int n2 = i2 = this.g.execute(stringreader, commandlistenerwrapper);
            return n2;
        }
        catch (CommandException commandexception) {
            int b1;
            commandlistenerwrapper.a(commandexception.a());
            int n3 = b1 = 0;
            return n3;
        }
        catch (CommandSyntaxException commandsyntaxexception) {
            int b1;
            int j2;
            commandlistenerwrapper.a(ChatComponentUtils.a(commandsyntaxexception.getRawMessage()));
            if (commandsyntaxexception.getInput() != null && commandsyntaxexception.getCursor() >= 0) {
                j2 = Math.min(commandsyntaxexception.getInput().length(), commandsyntaxexception.getCursor());
                IChatMutableComponent ichatmutablecomponent = new ChatComponentText("").a(EnumChatFormat.h).a(chatmodifier -> chatmodifier.a(new ChatClickable(ChatClickable.EnumClickAction.d, label)));
                if (j2 > 10) {
                    ichatmutablecomponent.c("...");
                }
                ichatmutablecomponent.c(commandsyntaxexception.getInput().substring(Math.max(0, j2 - 10), j2));
                if (j2 < commandsyntaxexception.getInput().length()) {
                    IChatMutableComponent ichatmutablecomponent1 = new ChatComponentText(commandsyntaxexception.getInput().substring(j2)).a(EnumChatFormat.m, EnumChatFormat.t);
                    ichatmutablecomponent.a(ichatmutablecomponent1);
                }
                ichatmutablecomponent.a(new ChatMessage("command.context.here").a(EnumChatFormat.m, EnumChatFormat.u));
                commandlistenerwrapper.a(ichatmutablecomponent);
            }
            j2 = b1 = 0;
            return j2;
        }
        catch (Exception exception) {
            ChatComponentText chatcomponenttext = new ChatComponentText(exception.getMessage() == null ? exception.getClass().getName() : exception.getMessage());
            if (f.isDebugEnabled()) {
                f.error("Command exception: {}", (Object)s2, (Object)exception);
                StackTraceElement[] astacktraceelement = exception.getStackTrace();
                for (int k2 = 0; k2 < Math.min(astacktraceelement.length, 3); ++k2) {
                    chatcomponenttext.c("\n\n").c(astacktraceelement[k2].getMethodName()).c("\n ").c(astacktraceelement[k2].getFileName()).c(":").c(String.valueOf(astacktraceelement[k2].getLineNumber()));
                }
            }
            commandlistenerwrapper.a(new ChatMessage("command.failed").a(chatmodifier -> chatmodifier.a(new ChatHoverable(ChatHoverable.EnumHoverAction.a, chatcomponenttext))));
            if (SharedConstants.aI) {
                commandlistenerwrapper.a(new ChatComponentText(SystemUtils.d(exception)));
                f.error("'{}' threw an exception", (Object)s2, (Object)exception);
            }
            b0 = 0;
        }
        finally {
            commandlistenerwrapper.j().aN().c();
        }
        return b0;
    }

    public void a(EntityPlayer player) {
        if (SpigotConfig.tabComplete < 0) {
            player.b.a(new PacketPlayOutCommands((RootCommandNode<ICompletionProvider>)new RootCommandNode()));
            return;
        }
        MCUtil.scheduleAsyncTask(() -> this.sendAsync(player));
    }

    private void sendAsync(EntityPlayer player) {
        IdentityHashMap map = Maps.newIdentityHashMap();
        RootCommandNode vanillaRoot = new RootCommandNode();
        RootCommandNode<CommandListenerWrapper> vanilla = player.c.vanillaCommandDispatcher.a().getRoot();
        map.put(vanilla, vanillaRoot);
        this.a((CommandNode<CommandListenerWrapper>)vanilla, (CommandNode<ICompletionProvider>)vanillaRoot, player.cQ(), map);
        RootCommandNode rootcommandnode = new RootCommandNode();
        map.put(this.g.getRoot(), rootcommandnode);
        this.a((CommandNode<CommandListenerWrapper>)this.g.getRoot(), (CommandNode<ICompletionProvider>)rootcommandnode, player.cQ(), map);
        LinkedHashSet<String> bukkit = new LinkedHashSet<String>();
        for (CommandNode node : rootcommandnode.getChildren()) {
            bukkit.add(node.getName());
        }
        new AsyncPlayerSendCommandsEvent((Player)player.getBukkitEntity(), rootcommandnode, false).callEvent();
        MinecraftServer.getServer().execute(() -> this.runSync(player, bukkit, (RootCommandNode<ICompletionProvider>)rootcommandnode));
    }

    private void runSync(EntityPlayer player, Collection<String> bukkit, RootCommandNode<ICompletionProvider> rootcommandnode) {
        new AsyncPlayerSendCommandsEvent((Player)player.getBukkitEntity(), rootcommandnode, false).callEvent();
        PlayerCommandSendEvent event = new PlayerCommandSendEvent((Player)player.getBukkitEntity(), new LinkedHashSet<String>(bukkit));
        event.getPlayer().getServer().getPluginManager().callEvent((Event)event);
        for (String orig : bukkit) {
            if (event.getCommands().contains(orig)) continue;
            rootcommandnode.removeCommand(orig);
        }
        player.b.a(new PacketPlayOutCommands(rootcommandnode));
    }

    private void a(CommandNode<CommandListenerWrapper> tree, CommandNode<ICompletionProvider> result, CommandListenerWrapper source, Map<CommandNode<CommandListenerWrapper>, CommandNode<ICompletionProvider>> resultNodes) {
        Iterator<CommandNode<CommandListenerWrapper>> iterator = tree.getChildren().iterator();
        boolean registeredAskServerSuggestionsForTree = false;
        while (iterator.hasNext()) {
            CommandNode<CommandListenerWrapper> commandnode2 = iterator.next();
            if (!SpigotConfig.sendNamespaced && commandnode2.getName().contains(":") || !commandnode2.canUse(source)) continue;
            ArgumentBuilder<CommandListenerWrapper, ?> argumentbuilder = commandnode2.createBuilder();
            argumentbuilder.requires(icompletionprovider -> true);
            if (argumentbuilder.getCommand() != null) {
                argumentbuilder.executes((Command<CommandListenerWrapper>)((Command)commandcontext -> 0));
            }
            if (argumentbuilder instanceof RequiredArgumentBuilder) {
                RequiredArgumentBuilder requiredargumentbuilder = (RequiredArgumentBuilder)argumentbuilder;
                if (requiredargumentbuilder.getSuggestionsProvider() != null) {
                    requiredargumentbuilder.suggests(CompletionProviders.b((SuggestionProvider<ICompletionProvider>)requiredargumentbuilder.getSuggestionsProvider()));
                    registeredAskServerSuggestionsForTree = requiredargumentbuilder.getSuggestionsProvider() == CompletionProviders.a;
                } else if (PaperConfig.fixTargetSelectorTagCompletion && !registeredAskServerSuggestionsForTree && requiredargumentbuilder.getType() instanceof ArgumentEntity) {
                    requiredargumentbuilder.suggests((arg_0, arg_1) -> ((ArgumentType)requiredargumentbuilder.getType()).listSuggestions(arg_0, arg_1));
                    registeredAskServerSuggestionsForTree = true;
                }
            }
            if (argumentbuilder.getRedirect() != null) {
                argumentbuilder.redirect(resultNodes.get(argumentbuilder.getRedirect()));
            }
            CommandNode<ICompletionProvider> commandnode3 = argumentbuilder.build();
            resultNodes.put(commandnode2, commandnode3);
            result.addChild(commandnode3);
            if (commandnode2.getChildren().isEmpty()) continue;
            this.a(commandnode2, commandnode3, source, resultNodes);
        }
    }

    public static LiteralArgumentBuilder<CommandListenerWrapper> a(String literal) {
        return LiteralArgumentBuilder.literal((String)literal);
    }

    public static <T> RequiredArgumentBuilder<CommandListenerWrapper, T> a(String name, ArgumentType<T> type) {
        return RequiredArgumentBuilder.argument((String)name, type);
    }

    public static Predicate<String> a(b parser) {
        return s2 -> {
            try {
                parser.parse(new StringReader(s2));
                return true;
            }
            catch (CommandSyntaxException commandsyntaxexception) {
                return false;
            }
        };
    }

    public com.mojang.brigadier.CommandDispatcher<CommandListenerWrapper> a() {
        return this.g;
    }

    @Nullable
    public static <S> CommandSyntaxException a(ParseResults<S> parse) {
        return !parse.getReader().canRead() ? null : (parse.getExceptions().size() == 1 ? (CommandSyntaxException)((Object)parse.getExceptions().values().iterator().next()) : (parse.getContext().getRange().isEmpty() ? CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownCommand().createWithContext(parse.getReader()) : CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownArgument().createWithContext(parse.getReader())));
    }

    public static void b() {
        RootCommandNode<CommandListenerWrapper> rootcommandnode = new CommandDispatcher(ServerType.a).a().getRoot();
        Set<ArgumentType<?>> set = ArgumentRegistry.a(rootcommandnode);
        Set set1 = set.stream().filter(argumenttype -> !ArgumentRegistry.a(argumenttype)).collect(Collectors.toSet());
        if (!set1.isEmpty()) {
            f.warn("Missing type registration for following arguments:\n {}", (Object)set1.stream().map(argumenttype -> "\t" + argumenttype).collect(Collectors.joining(",\n")));
            throw new IllegalStateException("Unregistered argument types");
        }
    }

    public static enum ServerType {
        a(true, true),
        b(false, true),
        c(true, false);

        final boolean d;
        final boolean e;

        private ServerType(boolean flag, boolean flag1) {
            this.d = flag;
            this.e = flag1;
        }
    }

    @FunctionalInterface
    public static interface b {
        public void parse(StringReader var1) throws CommandSyntaxException;
    }
}

