/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.BuiltInExceptionProvider;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.network.chat.ChatMessage;
import net.minecraft.util.ChatDeserializer;

public abstract class CriterionConditionValue<T extends Number> {
    public static final SimpleCommandExceptionType a = new SimpleCommandExceptionType((Message)new ChatMessage("argument.range.empty"));
    public static final SimpleCommandExceptionType b = new SimpleCommandExceptionType((Message)new ChatMessage("argument.range.swapped"));
    @Nullable
    protected final T c;
    @Nullable
    protected final T d;

    protected CriterionConditionValue(@Nullable T min, @Nullable T max) {
        this.c = min;
        this.d = max;
    }

    @Nullable
    public T a() {
        return this.c;
    }

    @Nullable
    public T b() {
        return this.d;
    }

    public boolean c() {
        return this.c == null && this.d == null;
    }

    public JsonElement d() {
        if (this.c()) {
            return JsonNull.INSTANCE;
        }
        if (this.c != null && this.c.equals(this.d)) {
            return new JsonPrimitive(this.c);
        }
        JsonObject jsonObject = new JsonObject();
        if (this.c != null) {
            jsonObject.addProperty("min", this.c);
        }
        if (this.d != null) {
            jsonObject.addProperty("max", this.d);
        }
        return jsonObject;
    }

    protected static <T extends Number, R extends CriterionConditionValue<T>> R a(@Nullable JsonElement json, R fallback, BiFunction<JsonElement, String, T> asNumber, a<T, R> factory) {
        if (json == null || json.isJsonNull()) {
            return fallback;
        }
        if (ChatDeserializer.b(json)) {
            Number number = (Number)asNumber.apply(json, "value");
            return factory.create(number, number);
        }
        JsonObject jsonObject = ChatDeserializer.m(json, "value");
        Number number2 = jsonObject.has("min") ? (Number)((Number)asNumber.apply(jsonObject.get("min"), "min")) : (Number)null;
        Number number3 = jsonObject.has("max") ? (Number)((Number)asNumber.apply(jsonObject.get("max"), "max")) : (Number)null;
        return factory.create(number2, number3);
    }

    protected static <T extends Number, R extends CriterionConditionValue<T>> R a(StringReader commandReader, b<T, R> commandFactory, Function<String, T> converter, Supplier<DynamicCommandExceptionType> exceptionTypeSupplier, Function<T, T> mapper) throws CommandSyntaxException {
        if (!commandReader.canRead()) {
            throw a.createWithContext((ImmutableStringReader)commandReader);
        }
        int i2 = commandReader.getCursor();
        try {
            Number number3;
            Number number = (Number)CriterionConditionValue.a(CriterionConditionValue.a(commandReader, converter, exceptionTypeSupplier), mapper);
            if (commandReader.canRead(2) && commandReader.peek() == '.' && commandReader.peek(1) == '.') {
                commandReader.skip();
                commandReader.skip();
                Number number2 = (Number)CriterionConditionValue.a(CriterionConditionValue.a(commandReader, converter, exceptionTypeSupplier), mapper);
                if (number == null && number2 == null) {
                    throw a.createWithContext((ImmutableStringReader)commandReader);
                }
            } else {
                number3 = number;
            }
            if (number == null && number3 == null) {
                throw a.createWithContext((ImmutableStringReader)commandReader);
            }
            return commandFactory.create(commandReader, number, number3);
        }
        catch (CommandSyntaxException commandSyntaxException) {
            commandReader.setCursor(i2);
            throw new CommandSyntaxException(commandSyntaxException.getType(), commandSyntaxException.getRawMessage(), commandSyntaxException.getInput(), i2);
        }
    }

    @Nullable
    private static <T extends Number> T a(StringReader reader, Function<String, T> converter, Supplier<DynamicCommandExceptionType> exceptionTypeSupplier) throws CommandSyntaxException {
        int i2 = reader.getCursor();
        while (reader.canRead() && CriterionConditionValue.a(reader)) {
            reader.skip();
        }
        String string = reader.getString().substring(i2, reader.getCursor());
        if (string.isEmpty()) {
            return null;
        }
        try {
            return (T)((Number)converter.apply(string));
        }
        catch (NumberFormatException numberFormatException) {
            throw exceptionTypeSupplier.get().createWithContext((ImmutableStringReader)reader, (Object)string);
        }
    }

    private static boolean a(StringReader reader) {
        char c2 = reader.peek();
        if (c2 >= '0' && c2 <= '9' || c2 == '-') {
            return true;
        }
        if (c2 == '.') {
            return !reader.canRead(2) || reader.peek(1) != '.';
        }
        return false;
    }

    @Nullable
    private static <T> T a(@Nullable T object, Function<T, T> function) {
        return object == null ? null : (T)function.apply(object);
    }

    @FunctionalInterface
    protected static interface a<T extends Number, R extends CriterionConditionValue<T>> {
        public R create(@Nullable T var1, @Nullable T var2);
    }

    @FunctionalInterface
    protected static interface b<T extends Number, R extends CriterionConditionValue<T>> {
        public R create(StringReader var1, @Nullable T var2, @Nullable T var3) throws CommandSyntaxException;
    }

    public static class DoubleRange
    extends CriterionConditionValue<Double> {
        public static final DoubleRange e = new DoubleRange(null, null);
        @Nullable
        private final Double f;
        @Nullable
        private final Double g;

        private static DoubleRange a(StringReader reader, @Nullable Double min, @Nullable Double max) throws CommandSyntaxException {
            if (min != null && max != null && min > max) {
                throw b.createWithContext((ImmutableStringReader)reader);
            }
            return new DoubleRange(min, max);
        }

        @Nullable
        private static Double a(@Nullable Double value) {
            return value == null ? null : Double.valueOf(value * value);
        }

        private DoubleRange(@Nullable Double min, @Nullable Double max) {
            super(min, max);
            this.f = DoubleRange.a(min);
            this.g = DoubleRange.a(max);
        }

        public static DoubleRange a(double value) {
            return new DoubleRange(value, value);
        }

        public static DoubleRange a(double min, double max) {
            return new DoubleRange(min, max);
        }

        public static DoubleRange b(double value) {
            return new DoubleRange(value, null);
        }

        public static DoubleRange c(double value) {
            return new DoubleRange(null, value);
        }

        public boolean d(double value) {
            if (this.c != null && (Double)this.c > value) {
                return false;
            }
            return this.d == null || !((Double)this.d < value);
        }

        public boolean e(double value) {
            if (this.f != null && this.f > value) {
                return false;
            }
            return this.g == null || !(this.g < value);
        }

        public static DoubleRange a(@Nullable JsonElement element) {
            return DoubleRange.a(element, e, ChatDeserializer::d, DoubleRange::new);
        }

        public static DoubleRange a(StringReader reader) throws CommandSyntaxException {
            return DoubleRange.a(reader, (Double value) -> value);
        }

        public static DoubleRange a(StringReader reader, Function<Double, Double> mapper) throws CommandSyntaxException {
            return DoubleRange.a(reader, DoubleRange::a, Double::parseDouble, () -> ((BuiltInExceptionProvider)CommandSyntaxException.BUILT_IN_EXCEPTIONS).readerInvalidDouble(), mapper);
        }
    }

    public static class IntegerRange
    extends CriterionConditionValue<Integer> {
        public static final IntegerRange e = new IntegerRange(null, null);
        @Nullable
        private final Long f;
        @Nullable
        private final Long g;

        private static IntegerRange a(StringReader reader, @Nullable Integer min, @Nullable Integer max) throws CommandSyntaxException {
            if (min != null && max != null && min > max) {
                throw b.createWithContext((ImmutableStringReader)reader);
            }
            return new IntegerRange(min, max);
        }

        @Nullable
        private static Long a(@Nullable Integer value) {
            return value == null ? null : Long.valueOf(value.longValue() * value.longValue());
        }

        private IntegerRange(@Nullable Integer min, @Nullable Integer max) {
            super(min, max);
            this.f = IntegerRange.a(min);
            this.g = IntegerRange.a(max);
        }

        public static IntegerRange a(int value) {
            return new IntegerRange(value, value);
        }

        public static IntegerRange a(int min, int max) {
            return new IntegerRange(min, max);
        }

        public static IntegerRange b(int value) {
            return new IntegerRange(value, null);
        }

        public static IntegerRange c(int value) {
            return new IntegerRange(null, value);
        }

        public boolean d(int value) {
            if (this.c != null && (Integer)this.c > value) {
                return false;
            }
            return this.d == null || (Integer)this.d >= value;
        }

        public boolean a(long value) {
            if (this.f != null && this.f > value) {
                return false;
            }
            return this.g == null || this.g >= value;
        }

        public static IntegerRange a(@Nullable JsonElement element) {
            return IntegerRange.a(element, e, ChatDeserializer::g, IntegerRange::new);
        }

        public static IntegerRange a(StringReader reader) throws CommandSyntaxException {
            return IntegerRange.a(reader, (Integer value) -> value);
        }

        public static IntegerRange a(StringReader reader, Function<Integer, Integer> converter) throws CommandSyntaxException {
            return IntegerRange.a(reader, IntegerRange::a, Integer::parseInt, () -> ((BuiltInExceptionProvider)CommandSyntaxException.BUILT_IN_EXCEPTIONS).readerInvalidInt(), converter);
        }
    }
}

