/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.CriterionConditionNBT;
import net.minecraft.advancements.critereon.CriterionTriggerProperties;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IRegistry;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;

public class CriterionConditionBlock {
    public static final CriterionConditionBlock a = new CriterionConditionBlock(null, null, CriterionTriggerProperties.a, CriterionConditionNBT.a);
    @Nullable
    private final TagKey<Block> b;
    @Nullable
    private final Set<Block> c;
    private final CriterionTriggerProperties d;
    private final CriterionConditionNBT e;

    public CriterionConditionBlock(@Nullable TagKey<Block> tag, @Nullable Set<Block> blocks, CriterionTriggerProperties state, CriterionConditionNBT nbt) {
        this.b = tag;
        this.c = blocks;
        this.d = state;
        this.e = nbt;
    }

    public boolean a(WorldServer world, BlockPosition pos) {
        TileEntity blockEntity;
        if (this == a) {
            return true;
        }
        if (!world.n(pos)) {
            return false;
        }
        IBlockData blockState = world.a_(pos);
        if (this.b != null && !blockState.a(this.b)) {
            return false;
        }
        if (this.c != null && !this.c.contains(blockState.b())) {
            return false;
        }
        if (!this.d.a(blockState)) {
            return false;
        }
        return this.e == CriterionConditionNBT.a || (blockEntity = world.c_(pos)) != null && this.e.a(blockEntity.m());
    }

    public static CriterionConditionBlock a(@Nullable JsonElement json) {
        if (json == null || json.isJsonNull()) {
            return a;
        }
        JsonObject jsonObject = ChatDeserializer.m(json, "block");
        CriterionConditionNBT nbtPredicate = CriterionConditionNBT.a(jsonObject.get("nbt"));
        ImmutableSet set = null;
        JsonArray jsonArray = ChatDeserializer.a(jsonObject, "blocks", null);
        if (jsonArray != null) {
            ImmutableSet.Builder builder = ImmutableSet.builder();
            for (JsonElement jsonElement : jsonArray) {
                MinecraftKey resourceLocation = new MinecraftKey(ChatDeserializer.a(jsonElement, "block"));
                builder.add((Object)IRegistry.U.b(resourceLocation).orElseThrow(() -> new JsonSyntaxException("Unknown block id '" + resourceLocation + "'")));
            }
            set = builder.build();
        }
        TagKey<Block> tagKey = null;
        if (jsonObject.has("tag")) {
            MinecraftKey resourceLocation2 = new MinecraftKey(ChatDeserializer.h(jsonObject, "tag"));
            tagKey = TagKey.a(IRegistry.h, resourceLocation2);
        }
        CriterionTriggerProperties statePropertiesPredicate = CriterionTriggerProperties.a(jsonObject.get("state"));
        return new CriterionConditionBlock(tagKey, (Set<Block>)set, statePropertiesPredicate, nbtPredicate);
    }

    public JsonElement a() {
        if (this == a) {
            return JsonNull.INSTANCE;
        }
        JsonObject jsonObject = new JsonObject();
        if (this.c != null) {
            JsonArray jsonArray = new JsonArray();
            for (Block block : this.c) {
                jsonArray.add(IRegistry.U.b(block).toString());
            }
            jsonObject.add("blocks", (JsonElement)jsonArray);
        }
        if (this.b != null) {
            jsonObject.addProperty("tag", this.b.b().toString());
        }
        jsonObject.add("nbt", this.e.a());
        jsonObject.add("state", this.d.a());
        return jsonObject;
    }

    public static class a {
        @Nullable
        private Set<Block> a;
        @Nullable
        private TagKey<Block> b;
        private CriterionTriggerProperties c = CriterionTriggerProperties.a;
        private CriterionConditionNBT d = CriterionConditionNBT.a;

        private a() {
        }

        public static a a() {
            return new a();
        }

        public a a(Block ... blocks) {
            this.a = ImmutableSet.copyOf((Object[])blocks);
            return this;
        }

        public a a(Iterable<Block> blocks) {
            this.a = ImmutableSet.copyOf(blocks);
            return this;
        }

        public a a(TagKey<Block> tag) {
            this.b = tag;
            return this;
        }

        public a a(NBTTagCompound nbt) {
            this.d = new CriterionConditionNBT(nbt);
            return this;
        }

        public a a(CriterionTriggerProperties state) {
            this.c = state;
            return this;
        }

        public CriterionConditionBlock b() {
            return new CriterionConditionBlock(this.b, this.a, this.c, this.d);
        }
    }
}

