/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.EnumChatFormat;
import net.minecraft.advancements.AdvancementDisplay;
import net.minecraft.advancements.AdvancementFrameType;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionInstance;
import net.minecraft.advancements.critereon.LootDeserializationContext;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.chat.ChatComponentText;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.ChatHoverable;
import net.minecraft.network.chat.ChatModifier;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.IMaterial;
import org.apache.commons.lang3.ArrayUtils;
import org.bukkit.craftbukkit.v1_18_R2.advancement.CraftAdvancement;

public class Advancement {
    @Nullable
    private final Advancement a;
    @Nullable
    private final AdvancementDisplay b;
    private final AdvancementRewards c;
    private final MinecraftKey d;
    private final Map<String, Criterion> e;
    private final String[][] f;
    private final Set<Advancement> g = Sets.newLinkedHashSet();
    private final IChatBaseComponent h;
    public final org.bukkit.advancement.Advancement bukkit = new CraftAdvancement(this);

    public Advancement(MinecraftKey id, @Nullable Advancement parent, @Nullable AdvancementDisplay display, AdvancementRewards rewards, Map<String, Criterion> criteria, String[][] requirements) {
        this.d = id;
        this.b = display;
        this.e = ImmutableMap.copyOf(criteria);
        this.a = parent;
        this.c = rewards;
        this.f = requirements;
        if (parent != null) {
            parent.a(this);
        }
        if (display == null) {
            this.h = new ChatComponentText(id.toString());
        } else {
            IChatBaseComponent ichatbasecomponent = display.a();
            EnumChatFormat enumchatformat = display.e().c();
            IChatMutableComponent ichatmutablecomponent = ChatComponentUtils.a(ichatbasecomponent.e(), ChatModifier.a.a(enumchatformat)).c("\n").a(display.b());
            IChatMutableComponent ichatmutablecomponent1 = ichatbasecomponent.e().a(chatmodifier -> chatmodifier.a(new ChatHoverable(ChatHoverable.EnumHoverAction.a, ichatmutablecomponent)));
            this.h = ChatComponentUtils.a(ichatmutablecomponent1).a(enumchatformat);
        }
    }

    public SerializedAdvancement a() {
        return new SerializedAdvancement(this.a == null ? null : this.a.h(), this.b, this.c, this.e, this.f);
    }

    @Nullable
    public Advancement b() {
        return this.a;
    }

    @Nullable
    public AdvancementDisplay c() {
        return this.b;
    }

    public AdvancementRewards d() {
        return this.c;
    }

    public String toString() {
        MinecraftKey minecraftkey = this.h();
        return "SimpleAdvancement{id=" + minecraftkey + ", parent=" + (Comparable)(this.a == null ? "null" : this.a.h()) + ", display=" + this.b + ", rewards=" + this.c + ", criteria=" + this.e + ", requirements=" + Arrays.deepToString((Object[])this.f) + "}";
    }

    public Iterable<Advancement> e() {
        return this.g;
    }

    public Map<String, Criterion> f() {
        return this.e;
    }

    public int g() {
        return this.f.length;
    }

    public void a(Advancement child) {
        this.g.add(child);
    }

    public MinecraftKey h() {
        return this.d;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Advancement)) {
            return false;
        }
        Advancement advancement = (Advancement)object;
        return this.d.equals(advancement.d);
    }

    public int hashCode() {
        return this.d.hashCode();
    }

    public String[][] i() {
        return this.f;
    }

    public IChatBaseComponent j() {
        return this.h;
    }

    public static class SerializedAdvancement {
        @Nullable
        private MinecraftKey a;
        @Nullable
        private Advancement b;
        @Nullable
        private AdvancementDisplay c;
        private AdvancementRewards d = AdvancementRewards.a;
        private Map<String, Criterion> e = Maps.newLinkedHashMap();
        @Nullable
        private String[][] f;
        private AdvancementRequirements g = AdvancementRequirements.a;

        SerializedAdvancement(@Nullable MinecraftKey parentId, @Nullable AdvancementDisplay display, AdvancementRewards rewards, Map<String, Criterion> criteria, String[][] requirements) {
            this.a = parentId;
            this.c = display;
            this.d = rewards;
            this.e = criteria;
            this.f = requirements;
        }

        private SerializedAdvancement() {
        }

        public static SerializedAdvancement a() {
            return new SerializedAdvancement();
        }

        public SerializedAdvancement a(Advancement parent) {
            this.b = parent;
            return this;
        }

        public SerializedAdvancement a(MinecraftKey parentId) {
            this.a = parentId;
            return this;
        }

        public SerializedAdvancement a(ItemStack icon, IChatBaseComponent title, IChatBaseComponent description, @Nullable MinecraftKey background, AdvancementFrameType frame, boolean showToast, boolean announceToChat, boolean hidden) {
            return this.a(new AdvancementDisplay(icon, title, description, background, frame, showToast, announceToChat, hidden));
        }

        public SerializedAdvancement a(IMaterial icon, IChatBaseComponent title, IChatBaseComponent description, @Nullable MinecraftKey background, AdvancementFrameType frame, boolean showToast, boolean announceToChat, boolean hidden) {
            return this.a(new AdvancementDisplay(new ItemStack(icon.l()), title, description, background, frame, showToast, announceToChat, hidden));
        }

        public SerializedAdvancement a(AdvancementDisplay display) {
            this.c = display;
            return this;
        }

        public SerializedAdvancement a(AdvancementRewards.a builder) {
            return this.a(builder.a());
        }

        public SerializedAdvancement a(AdvancementRewards rewards) {
            this.d = rewards;
            return this;
        }

        public SerializedAdvancement a(String name, CriterionInstance conditions) {
            return this.a(name, new Criterion(conditions));
        }

        public SerializedAdvancement a(String name, Criterion criterion) {
            if (this.e.containsKey(name)) {
                throw new IllegalArgumentException("Duplicate criterion " + name);
            }
            this.e.put(name, criterion);
            return this;
        }

        public SerializedAdvancement a(AdvancementRequirements merger) {
            this.g = merger;
            return this;
        }

        public SerializedAdvancement a(String[][] requirements) {
            this.f = requirements;
            return this;
        }

        public boolean a(Function<MinecraftKey, Advancement> parentProvider) {
            if (this.a == null) {
                return true;
            }
            if (this.b == null) {
                this.b = parentProvider.apply(this.a);
            }
            return this.b != null;
        }

        public Advancement b(MinecraftKey id) {
            if (!this.a((MinecraftKey minecraftkey1) -> null)) {
                throw new IllegalStateException("Tried to build incomplete advancement!");
            }
            if (this.f == null) {
                this.f = this.g.createRequirements(this.e.keySet());
            }
            return new Advancement(id, this.b, this.c, this.d, this.e, this.f);
        }

        public Advancement a(Consumer<Advancement> consumer, String id) {
            Advancement advancement = this.b(new MinecraftKey(id));
            consumer.accept(advancement);
            return advancement;
        }

        public JsonObject b() {
            if (this.f == null) {
                this.f = this.g.createRequirements(this.e.keySet());
            }
            JsonObject jsonobject = new JsonObject();
            if (this.b != null) {
                jsonobject.addProperty("parent", this.b.h().toString());
            } else if (this.a != null) {
                jsonobject.addProperty("parent", this.a.toString());
            }
            if (this.c != null) {
                jsonobject.add("display", this.c.k());
            }
            jsonobject.add("rewards", this.d.b());
            JsonObject jsonobject1 = new JsonObject();
            for (Map.Entry<String, Criterion> entry : this.e.entrySet()) {
                jsonobject1.add(entry.getKey(), entry.getValue().b());
            }
            jsonobject.add("criteria", (JsonElement)jsonobject1);
            JsonArray jsonarray = new JsonArray();
            for (String[] astring1 : this.f) {
                JsonArray jsonarray1 = new JsonArray();
                String[] astring2 = astring1;
                int k2 = astring1.length;
                for (int l2 = 0; l2 < k2; ++l2) {
                    String s2 = astring2[l2];
                    jsonarray1.add(s2);
                }
                jsonarray.add((JsonElement)jsonarray1);
            }
            jsonobject.add("requirements", (JsonElement)jsonarray);
            return jsonobject;
        }

        public void a(PacketDataSerializer buf) {
            if (this.f == null) {
                this.f = this.g.createRequirements(this.e.keySet());
            }
            if (this.a == null) {
                buf.writeBoolean(false);
            } else {
                buf.writeBoolean(true);
                buf.a(this.a);
            }
            if (this.c == null) {
                buf.writeBoolean(false);
            } else {
                buf.writeBoolean(true);
                this.c.a(buf);
            }
            Criterion.a(this.e, buf);
            buf.d(this.f.length);
            for (String[] astring1 : this.f) {
                buf.d(astring1.length);
                String[] astring2 = astring1;
                int k2 = astring1.length;
                for (int l2 = 0; l2 < k2; ++l2) {
                    String s2 = astring2[l2];
                    buf.a(s2);
                }
            }
        }

        public String toString() {
            return "Task Advancement{parentId=" + this.a + ", display=" + this.c + ", rewards=" + this.d + ", criteria=" + this.e + ", requirements=" + Arrays.deepToString((Object[])this.f) + "}";
        }

        public static SerializedAdvancement a(JsonObject obj, LootDeserializationContext predicateDeserializer) {
            int l2;
            int j2;
            int i2;
            MinecraftKey minecraftkey = obj.has("parent") ? new MinecraftKey(ChatDeserializer.h(obj, "parent")) : null;
            AdvancementDisplay advancementdisplay = obj.has("display") ? AdvancementDisplay.a(ChatDeserializer.t(obj, "display")) : null;
            AdvancementRewards advancementrewards = obj.has("rewards") ? AdvancementRewards.a(ChatDeserializer.t(obj, "rewards")) : AdvancementRewards.a;
            Map<String, Criterion> map = Criterion.b(ChatDeserializer.t(obj, "criteria"), predicateDeserializer);
            if (map.isEmpty()) {
                throw new JsonSyntaxException("Advancement criteria cannot be empty");
            }
            JsonArray jsonarray = ChatDeserializer.a(obj, "requirements", new JsonArray());
            String[][] astring = new String[jsonarray.size()][];
            for (i2 = 0; i2 < jsonarray.size(); ++i2) {
                JsonArray jsonarray1 = ChatDeserializer.n(jsonarray.get(i2), "requirements[" + i2 + "]");
                astring[i2] = new String[jsonarray1.size()];
                for (j2 = 0; j2 < jsonarray1.size(); ++j2) {
                    astring[i2][j2] = ChatDeserializer.a(jsonarray1.get(j2), "requirements[" + i2 + "][" + j2 + "]");
                }
            }
            if (astring.length == 0) {
                astring = new String[map.size()][];
                i2 = 0;
                for (String s2 : map.keySet()) {
                    astring[i2++] = new String[]{s2};
                }
            }
            String[][] astring1 = astring;
            int k2 = astring.length;
            for (j2 = 0; j2 < k2; ++j2) {
                String[] astring2 = astring1[j2];
                if (astring2.length == 0 && map.isEmpty()) {
                    throw new JsonSyntaxException("Requirement entry cannot be empty");
                }
                String[] astring3 = astring2;
                l2 = astring2.length;
                for (int i1 = 0; i1 < l2; ++i1) {
                    String s1 = astring3[i1];
                    if (map.containsKey(s1)) continue;
                    throw new JsonSyntaxException("Unknown required criterion '" + s1 + "'");
                }
            }
            for (String s2 : map.keySet()) {
                boolean flag = false;
                String[][] astring4 = astring;
                int j1 = astring.length;
                for (l2 = 0; l2 < j1; ++l2) {
                    Object[] astring5 = astring4[l2];
                    if (!ArrayUtils.contains((Object[])astring5, (Object)s2)) {
                        continue;
                    }
                    flag = true;
                    break;
                }
                if (flag) continue;
                throw new JsonSyntaxException("Criterion '" + s2 + "' isn't a requirement for completion. This isn't supported behaviour, all criteria must be required.");
            }
            return new SerializedAdvancement(minecraftkey, advancementdisplay, advancementrewards, map, astring);
        }

        public static SerializedAdvancement b(PacketDataSerializer buf) {
            MinecraftKey minecraftkey = buf.readBoolean() ? buf.q() : null;
            AdvancementDisplay advancementdisplay = buf.readBoolean() ? AdvancementDisplay.b(buf) : null;
            Map<String, Criterion> map = Criterion.c(buf);
            String[][] astring = new String[buf.j()][];
            for (int i2 = 0; i2 < astring.length; ++i2) {
                astring[i2] = new String[buf.j()];
                for (int j2 = 0; j2 < astring[i2].length; ++j2) {
                    astring[i2][j2] = buf.p();
                }
            }
            return new SerializedAdvancement(minecraftkey, advancementdisplay, AdvancementRewards.a, map, astring);
        }

        public Map<String, Criterion> c() {
            return this.e;
        }
    }
}

