/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.world.structure;

import io.papermc.paper.registry.PaperRegistry;
import io.papermc.paper.registry.RegistryKey;
import io.papermc.paper.world.structure.ConfiguredStructure;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.core.IRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.StructureGenerator;
import org.bukkit.NamespacedKey;
import org.bukkit.StructureType;

public final class PaperConfiguredStructure {
    private PaperConfiguredStructure() {
    }

    public static void init() {
        new ConfiguredStructureRegistry().register();
    }

    static final class ConfiguredStructureRegistry
    extends PaperRegistry<ConfiguredStructure, StructureFeature<?, ?>> {
        private static final Supplier<IRegistry<StructureGenerator<?>>> STRUCTURE_FEATURE_REGISTRY = ConfiguredStructureRegistry.registryFor(IRegistry.aW);

        public ConfiguredStructureRegistry() {
            super(RegistryKey.CONFIGURED_STRUCTURE_REGISTRY);
        }

        @Override
        public ConfiguredStructure convertToApi(NamespacedKey key, StructureFeature<?, ?> nms) {
            MinecraftKey structureFeatureLoc = Objects.requireNonNull(STRUCTURE_FEATURE_REGISTRY.get().b((StructureGenerator<?>)nms.d));
            StructureType structureType = Objects.requireNonNull((StructureType)StructureType.getStructureTypes().get(structureFeatureLoc.a()), structureFeatureLoc + " could not be converted to an API type");
            return new ConfiguredStructure(key, structureType);
        }
    }
}

