/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.world;

import com.destroystokyo.paper.util.maplist.EntityList;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.server.level.PlayerChunk;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.boss.EntityComplexPart;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderDragon;
import net.minecraft.world.phys.AxisAlignedBB;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftEntity;
import org.bukkit.entity.Entity;

public final class ChunkEntitySlices {
    protected final int minSection;
    protected final int maxSection;
    protected final int chunkX;
    protected final int chunkZ;
    protected final WorldServer world;
    protected final EntityCollectionBySection allEntities;
    protected final EntityCollectionBySection hardCollidingEntities;
    protected final Reference2ObjectOpenHashMap<Class<? extends net.minecraft.world.entity.Entity>, EntityCollectionBySection> entitiesByClass;
    protected final EntityList entities = new EntityList();
    public PlayerChunk.State status;

    public ChunkEntitySlices(WorldServer world, int chunkX, int chunkZ, PlayerChunk.State status, int minSection, int maxSection) {
        this.minSection = minSection;
        this.maxSection = maxSection;
        this.chunkX = chunkX;
        this.chunkZ = chunkZ;
        this.world = world;
        this.allEntities = new EntityCollectionBySection(this);
        this.hardCollidingEntities = new EntityCollectionBySection(this);
        this.entitiesByClass = new Reference2ObjectOpenHashMap();
        this.status = status;
    }

    public Entity[] getChunkEntities() {
        ArrayList<CraftEntity> ret = new ArrayList<CraftEntity>();
        net.minecraft.world.entity.Entity[] entities = this.entities.getRawData();
        int size = Math.min(entities.length, this.entities.size());
        for (int i2 = 0; i2 < size; ++i2) {
            CraftEntity bukkit;
            net.minecraft.world.entity.Entity entity = entities[i2];
            if (entity == null || (bukkit = entity.getBukkitEntity()) == null || !bukkit.isValid()) continue;
            ret.add(bukkit);
        }
        return ret.toArray(new Entity[0]);
    }

    public boolean isEmpty() {
        return this.entities.size() == 0;
    }

    private void updateTicketLevels() {
        net.minecraft.world.entity.Entity[] entities = this.entities.getRawData();
        int size = Math.min(entities.length, this.entities.size());
        for (int i2 = 0; i2 < size; ++i2) {
            net.minecraft.world.entity.Entity entity = entities[i2];
            entity.chunkStatus = this.status;
        }
    }

    public synchronized void updateStatus(PlayerChunk.State status) {
        this.status = status;
        this.updateTicketLevels();
    }

    public synchronized void addEntity(net.minecraft.world.entity.Entity entity, int chunkSection) {
        if (!this.entities.add(entity)) {
            return;
        }
        entity.chunkStatus = this.status;
        int sectionIndex = chunkSection - this.minSection;
        this.allEntities.addEntity(entity, sectionIndex);
        if (entity.hardCollides()) {
            this.hardCollidingEntities.addEntity(entity, sectionIndex);
        }
        ObjectIterator iterator = this.entitiesByClass.reference2ObjectEntrySet().fastIterator();
        while (iterator.hasNext()) {
            Reference2ObjectMap.Entry entry = (Reference2ObjectMap.Entry)iterator.next();
            if (!((Class)entry.getKey()).isInstance(entity)) continue;
            ((EntityCollectionBySection)entry.getValue()).addEntity(entity, sectionIndex);
        }
    }

    public synchronized void removeEntity(net.minecraft.world.entity.Entity entity, int chunkSection) {
        if (!this.entities.remove(entity)) {
            return;
        }
        entity.chunkStatus = PlayerChunk.State.a;
        int sectionIndex = chunkSection - this.minSection;
        this.allEntities.removeEntity(entity, sectionIndex);
        if (entity.hardCollides()) {
            this.hardCollidingEntities.removeEntity(entity, sectionIndex);
        }
        ObjectIterator iterator = this.entitiesByClass.reference2ObjectEntrySet().fastIterator();
        while (iterator.hasNext()) {
            Reference2ObjectMap.Entry entry = (Reference2ObjectMap.Entry)iterator.next();
            if (!((Class)entry.getKey()).isInstance(entity)) continue;
            ((EntityCollectionBySection)entry.getValue()).removeEntity(entity, sectionIndex);
        }
    }

    public void getHardCollidingEntities(net.minecraft.world.entity.Entity except, AxisAlignedBB box, List<net.minecraft.world.entity.Entity> into, Predicate<? super net.minecraft.world.entity.Entity> predicate) {
        this.hardCollidingEntities.getEntities(except, box, into, predicate);
    }

    public void getEntities(net.minecraft.world.entity.Entity except, AxisAlignedBB box, List<net.minecraft.world.entity.Entity> into, Predicate<? super net.minecraft.world.entity.Entity> predicate) {
        this.allEntities.getEntitiesWithEnderDragonParts(except, box, into, predicate);
    }

    public <T extends net.minecraft.world.entity.Entity> void getEntities(EntityTypes<?> type, AxisAlignedBB box, List<? super T> into, Predicate<? super T> predicate) {
        this.allEntities.getEntities(type, box, into, predicate);
    }

    protected EntityCollectionBySection initClass(Class<? extends net.minecraft.world.entity.Entity> clazz) {
        EntityCollectionBySection ret = new EntityCollectionBySection(this);
        for (int sectionIndex = 0; sectionIndex < this.allEntities.entitiesBySection.length; ++sectionIndex) {
            BasicEntityList<net.minecraft.world.entity.Entity> sectionEntities = this.allEntities.entitiesBySection[sectionIndex];
            if (sectionEntities == null) continue;
            E[] storage = sectionEntities.storage;
            int len = Math.min(storage.length, sectionEntities.size());
            for (int i2 = 0; i2 < len; ++i2) {
                Object entity = storage[i2];
                if (!clazz.isInstance(entity)) continue;
                ret.addEntity((net.minecraft.world.entity.Entity)entity, sectionIndex);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends net.minecraft.world.entity.Entity> void getEntities(Class<? extends T> clazz, net.minecraft.world.entity.Entity except, AxisAlignedBB box, List<? super T> into, Predicate<? super T> predicate) {
        EntityCollectionBySection collection = (EntityCollectionBySection)this.entitiesByClass.get(clazz);
        if (collection != null) {
            collection.getEntitiesWithEnderDragonParts(except, clazz, box, into, predicate);
        } else {
            ChunkEntitySlices chunkEntitySlices = this;
            synchronized (chunkEntitySlices) {
                collection = this.initClass(clazz);
                this.entitiesByClass.putIfAbsent(clazz, (Object)collection);
            }
            collection.getEntitiesWithEnderDragonParts(except, clazz, box, into, predicate);
        }
    }

    public synchronized void updateEntity(net.minecraft.world.entity.Entity entity) {
    }

    protected static final class EntityCollectionBySection {
        protected final ChunkEntitySlices manager;
        protected final long[] nonEmptyBitset;
        protected final BasicEntityList<net.minecraft.world.entity.Entity>[] entitiesBySection;
        protected int count;

        public EntityCollectionBySection(ChunkEntitySlices manager) {
            this.manager = manager;
            int sectionCount = manager.maxSection - manager.minSection + 1;
            this.nonEmptyBitset = new long[sectionCount + 63 >>> 6];
            this.entitiesBySection = new BasicEntityList[sectionCount];
        }

        public void addEntity(net.minecraft.world.entity.Entity entity, int sectionIndex) {
            BasicEntityList<net.minecraft.world.entity.Entity> list = this.entitiesBySection[sectionIndex];
            if (list != null && list.has(entity)) {
                return;
            }
            if (list == null) {
                this.entitiesBySection[sectionIndex] = list = new BasicEntityList();
                int n2 = sectionIndex >>> 6;
                this.nonEmptyBitset[n2] = this.nonEmptyBitset[n2] | 1L << (sectionIndex & 0x3F);
            }
            list.add(entity);
            ++this.count;
        }

        public void removeEntity(net.minecraft.world.entity.Entity entity, int sectionIndex) {
            BasicEntityList<net.minecraft.world.entity.Entity> list = this.entitiesBySection[sectionIndex];
            if (list == null || !list.remove(entity)) {
                return;
            }
            --this.count;
            if (list.isEmpty()) {
                this.entitiesBySection[sectionIndex] = null;
                int n2 = sectionIndex >>> 6;
                this.nonEmptyBitset[n2] = this.nonEmptyBitset[n2] ^ 1L << (sectionIndex & 0x3F);
            }
        }

        public void getEntities(net.minecraft.world.entity.Entity except, AxisAlignedBB box, List<net.minecraft.world.entity.Entity> into, Predicate<? super net.minecraft.world.entity.Entity> predicate) {
            if (this.count == 0) {
                return;
            }
            int minSection = this.manager.minSection;
            int maxSection = this.manager.maxSection;
            int min = MathHelper.a(MathHelper.b(box.b - 2.0) >> 4, minSection, maxSection);
            int max = MathHelper.a(MathHelper.b(box.e + 2.0) >> 4, minSection, maxSection);
            BasicEntityList<net.minecraft.world.entity.Entity>[] entitiesBySection = this.entitiesBySection;
            for (int section = min; section <= max; ++section) {
                BasicEntityList<net.minecraft.world.entity.Entity> list = entitiesBySection[section - minSection];
                if (list == null) continue;
                E[] storage = list.storage;
                int len = Math.min(storage.length, list.size());
                for (int i2 = 0; i2 < len; ++i2) {
                    Object entity = storage[i2];
                    if (entity == null || entity == except || !((net.minecraft.world.entity.Entity)entity).cw().c(box) || predicate != null && !predicate.test((net.minecraft.world.entity.Entity)entity)) continue;
                    into.add((net.minecraft.world.entity.Entity)entity);
                }
            }
        }

        public void getEntitiesWithEnderDragonParts(net.minecraft.world.entity.Entity except, AxisAlignedBB box, List<net.minecraft.world.entity.Entity> into, Predicate<? super net.minecraft.world.entity.Entity> predicate) {
            if (this.count == 0) {
                return;
            }
            int minSection = this.manager.minSection;
            int maxSection = this.manager.maxSection;
            int min = MathHelper.a(MathHelper.b(box.b - 2.0) >> 4, minSection, maxSection);
            int max = MathHelper.a(MathHelper.b(box.e + 2.0) >> 4, minSection, maxSection);
            BasicEntityList<net.minecraft.world.entity.Entity>[] entitiesBySection = this.entitiesBySection;
            for (int section = min; section <= max; ++section) {
                BasicEntityList<net.minecraft.world.entity.Entity> list = entitiesBySection[section - minSection];
                if (list == null) continue;
                E[] storage = list.storage;
                int len = Math.min(storage.length, list.size());
                for (int i2 = 0; i2 < len; ++i2) {
                    Object entity = storage[i2];
                    if (entity == null || entity == except || !((net.minecraft.world.entity.Entity)entity).cw().c(box)) continue;
                    if (predicate == null || predicate.test((net.minecraft.world.entity.Entity)entity)) {
                        into.add((net.minecraft.world.entity.Entity)entity);
                    }
                    if (!(entity instanceof EntityEnderDragon)) continue;
                    for (EntityComplexPart part : ((EntityEnderDragon)entity).ch) {
                        if (part == except || !part.cw().c(box) || predicate != null && !predicate.test(part)) continue;
                        into.add(part);
                    }
                }
            }
        }

        public void getEntitiesWithEnderDragonParts(net.minecraft.world.entity.Entity except, Class<?> clazz, AxisAlignedBB box, List<net.minecraft.world.entity.Entity> into, Predicate<? super net.minecraft.world.entity.Entity> predicate) {
            if (this.count == 0) {
                return;
            }
            int minSection = this.manager.minSection;
            int maxSection = this.manager.maxSection;
            int min = MathHelper.a(MathHelper.b(box.b - 2.0) >> 4, minSection, maxSection);
            int max = MathHelper.a(MathHelper.b(box.e + 2.0) >> 4, minSection, maxSection);
            BasicEntityList<net.minecraft.world.entity.Entity>[] entitiesBySection = this.entitiesBySection;
            for (int section = min; section <= max; ++section) {
                BasicEntityList<net.minecraft.world.entity.Entity> list = entitiesBySection[section - minSection];
                if (list == null) continue;
                E[] storage = list.storage;
                int len = Math.min(storage.length, list.size());
                for (int i2 = 0; i2 < len; ++i2) {
                    Object entity = storage[i2];
                    if (entity == null || entity == except || !((net.minecraft.world.entity.Entity)entity).cw().c(box)) continue;
                    if (predicate == null || predicate.test((net.minecraft.world.entity.Entity)entity)) {
                        into.add((net.minecraft.world.entity.Entity)entity);
                    }
                    if (!(entity instanceof EntityEnderDragon)) continue;
                    for (EntityComplexPart part : ((EntityEnderDragon)entity).ch) {
                        if (part == except || !part.cw().c(box) || !clazz.isInstance(part) || predicate != null && !predicate.test(part)) continue;
                        into.add(part);
                    }
                }
            }
        }

        public <T extends net.minecraft.world.entity.Entity> void getEntities(EntityTypes<?> type, AxisAlignedBB box, List<? super T> into, Predicate<? super T> predicate) {
            if (this.count == 0) {
                return;
            }
            int minSection = this.manager.minSection;
            int maxSection = this.manager.maxSection;
            int min = MathHelper.a(MathHelper.b(box.b - 2.0) >> 4, minSection, maxSection);
            int max = MathHelper.a(MathHelper.b(box.e + 2.0) >> 4, minSection, maxSection);
            BasicEntityList<net.minecraft.world.entity.Entity>[] entitiesBySection = this.entitiesBySection;
            for (int section = min; section <= max; ++section) {
                BasicEntityList<net.minecraft.world.entity.Entity> list = entitiesBySection[section - minSection];
                if (list == null) continue;
                E[] storage = list.storage;
                int len = Math.min(storage.length, list.size());
                for (int i2 = 0; i2 < len; ++i2) {
                    Object entity = storage[i2];
                    if (entity == null || type != null && ((net.minecraft.world.entity.Entity)entity).ad() != type || !((net.minecraft.world.entity.Entity)entity).cw().c(box) || predicate != null && !predicate.test(entity)) continue;
                    into.add(entity);
                }
            }
        }
    }

    protected static final class BasicEntityList<E extends net.minecraft.world.entity.Entity> {
        protected static final net.minecraft.world.entity.Entity[] EMPTY = new net.minecraft.world.entity.Entity[0];
        protected static final int DEFAULT_CAPACITY = 4;
        protected E[] storage;
        protected int size;

        public BasicEntityList() {
            this(0);
        }

        public BasicEntityList(int cap) {
            this.storage = cap <= 0 ? EMPTY : new net.minecraft.world.entity.Entity[cap];
        }

        public boolean isEmpty() {
            return this.size == 0;
        }

        public int size() {
            return this.size;
        }

        private void resize() {
            this.storage = this.storage == EMPTY ? new net.minecraft.world.entity.Entity[4] : (net.minecraft.world.entity.Entity[])Arrays.copyOf(this.storage, this.storage.length * 2);
        }

        public void add(E entity) {
            int idx;
            if ((idx = this.size++) >= this.storage.length) {
                this.resize();
                this.storage[idx] = entity;
            } else {
                this.storage[idx] = entity;
            }
        }

        public int indexOf(E entity) {
            E[] storage = this.storage;
            int len = Math.min(this.storage.length, this.size);
            for (int i2 = 0; i2 < len; ++i2) {
                if (storage[i2] != entity) continue;
                return i2;
            }
            return -1;
        }

        public boolean remove(E entity) {
            int idx = this.indexOf(entity);
            if (idx == -1) {
                return false;
            }
            int size = --this.size;
            E[] storage = this.storage;
            if (idx != size) {
                System.arraycopy(storage, idx + 1, storage, idx, size - idx);
            }
            storage[size] = null;
            return true;
        }

        public boolean has(E entity) {
            return this.indexOf(entity) != -1;
        }
    }
}

