/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.voxel;

import io.papermc.paper.util.CollisionUtil;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.EnumDirection;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapes;

public final class AABBVoxelShape
extends VoxelShape {
    public final AxisAlignedBB aabb;
    private DoubleList cachedListX;
    private DoubleList cachedListY;
    private DoubleList cachedListZ;

    public AABBVoxelShape(AxisAlignedBB aabb) {
        super(VoxelShapes.getFullUnoptimisedCube().a);
        this.aabb = aabb;
    }

    @Override
    public boolean b() {
        return CollisionUtil.isEmpty(this.aabb);
    }

    @Override
    public double b(EnumDirection.EnumAxis enumdirection_enumaxis) {
        switch (enumdirection_enumaxis.ordinal()) {
            case 0: {
                return this.aabb.a;
            }
            case 1: {
                return this.aabb.b;
            }
            case 2: {
                return this.aabb.c;
            }
        }
        throw new IllegalStateException("Unknown axis requested");
    }

    @Override
    public double c(EnumDirection.EnumAxis enumdirection_enumaxis) {
        switch (enumdirection_enumaxis.ordinal()) {
            case 0: {
                return this.aabb.d;
            }
            case 1: {
                return this.aabb.e;
            }
            case 2: {
                return this.aabb.f;
            }
        }
        throw new IllegalStateException("Unknown axis requested");
    }

    @Override
    public AxisAlignedBB a() {
        return this.aabb;
    }

    @Override
    protected double a(EnumDirection.EnumAxis enumdirection_enumaxis, int i2) {
        switch (enumdirection_enumaxis.ordinal() | i2 << 2) {
            case 0: {
                return this.aabb.a;
            }
            case 1: {
                return this.aabb.b;
            }
            case 2: {
                return this.aabb.c;
            }
            case 4: {
                return this.aabb.d;
            }
            case 5: {
                return this.aabb.e;
            }
            case 6: {
                return this.aabb.f;
            }
        }
        throw new IllegalStateException("Unknown axis requested");
    }

    @Override
    protected DoubleList a(EnumDirection.EnumAxis enumdirection_enumaxis) {
        switch (enumdirection_enumaxis.ordinal()) {
            case 0: {
                return this.cachedListX == null ? (this.cachedListX = DoubleArrayList.wrap((double[])new double[]{this.aabb.a, this.aabb.d})) : this.cachedListX;
            }
            case 1: {
                return this.cachedListY == null ? (this.cachedListY = DoubleArrayList.wrap((double[])new double[]{this.aabb.b, this.aabb.e})) : this.cachedListY;
            }
            case 2: {
                return this.cachedListZ == null ? (this.cachedListZ = DoubleArrayList.wrap((double[])new double[]{this.aabb.c, this.aabb.f})) : this.cachedListZ;
            }
        }
        throw new IllegalStateException("Unknown axis requested");
    }

    @Override
    public VoxelShape a(double d0, double d1, double d2) {
        return new AABBVoxelShape(this.aabb.d(d0, d1, d2));
    }

    @Override
    public VoxelShape c() {
        if (this.b()) {
            return VoxelShapes.a();
        }
        if (this == VoxelShapes.BLOCK_OPTIMISED || this.aabb.equals(VoxelShapes.BLOCK_OPTIMISED.aabb)) {
            return VoxelShapes.BLOCK_OPTIMISED;
        }
        return this;
    }

    @Override
    public void b(VoxelShapes.a voxelshapes_a) {
        voxelshapes_a.consume(this.aabb.a, this.aabb.b, this.aabb.c, this.aabb.d, this.aabb.e, this.aabb.f);
    }

    @Override
    public List<AxisAlignedBB> d() {
        ArrayList<AxisAlignedBB> ret = new ArrayList<AxisAlignedBB>(1);
        ret.add(this.aabb);
        return ret;
    }

    @Override
    protected int a(EnumDirection.EnumAxis enumdirection_enumaxis, double d0) {
        switch (enumdirection_enumaxis.ordinal()) {
            case 0: {
                return d0 < this.aabb.d ? (d0 < this.aabb.a ? -1 : 0) : 1;
            }
            case 1: {
                return d0 < this.aabb.e ? (d0 < this.aabb.b ? -1 : 0) : 1;
            }
            case 2: {
                return d0 < this.aabb.f ? (d0 < this.aabb.c ? -1 : 0) : 1;
            }
        }
        throw new IllegalStateException("Unknown axis requested");
    }

    @Override
    protected VoxelShape b(EnumDirection direction) {
        if (this.b()) {
            return VoxelShapes.a();
        }
        if (this == VoxelShapes.BLOCK_OPTIMISED) {
            return this;
        }
        switch (direction) {
            case f: 
            case e: {
                double from;
                double d2 = from = direction == EnumDirection.f ? 0.9999999 : 1.0E-7;
                if (from > this.aabb.d || this.aabb.a > from) {
                    return VoxelShapes.a();
                }
                return new AABBVoxelShape(new AxisAlignedBB(0.0, this.aabb.b, this.aabb.c, 1.0, this.aabb.e, this.aabb.f)).c();
            }
            case b: 
            case a: {
                double from;
                double d3 = from = direction == EnumDirection.b ? 0.9999999 : 1.0E-7;
                if (from > this.aabb.e || this.aabb.b > from) {
                    return VoxelShapes.a();
                }
                return new AABBVoxelShape(new AxisAlignedBB(this.aabb.a, 0.0, this.aabb.c, this.aabb.d, 1.0, this.aabb.f)).c();
            }
            case d: 
            case c: {
                double from;
                double d4 = from = direction == EnumDirection.d ? 0.9999999 : 1.0E-7;
                if (from > this.aabb.f || this.aabb.c > from) {
                    return VoxelShapes.a();
                }
                return new AABBVoxelShape(new AxisAlignedBB(this.aabb.a, this.aabb.b, 0.0, this.aabb.d, this.aabb.e, 1.0)).c();
            }
        }
        throw new IllegalStateException("Unknown axis requested");
    }

    @Override
    public double a(EnumDirection.EnumAxis enumdirection_enumaxis, AxisAlignedBB axisalignedbb, double d0) {
        if (CollisionUtil.isEmpty(this.aabb) || CollisionUtil.isEmpty(axisalignedbb)) {
            return d0;
        }
        switch (enumdirection_enumaxis.ordinal()) {
            case 0: {
                return CollisionUtil.collideX(this.aabb, axisalignedbb, d0);
            }
            case 1: {
                return CollisionUtil.collideY(this.aabb, axisalignedbb, d0);
            }
            case 2: {
                return CollisionUtil.collideZ(this.aabb, axisalignedbb, d0);
            }
        }
        throw new IllegalStateException("Unknown axis requested");
    }

    @Override
    public boolean intersects(AxisAlignedBB axisalingedbb) {
        return CollisionUtil.voxelShapeIntersect(this.aabb, axisalingedbb);
    }
}

