/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.registry;

import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import io.papermc.paper.registry.RegistryKey;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import org.bukkit.Keyed;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.craftbukkit.v1_18_R2.util.CraftNamespacedKey;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class PaperRegistry<API extends Keyed, MINECRAFT>
implements Registry<API> {
    private static Supplier<IRegistryCustom> REGISTRY_ACCESS = Suppliers.memoize(() -> MinecraftServer.getServer().aU());
    private static final Map<RegistryKey<?, ?>, PaperRegistry<?, ?>> INTERNAL_REGISTRIES = new HashMap();
    public static final Map<RegistryKey<?, ?>, PaperRegistry<?, ?>> REGISTRIES = Collections.unmodifiableMap(INTERNAL_REGISTRIES);
    private static final Map<Class<?>, PaperRegistry<?, ?>> REGISTRY_BY_API_CLASS = new HashMap();
    private static final Map<ResourceKey<? extends IRegistry<?>>, PaperRegistry<?, ?>> REGISTRY_BY_RES_KEY = new HashMap();
    private boolean registered;
    private final RegistryKey<API, MINECRAFT> registryKey;
    private final Supplier<IRegistry<MINECRAFT>> registry;
    private final Map<NamespacedKey, API> cache = new HashMap<NamespacedKey, API>();

    public PaperRegistry(RegistryKey<API, MINECRAFT> registryKey) {
        this.registryKey = registryKey;
        this.registry = Suppliers.memoize(() -> REGISTRY_ACCESS.get().d(this.registryKey.resourceKey()));
    }

    public @Nullable API get(NamespacedKey key) {
        return (API)this.cache.computeIfAbsent(key, k2 -> {
            @Nullable MINECRAFT nms = this.registry.get().a(CraftNamespacedKey.toMinecraft(k2));
            if (nms != null) {
                return this.convertToApi((NamespacedKey)k2, nms);
            }
            return null;
        });
    }

    public abstract API convertToApi(NamespacedKey var1, MINECRAFT var2);

    public API convertToApi(MinecraftKey resourceLocation, MINECRAFT nms) {
        return this.convertToApi(CraftNamespacedKey.fromMinecraft(resourceLocation), nms);
    }

    public API convertToApi(Holder<MINECRAFT> nmsHolder) {
        MinecraftKey loc;
        Optional<ResourceKey<MINECRAFT>> key = nmsHolder.e();
        if (nmsHolder.b() && key.isPresent()) {
            return this.convertToApi(key.get().a(), nmsHolder.a());
        }
        if (!nmsHolder.b() && key.isPresent()) {
            return this.convertToApi(key.get().a(), this.registry.get().f(key.get()));
        }
        if (nmsHolder.b() && key.isEmpty() && (loc = this.registry.get().b(nmsHolder.a())) != null) {
            return this.convertToApi(loc, nmsHolder.a());
        }
        throw new IllegalStateException("Cannot convert " + nmsHolder + " to an API type in: " + this.registryKey);
    }

    public MINECRAFT getMinecraftValue(API apiValue) {
        return this.registry.get().b(CraftNamespacedKey.toMinecraft(apiValue.getKey())).orElseThrow();
    }

    public Holder<MINECRAFT> getMinecraftHolder(API apiValue) {
        return this.registry.get().g(ResourceKey.a(this.registryKey.resourceKey(), CraftNamespacedKey.toMinecraft(apiValue.getKey())));
    }

    public Iterator<API> iterator() {
        return this.registry.get().d().stream().map(key -> this.get(CraftNamespacedKey.fromMinecraft(key))).iterator();
    }

    public void clearCache() {
        this.cache.clear();
    }

    public void register() {
        if (this.registered) {
            throw new IllegalStateException("Already registered: " + this.registryKey.apiClass());
        }
        INTERNAL_REGISTRIES.put(this.registryKey, this);
        REGISTRY_BY_API_CLASS.put(this.registryKey.apiClass(), this);
        REGISTRY_BY_RES_KEY.put(this.registryKey.resourceKey(), this);
        this.registered = true;
    }

    public boolean equals(@Nullable Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || !PaperRegistry.class.isAssignableFrom(o2.getClass())) {
            return false;
        }
        PaperRegistry that = (PaperRegistry)o2;
        return this.registryKey.equals(that.registryKey);
    }

    public int hashCode() {
        return Objects.hash(this.registryKey);
    }

    protected static <T> Supplier<IRegistry<T>> registryFor(ResourceKey<? extends IRegistry<T>> registryKey) {
        return Suppliers.memoize(() -> REGISTRY_ACCESS.get().d(registryKey));
    }

    public static void clearCaches() {
        for (PaperRegistry<?, ?> registry : INTERNAL_REGISTRIES.values()) {
            registry.clearCache();
        }
    }

    public static <T extends Keyed> PaperRegistry<T, ?> getRegistry(Class<T> classOfT) {
        Preconditions.checkArgument((boolean)REGISTRY_BY_API_CLASS.containsKey(classOfT), (Object)"No registry for that type");
        return REGISTRY_BY_API_CLASS.get(classOfT);
    }

    public static <T> PaperRegistry<?, T> getRegistry(ResourceKey<? extends IRegistry<T>> resourceKey) {
        Preconditions.checkArgument((boolean)REGISTRY_BY_RES_KEY.containsKey(resourceKey));
        return REGISTRY_BY_RES_KEY.get(resourceKey);
    }

    public static <A extends Keyed, M> PaperRegistry<A, M> getRegistry(RegistryKey<A, M> registryKey) {
        Preconditions.checkArgument((boolean)INTERNAL_REGISTRIES.containsKey(registryKey));
        return INTERNAL_REGISTRIES.get(registryKey);
    }
}

