/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.chunk;

import com.destroystokyo.paper.PaperConfig;
import com.destroystokyo.paper.util.misc.PlayerAreaMap;
import com.destroystokyo.paper.util.misc.PooledLinkedHashSets;
import io.papermc.paper.util.CoordinateUtils;
import io.papermc.paper.util.IntervalledCounter;
import io.papermc.paper.util.TickThread;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceLinkedOpenHashSet;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.network.protocol.game.ClientboundLevelChunkWithLightPacket;
import net.minecraft.network.protocol.game.ClientboundSetSimulationDistancePacket;
import net.minecraft.network.protocol.game.PacketPlayOutViewCentre;
import net.minecraft.network.protocol.game.PacketPlayOutViewDistance;
import net.minecraft.server.MCUtil;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.PlayerChunk;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.chunk.Chunk;
import org.apache.commons.lang3.mutable.MutableObject;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftPlayer;
import org.bukkit.entity.Player;

public final class PlayerChunkLoader {
    public static final int MIN_VIEW_DISTANCE = 2;
    public static final int MAX_VIEW_DISTANCE = 32;
    public static final int TICK_TICKET_LEVEL = 31;
    public static final int LOADED_TICKET_LEVEL = 33;
    protected final PlayerChunkMap chunkMap;
    protected final Reference2ObjectLinkedOpenHashMap<EntityPlayer, PlayerLoaderData> playerMap = new Reference2ObjectLinkedOpenHashMap(512, 0.7f);
    protected final ReferenceLinkedOpenHashSet<PlayerLoaderData> chunkSendQueue = new ReferenceLinkedOpenHashSet(512, 0.7f);
    protected final TreeSet<PlayerLoaderData> chunkLoadQueue = new TreeSet((p1, p2) -> {
        ChunkPriorityHolder holder2;
        if (p1 == p2) {
            return 0;
        }
        ChunkPriorityHolder holder1 = p1.loadQueue.peekFirst();
        int priorityCompare = Double.compare(holder1 == null ? Double.MAX_VALUE : holder1.priority, (holder2 = p2.loadQueue.peekFirst()) == null ? Double.MAX_VALUE : holder2.priority);
        if (priorityCompare != 0) {
            return priorityCompare;
        }
        int idCompare = Integer.compare(p1.player.ae(), p2.player.ae());
        if (idCompare != 0) {
            return idCompare;
        }
        return Integer.compare(System.identityHashCode(p1), System.identityHashCode(p2));
    });
    protected final TreeSet<PlayerLoaderData> chunkSendWaitQueue = new TreeSet((p1, p2) -> {
        if (p1 == p2) {
            return 0;
        }
        int timeCompare = Long.compare(p1.nextChunkSendTarget, p2.nextChunkSendTarget);
        if (timeCompare != 0) {
            return timeCompare;
        }
        int idCompare = Integer.compare(p1.player.ae(), p2.player.ae());
        if (idCompare != 0) {
            return idCompare;
        }
        return Integer.compare(System.identityHashCode(p1), System.identityHashCode(p2));
    });
    public final PlayerAreaMap broadcastMap;
    public final PlayerAreaMap loadMap;
    public final PlayerAreaMap loadTicketCleanup;
    public final PlayerAreaMap tickMap;
    protected int rawSendDistance = -1;
    protected int rawLoadDistance = -1;
    protected int rawTickDistance = -1;
    protected final LongOpenHashSet isTargetedForPlayerLoad = new LongOpenHashSet();
    protected final LongOpenHashSet chunkTicketTracker = new LongOpenHashSet();
    protected static final AtomicInteger concurrentChunkSends = new AtomicInteger();
    protected final Reference2IntOpenHashMap<PlayerLoaderData> sendingChunkCounts = new Reference2IntOpenHashMap();
    private static long nextChunkSend;
    protected int concurrentChunkLoads;
    protected static final IntervalledCounter TICKET_ADDITION_COUNTER_SHORT;
    protected static final IntervalledCounter TICKET_ADDITION_COUNTER_LONG;

    public static int getTickViewDistance(Player player) {
        return PlayerChunkLoader.getTickViewDistance(((CraftPlayer)player).getHandle());
    }

    public static int getTickViewDistance(EntityPlayer player) {
        WorldServer level = (WorldServer)player.s;
        PlayerLoaderData data = level.K.a.playerChunkManager.getData(player);
        if (data == null) {
            return level.K.a.playerChunkManager.getTargetTickViewDistance();
        }
        return data.getTargetTickViewDistance();
    }

    public static int getLoadViewDistance(Player player) {
        return PlayerChunkLoader.getLoadViewDistance(((CraftPlayer)player).getHandle());
    }

    public static int getLoadViewDistance(EntityPlayer player) {
        WorldServer level = (WorldServer)player.s;
        PlayerLoaderData data = level.K.a.playerChunkManager.getData(player);
        if (data == null) {
            return level.K.a.playerChunkManager.getLoadDistance();
        }
        return data.getLoadDistance();
    }

    public static int getSendViewDistance(Player player) {
        return PlayerChunkLoader.getSendViewDistance(((CraftPlayer)player).getHandle());
    }

    public static int getSendViewDistance(EntityPlayer player) {
        WorldServer level = (WorldServer)player.s;
        PlayerLoaderData data = level.K.a.playerChunkManager.getData(player);
        if (data == null) {
            return level.K.a.playerChunkManager.getTargetSendDistance();
        }
        return data.getTargetSendViewDistance();
    }

    public int getTargetTickViewDistance() {
        return this.getTickDistance();
    }

    public void setTargetTickViewDistance(int distance) {
        this.setTickDistance(distance);
    }

    public int getTargetNoTickViewDistance() {
        return this.getLoadDistance() - 1;
    }

    public void setTargetNoTickViewDistance(int distance) {
        this.setLoadDistance(distance == -1 ? -1 : distance + 1);
    }

    public int getTargetSendDistance() {
        return this.rawSendDistance == -1 ? this.getLoadDistance() : this.rawSendDistance;
    }

    public void setTargetSendDistance(int distance) {
        this.setSendDistance(distance);
    }

    public int getSendDistance() {
        int loadDistance = this.getLoadDistance();
        return this.rawSendDistance == -1 ? loadDistance : Math.min(this.rawSendDistance, loadDistance);
    }

    public void setSendDistance(int distance) {
        if (distance != -1 && (distance < 2 || distance > 33)) {
            throw new IllegalArgumentException("Send distance must be a number between 2 and 33, or -1, got: " + distance);
        }
        this.rawSendDistance = distance;
    }

    public int getLoadDistance() {
        int tickDistance = this.getTickDistance();
        return this.rawLoadDistance == -1 ? tickDistance + 1 : Math.max(tickDistance + 1, this.rawLoadDistance);
    }

    public void setLoadDistance(int distance) {
        if (distance != -1 && (distance < 2 || distance > 33)) {
            throw new IllegalArgumentException("Load distance must be a number between 2 and 33, or -1, got: " + distance);
        }
        this.rawLoadDistance = distance;
    }

    public int getTickDistance() {
        return this.rawTickDistance;
    }

    public void setTickDistance(int distance) {
        if (distance < 2 || distance > 32) {
            throw new IllegalArgumentException("View distance must be a number between 2 and 32, got: " + distance);
        }
        this.rawTickDistance = distance;
    }

    public PlayerChunkLoader(PlayerChunkMap chunkMap, PooledLinkedHashSets<EntityPlayer> pooledHashSets) {
        this.chunkMap = chunkMap;
        this.broadcastMap = new PlayerAreaMap(pooledHashSets, null, (player, rangeX, rangeZ, currPosX, currPosZ, prevPosX, prevPosZ, newState) -> this.onChunkLeave((EntityPlayer)player, rangeX, rangeZ));
        this.loadMap = new PlayerAreaMap(pooledHashSets, null, (player, rangeX, rangeZ, currPosX, currPosZ, prevPosX, prevPosZ, newState) -> {
            if (newState != null) {
                return;
            }
            this.isTargetedForPlayerLoad.remove(CoordinateUtils.getChunkKey(rangeX, rangeZ));
        });
        this.loadTicketCleanup = new PlayerAreaMap(pooledHashSets, null, (player, rangeX, rangeZ, currPosX, currPosZ, prevPosX, prevPosZ, newState) -> {
            if (newState != null) {
                return;
            }
            ChunkCoordIntPair chunkPos = new ChunkCoordIntPair(rangeX, rangeZ);
            this.chunkMap.r.k().removeTicketAtLevel(TicketType.c, chunkPos, 33, chunkPos);
            if (this.chunkTicketTracker.remove(chunkPos.a())) {
                --this.concurrentChunkLoads;
            }
        });
        this.tickMap = new PlayerAreaMap(pooledHashSets, (player, rangeX, rangeZ, currPosX, currPosZ, prevPosX, prevPosZ, newState) -> {
            if (newState.size() != 1) {
                return;
            }
            Chunk chunk = this.chunkMap.r.k().getChunkAtIfLoadedMainThreadNoCache(rangeX, rangeZ);
            if (chunk == null || !chunk.areNeighboursLoaded(2)) {
                return;
            }
            ChunkCoordIntPair chunkPos = new ChunkCoordIntPair(rangeX, rangeZ);
            this.chunkMap.r.k().addTicketAtLevel(TicketType.c, chunkPos, 31, chunkPos);
        }, (player, rangeX, rangeZ, currPosX, currPosZ, prevPosX, prevPosZ, newState) -> {
            if (newState != null) {
                return;
            }
            ChunkCoordIntPair chunkPos = new ChunkCoordIntPair(rangeX, rangeZ);
            this.chunkMap.r.k().removeTicketAtLevel(TicketType.c, chunkPos, 31, chunkPos);
        });
    }

    public boolean isChunkNearPlayers(int chunkX, int chunkZ) {
        PooledLinkedHashSets.PooledObjectLinkedOpenHashSet playersInSendRange = this.broadcastMap.getObjectsInRange(chunkX, chunkZ);
        return playersInSendRange != null;
    }

    public void onChunkPostProcessing(int chunkX, int chunkZ) {
        this.onChunkSendReady(chunkX, chunkZ);
    }

    private boolean chunkNeedsPostProcessing(int chunkX, int chunkZ) {
        long key = CoordinateUtils.getChunkKey(chunkX, chunkZ);
        PlayerChunk chunk = this.chunkMap.b(key);
        if (chunk == null) {
            return false;
        }
        Chunk levelChunk = chunk.getSendingChunk();
        return levelChunk != null && !levelChunk.isPostProcessingDone;
    }

    public boolean isChunkPlayerLoaded(int chunkX, int chunkZ) {
        long key = CoordinateUtils.getChunkKey(chunkX, chunkZ);
        PlayerChunk chunk = this.chunkMap.b(key);
        if (chunk == null) {
            return false;
        }
        Chunk levelChunk = chunk.getSendingChunk();
        return levelChunk != null && levelChunk.isPostProcessingDone && this.isTargetedForPlayerLoad.contains(key);
    }

    public boolean isChunkSent(EntityPlayer player, int chunkX, int chunkZ, boolean borderOnly) {
        return borderOnly ? this.isChunkSentBorderOnly(player, chunkX, chunkZ) : this.isChunkSent(player, chunkX, chunkZ);
    }

    public boolean isChunkSent(EntityPlayer player, int chunkX, int chunkZ) {
        PlayerLoaderData data = (PlayerLoaderData)this.playerMap.get((Object)player);
        if (data == null) {
            return false;
        }
        return data.hasSentChunk(chunkX, chunkZ);
    }

    public boolean isChunkSentBorderOnly(EntityPlayer player, int chunkX, int chunkZ) {
        PlayerLoaderData data = (PlayerLoaderData)this.playerMap.get((Object)player);
        if (data == null) {
            return false;
        }
        boolean center = data.hasSentChunk(chunkX, chunkZ);
        if (!center) {
            return false;
        }
        return !data.hasSentChunk(chunkX - 1, chunkZ) || !data.hasSentChunk(chunkX + 1, chunkZ) || !data.hasSentChunk(chunkX, chunkZ - 1) || !data.hasSentChunk(chunkX, chunkZ + 1);
    }

    protected int getMaxConcurrentChunkSends() {
        return PaperConfig.playerMaxConcurrentChunkSends;
    }

    protected int getMaxChunkLoads() {
        double config = PaperConfig.playerMaxConcurrentChunkLoads;
        double max = PaperConfig.globalMaxConcurrentChunkLoads;
        return (int)Math.ceil(Math.min(config * (double)MinecraftServer.getServer().H(), max <= 1.0 ? Double.MAX_VALUE : max));
    }

    protected long getTargetSendPerPlayerAddend() {
        return PaperConfig.playerTargetChunkSendRate <= 1.0 ? 0L : Math.round(1.0E9 / PaperConfig.playerTargetChunkSendRate);
    }

    protected long getMaxSendAddend() {
        return PaperConfig.globalMaxChunkSendRate <= 1.0 ? 0L : Math.round(1.0E9 / PaperConfig.globalMaxChunkSendRate);
    }

    public void onChunkPlayerTickReady(int chunkX, int chunkZ) {
        ChunkCoordIntPair chunkPos = new ChunkCoordIntPair(chunkX, chunkZ);
        this.chunkMap.r.k().addTicketAtLevel(TicketType.c, chunkPos, 31, chunkPos);
    }

    public void onChunkSendReady(int chunkX, int chunkZ) {
        PooledLinkedHashSets.PooledObjectLinkedOpenHashSet playersInSendRange = this.broadcastMap.getObjectsInRange(chunkX, chunkZ);
        if (playersInSendRange == null) {
            return;
        }
        for (Object raw : playersInSendRange.getBackingSet()) {
            if (!(raw instanceof EntityPlayer)) continue;
            this.onChunkSendReady((EntityPlayer)raw, chunkX, chunkZ);
        }
    }

    public void onChunkSendReady(EntityPlayer player, int chunkX, int chunkZ) {
        PlayerLoaderData data = (PlayerLoaderData)this.playerMap.get((Object)player);
        if (data == null) {
            return;
        }
        if (data.hasSentChunk(chunkX, chunkZ) || !this.isChunkPlayerLoaded(chunkX, chunkZ)) {
            return;
        }
        if (!data.chunksToBeSent.remove(CoordinateUtils.getChunkKey(chunkX, chunkZ))) {
            return;
        }
        long playerPos = this.broadcastMap.getLastCoordinate(player);
        int playerChunkX = CoordinateUtils.getChunkX(playerPos);
        int playerChunkZ = CoordinateUtils.getChunkZ(playerPos);
        int manhattanDistance = Math.abs(playerChunkX - chunkX) + Math.abs(playerChunkZ - chunkZ);
        ChunkPriorityHolder holder = new ChunkPriorityHolder(chunkX, chunkZ, manhattanDistance, 0.0);
        data.sendQueue.add(holder);
    }

    public void onChunkLoad(int chunkX, int chunkZ) {
        if (this.chunkTicketTracker.remove(CoordinateUtils.getChunkKey(chunkX, chunkZ))) {
            --this.concurrentChunkLoads;
        }
    }

    public void onChunkLeave(EntityPlayer player, int chunkX, int chunkZ) {
        PlayerLoaderData data = (PlayerLoaderData)this.playerMap.get((Object)player);
        if (data == null) {
            return;
        }
        data.unloadChunk(chunkX, chunkZ);
    }

    public void addPlayer(EntityPlayer player) {
        TickThread.ensureTickThread("Cannot add player async");
        if (!player.isRealPlayer) {
            return;
        }
        PlayerLoaderData data = new PlayerLoaderData(player, this);
        if (this.playerMap.putIfAbsent((Object)player, (Object)data) == null) {
            data.update();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePlayer(EntityPlayer player) {
        TickThread.ensureTickThread("Cannot remove player async");
        if (!player.isRealPlayer) {
            return;
        }
        PlayerLoaderData loaderData = (PlayerLoaderData)this.playerMap.remove((Object)player);
        if (loaderData == null) {
            return;
        }
        loaderData.remove();
        this.chunkLoadQueue.remove(loaderData);
        this.chunkSendQueue.remove((Object)loaderData);
        this.chunkSendWaitQueue.remove(loaderData);
        Reference2IntOpenHashMap<PlayerLoaderData> reference2IntOpenHashMap = this.sendingChunkCounts;
        synchronized (reference2IntOpenHashMap) {
            int count = this.sendingChunkCounts.removeInt((Object)loaderData);
            if (count != 0) {
                concurrentChunkSends.getAndAdd(-count);
            }
        }
    }

    public void updatePlayer(EntityPlayer player) {
        TickThread.ensureTickThread("Cannot update player async");
        if (!player.isRealPlayer) {
            return;
        }
        PlayerLoaderData loaderData = (PlayerLoaderData)this.playerMap.get((Object)player);
        if (loaderData != null) {
            loaderData.update();
        }
    }

    public PlayerLoaderData getData(EntityPlayer player) {
        return (PlayerLoaderData)this.playerMap.get((Object)player);
    }

    public void tick() {
        TickThread.ensureTickThread("Cannot tick async");
        for (PlayerLoaderData data : this.playerMap.values()) {
            data.update();
        }
        this.tickMidTick();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void trySendChunks() {
        int currSends;
        long time = System.nanoTime();
        if (time < nextChunkSend) {
            return;
        }
        while (!this.chunkSendWaitQueue.isEmpty()) {
            PlayerLoaderData data = this.chunkSendWaitQueue.first();
            if (data.nextChunkSendTarget > time) break;
            this.chunkSendWaitQueue.pollFirst();
            this.chunkSendQueue.add((Object)data);
        }
        if (this.chunkSendQueue.isEmpty()) {
            return;
        }
        int maxSends = this.getMaxConcurrentChunkSends();
        long nextPlayerDeadline = this.getTargetSendPerPlayerAddend() + time;
        while (!this.chunkSendQueue.isEmpty() && (currSends = concurrentChunkSends.get()) < maxSends) {
            if (!concurrentChunkSends.compareAndSet(currSends, currSends + 1)) continue;
            PlayerLoaderData data = (PlayerLoaderData)this.chunkSendQueue.removeFirst();
            ChunkPriorityHolder queuedSend = data.sendQueue.pollFirst();
            if (queuedSend == null) {
                concurrentChunkSends.getAndDecrement();
                if (!this.chunkSendQueue.isEmpty()) continue;
                break;
            }
            if (!this.isChunkPlayerLoaded(queuedSend.chunkX, queuedSend.chunkZ)) {
                throw new IllegalStateException();
            }
            data.nextChunkSendTarget = nextPlayerDeadline;
            this.chunkSendWaitQueue.add(data);
            Reference2IntOpenHashMap<PlayerLoaderData> reference2IntOpenHashMap = this.sendingChunkCounts;
            synchronized (reference2IntOpenHashMap) {
                this.sendingChunkCounts.addTo((Object)data, 1);
            }
            data.sendChunk(queuedSend.chunkX, queuedSend.chunkZ, () -> {
                Reference2IntOpenHashMap<PlayerLoaderData> reference2IntOpenHashMap = this.sendingChunkCounts;
                synchronized (reference2IntOpenHashMap) {
                    int count = this.sendingChunkCounts.getInt((Object)data);
                    if (count == 0) {
                        return;
                    }
                    if (count == 1) {
                        this.sendingChunkCounts.removeInt((Object)data);
                    } else {
                        this.sendingChunkCounts.put((Object)data, count - 1);
                    }
                }
                concurrentChunkSends.getAndDecrement();
            });
            nextChunkSend = this.getMaxSendAddend() + time;
            if (time >= nextChunkSend) continue;
            break;
        }
    }

    private void tryLoadChunks() {
        if (this.chunkLoadQueue.isEmpty()) {
            return;
        }
        int maxLoads = this.getMaxChunkLoads();
        long time = System.nanoTime();
        boolean updatedCounters = false;
        while (true) {
            int currentChunkLoads;
            int offZ;
            int offX;
            int dx;
            int dz;
            PlayerLoaderData data = this.chunkLoadQueue.pollFirst();
            ChunkPriorityHolder queuedLoad = data.loadQueue.peekFirst();
            if (queuedLoad == null) {
                if (!this.chunkLoadQueue.isEmpty()) continue;
                break;
            }
            if (!updatedCounters) {
                updatedCounters = true;
                TICKET_ADDITION_COUNTER_SHORT.updateCurrentTime(time);
                TICKET_ADDITION_COUNTER_LONG.updateCurrentTime(time);
            }
            if (this.isChunkPlayerLoaded(queuedLoad.chunkX, queuedLoad.chunkZ)) {
                data.loadQueue.pollFirst();
                this.chunkLoadQueue.add(data);
                this.onChunkSendReady(queuedLoad.chunkX, queuedLoad.chunkZ);
                continue;
            }
            long chunkKey = CoordinateUtils.getChunkKey(queuedLoad.chunkX, queuedLoad.chunkZ);
            double priority = queuedLoad.priority;
            boolean unloadedTargetChunk = false;
            block1: for (dz = -1; dz <= 1; ++dz) {
                for (dx = -1; dx <= 1; ++dx) {
                    offX = queuedLoad.chunkX + dx;
                    offZ = queuedLoad.chunkZ + dz;
                    if (this.chunkMap.r.k().getChunkAtIfLoadedMainThreadNoCache(offX, offZ) != null) continue;
                    unloadedTargetChunk = true;
                    break block1;
                }
            }
            if (unloadedTargetChunk && priority >= 0.0 && ((currentChunkLoads = this.concurrentChunkLoads) >= maxLoads || PaperConfig.globalMaxChunkLoadRate > 0.0 && (TICKET_ADDITION_COUNTER_SHORT.getRate() >= PaperConfig.globalMaxChunkLoadRate || TICKET_ADDITION_COUNTER_LONG.getRate() >= PaperConfig.globalMaxChunkLoadRate))) {
                this.chunkLoadQueue.add(data);
                break;
            }
            data.loadQueue.pollFirst();
            this.chunkLoadQueue.add(data);
            for (dz = -1; dz <= 1; ++dz) {
                for (dx = -1; dx <= 1; ++dx) {
                    offX = queuedLoad.chunkX + dx;
                    offZ = queuedLoad.chunkZ + dz;
                    ChunkCoordIntPair chunkPos = new ChunkCoordIntPair(offX, offZ);
                    this.chunkMap.r.k().addTicketAtLevel(TicketType.c, chunkPos, 33, chunkPos);
                    if (this.chunkMap.r.k().getChunkAtIfLoadedMainThreadNoCache(offX, offZ) != null || !(priority > 0.0) || !this.chunkTicketTracker.add(CoordinateUtils.getChunkKey(offX, offZ))) continue;
                    ++this.concurrentChunkLoads;
                    TICKET_ADDITION_COUNTER_SHORT.addTime(time);
                    TICKET_ADDITION_COUNTER_LONG.addTime(time);
                }
            }
            this.isTargetedForPlayerLoad.add(chunkKey);
            if (this.isChunkPlayerLoaded(queuedLoad.chunkX, queuedLoad.chunkZ)) {
                this.onChunkSendReady(queuedLoad.chunkX, queuedLoad.chunkZ);
                continue;
            }
            if (!this.chunkNeedsPostProcessing(queuedLoad.chunkX, queuedLoad.chunkZ)) continue;
            this.chunkMap.t.execute(() -> {
                long key = CoordinateUtils.getChunkKey(queuedLoad.chunkX, queuedLoad.chunkZ);
                PlayerChunk holder = this.chunkMap.b(key);
                if (holder == null) {
                    return;
                }
                Chunk chunk = holder.getSendingChunk();
                if (chunk != null && !chunk.isPostProcessingDone) {
                    chunk.F();
                }
            });
        }
    }

    public void tickMidTick() {
        this.trySendChunks();
        this.tryLoadChunks();
    }

    static {
        TICKET_ADDITION_COUNTER_SHORT = new IntervalledCounter(50000000L);
        TICKET_ADDITION_COUNTER_LONG = new IntervalledCounter(1000000000L);
    }

    public static final class PlayerLoaderData {
        protected static final float FOV = 110.0f;
        protected static final double PRIORITISED_DISTANCE = 192.0;
        protected static final double LOOK_PRIORITY_SPEED_THRESHOLD = 0.25;
        protected static final double LOOK_PRIORITY_YAW_DELTA_RECALC_THRESHOLD = 3.0;
        protected double lastLocX = Double.NEGATIVE_INFINITY;
        protected double lastLocZ = Double.NEGATIVE_INFINITY;
        protected int lastChunkX = Integer.MIN_VALUE;
        protected int lastChunkZ = Integer.MIN_VALUE;
        protected float lastYaw = Float.NEGATIVE_INFINITY;
        protected int lastSendDistance = Integer.MIN_VALUE;
        protected int lastLoadDistance = Integer.MIN_VALUE;
        protected int lastTickDistance = Integer.MIN_VALUE;
        protected boolean usingLookingPriority;
        protected final EntityPlayer player;
        protected final PlayerChunkLoader loader;
        protected final ArrayDeque<ChunkPriorityHolder> loadQueue = new ArrayDeque();
        protected final LongOpenHashSet sentChunks = new LongOpenHashSet();
        protected final LongOpenHashSet chunksToBeSent = new LongOpenHashSet();
        protected final TreeSet<ChunkPriorityHolder> sendQueue = new TreeSet((p1, p2) -> {
            int distanceCompare = Integer.compare(p1.manhattanDistanceToPlayer, p2.manhattanDistanceToPlayer);
            if (distanceCompare != 0) {
                return distanceCompare;
            }
            int coordinateXCompare = Integer.compare(p1.chunkX, p2.chunkX);
            if (coordinateXCompare != 0) {
                return coordinateXCompare;
            }
            return Integer.compare(p1.chunkZ, p2.chunkZ);
        });
        protected int sendViewDistance = -1;
        protected int loadViewDistance = -1;
        protected int tickViewDistance = -1;
        protected long nextChunkSendTarget;

        public PlayerLoaderData(EntityPlayer player, PlayerChunkLoader loader) {
            this.player = player;
            this.loader = loader;
        }

        public int getTargetSendViewDistance() {
            int tickViewDistance = this.tickViewDistance == -1 ? this.loader.getTickDistance() : this.tickViewDistance;
            int loadViewDistance = Math.max(tickViewDistance + 1, this.loadViewDistance == -1 ? this.loader.getLoadDistance() : this.loadViewDistance);
            int clientViewDistance = this.getClientViewDistance();
            int sendViewDistance = Math.min(loadViewDistance, this.sendViewDistance == -1 ? (!PaperConfig.playerAutoConfigureSendViewDistance || clientViewDistance == -1 ? this.loader.getSendDistance() : clientViewDistance + 1) : this.sendViewDistance);
            return sendViewDistance;
        }

        public void setTargetSendViewDistance(int distance) {
            if (distance != -1 && (distance < 2 || distance > 33)) {
                throw new IllegalArgumentException("Send view distance must be a number between 2 and 33 or -1, got: " + distance);
            }
            this.sendViewDistance = distance;
        }

        public int getTargetNoTickViewDistance() {
            return (this.loadViewDistance == -1 ? this.getLoadDistance() : this.loadViewDistance) - 1;
        }

        public void setTargetNoTickViewDistance(int distance) {
            if (distance != -1 && (distance < 2 || distance > 32)) {
                throw new IllegalArgumentException("Simulation distance must be a number between 2 and 32 or -1, got: " + distance);
            }
            this.loadViewDistance = distance == -1 ? -1 : distance + 1;
        }

        public int getTargetTickViewDistance() {
            return this.tickViewDistance == -1 ? this.loader.getTickDistance() : this.tickViewDistance;
        }

        public void setTargetTickViewDistance(int distance) {
            if (distance != -1 && (distance < 2 || distance > 32)) {
                throw new IllegalArgumentException("View distance must be a number between 2 and 32 or -1, got: " + distance);
            }
            this.tickViewDistance = distance;
        }

        protected int getLoadDistance() {
            int tickViewDistance = this.tickViewDistance == -1 ? this.loader.getTickDistance() : this.tickViewDistance;
            return Math.max(tickViewDistance + 1, this.loadViewDistance == -1 ? this.loader.getLoadDistance() : this.loadViewDistance);
        }

        public boolean hasSentChunk(int chunkX, int chunkZ) {
            return this.sentChunks.contains(CoordinateUtils.getChunkKey(chunkX, chunkZ));
        }

        public void sendChunk(int chunkX, int chunkZ, Runnable onChunkSend) {
            if (!this.sentChunks.add(CoordinateUtils.getChunkKey(chunkX, chunkZ))) {
                throw new IllegalStateException();
            }
            this.player.x().k().a.a(this.player, new ChunkCoordIntPair(chunkX, chunkZ), (MutableObject<Map<Object, ClientboundLevelChunkWithLightPacket>>)new MutableObject(), false, true);
            this.player.b.a.execute(onChunkSend);
        }

        public void unloadChunk(int chunkX, int chunkZ) {
            if (this.sentChunks.remove(CoordinateUtils.getChunkKey(chunkX, chunkZ))) {
                this.player.x().k().a.a(this.player, new ChunkCoordIntPair(chunkX, chunkZ), null, true, false);
            }
        }

        protected static boolean wantChunkLoaded(int centerX, int centerZ, int chunkX, int chunkZ, int sendRadius) {
            return PlayerChunkMap.a(chunkX, chunkZ, centerX, centerZ, sendRadius);
        }

        protected static boolean triangleIntersects(double p1x, double p1z, double p2x, double p2z, double p3x, double p3z, double targetX, double targetZ) {
            double d2 = (p2z - p3z) * (p1x - p3x) + (p3x - p2x) * (p1z - p3z);
            double a2 = ((p2z - p3z) * (targetX - p3x) + (p3x - p2x) * (targetZ - p3z)) / d2;
            if (a2 < 0.0 || a2 > 1.0) {
                return false;
            }
            double b2 = ((p3z - p1z) * (targetX - p3x) + (p1x - p3x) * (targetZ - p3z)) / d2;
            if (b2 < 0.0 || b2 > 1.0) {
                return false;
            }
            double c2 = 1.0 - a2 - b2;
            return c2 >= 0.0 && c2 <= 1.0;
        }

        public void remove() {
            this.loader.broadcastMap.remove(this.player);
            this.loader.loadMap.remove(this.player);
            this.loader.loadTicketCleanup.remove(this.player);
            this.loader.tickMap.remove(this.player);
        }

        protected int getClientViewDistance() {
            return this.player.clientViewDistance == null ? -1 : this.player.clientViewDistance;
        }

        public void update() {
            int tickViewDistance = this.tickViewDistance == -1 ? this.loader.getTickDistance() : this.tickViewDistance;
            int loadViewDistance = Math.max(tickViewDistance + 1, this.loadViewDistance == -1 ? this.loader.getLoadDistance() : this.loadViewDistance);
            int clientViewDistance = this.getClientViewDistance();
            int sendViewDistance = Math.min(loadViewDistance, this.sendViewDistance == -1 ? (!PaperConfig.playerAutoConfigureSendViewDistance || clientViewDistance == -1 ? this.loader.getSendDistance() : clientViewDistance + 1) : this.sendViewDistance);
            double posX = this.player.dc();
            double posZ = this.player.di();
            float yaw = MCUtil.normalizeYaw(((Entity)this.player).aA + 90.0f);
            boolean useLookPriority = PaperConfig.playerFrustumPrioritisation && (this.player.da().i() > 0.25 || this.player.fs().b);
            this.loader.chunkSendWaitQueue.add(this);
            if (sendViewDistance == this.lastSendDistance && loadViewDistance == this.lastLoadDistance && tickViewDistance == this.lastTickDistance && (this.usingLookingPriority ? MathHelper.b(this.lastLocX) == MathHelper.b(posX) && MathHelper.b(this.lastLocZ) == MathHelper.b(posZ) : MathHelper.b(this.lastLocX) >> 4 == MathHelper.b(posX) >> 4 && MathHelper.b(this.lastLocZ) >> 4 == MathHelper.b(posZ) >> 4) && this.usingLookingPriority == useLookPriority && (!this.usingLookingPriority || (double)Math.abs(yaw - this.lastYaw) <= 3.0)) {
                return;
            }
            int centerChunkX = MathHelper.b(posX) >> 4;
            int centerChunkZ = MathHelper.b(posZ) >> 4;
            boolean needsChunkCenterUpdate = centerChunkX != this.lastChunkX || centerChunkZ != this.lastChunkZ;
            this.loader.broadcastMap.addOrUpdate(this.player, centerChunkX, centerChunkZ, sendViewDistance);
            this.loader.loadMap.addOrUpdate(this.player, centerChunkX, centerChunkZ, loadViewDistance);
            this.loader.loadTicketCleanup.addOrUpdate(this.player, centerChunkX, centerChunkZ, loadViewDistance + 1);
            this.loader.tickMap.addOrUpdate(this.player, centerChunkX, centerChunkZ, tickViewDistance);
            if (sendViewDistance != this.lastSendDistance) {
                this.player.b.a(new PacketPlayOutViewDistance(sendViewDistance));
            }
            if (tickViewDistance != this.lastTickDistance) {
                this.player.b.a(new ClientboundSetSimulationDistancePacket(tickViewDistance));
            }
            this.lastLocX = posX;
            this.lastLocZ = posZ;
            this.lastYaw = yaw;
            this.lastSendDistance = sendViewDistance;
            this.lastLoadDistance = loadViewDistance;
            this.lastTickDistance = tickViewDistance;
            this.usingLookingPriority = useLookPriority;
            this.lastChunkX = centerChunkX;
            this.lastChunkZ = centerChunkZ;
            double p1x = posX;
            double p1z = posZ;
            double p2x = 192.0 * Math.cos(Math.toRadians((double)yaw + 55.0)) + p1x;
            double p2z = 192.0 * Math.sin(Math.toRadians((double)yaw + 55.0)) + p1z;
            double p3x = 192.0 * Math.cos(Math.toRadians((double)yaw - 55.0)) + p1x;
            double p3z = 192.0 * Math.sin(Math.toRadians((double)yaw - 55.0)) + p1z;
            ArrayList<ChunkPriorityHolder> loadQueue = new ArrayList<ChunkPriorityHolder>();
            this.sendQueue.clear();
            this.chunksToBeSent.clear();
            int searchViewDistance = Math.max(loadViewDistance, sendViewDistance);
            for (int dx = -searchViewDistance; dx <= searchViewDistance; ++dx) {
                for (int dz = -searchViewDistance; dz <= searchViewDistance; ++dz) {
                    boolean sendChunk;
                    int chunkX = dx + centerChunkX;
                    int chunkZ = dz + centerChunkZ;
                    int squareDistance = Math.max(Math.abs(dx), Math.abs(dz));
                    boolean bl = sendChunk = squareDistance <= sendViewDistance && PlayerLoaderData.wantChunkLoaded(centerChunkX, centerChunkZ, chunkX, chunkZ, sendViewDistance);
                    if (this.hasSentChunk(chunkX, chunkZ)) {
                        if (sendChunk) continue;
                        this.unloadChunk(chunkX, chunkZ);
                        continue;
                    }
                    boolean loadChunk = squareDistance <= loadViewDistance;
                    boolean prioritised = useLookPriority && PlayerLoaderData.triangleIntersects(p1x, p1z, p2x, p2z, p3x, p3z, chunkX << 4 | 8, chunkZ << 4 | 8);
                    int manhattanDistance = Math.abs(dx) + Math.abs(dz);
                    double priority = squareDistance <= PaperConfig.playerMinChunkLoadRadius ? (double)(-(2 * PaperConfig.playerMinChunkLoadRadius + 1 - manhattanDistance)) : (prioritised ? (double)manhattanDistance / 6.0 : (double)manhattanDistance);
                    ChunkPriorityHolder holder = new ChunkPriorityHolder(chunkX, chunkZ, manhattanDistance, priority);
                    if (!this.loader.isChunkPlayerLoaded(chunkX, chunkZ)) {
                        if (!loadChunk) continue;
                        loadQueue.add(holder);
                        if (!sendChunk) continue;
                        this.chunksToBeSent.add(CoordinateUtils.getChunkKey(chunkX, chunkZ));
                        continue;
                    }
                    if (!sendChunk) continue;
                    this.sendQueue.add(holder);
                }
            }
            loadQueue.sort((p1, p2) -> Double.compare(p1.priority, p2.priority));
            this.loader.chunkLoadQueue.remove(this);
            this.loadQueue.clear();
            this.loadQueue.addAll(loadQueue);
            this.loader.chunkLoadQueue.add(this);
            if (needsChunkCenterUpdate) {
                this.player.b.a(new PacketPlayOutViewCentre(centerChunkX, centerChunkZ));
            }
        }
    }

    static final class ChunkPriorityHolder {
        public final int chunkX;
        public final int chunkZ;
        public final int manhattanDistanceToPlayer;
        public final double priority;

        public ChunkPriorityHolder(int chunkX, int chunkZ, int manhattanDistanceToPlayer, double priority) {
            this.chunkX = chunkX;
            this.chunkZ = chunkZ;
            this.manhattanDistanceToPlayer = manhattanDistanceToPlayer;
            this.priority = priority;
        }
    }
}

