/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.attribute;

import com.google.common.collect.Maps;
import io.papermc.paper.attribute.UnmodifiableAttributeInstance;
import java.util.Map;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import org.bukkit.attribute.Attributable;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.craftbukkit.v1_18_R2.attribute.CraftAttributeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnmodifiableAttributeMap
implements Attributable {
    private final Map<Attribute, AttributeInstance> attributes = Maps.newHashMap();
    private final AttributeProvider handle;

    public UnmodifiableAttributeMap(@NotNull AttributeProvider handle) {
        this.handle = handle;
    }

    @Nullable
    public AttributeInstance getAttribute(@NotNull Attribute attribute) {
        AttributeBase nmsAttribute = CraftAttributeMap.toMinecraft(attribute);
        AttributeModifiable nmsAttributeInstance = this.handle.a.get(nmsAttribute);
        if (nmsAttribute == null) {
            return null;
        }
        return new UnmodifiableAttributeInstance(nmsAttributeInstance, attribute);
    }

    public void registerAttribute(@NotNull Attribute attribute) {
        throw new UnsupportedOperationException("Cannot register new attributes here");
    }
}

