/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.adventure;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.netty.util.AttributeKey;
import io.papermc.paper.adventure.AdventureComponent;
import io.papermc.paper.adventure.NBTLegacyHoverEventSerializer;
import io.papermc.paper.adventure.WrapperAwareSerializer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.inventory.Book;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.nbt.api.BinaryTagHolder;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.flattener.ComponentFlattener;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.kyori.adventure.text.serializer.gson.LegacyHoverEventSerializer;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.kyori.adventure.text.serializer.plain.PlainComponentSerializer;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import net.kyori.adventure.translation.GlobalTranslator;
import net.kyori.adventure.translation.TranslationRegistry;
import net.kyori.adventure.translation.Translator;
import net.kyori.adventure.util.Codec;
import net.minecraft.EnumChatFormat;
import net.minecraft.locale.LocaleLanguage;
import net.minecraft.nbt.MojangsonParser;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.world.BossBattle;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PaperAdventure {
    public static final AttributeKey<Locale> LOCALE_ATTRIBUTE = AttributeKey.valueOf((String)"adventure:locale");
    private static final Pattern LOCALIZATION_PATTERN = Pattern.compile("%(?:(\\d+)\\$)?s");
    public static final ComponentFlattener FLATTENER = (ComponentFlattener)((ComponentFlattener.Builder)ComponentFlattener.basic().toBuilder()).complexMapper(TranslatableComponent.class, (translatable, consumer) -> {
        if (!LocaleLanguage.a().b(translatable.key())) {
            for (Translator source : GlobalTranslator.translator().sources()) {
                TranslationRegistry registry;
                if (!(source instanceof TranslationRegistry) || !(registry = (TranslationRegistry)source).contains(translatable.key())) continue;
                consumer.accept(GlobalTranslator.render((Component)translatable, (Locale)Locale.US));
                return;
            }
        }
        @NotNull String translated = LocaleLanguage.a().a(translatable.key());
        Matcher matcher = LOCALIZATION_PATTERN.matcher(translated);
        List args = translatable.args();
        int argPosition = 0;
        int lastIdx = 0;
        while (matcher.find()) {
            int idx;
            if (lastIdx < matcher.start()) {
                consumer.accept(Component.text((String)translated.substring(lastIdx, matcher.start())));
            }
            lastIdx = matcher.end();
            @Nullable String argIdx = matcher.group(1);
            if (argIdx != null) {
                try {
                    idx = Integer.parseInt(argIdx) - 1;
                    if (idx >= args.size()) continue;
                    consumer.accept((Component)args.get(idx));
                }
                catch (NumberFormatException idx2) {}
                continue;
            }
            if ((idx = argPosition++) >= args.size()) continue;
            consumer.accept((Component)args.get(idx));
        }
        if (lastIdx < translated.length()) {
            consumer.accept(Component.text((String)translated.substring(lastIdx)));
        }
    }).build();
    public static final LegacyComponentSerializer LEGACY_SECTION_UXRC = LegacyComponentSerializer.builder().flattener(FLATTENER).hexColors().useUnusualXRepeatedCharacterHexFormat().build();
    @Deprecated
    public static final PlainComponentSerializer PLAIN_COMPONENT = (PlainComponentSerializer)PlainComponentSerializer.builder().flattener(FLATTENER).build();
    public static final PlainTextComponentSerializer PLAIN = (PlainTextComponentSerializer)PlainTextComponentSerializer.builder().flattener(FLATTENER).build();
    public static final GsonComponentSerializer GSON = GsonComponentSerializer.builder().legacyHoverEventSerializer((LegacyHoverEventSerializer)NBTLegacyHoverEventSerializer.INSTANCE).build();
    public static final GsonComponentSerializer COLOR_DOWNSAMPLING_GSON = GsonComponentSerializer.builder().legacyHoverEventSerializer((LegacyHoverEventSerializer)NBTLegacyHoverEventSerializer.INSTANCE).downsampleColors().build();
    private static final Codec<NBTTagCompound, String, IOException, IOException> NBT_CODEC = new Codec<NBTTagCompound, String, IOException, IOException>(){

        @NotNull
        public NBTTagCompound decode(@NotNull String encoded) throws IOException {
            try {
                return MojangsonParser.a(encoded);
            }
            catch (CommandSyntaxException e2) {
                throw new IOException(e2);
            }
        }

        @NotNull
        public String encode(@NotNull NBTTagCompound decoded) {
            return decoded.toString();
        }
    };
    static final WrapperAwareSerializer WRAPPER_AWARE_SERIALIZER = new WrapperAwareSerializer();

    private PaperAdventure() {
    }

    public static MinecraftKey asVanilla(Key key) {
        return new MinecraftKey(key.namespace(), key.value());
    }

    public static MinecraftKey asVanillaNullable(Key key) {
        if (key == null) {
            return null;
        }
        return PaperAdventure.asVanilla(key);
    }

    public static Component asAdventure(IChatBaseComponent component) {
        return component == null ? Component.empty() : (Component)GSON.serializer().fromJson(IChatBaseComponent.ChatSerializer.b(component), Component.class);
    }

    public static ArrayList<Component> asAdventure(List<IChatBaseComponent> vanillas) {
        ArrayList<Component> adventures = new ArrayList<Component>(vanillas.size());
        for (IChatBaseComponent vanilla : vanillas) {
            adventures.add(PaperAdventure.asAdventure(vanilla));
        }
        return adventures;
    }

    public static ArrayList<Component> asAdventureFromJson(List<String> jsonStrings) {
        ArrayList<Component> adventures = new ArrayList<Component>(jsonStrings.size());
        for (String json : jsonStrings) {
            adventures.add(GsonComponentSerializer.gson().deserialize((Object)json));
        }
        return adventures;
    }

    public static List<String> asJson(List<Component> adventures) {
        ArrayList<String> jsons = new ArrayList<String>(adventures.size());
        for (Component component : adventures) {
            jsons.add((String)GsonComponentSerializer.gson().serialize(component));
        }
        return jsons;
    }

    public static IChatBaseComponent asVanilla(Component component) {
        if (component == null) {
            return null;
        }
        return new AdventureComponent(component);
    }

    public static List<IChatBaseComponent> asVanilla(List<Component> adventures) {
        ArrayList<IChatBaseComponent> vanillas = new ArrayList<IChatBaseComponent>(adventures.size());
        for (Component adventure : adventures) {
            vanillas.add(PaperAdventure.asVanilla(adventure));
        }
        return vanillas;
    }

    public static String asJsonString(Component component, Locale locale) {
        return (String)GSON.serialize(PaperAdventure.translated(component, locale));
    }

    public static String asJsonString(IChatBaseComponent component, Locale locale) {
        if (component instanceof AdventureComponent) {
            return PaperAdventure.asJsonString(((AdventureComponent)component).adventure, locale);
        }
        return IChatBaseComponent.ChatSerializer.a(component);
    }

    public static String asPlain(Component component, Locale locale) {
        return PLAIN.serialize(PaperAdventure.translated(component, locale));
    }

    private static Component translated(Component component, Locale locale) {
        return GlobalTranslator.render((Component)component, (Locale)(locale != null ? locale : Locale.US));
    }

    public static BossBattle.BarColor asVanilla(BossBar.Color color) {
        return switch (color) {
            default -> throw new IncompatibleClassChangeError();
            case BossBar.Color.PINK -> BossBattle.BarColor.a;
            case BossBar.Color.BLUE -> BossBattle.BarColor.b;
            case BossBar.Color.RED -> BossBattle.BarColor.c;
            case BossBar.Color.GREEN -> BossBattle.BarColor.d;
            case BossBar.Color.YELLOW -> BossBattle.BarColor.e;
            case BossBar.Color.PURPLE -> BossBattle.BarColor.f;
            case BossBar.Color.WHITE -> BossBattle.BarColor.g;
        };
    }

    public static BossBar.Color asAdventure(BossBattle.BarColor color) {
        return switch (color) {
            default -> throw new IncompatibleClassChangeError();
            case BossBattle.BarColor.a -> BossBar.Color.PINK;
            case BossBattle.BarColor.b -> BossBar.Color.BLUE;
            case BossBattle.BarColor.c -> BossBar.Color.RED;
            case BossBattle.BarColor.d -> BossBar.Color.GREEN;
            case BossBattle.BarColor.e -> BossBar.Color.YELLOW;
            case BossBattle.BarColor.f -> BossBar.Color.PURPLE;
            case BossBattle.BarColor.g -> BossBar.Color.WHITE;
        };
    }

    public static BossBattle.BarStyle asVanilla(BossBar.Overlay overlay) {
        return switch (overlay) {
            default -> throw new IncompatibleClassChangeError();
            case BossBar.Overlay.PROGRESS -> BossBattle.BarStyle.a;
            case BossBar.Overlay.NOTCHED_6 -> BossBattle.BarStyle.b;
            case BossBar.Overlay.NOTCHED_10 -> BossBattle.BarStyle.c;
            case BossBar.Overlay.NOTCHED_12 -> BossBattle.BarStyle.d;
            case BossBar.Overlay.NOTCHED_20 -> BossBattle.BarStyle.e;
        };
    }

    public static BossBar.Overlay asAdventure(BossBattle.BarStyle overlay) {
        return switch (overlay) {
            default -> throw new IncompatibleClassChangeError();
            case BossBattle.BarStyle.a -> BossBar.Overlay.PROGRESS;
            case BossBattle.BarStyle.b -> BossBar.Overlay.NOTCHED_6;
            case BossBattle.BarStyle.c -> BossBar.Overlay.NOTCHED_10;
            case BossBattle.BarStyle.d -> BossBar.Overlay.NOTCHED_12;
            case BossBattle.BarStyle.e -> BossBar.Overlay.NOTCHED_20;
        };
    }

    public static void setFlag(BossBar bar, BossBar.Flag flag, boolean value) {
        if (value) {
            bar.addFlag(flag);
        } else {
            bar.removeFlag(flag);
        }
    }

    public static ItemStack asItemStack(Book book, Locale locale) {
        ItemStack item = new ItemStack(Items.rh, 1);
        NBTTagCompound tag = item.u();
        tag.a("title", PaperAdventure.validateField(PaperAdventure.asPlain(book.title(), locale), 32, "title"));
        tag.a("author", PaperAdventure.asPlain(book.author(), locale));
        NBTTagList pages = new NBTTagList();
        if (book.pages().size() > 100) {
            throw new IllegalArgumentException("Book provided had " + book.pages().size() + " pages, but is only allowed a maximum of 100");
        }
        for (Component page : book.pages()) {
            pages.add(NBTTagString.a(PaperAdventure.validateField(PaperAdventure.asJsonString(page, locale), Short.MAX_VALUE, "page")));
        }
        tag.a("pages", pages);
        return item;
    }

    private static String validateField(String content, int length, String name) {
        if (content == null) {
            return content;
        }
        int actual = content.length();
        if (actual > length) {
            throw new IllegalArgumentException("Field '" + name + "' has a maximum length of " + length + " but was passed '" + content + "', which was " + actual + " characters long.");
        }
        return content;
    }

    public static SoundCategory asVanilla(Sound.Source source) {
        return switch (source) {
            default -> throw new IncompatibleClassChangeError();
            case Sound.Source.MASTER -> SoundCategory.a;
            case Sound.Source.MUSIC -> SoundCategory.b;
            case Sound.Source.RECORD -> SoundCategory.c;
            case Sound.Source.WEATHER -> SoundCategory.d;
            case Sound.Source.BLOCK -> SoundCategory.e;
            case Sound.Source.HOSTILE -> SoundCategory.f;
            case Sound.Source.NEUTRAL -> SoundCategory.g;
            case Sound.Source.PLAYER -> SoundCategory.h;
            case Sound.Source.AMBIENT -> SoundCategory.i;
            case Sound.Source.VOICE -> SoundCategory.j;
        };
    }

    @Nullable
    public static SoundCategory asVanillaNullable(// Could not load outer class - annotation placement on inner may be incorrect
     @Nullable Sound.Source source) {
        if (source == null) {
            return null;
        }
        return PaperAdventure.asVanilla(source);
    }

    @Nullable
    public static BinaryTagHolder asBinaryTagHolder(@Nullable NBTTagCompound tag) {
        if (tag == null) {
            return null;
        }
        try {
            return BinaryTagHolder.encode((Object)tag, NBT_CODEC);
        }
        catch (IOException e2) {
            return null;
        }
    }

    @NotNull
    public static TextColor asAdventure(EnumChatFormat formatting) {
        Integer color = formatting.e();
        if (color == null) {
            throw new IllegalArgumentException("Not a valid color");
        }
        return TextColor.color((int)color);
    }

    @Nullable
    public static EnumChatFormat asVanilla(TextColor color) {
        return EnumChatFormat.getByHexValue(color.value());
    }
}

