/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.adventure;

import com.google.gson.JsonElement;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import io.papermc.paper.adventure.PaperAdventure;
import java.lang.reflect.Type;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.minecraft.network.chat.ChatModifier;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.util.FormattedString;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.jetbrains.annotations.Nullable;

public final class AdventureComponent
implements IChatBaseComponent {
    final Component adventure;
    private @MonotonicNonNull IChatBaseComponent vanilla;

    public AdventureComponent(Component adventure) {
        this.adventure = adventure;
    }

    public IChatBaseComponent deepConverted() {
        IChatBaseComponent vanilla = this.vanilla;
        if (vanilla == null) {
            this.vanilla = vanilla = PaperAdventure.WRAPPER_AWARE_SERIALIZER.serialize(this.adventure);
        }
        return vanilla;
    }

    public @Nullable IChatBaseComponent deepConvertedIfPresent() {
        return this.vanilla;
    }

    @Override
    public ChatModifier c() {
        return this.deepConverted().c();
    }

    @Override
    public String a() {
        if (this.adventure instanceof TextComponent) {
            return ((TextComponent)this.adventure).content();
        }
        return this.deepConverted().a();
    }

    @Override
    public String getString() {
        return PaperAdventure.PLAIN.serialize(this.adventure);
    }

    @Override
    public List<IChatBaseComponent> b() {
        return this.deepConverted().b();
    }

    @Override
    public IChatMutableComponent g() {
        return this.deepConverted().g();
    }

    @Override
    public IChatMutableComponent e() {
        return this.deepConverted().e();
    }

    @Override
    public FormattedString f() {
        return this.deepConverted().f();
    }

    public static class Serializer
    implements JsonSerializer<AdventureComponent> {
        public JsonElement serialize(AdventureComponent src, Type type, JsonSerializationContext context) {
            return PaperAdventure.GSON.serializer().toJsonTree((Object)src.adventure, Component.class);
        }
    }
}

